/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.CampaignData;
import common.DefaultOperation;
import java.io.FileInputStream;
import java.util.Properties;
import server.campaign.operations.ModifyingOperation;
import server.campaign.operations.Operation;

public class OperationLoader {
    DefaultOperation defaults = new DefaultOperation();

    public Operation loadOpValues(String opName) {
        Properties opValues = new Properties();
        String shortFilename = "./data/operations/short/" + opName;
        try {
            opValues.load(new FileInputStream(shortFilename));
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("Problems loading short op: " + opName);
            CampaignData.mwlog.errLog(e);
        }
        String longFilename = "./data/operations/long/" + opName;
        try {
            opValues.load(new FileInputStream(longFilename));
        }
        catch (Exception e) {
            // empty catch block
        }
        opName = opName.substring(0, opName.length() - 4);
        return new Operation(opName.trim(), this.defaults, opValues);
    }

    public ModifyingOperation loadModOpValues(String opName) {
        Properties modValues = new Properties();
        String modFilename = "./data/operations/modifiers/" + opName;
        try {
            modValues.load(new FileInputStream(modFilename));
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("Problems loading mod op: " + opName);
            CampaignData.mwlog.errLog(e);
        }
        opName = opName.substring(0, opName.length() - 5);
        return new ModifyingOperation(opName.trim(), modValues);
    }
}

