/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.CampaignData;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.operations.LongOperation;
import server.campaign.operations.ModifyingOperation;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationLoader;
import server.campaign.operations.OperationWriter;
import server.campaign.operations.OpsChickenThread;
import server.campaign.operations.OpsDisconnectionThread;
import server.campaign.operations.OpsScrapThread;
import server.campaign.operations.ShortOperation;
import server.campaign.operations.ShortResolver;
import server.campaign.operations.ShortValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationManager {
    public static final int TERM_TERMCOMMAND = 0;
    public static final int TERM_NOATTACKERS = 1;
    public static final int TERM_NOPOSSIBLEDEFENDERS = 2;
    public static final int TERM_REPORTINGERROR = 3;
    public static final int TERM_NO_REMAINING_PLAYERS = 4;
    private OperationLoader opLoader = new OperationLoader();
    private OperationWriter opWriter = new OperationWriter();
    private ShortResolver shortResolver = new ShortResolver();
    private ShortValidator shortValidator = new ShortValidator(this);
    private TreeMap<String, Operation> ops = new TreeMap();
    private TreeMap<String, ModifyingOperation> mods = new TreeMap();
    private TreeMap<Integer, ShortOperation> runningOperations = new TreeMap();
    private TreeMap<String, OpsDisconnectionThread> disconnectionThreads;
    private TreeMap<String, OpsScrapThread> scrapThreads;
    private TreeMap<String, Long> disconnectionTimestamps;
    private TreeMap<String, Long> disconnectionDurations;
    private TreeMap<Integer, LongOperation> activeLongOps = new TreeMap();
    private boolean MULOnlyArmiesOpsLoad = false;

    public OperationManager() {
        this.disconnectionThreads = new TreeMap();
        this.scrapThreads = new TreeMap();
        this.disconnectionTimestamps = new TreeMap();
        this.disconnectionDurations = new TreeMap();
        this.loadOperations();
    }

    public void doDisconnectCheckOnPlayer(String name) {
        OpsDisconnectionThread otherThread;
        SPlayer p = CampaignMain.cm.getPlayer(name);
        if (p == null) {
            return;
        }
        ShortOperation so = this.getShortOpForPlayer(p);
        if (so == null) {
            return;
        }
        if (so.getStatus() != ShortOperation.STATUS_INPROGRESS) {
            return;
        }
        if (so.getAllPlayerNames().size() > 2) {
            return;
        }
        String otherName = "";
        for (String currName : so.getAllPlayerNames()) {
            if (currName.equalsIgnoreCase(p.getName())) continue;
            otherName = currName;
        }
        Long timeOffline = this.disconnectionDurations.get(p.getName().toLowerCase());
        if (timeOffline == null) {
            timeOffline = new Long(0L);
        }
        if ((otherThread = this.disconnectionThreads.get(otherName.toLowerCase())) != null && !otherThread.playerHasReturned()) {
            this.terminateOperation(so, 4, null);
            return;
        }
        long logoutTime = System.currentTimeMillis();
        OpsDisconnectionThread discoThread = new OpsDisconnectionThread(so.getShortID(), otherName, p.getName(), (long)timeOffline);
        OpsDisconnectionThread oldDiscoThread = this.disconnectionThreads.put(p.getName().toLowerCase(), discoThread);
        if (oldDiscoThread != null && !oldDiscoThread.playerHasReturned()) {
            oldDiscoThread.playerReturned(false, timeOffline);
        }
        this.disconnectionTimestamps.put(p.getName().toLowerCase(), logoutTime);
        discoThread.start();
    }

    public void doReconnectCheckOnPlayer(String name) {
        SPlayer p = CampaignMain.cm.getPlayer(name);
        if (p == null) {
            return;
        }
        OpsDisconnectionThread discoT = this.disconnectionThreads.get(p.getName().toLowerCase());
        if (discoT == null) {
            if (CampaignMain.cm.getOpsManager().getShortOpForPlayer(p) != null) {
                ShortOperation so = CampaignMain.cm.getOpsManager().getShortOpForPlayer(p);
                if (so.getStatus() == ShortOperation.STATUS_REPORTING || so.getStatus() == ShortOperation.STATUS_FINISHED) {
                    return;
                }
                so.sendReconnectInfoToPlayer(p);
            }
            return;
        }
        long currTime = System.currentTimeMillis();
        long exitStamp = this.disconnectionTimestamps.get(p.getName().toLowerCase());
        long discoDuration = currTime - exitStamp;
        discoT.playerReturned(true, discoDuration);
        ShortOperation so = this.runningOperations.get(discoT.getShortID());
        if (so == null) {
            return;
        }
        if (so.getStatus() == ShortOperation.STATUS_REPORTING || so.getStatus() == ShortOperation.STATUS_FINISHED) {
            return;
        }
        long gracePeriod = Long.parseLong(CampaignMain.cm.getConfig("DisconnectionGracePeriod")) * 1000L;
        if ((discoDuration -= gracePeriod) < 0L) {
            discoDuration = 0L;
        }
        this.disconnectionDurations.put(p.getName().toLowerCase(), discoDuration);
        so.sendReconnectInfoToPlayer(p);
    }

    public void clearAllDisconnectionTracks(ShortOperation so) {
        for (String currN : so.getAllPlayerNames()) {
            String lowerName = currN.toLowerCase();
            OpsDisconnectionThread discoThread = this.disconnectionThreads.get(lowerName);
            if (discoThread != null) {
                discoThread.playerReturned(false, 0L);
                this.disconnectionThreads.remove(lowerName);
            }
            this.disconnectionDurations.remove(lowerName);
            this.disconnectionTimestamps.remove(lowerName);
        }
    }

    public Operation getOperation(String name) {
        return this.ops.get(name);
    }

    public TreeMap<String, Operation> getOperations() {
        return this.ops;
    }

    public ModifyingOperation getModifyingOperation(String name) {
        return this.mods.get(name);
    }

    public TreeMap<Integer, ShortOperation> getRunningOps() {
        return this.runningOperations;
    }

    public String validateShortAttack(SPlayer ap, SArmy aa, Operation o, SPlanet target, int longID, boolean joiningAttack) {
        ArrayList<Integer> failures = this.shortValidator.validateShortAttacker(ap, aa, o, target, longID, joiningAttack);
        if (failures.size() > 0) {
            return this.shortValidator.failuresToString(failures);
        }
        return null;
    }

    public String validateShortDefense(SPlayer dp, SArmy da, Operation o, SPlanet target) {
        ArrayList<Integer> failures = this.shortValidator.validateShortDefender(dp, da, o, target);
        if (failures.size() > 0) {
            return this.shortValidator.failuresToString(failures);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveShortAttack(Operation o, ShortOperation so, String report) {
        ShortResolver shortResolver = this.shortResolver;
        synchronized (shortResolver) {
            this.shortResolver.resolveShortAttack(o, so, report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveShortAttack(Operation o, ShortOperation so, String winnerName, String loserName) {
        ShortResolver shortResolver = this.shortResolver;
        synchronized (shortResolver) {
            this.shortResolver.resolveShortAttack(o, so, winnerName, loserName);
        }
    }

    public void addShortOperation(ShortOperation so, SPlayer ap, Operation o) {
        if (so == null) {
            CampaignData.mwlog.errLog("Error: Tried to add a null ShortOperation to the Manager");
            return;
        }
        this.runningOperations.put(so.getShortID(), so);
        int money = o.getIntValue("AttackerCostMoney");
        int flu = o.getIntValue("AttackerCostInfluence");
        int rp = o.getIntValue("AttackerCostReward");
        String toSend = "You are on your way to " + so.getTargetWorld().getName() + " (" + o.getName();
        if (money > 0) {
            ap.addMoney(-money);
            toSend = toSend + ", " + CampaignMain.cm.moneyOrFluMessage(true, true, -money, true);
        }
        if (flu > 0) {
            ap.addInfluence(-flu);
            toSend = toSend + ", " + CampaignMain.cm.moneyOrFluMessage(false, true, -flu, true);
        }
        if (rp > 0) {
            ap.addReward(-rp);
            toSend = toSend + ", -" + rp + " RP";
        }
        toSend = toSend + ").";
        CampaignMain.cm.toUser(toSend, ap.getName(), true);
    }

    public void terminateOperation(ShortOperation so, int termCode, SPlayer terminator, boolean ignoreStatus) {
        String toPlayer;
        boolean didReturn;
        SPlayer currP;
        if (so == null) {
            CampaignData.mwlog.errLog("Attempted to terminate null ShortOperation");
            return;
        }
        if (!ignoreStatus) {
            if (so.getStatus() == ShortOperation.STATUS_REPORTING) {
                return;
            }
            if (so.getStatus() == ShortOperation.STATUS_FINISHED) {
                return;
            }
            if (so.getStatus() == ShortOperation.STATUS_INPROGRESS && termCode != 0 && termCode != 4) {
                return;
            }
        }
        String message = "Attack #" + so.getShortID() + " was cancelled";
        switch (termCode) {
            case 0: {
                message = message + " by " + terminator.getName();
                break;
            }
            case 2: {
                message = message + " because no potential defenders remained";
                break;
            }
            case 1: {
                message = message + " because no attacking players remained";
                break;
            }
            case 3: {
                message = message + " because there was a reporting error";
                break;
            }
            case 4: {
                message = message + " because all involved players disconnected";
            }
        }
        Operation o = this.getOperation(so.getName());
        int attmoney = o.getIntValue("AttackerCostMoney");
        int attflu = o.getIntValue("AttackerCostInfluence");
        int attrp = o.getIntValue("AttackerCostReward");
        int defmoney = o.getIntValue("DefenderCostMoney");
        int defflu = o.getIntValue("DefenderCostInfluence");
        int defrp = o.getIntValue("DefenderCostReward");
        for (String currName : so.getAttackers().keySet()) {
            currP = CampaignMain.cm.getPlayer(currName);
            didReturn = false;
            toPlayer = message;
            if (attmoney > 0) {
                didReturn = true;
                currP.addMoney(attmoney);
                toPlayer = toPlayer + " (+" + CampaignMain.cm.moneyOrFluMessage(true, true, attmoney);
            }
            if (attflu > 0) {
                currP.addInfluence(attflu);
                toPlayer = !didReturn ? toPlayer + " (+" + CampaignMain.cm.moneyOrFluMessage(false, true, attflu) : toPlayer + ", +" + CampaignMain.cm.moneyOrFluMessage(false, true, attflu);
                didReturn = true;
            }
            if (attrp > 0) {
                currP.addReward(attrp);
                toPlayer = !didReturn ? toPlayer + " (+" + attrp + " RP" : toPlayer + ", +" + attrp + " RP";
                didReturn = true;
            }
            toPlayer = didReturn ? toPlayer + ")." : toPlayer + ".";
            CampaignMain.cm.toUser(toPlayer, currName, true);
            CampaignMain.cm.toUser("PL|STN|-1", toPlayer, false);
        }
        for (String currName : so.getDefenders().keySet()) {
            currP = CampaignMain.cm.getPlayer(currName);
            didReturn = false;
            toPlayer = message;
            if (defmoney > 0) {
                didReturn = true;
                currP.addMoney(defmoney);
                toPlayer = toPlayer + "(+" + CampaignMain.cm.moneyOrFluMessage(true, true, defmoney);
            }
            if (defflu > 0) {
                currP.addInfluence(defflu);
                if (!didReturn) {
                    toPlayer = toPlayer + "(+" + CampaignMain.cm.moneyOrFluMessage(false, true, defflu);
                } else {
                    toPlayer = toPlayer + ", +" + CampaignMain.cm.moneyOrFluMessage(false, true, defflu);
                    didReturn = true;
                }
            }
            if (defrp > 0) {
                currP.addReward(defrp);
                if (!didReturn) {
                    toPlayer = toPlayer + "(+" + defrp + " RP";
                    didReturn = true;
                } else {
                    toPlayer = toPlayer + ", +" + defrp + " RP";
                    didReturn = true;
                }
            }
            toPlayer = didReturn ? toPlayer + ")." : toPlayer + ".";
            if (o.getBooleanValue("AttackerUnitsTakenBeforeFightStarts")) {
                try {
                    SHouse faction = CampaignMain.cm.getHouseForPlayer(so.getDefenders().firstKey());
                    for (SUnit unit : so.preCapturedUnits) {
                        faction.addUnit(unit, true);
                    }
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            }
            CampaignMain.cm.toUser(toPlayer, currName, true);
            CampaignMain.cm.toUser("PL|STN|-1", toPlayer, false);
        }
        TreeMap<String, Integer> allArmies = so.getAllPlayersAndArmies();
        for (String currN : allArmies.keySet()) {
            try {
                CampaignMain.cm.getPlayer(currN).lockArmy(-1);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(currN + " had a null army while terminating. Continuing to next player.");
            }
        }
        if (so.getStatus() == ShortOperation.STATUS_INPROGRESS) {
            for (String currN : so.getAllPlayerNames()) {
                OpsDisconnectionThread dt = this.disconnectionThreads.get(currN.toLowerCase());
                if (dt != null && !dt.playerHasReturned()) {
                    dt.playerReturned(false, 0L);
                    continue;
                }
                SPlayer currP2 = CampaignMain.cm.getPlayer(currN);
                CampaignMain.cm.getIThread().removeImmunity(currP2);
                if (so.isFromReserve()) {
                    currP2.setFighting(false, true);
                } else {
                    currP2.setFighting(false);
                }
                CampaignMain.cm.sendPlayerStatusUpdate(currP2, true);
            }
        }
        this.clearAllDisconnectionTracks(so);
        so.terminateChickenThreads();
        this.runningOperations.remove(so.getShortID());
        so = null;
    }

    public void terminateOperation(ShortOperation so, int termCode, SPlayer terminator) {
        if (CampaignMain.cm.isUsingCyclops()) {
            CampaignMain.cm.getMWCC().opCancel(so);
        }
        this.terminateOperation(so, termCode, terminator, false);
    }

    public int getLongID(SHouse h, SPlanet p) {
        for (LongOperation currL : this.activeLongOps.values()) {
            SHouse attacker = currL.getAttackingHouse();
            SPlanet planet = currL.getTargetWorld();
            if (!attacker.equals(h) || !planet.equals(p)) continue;
            return currL.getID();
        }
        return -1;
    }

    public boolean isLongOnPlanet(SPlanet p) {
        for (LongOperation currL : this.activeLongOps.values()) {
            SPlanet planet = currL.getTargetWorld();
            if (!planet.equals(p)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLongOnPlanet(SHouse h, SPlanet p) {
        for (LongOperation currL : this.activeLongOps.values()) {
            SHouse attacker = currL.getAttackingHouse();
            SPlanet planet = currL.getTargetWorld();
            if (!attacker.equals(h) || !planet.equals(p)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSpecificLongOnPlanet(SHouse h, SPlanet p, Operation o) {
        for (LongOperation currL : this.activeLongOps.values()) {
            SHouse attacker = currL.getAttackingHouse();
            SPlanet planet = currL.getTargetWorld();
            if (!attacker.equals(h) || !planet.equals(p) || !currL.getName().equals(o.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasShortOnPlanet(SHouse h, SPlanet p) {
        for (ShortOperation currS : this.runningOperations.values()) {
            SPlayer anAttacker = CampaignMain.cm.getPlayer(currS.getAttackers().firstKey());
            SHouse attacker = anAttacker.getHouseFightingFor();
            SPlanet planet = currS.getTargetWorld();
            if (!attacker.equals(h) || !planet.equals(p)) continue;
            return true;
        }
        return false;
    }

    public OpsChickenThread getPlayerThreadForAttack(String pname, int opID) {
        TreeMap<String, OpsChickenThread> threads = this.getRunningOps().get(opID).getChickenThreads();
        return threads.get(pname.toLowerCase());
    }

    public void removePlayerFromAllPossibleDefenderLists(String playerName, boolean penalize) {
        ArrayList<ShortOperation> toTerminate = new ArrayList<ShortOperation>();
        for (ShortOperation so : this.getRunningOps().values()) {
            so.removePossibleDefender(playerName, penalize);
            if (so.getChickenThreads().size() != 0) continue;
            toTerminate.add(so);
        }
        for (ShortOperation so : toTerminate) {
            this.terminateOperation(so, 2, null);
        }
    }

    public void removePlayerFromAllAttackerLists(SPlayer p, ShortOperation so, boolean verbose) {
        ArrayList<ShortOperation> toTerminate = new ArrayList<ShortOperation>();
        for (ShortOperation currO : this.getRunningOps().values()) {
            if (currO.getStatus() != ShortOperation.STATUS_WAITING || !currO.hasPlayer(p)) continue;
            if (so == null) {
                currO.removeAttacker(p);
                if (verbose) {
                    for (String currN : currO.getAllPlayerNames()) {
                        CampaignMain.cm.toUser(p.getName() + " left Attack #" + currO.getShortID() + " (deactivated or logged out).", currN, true);
                    }
                }
                if (currO.getAttackers().size() != 0) continue;
                toTerminate.add(currO);
                continue;
            }
            if (currO == so) continue;
            currO.removeAttacker(p);
            if (verbose) {
                for (String currN : currO.getAllPlayerNames()) {
                    CampaignMain.cm.toUser(p.getName() + " left the game for Attack #" + so.getShortID() + ".", currN, true);
                }
            }
            if (currO.getAttackers().size() != 0) continue;
            toTerminate.add(currO);
        }
        for (ShortOperation ott : toTerminate) {
            this.terminateOperation(ott, 1, null);
        }
    }

    public void removePlayerFromAllDefenderLists(SPlayer p, ShortOperation so, boolean verbose) {
        for (ShortOperation currO : this.getRunningOps().values()) {
            if (currO.getStatus() != ShortOperation.STATUS_WAITING || !currO.hasPlayer(p)) continue;
            if (so == null && currO.getStatus() == ShortOperation.STATUS_WAITING) {
                currO.removeDefender(p);
                if (!verbose) continue;
                for (String currN : currO.getAllPlayerNames()) {
                    CampaignMain.cm.toUser(p.getName() + " left Attack #" + currO.getShortID() + " (deactivated or logged out).", currN, true);
                }
                continue;
            }
            if (so == null || currO == so) continue;
            currO.removeDefender(p);
            if (!verbose) continue;
            for (String currN : currO.getAllPlayerNames()) {
                CampaignMain.cm.toUser(p.getName() + " left the game for Attack #" + so.getShortID() + ".", currN, true);
            }
        }
    }

    public String tick() {
        TreeMap<Long, ShortOperation> timeSort = new TreeMap<Long, ShortOperation>();
        String toReturn = "<b><i>Recently Completed Games:</i><br>";
        Iterator<ShortOperation> i = this.runningOperations.values().iterator();
        while (i.hasNext()) {
            ShortOperation currO = i.next();
            if (currO.getStatus() != ShortOperation.STATUS_FINISHED) continue;
            timeSort.put(currO.getCompletionTime(), currO);
            if (!currO.decrementShowsToClear()) continue;
            i.remove();
        }
        Iterator<OpsScrapThread> i2 = this.scrapThreads.values().iterator();
        while (i2.hasNext()) {
            if (!i2.next().isFinished()) continue;
            i2.remove();
        }
        boolean completeInfo = CampaignMain.cm.getBooleanConfig("ShowCompleteGameInfoOnTick");
        if (timeSort.size() == 0) {
            return "";
        }
        for (ShortOperation currO : timeSort.values()) {
            toReturn = toReturn + currO.getInfo(completeInfo, false) + "<br>";
        }
        toReturn = toReturn + "</b>";
        timeSort.clear();
        return toReturn;
    }

    public int playerIsAnAttacker(SPlayer p) {
        for (ShortOperation currO : this.getRunningOps().values()) {
            if (currO.getAttackers().get(p.getName().toLowerCase()) == null || currO.getStatus() == ShortOperation.STATUS_FINISHED) continue;
            return currO.getShortID();
        }
        return -1;
    }

    public int playerIsADefender(SPlayer p) {
        for (ShortOperation currO : this.getRunningOps().values()) {
            if (currO.getDefenders().get(p.getName().toLowerCase()) == null || currO.getStatus() == ShortOperation.STATUS_FINISHED) continue;
            return currO.getShortID();
        }
        return -1;
    }

    public ShortOperation getShortOpForPlayer(SPlayer p) {
        for (ShortOperation currSO : this.getRunningOps().values()) {
            if (!currSO.hasPlayer(p) || currSO.getStatus() == ShortOperation.STATUS_FINISHED) continue;
            return currSO;
        }
        return null;
    }

    public boolean playerHasActiveChickenThread(SPlayer p) {
        for (ShortOperation currSO : this.getRunningOps().values()) {
            if (!currSO.getChickenThreads().containsKey(p.getName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public TreeMap<String, OpsScrapThread> getScrapThreads() {
        return this.scrapThreads;
    }

    public int getFreeShortID() {
        int i = 0;
        while (this.runningOperations.get(new Integer(i)) != null) {
            ++i;
        }
        return i;
    }

    public int getFreeLongID() {
        int i = 0;
        while (this.activeLongOps.get(new Integer(i)) != null) {
            ++i;
        }
        return i;
    }

    public ShortValidator getShortValidator() {
        return this.shortValidator;
    }

    public void checkOperations(SArmy a, boolean display) {
        this.shortValidator.checkOperations(a, display, this.ops);
    }

    public void loadOperations() {
        File shortDir = new File("./data/operations/short/");
        File longDir = new File("./data/operations/long/");
        File modDir = new File("./data/operations/modifiers/");
        try {
            if (!shortDir.exists()) {
                shortDir.mkdirs();
            }
            if (!longDir.exists()) {
                longDir.mkdir();
            }
            if (!modDir.exists()) {
                modDir.mkdir();
            }
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("Error while creating operations directories.");
        }
        this.ops.clear();
        this.mods.clear();
        this.MULOnlyArmiesOpsLoad = false;
        String[] shortNames = shortDir.list();
        for (int i = 0; i < shortNames.length; ++i) {
            Operation currOp = this.opLoader.loadOpValues(shortNames[i]);
            this.ops.put(currOp.getName(), currOp);
            if (!currOp.getBooleanValue("MULArmiesOnly")) continue;
            this.MULOnlyArmiesOpsLoad = true;
        }
        String[] modNames = modDir.list();
        for (int i = 0; i < modNames.length; ++i) {
            ModifyingOperation currMod = this.opLoader.loadModOpValues(modNames[i]);
            this.mods.put(currMod.getName(), currMod);
            String targets = currMod.getValueAsString("LinkedOperations");
            StringTokenizer st = new StringTokenizer(targets, ";");
            while (st.hasMoreTokens()) {
                String currTarget = st.nextToken().trim();
                Operation currOp = this.ops.get(currTarget);
                if (currOp == null) {
                    CampaignData.mwlog.errLog("Error assigning modop target. Mod: " + currMod.getName() + " Target: " + currTarget);
                    continue;
                }
                currOp.addModifyingOperation(currMod);
            }
        }
        this.opWriter.writeOpList(this.ops);
    }

    public boolean hasMULOnlyOps() {
        return this.MULOnlyArmiesOpsLoad;
    }
}

