/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

public class OperationReportEntry {
    private String attackerName = "";
    private String defenderName = "";
    private String winnerName = "";
    private String loserName = "";
    private String planetName = "";
    private String terrainName = "";
    private String themeName = "";
    private int attackerStartBV = 0;
    private int attackerEndBV = 0;
    private int defenderStartBV = 0;
    private int defenderEndBV = 0;
    private int attackerSize = 0;
    private int defenderSize = 0;
    private boolean attackerWon = false;
    private boolean drawGame = false;
    private long gameLength = 0L;
    private long startTime = 0L;
    private long endTime = 0L;
    private String opType = "";

    public boolean gameIsDraw() {
        return this.drawGame;
    }

    public void setDrawGame(boolean draw) {
        this.drawGame = draw;
    }

    public int getAttackerSize() {
        return this.attackerSize;
    }

    public void setAttackerSize(int size) {
        this.attackerSize = size;
    }

    public int getDefenderSize() {
        return this.defenderSize;
    }

    public void setDefenderSize(int size) {
        this.defenderSize = size;
    }

    public String getOpType() {
        return this.opType;
    }

    public void setOpType(String op) {
        this.opType = op;
    }

    public int getAttackerStartBV() {
        return this.attackerStartBV;
    }

    public int getAttackerEndBV() {
        return this.attackerEndBV;
    }

    public int getDefenderStartBV() {
        return this.defenderStartBV;
    }

    public int getDefenderEndBV() {
        return this.defenderEndBV;
    }

    public boolean attackerIsWinner() {
        return this.attackerWon;
    }

    public long getGameLength() {
        return this.gameLength;
    }

    public String getAttackers() {
        return this.attackerName;
    }

    public String getDefenders() {
        return this.defenderName;
    }

    public String getWinners() {
        return this.winnerName;
    }

    public String getLosers() {
        return this.loserName;
    }

    public String getPlanet() {
        return this.planetName;
    }

    public String getTheme() {
        return this.themeName;
    }

    public String getTerrain() {
        return this.terrainName;
    }

    public void setAttackerName(String name) {
        this.attackerName = name;
    }

    public void setDefenderName(String name) {
        this.defenderName = name;
    }

    public void setWinnerName(String name) {
        this.winnerName = name;
    }

    public void setLoserName(String name) {
        this.loserName = name;
    }

    public void setBV(boolean attacker, boolean start, int BV) {
        if (attacker) {
            if (start) {
                this.attackerStartBV = BV;
            } else {
                this.attackerEndBV = BV;
            }
        } else if (start) {
            this.defenderStartBV = BV;
        } else {
            this.defenderEndBV = BV;
        }
    }

    public void addEndingBV(boolean attacker, int BV) {
        if (attacker) {
            this.attackerEndBV += BV;
        } else {
            this.defenderEndBV += BV;
        }
    }

    public void addStartingBV(boolean attacker, int BV) {
        if (attacker) {
            this.attackerStartBV += BV;
        } else {
            this.defenderStartBV += BV;
        }
    }

    public void setPlanetInfo(String pName, String tName, String thName) {
        this.planetName = pName;
        this.terrainName = tName;
        this.themeName = thName;
    }

    public void setAttackerWon(boolean aWon) {
        this.attackerWon = aWon;
    }

    public void setStartTime(long time) {
        this.startTime = time;
    }

    public void setEndTime(long time) {
        this.endTime = time;
        this.gameLength = this.endTime - this.startTime;
    }

    public String getHumanReadableGameLength() {
        int seconds = (int)(this.gameLength / 1000L);
        int hours = seconds / 3600;
        int minutes = (seconds -= hours * 60 * 60) / 60;
        seconds -= minutes * 60;
        StringBuilder timeString = new StringBuilder();
        if (hours > 0) {
            timeString.append(hours + "h");
        }
        timeString.append(minutes + "m");
        timeString.append(seconds + "s");
        return timeString.toString();
    }
}

