/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.CampaignData;
import common.Unit;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.operations.OperationReportEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationReporter {
    private OperationReportEntry opData = new OperationReportEntry();
    private Vector<String> winnerSet = new Vector();
    private Vector<String> loserSet = new Vector();
    private TreeMap<Integer, String> attackerUnits = new TreeMap();
    private TreeMap<Integer, String> defenderUnits = new TreeMap();
    private TreeMap<String, String> attackerMap = new TreeMap();
    private TreeMap<String, String> defenderMap = new TreeMap();

    private void setWinners(TreeMap<String, SPlayer> winners) {
        for (String winner : winners.keySet()) {
            this.winnerSet.add(winner);
        }
        Iterator<String> it = this.winnerSet.iterator();
        int count = 0;
        StringBuilder wNames = new StringBuilder();
        while (it.hasNext()) {
            String name;
            if (count > 0) {
                wNames.append(", ");
            }
            if ((name = it.next()).equalsIgnoreCase("Draw")) {
                wNames.append("Draw");
            } else {
                wNames.append(winners.get(name).getName());
            }
            ++count;
        }
        this.opData.setWinnerName(wNames.toString());
    }

    private void setLosers(TreeMap<String, SPlayer> losers) {
        for (String loser : losers.keySet()) {
            this.loserSet.add(loser);
        }
        Iterator<String> it = this.loserSet.iterator();
        int count = 0;
        StringBuilder lNames = new StringBuilder();
        while (it.hasNext()) {
            if (count > 0) {
                lNames.append(", ");
            }
            lNames.append(losers.get(it.next()).getName());
            ++count;
        }
        this.opData.setLoserName(lNames.toString());
    }

    public void setWinnersAndLosers(TreeMap<String, SPlayer> winners, TreeMap<String, SPlayer> losers) {
        this.setWinners(winners);
        this.setLosers(losers);
    }

    public void setPlanetInfo(String pName, String tName, String thName) {
        this.opData.setPlanetInfo(pName, tName, thName);
    }

    public void setAttackerStartBV(int BV) {
        this.opData.setBV(true, true, BV);
    }

    public void setDefenderStartBV(int BV) {
        this.opData.setBV(false, true, BV);
    }

    public void setAttackerEndBV(int BV) {
        this.opData.setBV(true, false, BV);
    }

    public void setDefenderEndBV(int BV) {
        this.opData.setBV(false, false, BV);
    }

    public void commit() {
        this.opData.setEndTime(System.currentTimeMillis());
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.commitBattleReport(this.opData);
            return;
        }
        CampaignData.mwlog.resultsLog("Operation Finished: ");
        CampaignData.mwlog.resultsLog("  OpType: " + this.opData.getOpType());
        CampaignData.mwlog.resultsLog("  Planet: " + this.opData.getPlanet() + ", Terrain: " + this.opData.getTerrain() + ", Theme: " + this.opData.getTheme());
        CampaignData.mwlog.resultsLog("  Attacker(s): " + this.opData.getAttackers() + " (" + this.opData.getAttackerSize() + " units)  --  Defender(s): " + this.opData.getDefenders() + " (" + this.opData.getDefenderSize() + " units)");
        CampaignData.mwlog.resultsLog("  BVs: Attacker: " + this.opData.getAttackerStartBV() + " / " + this.opData.getAttackerEndBV() + "  --  Defender: " + this.opData.getDefenderStartBV() + " / " + this.opData.getDefenderEndBV());
        CampaignData.mwlog.resultsLog("  Attacker Won: " + Boolean.toString(this.opData.attackerIsWinner()));
        CampaignData.mwlog.resultsLog("  Winner(s): " + this.opData.getWinners() + "  --  Loser(s): " + this.opData.getLosers());
        CampaignData.mwlog.resultsLog("  Game Length: " + this.opData.getHumanReadableGameLength());
    }

    public void closeOperation(boolean draw, boolean attackerWon) {
        this.opData.setDrawGame(draw);
        this.opData.setAttackerWon(attackerWon);
    }

    public void setUpOperation(String operationName, String planetName, String terrainName, String themeName) {
        this.setPlanetInfo(planetName, terrainName, themeName);
        this.opData.setOpType(operationName);
        this.opData.setStartTime(System.currentTimeMillis());
    }

    public void addAttacker(String playerName, int armyID) {
        this.attackerMap.put(playerName, CampaignMain.cm.getPlayer(playerName).getHouseFightingFor().getName());
        String playerString = playerName + " (" + this.attackerMap.get(playerName) + ")";
        SArmy army = CampaignMain.cm.getPlayer(playerName).getArmy(armyID);
        if (army != null) {
            this.opData.addStartingBV(true, army.getBV());
            this.addArmy(true, army);
            String s = this.opData.getAttackers();
            if (s.length() == 0) {
                this.opData.setAttackerName(playerString);
            } else {
                this.opData.setAttackerName(s + ", " + playerString);
            }
        }
    }

    public void addDefender(String playerName, int armyID) {
        this.defenderMap.put(playerName, CampaignMain.cm.getPlayer(playerName).getHouseFightingFor().getName());
        String playerString = playerName + " (" + this.defenderMap.get(playerName) + ")";
        SArmy army = CampaignMain.cm.getPlayer(playerName).getArmy(armyID);
        if (army != null) {
            this.opData.addStartingBV(false, army.getBV());
            this.addArmy(false, army);
            String s = this.opData.getDefenders();
            if (s.length() == 0) {
                this.opData.setDefenderName(playerString);
            } else {
                this.opData.setDefenderName(s + ", " + playerString);
            }
        }
    }

    public void addArmy(boolean attackerArmy, SArmy army) {
        int numUnits = army.getAmountOfUnits();
        if (attackerArmy) {
            this.opData.setAttackerSize(numUnits);
        } else {
            this.opData.setDefenderSize(numUnits);
        }
        for (Unit currU : army.getUnits()) {
            int ID = currU.getId();
            String model = ((SUnit)currU).getModelName();
            CampaignData.mwlog.dbLog("Adding Unit " + ID + ": " + model);
            if (attackerArmy) {
                this.attackerUnits.put(ID, model);
                continue;
            }
            this.defenderUnits.put(ID, model);
        }
    }

    public void addEndingUnit(SUnit unit, int removalReason) {
        if (removalReason == 1024 || removalReason == 272 || removalReason == 528 || removalReason == 2048) {
            return;
        }
        this.addEndingBV(unit.getId(), unit.calcBV());
    }

    private void addEndingBV(int unitID, int BV) {
        if (this.attackerUnits.containsKey(unitID)) {
            this.opData.addEndingBV(true, BV);
        } else if (this.defenderUnits.containsKey(unitID)) {
            this.opData.addEndingBV(false, BV);
        }
    }
}

