/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.CampaignData;
import common.House;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import server.campaign.CampaignMain;
import server.campaign.operations.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationWriter {
    public void writeOpList(TreeMap<String, Operation> ops) {
        String path = "./data/operations/OpList.txt";
        File oldFile = new File(path);
        if (oldFile.exists()) {
            oldFile.delete();
        }
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(path));
            ps.println("#Timestamp=" + System.currentTimeMillis());
            for (Operation currO : ops.values()) {
                String name = currO.getName() + "*";
                String range = currO.getValue("OperationRange") + "*";
                String color = currO.getValue("OperationColor") + "*";
                String hasLong = currO.getTypeIndicator() + "*";
                String launchOn = currO.getValue("PercentageToAttackOnWorld") + "*";
                String launchFrom = currO.getValue("PercentageToAttackOffWorld") + "*";
                String minOwn = currO.getValue("MinPlanetOwnership") + "*";
                String maxOwn = currO.getValue("MaxPlanetOwnership") + "*";
                String reserveOnly = currO.getValue("OnlyAllowedFromReserve") + "*";
                String activeOnly = currO.getValue("OnlyAllowedFromActive") + "*";
                String minSubFactionLevel = currO.getValue("MinSubFactionAccessLevel") + "*";
                String facInfo = "any*";
                if (Boolean.parseBoolean(currO.getValue("OnlyAgainstFactoryWorlds"))) {
                    facInfo = "only*";
                } else if (Boolean.parseBoolean(currO.getValue("OnlyAgainstNonFactoryWorlds"))) {
                    facInfo = "none*";
                }
                String homeworldInfo = "any*";
                if (Boolean.parseBoolean(currO.getValue("OnlyAgainstHomeWorlds"))) {
                    homeworldInfo = "only*";
                } else if (Boolean.parseBoolean(currO.getValue("OnlyAgainstNonHomeWorlds"))) {
                    homeworldInfo = "none*";
                }
                StringBuffer legalDefenders = new StringBuffer();
                if (!currO.getValue("LegalDefendFactions").trim().equals("")) {
                    legalDefenders.append(currO.getValue("LegalDefendFactions").trim() + "*");
                } else if (!currO.getValue("IllegalDefendFactions").trim().equals("")) {
                    StringTokenizer illegalTokenizer = new StringTokenizer(currO.getValue("IllegalDefendFactions").trim(), "$");
                    TreeSet<String> illegals = new TreeSet<String>();
                    while (illegalTokenizer.hasMoreTokens()) {
                        illegals.add(illegalTokenizer.nextToken());
                    }
                    for (House currH : CampaignMain.cm.getData().getAllHouses()) {
                        if (illegals.contains(currH.getName())) continue;
                        legalDefenders.append(currH.getName() + "$");
                    }
                    legalDefenders.append("*");
                } else {
                    legalDefenders.append("allFactions*");
                }
                StringBuffer allowPlanetFlags = new StringBuffer(currO.getValue("AllowPlanetFlags"));
                if (allowPlanetFlags.length() < 1) {
                    allowPlanetFlags.append("^ ^*");
                } else {
                    allowPlanetFlags.append("*");
                }
                StringBuffer disallowPlanetFlags = new StringBuffer(currO.getValue("DisallowPlanetFlags"));
                if (disallowPlanetFlags.length() < 1) {
                    disallowPlanetFlags.append("^ ^*");
                } else {
                    disallowPlanetFlags.append("*");
                }
                ps.println(name + range + color + hasLong + facInfo + homeworldInfo + launchOn + launchFrom + minOwn + maxOwn + reserveOnly + activeOnly + legalDefenders.toString().trim() + allowPlanetFlags.toString().trim() + disallowPlanetFlags.toString().trim() + minSubFactionLevel);
            }
            ps.close();
        }
        catch (FileNotFoundException fe) {
            CampaignData.mwlog.errLog("Error: could not find " + path);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }
}

