/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.CampaignData;
import common.Unit;
import common.UnitFactory;
import common.util.StringUtils;
import java.util.ArrayList;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.operations.Operation;
import server.campaign.operations.ShortOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpsChickenThread
extends Thread {
    private SPlayer pdefender;
    private Vector<SArmy> parmies;
    private int opID;
    private String opName;
    private String message;
    private boolean shouldContinue;
    private int waittime;
    private int leechCount;

    public OpsChickenThread(SPlayer pd, int id, String name, String mess) {
        this.pdefender = pd;
        this.parmies = new Vector(1, 1);
        this.shouldContinue = true;
        this.leechCount = 0;
        this.message = mess;
        this.opID = id;
        this.opName = name;
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        this.waittime = o.getIntValue("TimeToNondefensePenalty");
    }

    public void addArmy(SArmy a) {
        this.parmies.add(a);
    }

    public Vector<SArmy> getArmies() {
        return this.parmies;
    }

    public synchronized void stopChicken() {
        CampaignData.mwlog.gameLog("ChickenThread " + this.opID + "/" + this.pdefender.getName() + " turned off.");
        this.shouldContinue = false;
    }

    public synchronized void doPenalty() {
        int actualPenalty;
        if (!this.shouldContinue) {
            return;
        }
        if (this.pdefender.getMyHouse().isNewbieHouse()) {
            String toPlayer = "You did not defend Attack #" + this.opID + ". You've not been punished because " + "you are in the training faction; however, if you leave an attack undefended in a normal " + "faction you may lose money, units, experience, influence, rewards, or some combination thereof.";
            CampaignMain.cm.toUser(toPlayer, this.pdefender.getName(), true);
            return;
        }
        if (CampaignMain.cm.getIThread().isImmune(this.pdefender)) {
            String toPlayer = "You did not defend Attack #" + this.opID + ". You've not been punished because " + "you are still immune; however, if your immunity wears off and you're still under attack you may " + "lose money, units, experience, influence, rewards, or some combination thereof.";
            CampaignMain.cm.toUser(toPlayer, this.pdefender.getName(), true);
            return;
        }
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        double rpPercent = o.getDoubleValue("PercentRPChickenPenalty");
        double expPercent = o.getDoubleValue("PercentExpChickenPenalty");
        double fluPrecent = o.getDoubleValue("PercentInfluenceChickenPenalty");
        double moneyPercent = o.getDoubleValue("PercentCBillChickenPenalty");
        int rpFlat = o.getIntValue("FlatRPChickenPenalty");
        int expFlat = o.getIntValue("FlatExpChickenPenalty");
        int fluFlat = o.getIntValue("FlatInfluenceChickenPenalty");
        int moneyFlat = o.getIntValue("FlatCBillChickenPenalty");
        int totalRPLoss = 0;
        int totalEXPLoss = 0;
        int totalFluLoss = 0;
        int totalMoneyLoss = 0;
        if (rpPercent > 0.0) {
            totalRPLoss = (int)((double)this.pdefender.getReward() * rpPercent);
        }
        if (expPercent > 0.0) {
            totalEXPLoss = (int)((double)this.pdefender.getExperience() * expPercent);
        }
        if (fluPrecent > 0.0) {
            totalFluLoss = (int)((double)this.pdefender.getInfluence() * fluPrecent);
        }
        if (moneyPercent > 0.0) {
            totalMoneyLoss = (int)((double)this.pdefender.getMoney() * moneyPercent);
        }
        if (rpFlat > 0) {
            totalRPLoss += rpFlat;
        }
        if (rpFlat > 0) {
            totalEXPLoss += expFlat;
        }
        if (rpFlat > 0) {
            totalFluLoss += fluFlat;
        }
        if (rpFlat > 0) {
            totalMoneyLoss += moneyFlat;
        }
        totalRPLoss = Math.min(totalRPLoss, this.pdefender.getReward());
        totalEXPLoss = Math.min(totalEXPLoss, this.pdefender.getExperience());
        totalFluLoss = Math.min(totalFluLoss, this.pdefender.getInfluence());
        totalMoneyLoss = Math.min(totalMoneyLoss, this.pdefender.getMoney());
        boolean hasLoss = false;
        String toPlayer = "Attack #" + this.opID + " wasn't defended in time!";
        StringBuilder winnerHSUpdates = new StringBuilder();
        StringBuilder loserHSUpdates = new StringBuilder();
        if (totalRPLoss > 0) {
            toPlayer = !hasLoss ? toPlayer + " (-" + totalRPLoss + " RP" : toPlayer + ", -" + totalRPLoss + " RP";
            this.pdefender.addReward(-totalRPLoss);
            hasLoss = true;
        }
        if (totalEXPLoss > 0) {
            toPlayer = !hasLoss ? toPlayer + " (-" + totalEXPLoss + " XP" : toPlayer + ", -" + totalEXPLoss + " XP";
            this.pdefender.addExperience(-totalEXPLoss, false);
            hasLoss = true;
        }
        if (totalFluLoss > 0) {
            toPlayer = !hasLoss ? toPlayer + " (-" + CampaignMain.cm.moneyOrFluMessage(false, true, totalFluLoss) : toPlayer + ", -" + CampaignMain.cm.moneyOrFluMessage(false, true, totalFluLoss);
            this.pdefender.addInfluence(-totalFluLoss);
            hasLoss = true;
        }
        if (totalMoneyLoss > 0) {
            toPlayer = !hasLoss ? toPlayer + " (-" + CampaignMain.cm.moneyOrFluMessage(true, true, totalMoneyLoss) : toPlayer + ", -" + CampaignMain.cm.moneyOrFluMessage(true, true, totalMoneyLoss);
            this.pdefender.addMoney(-totalMoneyLoss);
            hasLoss = true;
        }
        if (hasLoss) {
            toPlayer = toPlayer + ")";
        }
        CampaignMain.cm.toUser(toPlayer, this.pdefender.getName(), true);
        ShortOperation parentOp = CampaignMain.cm.getOpsManager().getRunningOps().get(this.opID);
        if (parentOp == null) {
            CampaignData.mwlog.errLog("Tried to do a leech with a null ShortOperation!");
            return;
        }
        int conquestPenalty = o.getIntValue("ConquestPerLeech");
        int delayPenalty = o.getIntValue("DelayPerLeech");
        int prodPenalty = o.getIntValue("ProdPointsPerLeech");
        int unitPenalty = o.getIntValue("UnitsPerLeech");
        int rolloverPenalty = o.getIntValue("FailurePenalty");
        String firstKey = parentOp.getAttackers().firstKey();
        SHouse attackH = CampaignMain.cm.getPlayer(firstKey).getHouseFightingFor();
        SHouse defendH = this.pdefender.getHouseFightingFor();
        SPlanet target = parentOp.getTargetWorld();
        String toMain = this.pdefender.getColoredName() + " did not defend " + StringUtils.aOrAn(attackH.getName(), true, false) + attackH.getColoredNameAsLink() + " attack on " + target.getNameAsColoredLink() + "(#" + this.opID + ") in time. " + defendH.getColoredNameAsLink() + " lost ";
        if (!attackH.isConquerable() || !defendH.isConquerable()) {
            conquestPenalty = 0;
        }
        if (!target.isConquerable()) {
            conquestPenalty = 0;
        }
        hasLoss = false;
        if (conquestPenalty > 0 && (actualPenalty = target.doGainInfluence(attackH, defendH, conquestPenalty, false)) > 0) {
            toMain = toMain + actualPenalty + "cp from the world";
            hasLoss = true;
        }
        if (delayPenalty > 0) {
            if (target.getFactoryCount() == 0) {
                return;
            }
            SHouse owner = target.getOwner();
            if (owner == null || !target.getOwner().equals(defendH)) {
                return;
            }
            for (UnitFactory UF : target.getUnitFactories()) {
                SUnitFactory currFac = (SUnitFactory)UF;
                loserHSUpdates.append(currFac.addRefresh(delayPenalty, false));
            }
            if (hasLoss) {
                toMain = toMain + ", production for " + delayPenalty + " miniticks";
            } else {
                toMain = toMain + " production for " + delayPenalty + " miniticks";
                hasLoss = true;
            }
        }
        if (unitPenalty > 0) {
            ArrayList<SUnit> capturedUnits = new ArrayList<SUnit>();
            int numCaptured = 0;
            for (int type = 0; type < 6; ++type) {
                for (int weight = 3; weight >= 0; --weight) {
                    boolean noUnits = false;
                    while (!noUnits && numCaptured < unitPenalty) {
                        SUnit captured = defendH.getEntity(weight, type);
                        if (captured == null) {
                            noUnits = true;
                            continue;
                        }
                        capturedUnits.add(captured);
                        winnerHSUpdates.append(attackH.addUnit(captured, false));
                        loserHSUpdates.append(defendH.getHSUnitRemovalString(captured));
                        ++numCaptured;
                    }
                }
            }
            if (numCaptured > 0) {
                String unitString = "";
                for (SUnit currU : capturedUnits) {
                    unitString = unitString + currU.getModelName() + ", ";
                }
                unitString = unitString.substring(0, unitString.length() - 2);
                if (hasLoss) {
                    toMain = numCaptured == 1 ? toMain + ", a unit [" + unitString + "]" : toMain + ", " + numCaptured + " units [" + unitString + "]";
                } else {
                    hasLoss = true;
                    toMain = numCaptured == 1 ? toMain + " a unit [" + unitString + "]" : toMain + " " + numCaptured + " units [" + unitString + "]";
                }
            }
        }
        if (prodPenalty > 0 || !hasLoss && rolloverPenalty > 0) {
            if (prodPenalty <= 0) {
                prodPenalty = rolloverPenalty;
            }
            boolean foundComponents = false;
            for (int type = 3; type >= 0 && !foundComponents; --type) {
                if (defendH.getPP(type, 0) <= 0) continue;
                int actualPP = defendH.getPP(type, 0);
                if (actualPP < prodPenalty) {
                    prodPenalty = actualPP;
                }
                loserHSUpdates.append(defendH.addPP(type, 0, -prodPenalty, false));
                winnerHSUpdates.append(attackH.addPP(type, 0, prodPenalty, false));
                if (hasLoss) {
                    toMain = toMain + ", " + prodPenalty + " " + Unit.getWeightClassDesc(type) + " Mek components";
                } else {
                    toMain = toMain + " " + prodPenalty + " " + Unit.getWeightClassDesc(type) + " Mek components";
                    hasLoss = true;
                }
                foundComponents = true;
            }
        }
        if (hasLoss) {
            CampaignMain.cm.doSendToAllOnlinePlayers(toMain, true);
        }
        if (winnerHSUpdates.length() > 0) {
            CampaignMain.cm.doSendToAllOnlinePlayers(attackH, "HS|" + winnerHSUpdates.toString(), false);
        }
        if (loserHSUpdates.length() > 0) {
            CampaignMain.cm.doSendToAllOnlinePlayers(defendH, "HS|" + loserHSUpdates.toString(), false);
        }
        CampaignData.mwlog.gameLog("Leech: " + this.opID + "/" + this.pdefender.getName() + "<br> Player saw: " + toPlayer + "<br> Main saw: " + toMain);
    }

    @Override
    public synchronized void run() {
        CampaignMain.cm.toUser(this.generateAttackLinks(), this.pdefender.getName(), true);
        CampaignMain.cm.toUser(this.generateAttackDialogCall(), this.pdefender.getName(), false);
        this.message = null;
        while (true) {
            try {
                this.wait(this.waittime * 1000);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            if (!this.shouldContinue) {
                return;
            }
            if (CampaignMain.cm.getOpsManager().getOperation(this.opName).getBooleanValue("FreeForAllOperation")) {
                ShortOperation parentOp = CampaignMain.cm.getOpsManager().getRunningOps().get(this.opID);
                Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
                int minPlayers = 3;
                try {
                    minPlayers = o.getIntValue("MinNumberOfPlayers");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (parentOp.getDefenders().size() + parentOp.getAttackers().size() > minPlayers) {
                    parentOp.changeStatus(ShortOperation.STATUS_INPROGRESS);
                } else {
                    CampaignMain.cm.getOpsManager().terminateOperation(parentOp, 2, null);
                }
                return;
            }
            ++this.leechCount;
            if (this.leechCount > CampaignMain.cm.getOpsManager().getOperation(this.opName).getIntValue("LeechesToDeactivate")) {
                this.shouldContinue = false;
                SPlayer currP = CampaignMain.cm.getPlayer(this.pdefender.getName());
                currP.setActive(false);
                CampaignMain.cm.sendPlayerStatusUpdate(currP, new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")) == false);
                CampaignMain.cm.toUser("You've been deactivated!", currP.getName(), true);
                return;
            }
            this.doPenalty();
        }
    }

    public String generateAttackLinks() {
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        boolean hasAnArmy = false;
        StringBuilder toSend = new StringBuilder(this.message + "<br>You may defend with: ");
        int numberOfTeams = Math.max(2, Math.min(8, o.getIntValue("NumberOfTeams")));
        for (SArmy currArmy : this.parmies) {
            int aID = currArmy.getID();
            int aBV = currArmy.getOperationsBV(null);
            int aUnits = currArmy.getAmountOfUnits();
            if (hasAnArmy) {
                toSend.append(", ");
            }
            if (o.getBooleanValue("TeamOperation") && !o.getBooleanValue("TeamsMustBeSameFaction") && !o.getBooleanValue("RandomTeamDetermination")) {
                for (int teamNumber = 1; teamNumber <= numberOfTeams; ++teamNumber) {
                    toSend.append("<a href=\"MEKWARS/c defend#" + this.opID + "#" + aID + "#" + teamNumber + "\"> Team #" + teamNumber + " Army #" + aID + "</a> (Units: " + aUnits + " / BV: " + aBV + ")");
                }
            } else {
                toSend.append("<a href=\"MEKWARS/c defend#" + this.opID + "#" + aID + "#" + -1 + "\">Army #" + aID + "</a> (Units: " + aUnits + " / BV: " + aBV + ")");
            }
            hasAnArmy = true;
        }
        return toSend.toString();
    }

    public String generateAttackDialogCall() {
        String opString = "CC|AT|" + this.opID;
        StringBuilder defendingArmyList = new StringBuilder();
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        int numberOfTeams = -1;
        if (o.getBooleanValue("TeamOperation")) {
            numberOfTeams = Math.max(2, Math.min(8, o.getIntValue("NumberOfTeams")));
            if (o.getBooleanValue("RandomTeamDetermination")) {
                numberOfTeams = -1;
            }
        }
        for (SArmy currArmy : this.parmies) {
            int aID = currArmy.getID();
            defendingArmyList.append("|" + aID);
        }
        return opString + "|" + numberOfTeams + defendingArmyList.toString();
    }
}

