/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.CampaignData;
import server.campaign.CampaignMain;
import server.campaign.operations.Operation;
import server.campaign.operations.ShortOperation;

public class OpsDisconnectionThread
extends Thread {
    private boolean playerReturned = false;
    private int id;
    private String winnerName = "";
    private String loserName = "";
    private long waitReduction;

    public OpsDisconnectionThread(int opID, String w, String l, long waitReduction) {
        if (l == null || l.equalsIgnoreCase("null") || w == null || w.equalsIgnoreCase("null")) {
            throw new NullPointerException();
        }
        this.winnerName = w;
        this.loserName = l;
        this.id = opID;
        this.waitReduction = waitReduction;
    }

    public synchronized void run() {
        long timeToReport = Long.parseLong(CampaignMain.cm.getConfig("DisconnectionTimeToReport"));
        timeToReport *= 1000L;
        if ((timeToReport -= this.waitReduction) < 120000L) {
            timeToReport = 120000L;
        }
        String timeToReturn = CampaignMain.readableTimeWithSeconds(timeToReport);
        CampaignMain.cm.toUser(CampaignMain.cm.getPlayer(this.loserName).getColoredName() + " disconnected. You will win by forfeit if he does not return within " + timeToReturn + ".", this.winnerName, true);
        CampaignData.mwlog.gameLog("Disco Thread/Start:" + this.id + "/" + this.loserName + ". " + this.winnerName + " wins in " + timeToReturn);
        try {
            this.wait(timeToReport);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        if (this.playerReturned) {
            return;
        }
        ShortOperation so = CampaignMain.cm.getOpsManager().getRunningOps().get(this.id);
        if (so == null) {
            return;
        }
        Operation o = CampaignMain.cm.getOpsManager().getOperation(so.getName());
        CampaignData.mwlog.gameLog("Autoreport: " + this.id + "/" + this.loserName + ". " + this.winnerName + " wins by forfeit");
        CampaignMain.cm.getOpsManager().resolveShortAttack(o, so, this.winnerName, this.loserName);
    }

    public void playerReturned(boolean tellOtherPlayer, long timeOffline) {
        if (tellOtherPlayer) {
            CampaignMain.cm.toUser(CampaignMain.cm.getPlayer(this.loserName).getColoredName() + " returned. He was offline for " + CampaignMain.readableTimeWithSeconds(timeOffline) + ".", this.winnerName, true);
            CampaignData.mwlog.gameLog("Disco Thread/Stop:" + this.id + "/" + this.loserName + ". Player returned.");
        } else {
            CampaignData.mwlog.gameLog("Disco Thread/Stop:" + this.id + "/" + this.loserName + ". Player threads cleared.");
        }
        this.playerReturned = true;
    }

    public int getShortID() {
        return this.id;
    }

    public boolean playerHasReturned() {
        return this.playerReturned;
    }
}

