/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.CampaignData;
import java.util.TreeMap;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;

public class OpsScrapThread
extends Thread {
    private String playerName;
    private int maxTotalPayment;
    private int paymentsToDate;
    private long waitTime;
    private boolean isFinished;
    private TreeMap<Integer, Integer> salvagedUnits;

    public OpsScrapThread(String playerName) {
        this.playerName = playerName;
        this.waitTime = new Long(CampaignMain.cm.getConfig("TimeToSelectSalvage"));
        this.maxTotalPayment = 0;
        this.paymentsToDate = 0;
        this.salvagedUnits = new TreeMap();
        this.isFinished = false;
    }

    public void addScrappableUnit(int unitID, int scrapValue) {
        this.salvagedUnits.put(unitID, scrapValue);
    }

    public void setMaxPayment(int maxPayment) {
        this.maxTotalPayment = maxPayment;
        TreeMap<Integer, Integer> toReplace = new TreeMap<Integer, Integer>();
        for (Integer currID : this.salvagedUnits.keySet()) {
            int currScrapValue = this.salvagedUnits.get(currID);
            if (currScrapValue <= this.maxTotalPayment) continue;
            toReplace.put(currID, this.maxTotalPayment);
        }
        for (int currID : toReplace.keySet()) {
            this.salvagedUnits.put(currID, (Integer)toReplace.get(currID));
        }
    }

    public void stopScrap() {
        SPlayer currPlayer = CampaignMain.cm.getPlayer(this.playerName);
        if (currPlayer == null) {
            return;
        }
        for (int currID : this.salvagedUnits.keySet()) {
            SUnit currU = currPlayer.getUnit(currID);
            if (currU == null) continue;
            currU.setScrappableFor(-1);
            CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), this.playerName, false);
        }
        if (currPlayer.getDutyStatus() >= 2) {
            CampaignMain.cm.toUser("You may only scrap units salvaged in your most recent game.", this.playerName);
        }
        this.salvagedUnits.clear();
        this.isFinished = true;
    }

    public void scrapUnit(int unitID) {
        Integer scrapValue = this.salvagedUnits.remove(unitID);
        if (scrapValue == null) {
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(this.playerName);
        if (p == null) {
            return;
        }
        this.paymentsToDate += scrapValue.intValue();
        int maxScrapValue = this.maxTotalPayment - scrapValue;
        TreeMap<Integer, Integer> toReplace = new TreeMap<Integer, Integer>();
        for (Integer currID : this.salvagedUnits.keySet()) {
            int currScrapValue = this.salvagedUnits.get(currID);
            if (currScrapValue <= maxScrapValue) continue;
            toReplace.put(currID, maxScrapValue);
        }
        for (int currID : toReplace.keySet()) {
            SUnit currU = p.getUnit(currID);
            if (currU == null) {
                this.salvagedUnits.remove(currID);
                continue;
            }
            currU.setScrappableFor(maxScrapValue);
            this.salvagedUnits.put(currID, (Integer)toReplace.get(currID));
            CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), this.playerName, false);
        }
    }

    public synchronized void run() {
        SPlayer currPlayer = CampaignMain.cm.getPlayer(this.playerName);
        if (currPlayer == null) {
            return;
        }
        if (currPlayer.getDutyStatus() < 2) {
            return;
        }
        if (!CampaignMain.cm.getBooleanConfig("SelectableSalvage")) {
            return;
        }
        this.waitTime *= 1000L;
        for (int currID : this.salvagedUnits.keySet()) {
            SUnit currU = currPlayer.getUnit(currID);
            if (currU.getScrappableFor() < 1) {
                currU.setScrappableFor(1);
            }
            CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), this.playerName, false);
        }
        CampaignMain.cm.toUser("You have " + CampaignMain.readableTimeWithSeconds(this.waitTime) + " to scrap salvaged units and recover repair costs.", this.playerName, true);
        try {
            this.wait(this.waitTime);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        if (this.isFinished) {
            return;
        }
        currPlayer = CampaignMain.cm.getPlayer(this.playerName);
        if (currPlayer == null) {
            return;
        }
        boolean shouldGetText = currPlayer.getDutyStatus() >= 2;
        boolean scrappablesRemaining = false;
        for (int currID : this.salvagedUnits.keySet()) {
            SUnit currU = currPlayer.getUnit(currID);
            if (currU == null) continue;
            currU.setScrappableFor(-1);
            if (!shouldGetText) continue;
            CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), this.playerName, false);
            scrappablesRemaining = true;
        }
        if (scrappablesRemaining && shouldGetText) {
            CampaignMain.cm.toUser("[!] Time to scrap salvaged has expired.", this.playerName, true);
        }
        this.salvagedUnits.clear();
        this.isFinished = true;
    }

    public boolean isFinished() {
        return this.isFinished;
    }
}

