/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.AdvancedTerrain;
import common.CampaignData;
import common.PlanetEnvironment;
import common.Unit;
import common.UnitFactory;
import common.util.StringUtils;
import common.util.UnitUtils;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import megamek.common.PlanetaryConditions;
import server.campaign.AutoArmy;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationEntity;
import server.campaign.operations.OperationReporter;
import server.campaign.operations.OpsChickenThread;
import server.campaign.pilot.SPilot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortOperation
implements Comparable<Object> {
    public static int STATUS_WAITING = 0;
    public static int STATUS_INPROGRESS = 1;
    public static int STATUS_REPORTING = 2;
    public static int STATUS_FINISHED = 4;
    int startingBV = 0;
    int startingUnits = 0;
    int finishingBV = 0;
    String modHeader = "";
    private SPlanet targetWorld;
    private boolean fromReserve;
    private int shortID = -1;
    private int longID = -1;
    private TreeMap<String, Integer> defenders;
    private TreeMap<String, Integer> attackers;
    private TreeMap<String, SPlayer> winners;
    private TreeMap<String, SPlayer> losers;
    private ArrayList<SArmy> pdlist;
    private TreeMap<String, OpsChickenThread> chickenThreads;
    private TreeMap<Integer, OperationEntity> unitsInProgress;
    private TreeMap<Integer, SPilot> pilotsInProgress;
    private SPlayer initiator;
    private PlanetEnvironment playEnvironment;
    private StringBuilder cityBuilder = new StringBuilder();
    AdvancedTerrain aTerrain = null;
    private boolean intelVacuum = false;
    private boolean doubleBlind = false;
    private double intelGravity = 0.0;
    private int intelTemp = 0;
    private int intelTimeFrame = 0;
    private int intelVisibility = 999;
    private TreeSet<String> cancellingPlayers = new TreeSet();
    private int maxAttackers = 1;
    private int maxDefenders = 1;
    private int minAttackers = 1;
    private int minDefenders = 1;
    private String completeFinishedString;
    private String incompleteFinishedString;
    private int currentStatus;
    private int showsToClear;
    private long startTime = -1L;
    private long completionTime = -1L;
    private StringBuffer gameOptions = new StringBuffer();
    private String attackerAutoString = null;
    private String defenderAutoString = null;
    private String attackerAutoEmplacementsString = null;
    private String defenderAutoEmplacementsString = null;
    private String attackerAutoMinesString = null;
    private String defenderAutoMinesString = null;
    private String attackArtDesc = "";
    private String defendArtDesc = "";
    private float defenderArmyCount = 0.0f;
    private float attackerArmyCount = 0.0f;
    private String attackerMULs = "";
    private String defenderMULs = "";
    private boolean isBuildingOperation = false;
    private String buildingOptions = "";
    private int[] mapEdge = new int[]{2, 6, 4, 8};
    private int[] mapEdgeReverse = new int[]{6, 2, 8, 4};
    private int[] playerEdge = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    private int[] playerEdgeReverse = new int[]{5, 6, 7, 8, 1, 2, 3, 4, 10, 9, 15, 16, 17, 18, 11, 12, 13, 14};
    private int attackerEdge = -1;
    private int defenderEdge = -1;
    private int totalBuildings = -1;
    private int minBuildings = -1;
    private int[] teamEdge = new int[]{2, 6, 4, 8, 1, 5, 3, 7};
    private boolean isTeamOp = false;
    private Dimension mapsize = new Dimension(32, 17);
    private String opName;
    private TreeMap<String, String> playerModifyingOps;
    private String opCyclopsID = null;
    private String autoReportString = null;
    private int playersReported = 0;
    private String bots;
    private String botTeams;
    public Vector<SUnit> preCapturedUnits = null;
    private OperationReporter reporter = new OperationReporter();

    public ShortOperation(String opName, SPlanet target, SPlayer initiator, SArmy attackingArmy, ArrayList<SArmy> possibleDefenders, int shortID, int longID, boolean fromReserve) {
        this.targetWorld = target;
        this.initiator = initiator;
        this.opName = opName;
        this.shortID = shortID;
        this.longID = longID;
        this.fromReserve = fromReserve;
        this.playerModifyingOps = new TreeMap();
        this.chickenThreads = new TreeMap();
        this.attackers = new TreeMap();
        this.defenders = new TreeMap();
        this.winners = new TreeMap();
        this.losers = new TreeMap();
        this.playEnvironment = this.targetWorld.getEnvironments().getRandomEnvironment(CampaignMain.cm.getR());
        this.addAttacker(initiator, attackingArmy, "");
        this.unitsInProgress = new TreeMap();
        this.pilotsInProgress = new TreeMap();
        this.showsToClear = 3;
        this.currentStatus = STATUS_WAITING;
        this.gameOptions.append("GO|");
        this.gameOptions.append(CampaignMain.cm.getMegaMekOptionsToString());
        String toLog = "Attack: #" + shortID + "/" + initiator.getName() + "/" + opName + "/" + target.getName() + ".<br> - Potential Defenders: ";
        for (SArmy currA : possibleDefenders) {
            toLog = toLog + currA.getName() + "/" + currA.getID() + " ";
        }
        CampaignData.mwlog.gameLog(toLog);
        Operation o = CampaignMain.cm.getOpsManager().getOperation(opName);
        this.preCapturedUnits = new Vector(1, 1);
        if (CampaignMain.cm.getBooleanConfig("UseStaticMaps")) {
            try {
                this.aTerrain = this.targetWorld.getAdvancedTerrain().get(new Integer(this.playEnvironment.getId())).clone();
            }
            catch (Exception ex) {
                CampaignData.mwlog.modLog("Unable to find terrain on planet " + this.targetWorld.getName() + " using blank terrain");
                this.aTerrain = new AdvancedTerrain();
            }
            if (o.getBooleanValue("UseOperationMap")) {
                this.aTerrain.setStaticMap(true);
                this.aTerrain.setStaticMapName(o.getValue("MapName"));
                this.aTerrain.setXBoardSize(o.getIntValue("BoardSizeX"));
                this.aTerrain.setYBoardSize(o.getIntValue("BoardSizeY"));
                this.aTerrain.setXSize(o.getIntValue("MapSizeX"));
                this.aTerrain.setYSize(o.getIntValue("MapSizeY"));
            }
            this.aTerrain.setLightConditions(0);
            this.aTerrain.setWeatherConditions(0);
            this.aTerrain.setWindStrength(0);
            this.aTerrain.setWindDirection(0);
            this.aTerrain.setShiftingWindDirection(false);
            this.aTerrain.setShiftingWindStrength(false);
            this.aTerrain.setFog(0);
            this.aTerrain.setEMI(false);
            this.aTerrain.setTerrainAffected(false);
        }
        this.pdlist = possibleDefenders;
        if (!fromReserve && !o.getBooleanValue("TeamOperation") && !o.getBooleanValue("TeamsMustBeSameFaction") || o.getBooleanValue("TeamOperation") && !o.getBooleanValue("TeamsMustBeSameFaction")) {
            this.informPossibleDefenders();
        }
    }

    public void addAttacker(SPlayer p, SArmy a, String modName) {
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        this.attackers.put(p.getName().toLowerCase(), a.getID());
        this.reporter.addAttacker(p.getName(), a.getID());
        if (!modName.equals("")) {
            this.playerModifyingOps.put(p.getName().toLowerCase(), modName);
        }
        p.lockArmy(a.getID());
        this.startingBV += a.getOperationsBV(null);
        this.startingUnits += a.getAmountOfUnits();
        if (o.getBooleanValue("TeamOperation")) {
            if (o.getBooleanValue("TeamsMustBeSameFaction")) {
                int maxPlayers = o.getIntValue("TeamSize");
                int maxBV = o.getIntValue("MaxAttackerBV");
                if (this.getAttackers().size() >= maxPlayers || this.getAttackersBV() >= maxBV) {
                    this.informPossibleDefenders();
                }
            } else {
                int maxTeams = o.getIntValue("NumberOfTeams");
                int maxPlayersPerTeam = o.getIntValue("TeamSize");
                int maxPlayers = Math.max(2, Math.min(8, maxTeams)) * maxPlayersPerTeam;
                if (this.getAllPlayerNames().size() >= maxPlayers) {
                    this.changeStatus(STATUS_INPROGRESS);
                }
            }
        }
    }

    public void removeAttacker(SPlayer p) {
        String pNameLower = p.getName().toLowerCase();
        if (this.attackers.containsKey(pNameLower)) {
            int armyID = this.attackers.remove(pNameLower);
            this.startingBV -= p.getArmy(armyID).getOperationsBV(null);
            this.startingUnits -= p.getArmy(armyID).getAmountOfUnits();
        }
        this.playerModifyingOps.remove(pNameLower);
    }

    public void addDefender(SPlayer p, SArmy a, String modName) {
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        this.defenders.put(p.getName().toLowerCase(), a.getID());
        this.reporter.addDefender(p.getName(), a.getID());
        if (!modName.equals("")) {
            this.playerModifyingOps.put(p.getName().toLowerCase(), modName);
        }
        p.lockArmy(a.getID());
        this.startingBV += a.getOperationsBV(null);
        this.startingUnits += a.getAmountOfUnits();
        if (o.getBooleanValue("TeamOperation")) {
            int maxTeams = o.getIntValue("NumberOfTeams");
            int maxPlayersPerTeam = o.getIntValue("TeamSize");
            int maxPlayers = Math.max(2, Math.min(8, maxTeams)) * maxPlayersPerTeam;
            this.isTeamOp = true;
            if (this.getAllPlayerNames().size() >= maxPlayers) {
                this.changeStatus(STATUS_INPROGRESS);
            } else if (o.getBooleanValue("TeamsMustBeSameFaction") && this.checkDefendersAndLaunch(maxTeams, maxPlayersPerTeam)) {
                this.changeStatus(STATUS_INPROGRESS);
            }
        } else if (!o.getBooleanValue("FreeForAllOperation")) {
            this.changeStatus(STATUS_INPROGRESS);
        }
    }

    public void removeDefender(SPlayer p) {
        String pNameLower = p.getName().toLowerCase();
        if (this.defenders.containsKey(pNameLower)) {
            int armyID = this.defenders.remove(pNameLower);
            this.startingBV -= p.getArmy(armyID).getOperationsBV(null);
            this.startingUnits -= p.getArmy(armyID).getAmountOfUnits();
        }
        this.playerModifyingOps.remove(pNameLower);
    }

    public String getName() {
        return this.opName;
    }

    public TreeMap<String, Integer> getAttackers() {
        return this.attackers;
    }

    public TreeMap<String, Integer> getDefenders() {
        return this.defenders;
    }

    public TreeMap<String, OpsChickenThread> getChickenThreads() {
        return this.chickenThreads;
    }

    public int getStatus() {
        return this.currentStatus;
    }

    public int getTotalBuildings() {
        return this.totalBuildings;
    }

    public int getMinBuildings() {
        return this.minBuildings;
    }

    public void changeStatus(int newStatus) {
        if (newStatus == STATUS_INPROGRESS) {
            SPlayer currP;
            SUnit u;
            Enumeration<Unit> units;
            int tempToSet;
            SPlayer currP2;
            AutoArmy currAutoArmy;
            AutoArmy currAutoArmy2;
            int pos;
            Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
            if (this.defenders.size() < 1) {
                if (!o.getBooleanValue("AttackerAllowAgainstUnclaimedLand")) {
                    for (String currP3 : this.attackers.keySet()) {
                        CampaignMain.cm.toUser("No defenders are listed for this op, someone screwed up!", currP3);
                    }
                }
                return;
            }
            boolean bl = this.isBuildingOperation = o.getIntValue("TotalBuildings") > 0;
            if (this.isBuildingOperation) {
                this.totalBuildings = o.getIntValue("TotalBuildings");
                this.minBuildings = o.getIntValue("MinBuildingsForOp");
                this.buildingOptions = "RBP|" + this.totalBuildings;
                this.buildingOptions = this.buildingOptions + "|" + this.minBuildings;
                this.buildingOptions = this.buildingOptions + "|" + o.getValue("MinFloors");
                this.buildingOptions = this.buildingOptions + "|" + o.getValue("MaxFloors");
                this.buildingOptions = this.buildingOptions + "|" + o.getValue("MinCF");
                this.buildingOptions = this.buildingOptions + "|" + o.getValue("MaxCF");
                this.buildingOptions = this.buildingOptions + "|" + o.getValue("BuildingType");
                if (o.getBooleanValue("BuildingsStartOnMapEdge")) {
                    pos = CampaignMain.cm.getRandomNumber(this.mapEdge.length);
                    this.defenderEdge = this.mapEdge[pos];
                    this.attackerEdge = this.mapEdgeReverse[pos];
                    this.buildingOptions = this.buildingOptions + "|" + this.defenderEdge;
                } else {
                    this.buildingOptions = this.buildingOptions + "|-1";
                }
            } else if (o.getBooleanValue("RandomDeployment")) {
                pos = this.getRandomDeployment(o);
                this.attackerEdge = this.playerEdge[pos];
                this.defenderEdge = this.playerEdgeReverse[pos];
                if (pos >= 11) {
                    this.gameOptions.append("|deep_deployment|true");
                }
            }
            if (o.getBooleanValue("TeamOperation")) {
                for (String currN : this.getAllPlayerNames()) {
                    SPlayer cPlayer = CampaignMain.cm.getPlayer(currN);
                    String edge = "GMEP|" + this.teamEdge[cPlayer.getTeamNumber() - 1];
                    CampaignMain.cm.toUser(edge, currN, false);
                }
            } else if (o.getBooleanValue("FreeForAllOperation") && this.getAllPlayerNames().size() > 2) {
                ArrayList<Integer> edges = new ArrayList<Integer>(10);
                int countDown = 9;
                boolean found = false;
                int pos2 = 0;
                for (pos2 = 0; pos2 < 10; ++pos2) {
                    edges.add(0);
                }
                pos2 = 0;
                for (String currN : this.getAllPlayerNames()) {
                    while (!found) {
                        pos2 = CampaignMain.cm.getRandomNumber(9) + 1;
                        if ((Integer)edges.get(pos2) == 1) continue;
                        found = true;
                        edges.add(pos2, 1);
                    }
                    found = false;
                    --countDown;
                    if (pos2 == 9) {
                        ++pos2;
                    }
                    String edge = "GMEP|" + pos2;
                    CampaignMain.cm.toUser(edge, currN, false);
                    if (countDown > 0) continue;
                    edges.clear();
                    countDown = 9;
                    for (pos2 = 0; pos2 < 10; ++pos2) {
                        edges.add(0);
                    }
                    pos2 = 0;
                }
            } else {
                String edge;
                if (this.defenderEdge != -1) {
                    for (String currN : this.defenders.keySet()) {
                        edge = "GMEP|" + this.defenderEdge;
                        CampaignMain.cm.toUser(edge, currN, false);
                    }
                }
                if (this.attackerEdge != -1) {
                    for (String currN : this.attackers.keySet()) {
                        edge = "GMEP|" + this.attackerEdge;
                        CampaignMain.cm.toUser(edge, currN, false);
                    }
                }
            }
            boolean attackerArty = o.getBooleanValue("AttackerReceivesAutoArtillery");
            boolean defenderArty = o.getBooleanValue("DefenderReceivesAutoArtillery");
            int totalBV = 0;
            if (attackerArty || defenderArty) {
                SPlayer currPlayer;
                for (String currN : this.defenders.keySet()) {
                    currPlayer = CampaignMain.cm.getPlayer(currN);
                    totalBV += currPlayer.getArmy(this.defenders.get(currN)).getBV();
                }
                for (String currN : this.attackers.keySet()) {
                    currPlayer = CampaignMain.cm.getPlayer(currN);
                    totalBV += currPlayer.getArmy(this.attackers.get(currN)).getBV();
                }
            }
            int attackArtBV = 0;
            if (attackerArty) {
                attackArtBV = totalBV;
                int flatMod = o.getIntValue("AttackerFlatArtilleryModifier");
                double percMod = o.getDoubleValue("AttackerPercentArtilleryModifier");
                int attackArtyMin = o.getIntValue("MinAttackerArtilleryBV");
                int attackArtyMax = o.getIntValue("MaxAttackerArtilleryBV");
                if (percMod > 0.0) {
                    attackArtBV = (int)((double)totalBV * percMod);
                }
                if ((attackArtBV += flatMod) < attackArtyMin) {
                    attackArtBV = attackArtyMin;
                } else if (attackArtBV > attackArtyMax) {
                    attackArtBV = attackArtyMax;
                }
            }
            int defendArtBV = 0;
            if (defenderArty) {
                defendArtBV = totalBV;
                int flatMod = o.getIntValue("DefenderFlatArtilleryModifier");
                double percMod = o.getDoubleValue("DefenderPercentArtilleryModifier");
                int defendArtyMin = o.getIntValue("MinDefenderArtilleryBV");
                int defendArtyMax = o.getIntValue("MaxDefenderArtilleryBV");
                if (percMod > 0.0) {
                    defendArtBV = (int)((double)defendArtBV * percMod);
                }
                if ((defendArtBV += flatMod) < defendArtyMin) {
                    defendArtBV = defendArtyMin;
                } else if (defendArtBV > defendArtyMax) {
                    defendArtBV = defendArtyMax;
                }
            }
            if (attackArtBV > 0) {
                currAutoArmy2 = new AutoArmy(attackArtBV, false);
                this.attackerAutoString = "PL|AAA|" + currAutoArmy2.toString("|");
                this.attackArtDesc = "[Bonus Arty: " + currAutoArmy2.getUnits().size() + " pieces, " + currAutoArmy2.getBV() + "BV]<br>";
                for (String currP4 : this.attackers.keySet()) {
                    CampaignMain.cm.toUser(this.attackerAutoString, currP4, false);
                }
            } else {
                this.attackerAutoString = "PL|AAA|CLEAR";
                for (String currP5 : this.attackers.keySet()) {
                    CampaignMain.cm.toUser(this.attackerAutoString, currP5, false);
                }
            }
            if (defendArtBV > 0) {
                currAutoArmy2 = new AutoArmy(defendArtBV, false);
                this.defenderAutoString = "PL|AAA|" + currAutoArmy2.toString("|");
                this.defendArtDesc = "[Bonus Arty: " + currAutoArmy2.getUnits().size() + " pieces, " + currAutoArmy2.getBV() + "BV]<br>";
                for (String currP6 : this.defenders.keySet()) {
                    CampaignMain.cm.toUser(this.defenderAutoString, currP6, false);
                }
            } else {
                this.defenderAutoString = "PL|AAA|CLEAR";
                for (String currP7 : this.defenders.keySet()) {
                    CampaignMain.cm.toUser(this.defenderAutoString, currP7, false);
                }
            }
            boolean attackerGuns = o.getBooleanValue("AttackerReceivesGunEmplacement");
            boolean defenderGuns = o.getBooleanValue("DefenderReceivesGunEmplacement");
            totalBV = 0;
            if (attackerGuns || defenderGuns) {
                for (String currN : this.defenders.keySet()) {
                    SPlayer currPlayer = CampaignMain.cm.getPlayer(currN);
                    totalBV += currPlayer.getArmy(this.defenders.get(currN)).getBV();
                }
                for (String currN : this.attackers.keySet()) {
                    SPlayer currPlayer = CampaignMain.cm.getPlayer(currN);
                    totalBV += currPlayer.getArmy(this.attackers.get(currN)).getBV();
                }
            }
            int attackGunBV = 0;
            if (attackerGuns) {
                attackGunBV = totalBV;
                int flatMod = o.getIntValue("AttackerFlatGunEmplacementModifier");
                double percMod = o.getDoubleValue("AttackerPercentGunEmplacementModifier");
                int attackGunsMin = o.getIntValue("MinAttackerGunEmplacementBV");
                int attackGunsMax = o.getIntValue("MaxAttackerGunEmplacementBV");
                if (percMod > 0.0) {
                    attackGunBV = (int)((double)attackGunBV * percMod);
                }
                if ((attackGunBV += flatMod) < attackGunsMin) {
                    attackGunBV = attackGunsMin;
                } else if (attackGunBV > attackGunsMax) {
                    attackGunBV = attackGunsMax;
                }
            }
            int defendGunBV = 0;
            if (defenderGuns) {
                defendGunBV = totalBV;
                int flatMod = o.getIntValue("DefenderFlatGunEmplacementModifier");
                double percMod = o.getDoubleValue("DefenderPercentGunEmplacementModifier");
                int defendGunsMin = o.getIntValue("MinDefenderGunEmplacementBV");
                int defendGunsMax = o.getIntValue("MaxDefenderGunEmplacementBV");
                if (percMod > 0.0) {
                    defendGunBV = (int)((double)defendGunBV * percMod);
                }
                if ((defendGunBV += flatMod) < defendGunsMin) {
                    defendGunBV = defendGunsMin;
                } else if (defendGunBV > defendGunsMax) {
                    defendGunBV = defendGunsMax;
                }
            }
            if (attackGunBV > 0) {
                currAutoArmy = new AutoArmy(attackGunBV, true);
                this.attackerAutoEmplacementsString = "PL|GEA|" + currAutoArmy.toString("|");
                this.attackArtDesc = this.attackArtDesc + "[Bonus Gun Emplacements: " + currAutoArmy.getUnits().size() + " pieces, " + currAutoArmy.getBV() + "BV]<br>";
                for (String currP8 : this.attackers.keySet()) {
                    CampaignMain.cm.toUser(this.attackerAutoEmplacementsString, currP8, false);
                }
            } else {
                this.attackerAutoEmplacementsString = "PL|GEA|CLEAR";
                for (String currP9 : this.attackers.keySet()) {
                    CampaignMain.cm.toUser(this.attackerAutoEmplacementsString, currP9, false);
                }
            }
            if (defendGunBV > 0) {
                currAutoArmy = new AutoArmy(defendGunBV, true);
                this.defenderAutoEmplacementsString = "PL|GEA|" + currAutoArmy.toString("|");
                this.defendArtDesc = this.defendArtDesc + "[Bonus Gun Emplacements: " + currAutoArmy.getUnits().size() + " pieces, " + currAutoArmy.getBV() + "BV]<br>";
                for (String currP10 : this.defenders.keySet()) {
                    CampaignMain.cm.toUser(this.defenderAutoEmplacementsString, currP10, false);
                }
            } else {
                this.defenderAutoEmplacementsString = "PL|GEA|CLEAR";
                for (String currP11 : this.defenders.keySet()) {
                    CampaignMain.cm.toUser(this.defenderAutoEmplacementsString, currP11, false);
                }
            }
            boolean attackerMines = o.getBooleanValue("AttackerReceivesMines");
            boolean defenderMines = o.getBooleanValue("DefenderReceivesMines");
            totalBV = 0;
            int totalTonnage = 0;
            if (attackerMines || defenderMines) {
                SPlayer currPlayer;
                for (String currN : this.defenders.keySet()) {
                    currPlayer = CampaignMain.cm.getPlayer(currN);
                    totalBV += currPlayer.getArmy(this.defenders.get(currN)).getBV();
                    totalTonnage += currPlayer.getArmy(this.defenders.get(currN)).getTotalTonnage();
                }
                for (String currN : this.attackers.keySet()) {
                    currPlayer = CampaignMain.cm.getPlayer(currN);
                    totalBV += currPlayer.getArmy(this.attackers.get(currN)).getBV();
                    totalTonnage += currPlayer.getArmy(this.attackers.get(currN)).getTotalTonnage();
                }
            }
            int attackerVibraMines = 0;
            int attackerConventionalMines = 0;
            if (attackerMines) {
                int ConventionalBVMod = o.getIntValue("AttackerBVPerConventional");
                int ConventionalTonMod = o.getIntValue("AttackerTonPerConventional");
                int VibraBVMod = o.getIntValue("AttackerBVPerVibra");
                int VibraTonMod = o.getIntValue("AttackerTonPerVibra");
                if (ConventionalBVMod > 0) {
                    attackerConventionalMines += totalBV / ConventionalBVMod;
                }
                if (ConventionalTonMod > 0) {
                    attackerConventionalMines += totalTonnage / ConventionalTonMod;
                }
                if (VibraBVMod > 0) {
                    attackerVibraMines += totalBV / VibraBVMod;
                }
                if (VibraTonMod > 0) {
                    attackerVibraMines += totalTonnage / VibraTonMod;
                }
            }
            int defenderVibraMines = 0;
            int defenderConventionalMines = 0;
            if (defenderMines) {
                int ConventionalBVMod = o.getIntValue("DefenderBVPerConventional");
                int ConventionalTonMod = o.getIntValue("DefenderTonPerConventional");
                int VibraBVMod = o.getIntValue("DefenderBVPerVibra");
                int VibraTonMod = o.getIntValue("DefenderTonPerVibra");
                if (ConventionalBVMod > 0) {
                    defenderConventionalMines += totalBV / ConventionalBVMod;
                }
                if (ConventionalTonMod > 0) {
                    defenderConventionalMines += totalTonnage / ConventionalTonMod;
                }
                if (VibraBVMod > 0) {
                    defenderVibraMines += totalBV / VibraBVMod;
                }
                if (VibraTonMod > 0) {
                    defenderVibraMines += totalTonnage / VibraTonMod;
                }
            }
            if (attackerConventionalMines > 0 || attackerVibraMines > 0) {
                this.attackerAutoMinesString = "PL|AAM|" + attackerConventionalMines + "|" + attackerVibraMines;
                this.attackArtDesc = this.attackArtDesc + "[Bonus Mines: Conventional: " + attackerConventionalMines + " Vibra: " + attackerVibraMines + "]<br>";
                for (String currP12 : this.attackers.keySet()) {
                    CampaignMain.cm.toUser(this.attackerAutoMinesString, currP12, false);
                }
            } else {
                this.attackerAutoMinesString = "PL|AAM|0|0";
                for (String currP13 : this.attackers.keySet()) {
                    CampaignMain.cm.toUser(this.attackerAutoMinesString, currP13, false);
                }
            }
            if (defenderConventionalMines > 0 || defenderVibraMines > 0) {
                this.defenderAutoMinesString = "PL|AAM|" + defenderConventionalMines + "|" + defenderVibraMines;
                this.defendArtDesc = this.defendArtDesc + "[Bonus Mines: Conventional: " + defenderConventionalMines + " Vibra: " + defenderVibraMines + "]<br>";
                for (String currP14 : this.defenders.keySet()) {
                    CampaignMain.cm.toUser(this.defenderAutoMinesString, currP14, false);
                }
            } else {
                this.defenderAutoMinesString = "PL|AAM|0|0";
                for (String currP15 : this.defenders.keySet()) {
                    CampaignMain.cm.toUser(this.defenderAutoMinesString, currP15, false);
                }
            }
            this.bots = "PL|UB|" + o.getBooleanValue("BotControlsAll");
            this.botTeams = "PL|BOST|" + o.getBooleanValue("BotsAllOnSameTeam");
            for (String currN : this.defenders.keySet()) {
                CampaignMain.cm.toUser(this.bots, currN, false);
                CampaignMain.cm.toUser(this.botTeams, currN, false);
            }
            for (String currN : this.attackers.keySet()) {
                CampaignMain.cm.toUser(this.bots, currN, false);
                CampaignMain.cm.toUser(this.botTeams, currN, false);
            }
            boolean attackerHasMUL = o.getBooleanValue("AttackerReceivesMULArmy");
            boolean defenderHasMUL = o.getBooleanValue("DefenderReceivesMULArmy");
            if (attackerHasMUL || defenderHasMUL) {
                Vector<SUnit> units2;
                int numOfArmies;
                int attackerMinArmies = o.getIntValue("MinAttackerMulArmies");
                int attackerMaxArmies = o.getIntValue("MaxAttackerMulArmies");
                String attackerArmyList = o.getValue("AttackerMulArmyList");
                int defenderMinArmies = o.getIntValue("MinDefenderMulArmies");
                int defenderMaxArmies = o.getIntValue("MaxDefenderMulArmies");
                String defenderArmyList = o.getValue("DefenderMulArmyList");
                if (attackerMinArmies > 0 && attackerMaxArmies >= attackerMaxArmies && attackerArmyList.trim().length() > 0 && attackerHasMUL) {
                    numOfArmies = CampaignMain.cm.getRandomNumber(attackerMaxArmies - attackerMinArmies) + attackerMinArmies;
                    units2 = new Vector<SUnit>(1, 1);
                    units2.addAll(this.createMulArmy(numOfArmies, attackerArmyList));
                    if (o.getBooleanValue("AttackerUnitsTakenBeforeFightStarts")) {
                        this.preCapturedUnits.addAll(this.getPreOperationUnits(o));
                        units2.addAll(this.preCapturedUnits);
                    }
                    this.attackerMULs = "PL|SMA|";
                    for (SUnit unit : units2) {
                        this.attackerMULs = this.attackerMULs + unit.toString(true) + "|";
                    }
                    for (String currN : this.attackers.keySet()) {
                        CampaignMain.cm.toUser(this.attackerMULs, currN, false);
                    }
                } else if (o.getBooleanValue("AttackerUnitsTakenBeforeFightStarts")) {
                    this.preCapturedUnits.addAll(this.getPreOperationUnits(o));
                    this.attackerMULs = "PL|SMA|";
                    for (SUnit unit : this.preCapturedUnits) {
                        this.attackerMULs = this.attackerMULs + unit.toString(true) + "|";
                    }
                    for (String currN : this.attackers.keySet()) {
                        CampaignMain.cm.toUser(this.attackerMULs, currN, false);
                    }
                } else {
                    this.attackerMULs = "PL|SMA|CLEAR";
                }
                if (defenderMinArmies > 0 && defenderMaxArmies >= defenderMaxArmies && defenderArmyList.trim().length() > 0 && defenderHasMUL) {
                    numOfArmies = CampaignMain.cm.getRandomNumber(defenderMaxArmies - defenderMinArmies) + defenderMinArmies;
                    units2 = new Vector(1, 1);
                    units2.addAll(this.createMulArmy(numOfArmies, defenderArmyList));
                    this.defenderMULs = "PL|SMA|";
                    for (SUnit unit : units2) {
                        this.defenderMULs = this.defenderMULs + unit.toString(true) + "|";
                    }
                    for (String currN : this.defenders.keySet()) {
                        CampaignMain.cm.toUser(this.defenderMULs, currN, false);
                    }
                } else {
                    this.defenderMULs = "PL|SMA|CLEAR";
                }
            } else {
                if (o.getBooleanValue("AttackerUnitsTakenBeforeFightStarts")) {
                    this.preCapturedUnits.addAll(this.getPreOperationUnits(o));
                    this.attackerMULs = "PL|SMA|";
                    for (SUnit unit : this.preCapturedUnits) {
                        this.attackerMULs = this.attackerMULs + unit.toString(true) + "|";
                    }
                    for (String currN : this.attackers.keySet()) {
                        CampaignMain.cm.toUser(this.attackerMULs, currN, false);
                    }
                } else {
                    this.attackerMULs = "PL|SMA|CLEAR";
                }
                this.defenderMULs = "PL|SMA|CLEAR";
            }
            this.currentStatus = STATUS_INPROGRESS;
            for (String currN : this.getAllPlayerNames()) {
                SPlayer currP16 = CampaignMain.cm.getPlayer(currN);
                currP16.setFighting(true);
                CampaignMain.cm.sendPlayerStatusUpdate(currP16, true);
                CampaignMain.cm.toUser("TL|" + this.getInfo(true, false), currN, false);
                CampaignMain.cm.getOpsManager().removePlayerFromAllPossibleDefenderLists(currN, false);
                CampaignMain.cm.getOpsManager().removePlayerFromAllDefenderLists(currP16, this, true);
                CampaignMain.cm.getOpsManager().removePlayerFromAllAttackerLists(currP16, this, true);
            }
            this.terminateChickenThreads();
            TreeMap<String, SHouse> houseMap = new TreeMap<String, SHouse>();
            for (String currN : this.getAllPlayerNames()) {
                SHouse currH = CampaignMain.cm.getPlayer(currN).getHouseFightingFor();
                if (houseMap.get(currH.getName()) != null) continue;
                houseMap.put(currH.getName(), currH);
            }
            for (SHouse currH : houseMap.values()) {
                CampaignMain.cm.doSendHouseMail(currH, "New Game:", this.getInfo(true, false));
            }
            String firstAttackName = this.attackers.firstKey();
            String firstDefendName = this.defenders.firstKey();
            SPlayer firstAttPlayer = CampaignMain.cm.getPlayer(firstAttackName);
            SPlayer firstDefPlayer = CampaignMain.cm.getPlayer(firstDefendName);
            String attackLogo = "<img height=\"150\" width=\"150\" src =\"" + firstAttPlayer.getMyLogo() + "\">";
            String defendLogo = "<img height=\"150\" width=\"150\" src =\"" + firstDefPlayer.getMyLogo() + "\">";
            String logos = attackLogo + " vs " + defendLogo + "<br>";
            double averageAttackELO = 0.0;
            double averageDefendELO = 0.0;
            for (String currN : this.defenders.keySet()) {
                currP2 = CampaignMain.cm.getPlayer(currN);
                averageDefendELO += currP2.getRating();
            }
            for (String currN : this.attackers.keySet()) {
                currP2 = CampaignMain.cm.getPlayer(currN);
                averageAttackELO += currP2.getRating();
            }
            double difference = Math.abs((averageAttackELO /= (double)this.attackers.size()) - (averageDefendELO /= (double)this.defenders.size()));
            String better = "";
            String worse = "";
            if (difference <= 50.0) {
                better = "<b>Intel Report:</b> This appears to be a balanced fight.";
                worse = "<b>Intel Report:</b> This appears to be a balanced fight.";
            } else if (difference <= 100.0) {
                better = "<b>Intel Report:</b> It appears that our forces have slightly more experience than the enemy.";
                worse = "<b>Intel Report:</b> It appears that our forces are slightly less experienced than the enemy.";
            } else if (difference <= 150.0) {
                better = "<b>Intel Report:</b> The opposing force is somewhat inexperienced. The advantage is ours.";
                worse = "<b>Intel Report:</b> The opposing force has seen a fair amount of combat, and will not be easily dispatched.";
            } else if (difference <= 210.0) {
                better = "<b>Intel Report:</b> Our forces are considerably more experienced than the enemy. Victory is likely, but not assured.";
                worse = "<b>Intel Report:</b> The enemy has sent a hardened, veteran force. This will be a difficult battle.";
            } else {
                better = "<b>Intel Report:</b> The opposing force is little more than ragtag militia - be merciful.";
                worse = "<b>Intel Report:</b> The enemy force is elite. Victory will be difficult to achieve, but would bring great honor.";
            }
            String attackIntel = "";
            String defendIntel = "";
            if (!CampaignMain.cm.getBooleanConfig("HideELO")) {
                if (averageAttackELO > averageDefendELO) {
                    attackIntel = better;
                    defendIntel = worse;
                } else {
                    attackIntel = worse;
                    defendIntel = better;
                }
            } else {
                attackIntel = "<b>Intel Report:</b> Nothing is known about your enemy. Good luck!";
                defendIntel = "<b>Intel Report:</b> Nothing is known about your enemy. Good luck!";
            }
            if (this.attackArtDesc.length() > 0) {
                attackIntel = attackIntel + "<br>" + this.attackArtDesc;
            }
            if (this.defendArtDesc.length() > 0) {
                defendIntel = defendIntel + "<br>" + this.defendArtDesc;
            }
            if (this.isBuildingOperation) {
                attackIntel = attackIntel + "<br><b>Mission Objectives:</b><br>You must destroy " + o.getValue("MinBuildingsForOp") + " out of " + o.getValue("TotalBuildings") + " facilities.";
                defendIntel = defendIntel + "<br><b>Mission Objectives:</b><br>You must defend all " + o.getValue("TotalBuildings") + " of your facilities.";
            }
            if (o.getBooleanValue("AttackerUnitsTakenBeforeFightStarts") && this.preCapturedUnits.size() > 0) {
                StringBuilder unitList = new StringBuilder();
                attackIntel = attackIntel + "<br><b>You've managed to steal the following ";
                if (this.preCapturedUnits.size() > 1) {
                    unitList.append("units ");
                } else {
                    unitList.append("unit ");
                }
                for (SUnit unit : this.preCapturedUnits) {
                    unitList.append(unit.getModelName());
                    unitList.append(", ");
                }
                unitList.replace(unitList.length() - 2, unitList.length(), ".");
                attackIntel = attackIntel + unitList.toString();
                attackIntel = attackIntel + "  Now you need to get away with them!";
                defendIntel = defendIntel + "<br><b>The attackers have managed to steal the following ";
                defendIntel = defendIntel + unitList.toString();
                defendIntel = defendIntel + "  You must stop them, at all costs, before they get away!";
            }
            if (CampaignMain.cm.getBooleanConfig("UseBlindDrops")) {
                this.gameOptions.append("|real_blind_drop|true");
            } else if (o.getBooleanValue("RealBlindDrop")) {
                this.gameOptions.append("|double_blind|true");
                this.gameOptions.append("|real_blind_drop|true");
                this.doubleBlind = true;
            } else {
                this.gameOptions.append("|real_blind_drop|false");
            }
            if (!this.doubleBlind) {
                this.doubleBlind = CampaignMain.cm.getMegaMekClient().game.getOptions().booleanOption("double_blind");
            }
            this.gameOptions.append("|set_arty_player_homeedge|");
            this.gameOptions.append(true);
            if (CampaignMain.cm.getBooleanConfig("UseStaticMaps")) {
                try {
                    int highTemp = this.aTerrain.getHighTemp();
                    int lowTemp = this.aTerrain.getLowTemp();
                    int tempdiff = highTemp - lowTemp;
                    tempToSet = lowTemp;
                    if (tempdiff > 0) {
                        tempToSet = CampaignMain.cm.getRandomNumber(tempdiff) + lowTemp;
                    }
                    if (o.getIntValue("DuskChance") > 0 || o.getIntValue("NightChance") > 0) {
                        if (CampaignMain.cm.getRandomNumber(100) + 1 <= o.getIntValue("DuskChance")) {
                            tempToSet -= Math.abs(this.aTerrain.getNightTempMod()) / 2;
                            this.intelTimeFrame = 1;
                            this.aTerrain.setLightConditions(1);
                        } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= o.getIntValue("NightChance")) {
                            tempToSet -= Math.abs(this.aTerrain.getNightTempMod());
                            this.intelTimeFrame = 2;
                            this.aTerrain.setLightConditions(2);
                        }
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getDuskChance()) {
                        tempToSet -= Math.abs(this.aTerrain.getNightTempMod()) / 2;
                        this.intelTimeFrame = 1;
                        this.aTerrain.setLightConditions(1);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getNightChance()) {
                        tempToSet -= Math.abs(this.aTerrain.getNightTempMod());
                        this.intelTimeFrame = 2;
                        this.aTerrain.setLightConditions(2);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getMoonLessNightChance()) {
                        tempToSet -= Math.abs(this.aTerrain.getNightTempMod());
                        this.intelTimeFrame = 3;
                        this.aTerrain.setLightConditions(3);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getPitchBlackNightChance()) {
                        tempToSet -= Math.abs(this.aTerrain.getNightTempMod());
                        this.intelTimeFrame = 4;
                        this.aTerrain.setLightConditions(4);
                    } else {
                        this.intelTimeFrame = 0;
                    }
                    if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getLightRainfallChance()) {
                        this.aTerrain.setWeatherConditions(1);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getModerateRainFallChance()) {
                        this.aTerrain.setWeatherConditions(2);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getHeavyRainfallChance()) {
                        this.aTerrain.setWeatherConditions(3);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getDownPourChance()) {
                        this.aTerrain.setWeatherConditions(4);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getLightSnowfallChance()) {
                        this.aTerrain.setWeatherConditions(5);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getModerateSnowFallChance()) {
                        this.aTerrain.setWeatherConditions(6);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getHeavySnowfallChance()) {
                        this.aTerrain.setWeatherConditions(7);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getSleetChance()) {
                        this.aTerrain.setWeatherConditions(8);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getIceStormChance()) {
                        this.aTerrain.setWeatherConditions(9);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getLightHailChance()) {
                        this.aTerrain.setWeatherConditions(10);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getHeavyHailChance()) {
                        this.aTerrain.setWeatherConditions(11);
                    }
                    if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getLightWindsChance()) {
                        this.aTerrain.setWindStrength(1);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getModerateWindsChance()) {
                        this.aTerrain.setWindStrength(2);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getStrongWindsChance()) {
                        this.aTerrain.setWindStrength(3);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getStormWindsChance()) {
                        this.aTerrain.setWindStrength(4);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getTornadoF13WindsChance()) {
                        this.aTerrain.setWindStrength(5);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getTornadoF4WindsChance()) {
                        this.aTerrain.setWindStrength(6);
                    }
                    boolean wind = false;
                    if (this.aTerrain.getLightWindsChance() > 0) {
                        wind = true;
                        this.aTerrain.setMaxWindStrength(1);
                    }
                    if (this.aTerrain.getModerateWindsChance() > 0) {
                        wind = true;
                        this.aTerrain.setMaxWindStrength(2);
                    }
                    if (this.aTerrain.getStrongWindsChance() > 0) {
                        wind = true;
                        this.aTerrain.setMaxWindStrength(3);
                    }
                    if (this.aTerrain.getStormWindsChance() > 0) {
                        wind = true;
                        this.aTerrain.setMaxWindStrength(4);
                    }
                    if (this.aTerrain.getTornadoF13WindsChance() > 0) {
                        wind = true;
                        this.aTerrain.setMaxWindStrength(5);
                    }
                    if (this.aTerrain.getTornadoF4WindsChance() > 0) {
                        wind = true;
                        this.aTerrain.setMaxWindStrength(6);
                    }
                    this.aTerrain.setShiftingWindDirection(wind);
                    this.aTerrain.setShiftingWindStrength(wind);
                    if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getLightFogChance()) {
                        this.aTerrain.setFog(1);
                    } else if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getHeavyFogChance()) {
                        this.aTerrain.setFog(2);
                    }
                    if (CampaignMain.cm.getRandomNumber(100) + 1 <= this.aTerrain.getEMIChance()) {
                        this.aTerrain.setEMI(true);
                    }
                    if (this.aTerrain.getAtmosphere() <= 1) {
                        this.gameOptions.append("|fire|false");
                        this.aTerrain.setShiftingWindDirection(false);
                        this.aTerrain.setShiftingWindStrength(false);
                    } else if (CampaignMain.cm.getMegaMekClient().game.getOptions().booleanOption("tacops_start_fire") && !wind) {
                        this.aTerrain.setShiftingWindDirection(true);
                        this.aTerrain.setShiftingWindStrength(true);
                        this.aTerrain.setMaxWindStrength(1);
                    }
                    this.intelGravity = this.aTerrain.getGravity();
                    this.intelTemp = tempToSet;
                    this.aTerrain.setTemperature(tempToSet);
                    this.intelVacuum = this.aTerrain.getAtmosphere() <= 1;
                    PlanetaryConditions pc = new PlanetaryConditions();
                    pc.setAtmosphere(this.aTerrain.getAtmosphere());
                    pc.setFog(this.aTerrain.getFog());
                    pc.setLight(this.aTerrain.getLightConditions());
                    pc.setWindStrength(this.aTerrain.getWindStrength());
                    pc.setWeather(this.aTerrain.getWeatherConditions());
                    this.intelVisibility = pc.getVisualRange(null, false);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("Unable to retrieve advanced terrain data for Planet: " + this.targetWorld.getName() + " Terrain: " + this.playEnvironment.getName());
                    CampaignData.mwlog.errLog(ex);
                }
            } else {
                int highTemp = this.targetWorld.getTemp().height;
                int lowTemp = this.targetWorld.getTemp().width;
                int tempdiff = highTemp - lowTemp;
                tempToSet = lowTemp;
                if (tempdiff > 0) {
                    tempToSet = CampaignMain.cm.getRandomNumber(tempdiff) + lowTemp;
                }
                if (this.targetWorld.isVacuum()) {
                    this.gameOptions.append("|fire|false");
                }
                this.intelGravity = this.targetWorld.getGravity();
                this.intelTemp = tempToSet;
                this.intelVacuum = this.targetWorld.isVacuum();
            }
            if (o.getBooleanValue("FreeForAllOperation")) {
                this.gameOptions.append("|exclusive_db_deployment|false");
            }
            if (o.getIntValue("NumberOfVictoryConditions") > 0 && o.getBooleanValue("UseDestroyEnemyBV") || o.getBooleanValue("UseBVRatioPercent") || o.getBooleanValue("UseUnitCommander")) {
                this.gameOptions.append("|check_victory|true");
                this.gameOptions.append("|achieve_conditions|");
                this.gameOptions.append(o.getValue("NumberOfVictoryConditions"));
                this.gameOptions.append("|use_bv_destroyed|");
                this.gameOptions.append(o.getValue("UseDestroyEnemyBV"));
                this.gameOptions.append("|bv_destroyed_percent|");
                this.gameOptions.append(o.getValue("DestroyEnemyBV"));
                this.gameOptions.append("|use_bv_ratio|");
                this.gameOptions.append(o.getValue("UseBVRatioPercent"));
                this.gameOptions.append("|bv_ratio_percent|");
                this.gameOptions.append(o.getValue("BVRatioPercent"));
                this.gameOptions.append("|commander_killed|");
                this.gameOptions.append(o.getValue("UseUnitCommander"));
            } else {
                this.gameOptions.append("|check_victory|true|use_bv_destroyed|false|use_bv_ratio|false");
            }
            if (o.getBooleanValue("BotControlsAll") || o.getBooleanValue("BotsAllOnSameTeam")) {
                this.gameOptions.append("|exclusive_db_deployment|false");
            }
            this.gameOptions.append("|individual_initiative|");
            this.gameOptions.append(o.getValue("IndividualInit"));
            this.gameOptions.append("|no_force_size_mod|");
            this.gameOptions.append(!CampaignMain.cm.getBooleanConfig("UseOperationsRule"));
            if (CampaignMain.cm.isUsingAdvanceRepair()) {
                SUnit u2;
                for (String currN : this.defenders.keySet()) {
                    SPlayer currP17 = CampaignMain.cm.getPlayer(currN);
                    SArmy currA = currP17.getArmy(this.defenders.get(currN));
                    Enumeration<Unit> units3 = currA.getUnits().elements();
                    while (units3.hasMoreElements()) {
                        u2 = (SUnit)units3.nextElement();
                        if (!UnitUtils.isRepairing(u2.getEntity())) continue;
                        CampaignMain.cm.getRTT().stopAllRepairJobs(u2.getId(), currP17);
                    }
                }
                for (String currN : this.attackers.keySet()) {
                    SPlayer currP18 = CampaignMain.cm.getPlayer(currN);
                    SArmy currA = currP18.getArmy(this.attackers.get(currN));
                    Enumeration<Unit> units4 = currA.getUnits().elements();
                    while (units4.hasMoreElements()) {
                        u2 = (SUnit)units4.nextElement();
                        if (!UnitUtils.isRepairing(u2.getEntity())) continue;
                        CampaignMain.cm.getRTT().stopAllRepairJobs(u2.getId(), currP18);
                    }
                }
            }
            int totalWeight = 0;
            for (String currN : this.defenders.keySet()) {
                SPlayer currP19 = CampaignMain.cm.getPlayer(currN);
                SArmy currA = currP19.getArmy(this.defenders.get(currN));
                units = currA.getUnits().elements();
                this.defenderArmyCount += currA.getRawForceSize();
                while (units.hasMoreElements()) {
                    u = (SUnit)units.nextElement();
                    totalWeight += SUnit.getMapSizeModification(u);
                }
            }
            for (String currN : this.attackers.keySet()) {
                SPlayer currP20 = CampaignMain.cm.getPlayer(currN);
                SArmy currA = currP20.getArmy(this.attackers.get(currN));
                this.attackerArmyCount += currA.getRawForceSize();
                units = currA.getUnits().elements();
                while (units.hasMoreElements()) {
                    u = (SUnit)units.nextElement();
                    totalWeight += SUnit.getMapSizeModification(u);
                }
            }
            totalWeight = (int)Math.sqrt(totalWeight);
            int sizeX = Math.max(totalWeight + 3, o.getIntValue("MapSizeX"));
            int sizeY = Math.max(totalWeight - 2, o.getIntValue("MapSizeY"));
            this.mapsize = new Dimension(sizeX, sizeY);
            for (String currN : this.attackers.keySet()) {
                if (CampaignMain.cm.getBooleanConfig("AllowPreliminaryOperationsReports")) {
                    currP = CampaignMain.cm.getPlayer(currN);
                    CampaignMain.cm.toUser(logos + this.planetIntel(attackIntel, currP.getHouseFightingFor()), currP.getName(), true);
                } else {
                    CampaignMain.cm.toUser(logos + attackIntel, currN, true);
                }
                CampaignMain.cm.toUser(this.getInfo(true, false), currN, true);
            }
            for (String currN : this.defenders.keySet()) {
                if (CampaignMain.cm.getBooleanConfig("AllowPreliminaryOperationsReports")) {
                    currP = CampaignMain.cm.getPlayer(currN);
                    CampaignMain.cm.toUser(logos + this.planetIntel(defendIntel, currP.getHouseFightingFor()), currP.getName(), true);
                } else {
                    CampaignMain.cm.toUser(logos + defendIntel, currN, true);
                }
                CampaignMain.cm.toUser(this.getInfo(true, false), currN, true);
            }
            if (o.getBooleanValue("RCGUseCityGenerator")) {
                this.cityBuilder.append("0$0$");
                this.cityBuilder.append(o.getValue("RCGMinCF") + "$");
                this.cityBuilder.append(o.getValue("RCGMaxCF") + "$");
                this.cityBuilder.append(o.getValue("RCGMinFloors") + "$");
                this.cityBuilder.append(o.getValue("RCGMaxFloors") + "$");
                this.cityBuilder.append(o.getValue("RCGCityDensity") + "$");
                this.cityBuilder.append(o.getValue("RCGCityType") + "$");
                this.cityBuilder.append(o.getValue("RCGCityBlocks") + "$");
            }
            for (String currN : this.getAllPlayerNames()) {
                CampaignMain.cm.toUser(this.gameOptions.toString(), currN, false);
                if (this.aTerrain != null) {
                    CampaignMain.cm.toUser("APE|" + this.aTerrain.toStringPlanetaryConditions(), currN, false);
                    CampaignMain.cm.toUser("PE|" + this.playEnvironment.toString(this.cityBuilder.toString()) + "|" + this.mapsize.width + "|" + this.mapsize.height + "|" + o.getValue("MapMedium"), currN, false);
                } else {
                    CampaignMain.cm.toUser("PE|" + this.playEnvironment.toString(this.cityBuilder.toString()) + "|" + this.mapsize.width + "|" + this.mapsize.height + "|" + o.getValue("MapMedium"), currN, false);
                }
                if (this.buildingOptions.length() > 1) {
                    CampaignMain.cm.toUser(this.buildingOptions, currN, false);
                }
                CampaignMain.cm.getPlayer(currN).setSave();
            }
            if (CampaignMain.cm.isUsingCyclops()) {
                this.opCyclopsID = Long.toString(System.currentTimeMillis()) + "-" + this.getShortID();
                CampaignMain.cm.getMWCC().opWrite(this);
            }
            this.startTime = System.currentTimeMillis();
            this.modHeader = this.modHeader + "[Attacker" + StringUtils.addAnS(this.attackers.size()) + ": ";
            for (String currName : this.attackers.keySet()) {
                currP = CampaignMain.cm.getPlayer(currName);
                this.modHeader = this.modHeader + currP.getColoredName() + ", ";
            }
            this.modHeader = this.modHeader.substring(0, this.modHeader.length() - 2);
            this.modHeader = this.modHeader + " / Defender" + StringUtils.addAnS(this.defenders.size()) + ":";
            for (String currName : this.defenders.keySet()) {
                currP = CampaignMain.cm.getPlayer(currName);
                this.modHeader = this.modHeader + currP.getColoredName() + ", ";
            }
            this.modHeader = this.modHeader.substring(0, this.modHeader.length() - 2);
            this.modHeader = this.modHeader + " / Type: " + this.getName();
            this.modHeader = this.modHeader + " / Start BV: " + this.startingBV;
            this.reporter.setUpOperation(this.getName(), this.getTargetWorld().getName(), this.getEnvironment().getName(), this.getEnvironment().getTheme());
        } else if (newStatus == STATUS_REPORTING) {
            this.currentStatus = newStatus;
        } else if (newStatus == STATUS_FINISHED) {
            this.currentStatus = newStatus;
            CampaignMain.cm.getOpsManager().clearAllDisconnectionTracks(this);
            this.completionTime = System.currentTimeMillis();
            StringBuilder toStore = new StringBuilder();
            toStore.append("#" + this.getShortID() + " [" + this.getName() + "]" + " [" + this.targetWorld.getName() + "]" + " Duration: " + CampaignMain.readableTime(this.completionTime - this.startTime) + " / Players: ");
            boolean firstPlayer = true;
            for (String currName : this.getAllPlayerNames()) {
                if (firstPlayer) {
                    toStore.append(currName);
                    firstPlayer = false;
                    continue;
                }
                toStore.append(" + " + currName);
            }
            toStore.append("/ Start BV: " + this.startingBV + " / Finish BV: " + this.finishingBV + " ");
            if (this.aTerrain != null) {
                toStore.append("/ Terrain: " + this.aTerrain.getDisplayName() + " ");
            } else {
                toStore.append("/ Terrain: " + this.playEnvironment.getName() + " ");
            }
            toStore.append("/ Theme: " + this.playEnvironment.getTheme());
            if (CampaignMain.cm.getBooleanConfig("UseOperationsRule")) {
                if (this.getWinners().containsKey(this.getAttackers().firstKey())) {
                    toStore.append(" / FSM (");
                    toStore.append(this.attackerArmyCount);
                    toStore.append(") ");
                    toStore.append(this.defenderArmyCount);
                } else {
                    toStore.append(" / FSM ");
                    toStore.append(this.attackerArmyCount);
                    toStore.append(" (");
                    toStore.append(this.defenderArmyCount);
                    toStore.append(")");
                }
            }
            CampaignData.mwlog.resultsLog(toStore.toString());
            TreeMap<String, SHouse> houseMap = new TreeMap<String, SHouse>();
            for (String currN : this.getAllPlayerNames()) {
                SHouse currH = CampaignMain.cm.getPlayer(currN).getHouseFightingFor();
                if (houseMap.get(currH.getName()) != null) continue;
                houseMap.put(currH.getName(), currH);
            }
            String toSend = "";
            toSend = CampaignMain.cm.getBooleanConfig("ShowCompleteGameInfoOnTick") ? this.completeFinishedString.replaceAll("<br>", " ") : this.incompleteFinishedString.replaceAll("<br>", " ");
            for (SHouse currH : houseMap.values()) {
                CampaignMain.cm.doSendHouseMail(currH, "Finished Game", toSend);
            }
            this.defenders.clear();
            this.attackers.clear();
            this.winners.clear();
            this.losers.clear();
        }
    }

    public void sendReconnectInfoToPlayer(SPlayer p) {
        String lowerName = p.getName().toLowerCase();
        if (this.currentStatus != STATUS_INPROGRESS) {
            return;
        }
        p.lockArmy(this.getAllPlayersAndArmies().get(p.getName().toLowerCase()));
        CampaignMain.cm.toUser(this.gameOptions.toString(), lowerName, false);
        Operation o = CampaignMain.cm.getOpsManager().getOperation(CampaignMain.cm.getOpsManager().getShortOpForPlayer(p).getName());
        if (this.aTerrain != null) {
            CampaignMain.cm.toUser("APE|" + this.aTerrain.toStringPlanetaryConditions(), lowerName, false);
            CampaignMain.cm.toUser("PE|" + this.playEnvironment.toString(this.cityBuilder.toString()) + "|" + this.mapsize.width + "|" + this.mapsize.height + "|" + o.getValue("MapMedium"), lowerName, false);
        } else {
            CampaignMain.cm.toUser("PE|" + this.playEnvironment.toString(this.cityBuilder.toString()) + "|" + this.mapsize.width + "|" + this.mapsize.height + "|" + o.getValue("MapMedium"), lowerName, false);
        }
        if (this.isTeamOp) {
            CampaignMain.cm.toUser("PL|STN|" + p.getTeamNumber(), lowerName, false);
            CampaignData.mwlog.debugLog(p.getName() + " Team: " + p.getTeamNumber());
            CampaignMain.cm.toUser("GMEP|" + this.teamEdge[p.getTeamNumber() - 1], lowerName, false);
            CampaignData.mwlog.debugLog("Sent team edge to " + p.getName());
        } else if (this.defenders.containsKey(lowerName)) {
            CampaignMain.cm.toUser("GMEP|" + this.defenderEdge, lowerName, false);
            CampaignMain.cm.toUser(this.defenderAutoString, lowerName, false);
            CampaignMain.cm.toUser(this.defenderAutoEmplacementsString, lowerName, false);
            CampaignMain.cm.toUser(this.defenderAutoMinesString, lowerName, false);
            CampaignMain.cm.toUser(this.defenderMULs, lowerName, false);
        } else if (this.attackers.containsKey(lowerName)) {
            CampaignMain.cm.toUser("GMEP|" + this.attackerEdge, lowerName, false);
            CampaignMain.cm.toUser(this.attackerAutoString, lowerName, false);
            CampaignMain.cm.toUser(this.attackerAutoEmplacementsString, lowerName, false);
            CampaignMain.cm.toUser(this.attackerAutoMinesString, lowerName, false);
            CampaignMain.cm.toUser(this.attackerMULs, lowerName, false);
        }
        if (this.buildingOptions.length() > 1) {
            CampaignMain.cm.toUser(this.buildingOptions, lowerName, false);
        }
        CampaignMain.cm.toUser(this.bots, lowerName, false);
        CampaignMain.cm.toUser(this.botTeams, lowerName, false);
        p.setFightingNoOppList();
        CampaignMain.cm.sendPlayerStatusUpdate(p, true);
    }

    public int getMaxAttackers() {
        return this.maxAttackers;
    }

    public int getMaxDefenders() {
        return this.maxDefenders;
    }

    public int getMinAttackers() {
        return this.minAttackers;
    }

    public int getMinDefedners() {
        return this.minDefenders;
    }

    public String getOpCyclopsID() {
        return this.opCyclopsID;
    }

    public PlanetEnvironment getEnvironment() {
        return this.playEnvironment;
    }

    public SPlanet getTargetWorld() {
        return this.targetWorld;
    }

    public int getShortID() {
        return this.shortID;
    }

    public void setShortID(int newID) {
        this.shortID = newID;
    }

    public int getLongID() {
        return this.longID;
    }

    public void addInProgressUpdate(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, "*");
        if (s.startsWith("MW*")) {
            tokenizer.nextToken();
            int originalID = Integer.parseInt(tokenizer.nextToken());
            int pickupID = Integer.parseInt(tokenizer.nextToken());
            boolean isDead = Boolean.parseBoolean(tokenizer.nextToken());
            SPilot mw = SPilot.getMekWarrior(originalID, pickupID);
            mw.setDeath(isDead);
            this.pilotsInProgress.put(originalID, mw);
        } else {
            OperationEntity oe = new OperationEntity(s);
            this.unitsInProgress.put(oe.getID(), oe);
        }
    }

    public TreeMap<Integer, OperationEntity> getUnitsInProgress() {
        return this.unitsInProgress;
    }

    public TreeMap<Integer, SPilot> getPilotsInProgress() {
        return this.pilotsInProgress;
    }

    public void informPossibleDefenders() {
        for (SArmy currArmy : this.pdlist) {
            SPlayer currPlayer = CampaignMain.cm.getPlayer(currArmy.getPlayerName());
            String playername = currPlayer.getName().toLowerCase();
            if (this.chickenThreads.containsKey(playername)) {
                OpsChickenThread pThread = this.chickenThreads.get(playername);
                pThread.addArmy(currArmy);
                continue;
            }
            String defenderMess = this.getDefenderMessage();
            OpsChickenThread newThread = new OpsChickenThread(currPlayer, this.shortID, this.opName, defenderMess);
            newThread.addArmy(currArmy);
            this.chickenThreads.put(playername, newThread);
            CampaignData.mwlog.gameLog("Created chicken thread for " + this.shortID + "/" + currPlayer.getName() + "(" + this.opName + ")");
        }
        CampaignData.mwlog.gameLog("Starting all chicken threads for #" + this.shortID + " (" + this.opName + ")");
        for (OpsChickenThread ct : this.chickenThreads.values()) {
            ct.start();
        }
    }

    public void removePossibleDefender(String name, boolean penalize) {
        String currName = name.toLowerCase();
        OpsChickenThread currT = this.chickenThreads.get(currName);
        if (currT == null) {
            return;
        }
        if (penalize) {
            currT.doPenalty();
        }
        currT.stopChicken();
        this.chickenThreads.remove(currName);
    }

    public void terminateChickenThreads() {
        for (OpsChickenThread currT : this.chickenThreads.values()) {
            currT.stopChicken();
        }
        this.chickenThreads.clear();
    }

    public String getInfo(boolean complete, boolean mod) {
        if (this.currentStatus == STATUS_WAITING) {
            return this.getWaitingInfo(complete);
        }
        if (this.currentStatus == STATUS_INPROGRESS || this.currentStatus == STATUS_REPORTING) {
            return this.getInProgressInfo(complete, mod);
        }
        if (this.currentStatus == STATUS_FINISHED) {
            return this.getFinishedInfo(complete, mod);
        }
        return "";
    }

    private String getDefenderMessage() {
        String resultString = "";
        int numAttackers = this.attackers.size();
        resultString = resultString + this.getAttackerString(false, false);
        resultString = numAttackers > 1 ? resultString + " are " : resultString + " is ";
        resultString = resultString + " attacking " + this.targetWorld.getNameAsColoredLink() + "! ";
        if (CampaignMain.cm.getBooleanConfig("DisplayOperationName")) {
            resultString = resultString + "Operation: " + this.getName() + ". ";
        }
        if (numAttackers == 1) {
            SArmy attackArm = CampaignMain.cm.getPlayer(this.attackers.firstKey()).getArmy(this.attackers.get(this.attackers.firstKey()));
            resultString = resultString + attackArm.getInaccurateDescription();
        } else if (numAttackers > 1) {
            int totalBV = 0;
            int totalUnits = 0;
            for (String currN : this.attackers.keySet()) {
                SArmy currArmy = CampaignMain.cm.getPlayer(currN).getArmy(this.attackers.get(currN));
                totalBV += currArmy.getOperationsBV(null);
                totalUnits += currArmy.getAmountOfUnits();
            }
            resultString = resultString + "(Total Units: " + totalUnits + " / Total BV: " + totalBV + ")";
        }
        return resultString;
    }

    private String getWaitingInfo(boolean complete) {
        String resultString = "";
        resultString = resultString + "#" + this.getShortID() + " ";
        int numAttackers = this.attackers.size();
        resultString = resultString + this.getAttackerString(complete, false);
        resultString = numAttackers > 1 ? resultString + " are " : resultString + " is ";
        resultString = resultString + " attacking " + this.targetWorld.getNameAsColoredLink() + "! ";
        if (CampaignMain.cm.getBooleanConfig("DisplayOperationName")) {
            resultString = resultString + "Operation: " + this.getName() + ". ";
        }
        if (numAttackers == 1) {
            SArmy attackArm = CampaignMain.cm.getPlayer(this.attackers.firstKey()).getArmy(this.attackers.get(this.attackers.firstKey()));
            resultString = complete ? resultString + attackArm.getInaccurateDescription() : resultString + attackArm.getInaccurateDescription();
        } else if (numAttackers > 1) {
            int totalBV = 0;
            int totalUnits = 0;
            for (String currN : this.attackers.keySet()) {
                SArmy currArmy = CampaignMain.cm.getPlayer(currN).getArmy(this.attackers.get(currN));
                totalBV += currArmy.getOperationsBV(null);
                totalUnits += currArmy.getAmountOfUnits();
            }
            resultString = resultString + "(Total Units: " + totalUnits + " / Total BV: " + totalBV + ")";
        }
        return resultString;
    }

    private String getInProgressInfo(boolean complete, boolean mod) {
        String multiPlayerString;
        String resultString;
        block16: {
            SArmy currArmy;
            resultString = "";
            multiPlayerString = "";
            boolean blindDrop = CampaignMain.cm.getBooleanConfig("UseBlindDrops");
            Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
            if (o.getBooleanValue("RealBlindDrop")) {
                blindDrop = true;
            }
            resultString = resultString + "#" + this.getShortID() + " ";
            int numAttackers = this.attackers.size();
            int numDefenders = this.defenders.size();
            if (mod) {
                Long duration = System.currentTimeMillis() - this.startTime;
                String readableDuration = CampaignMain.readableTime(duration);
                resultString = resultString + this.modHeader + " / Duration: " + readableDuration + "]<br>";
            }
            resultString = resultString + this.getAttackerString(complete, true);
            resultString = numAttackers > 1 ? resultString + " are " : resultString + " is ";
            resultString = resultString + " attempting " + StringUtils.aOrAn(this.opName, true) + " on " + this.targetWorld.getNameAsColoredLink() + " ";
            if (numAttackers == 1 && numDefenders < 2) {
                SArmy attackArm = CampaignMain.cm.getPlayer(this.attackers.firstKey()).getArmy(this.attackers.get(this.attackers.firstKey()));
                SArmy defendArm = CampaignMain.cm.getPlayer(this.defenders.firstKey()).getArmy(this.defenders.get(this.defenders.firstKey()));
                resultString = mod || complete && !blindDrop ? resultString + " with " + attackArm.getDescription(true, defendArm) : resultString + attackArm.getInaccurateDescription();
            } else if (numAttackers > 1 || numDefenders > 1) {
                int totalBV = 0;
                int totalUnits = 0;
                for (String currN : this.attackers.keySet()) {
                    currArmy = CampaignMain.cm.getPlayer(currN).getArmy(this.attackers.get(currN));
                    totalBV += currArmy.getOperationsBV(null);
                    totalUnits += currArmy.getAmountOfUnits();
                    if (!mod && (!complete || blindDrop)) continue;
                    resultString = resultString + "with " + currArmy.getDescription(true, null);
                }
                multiPlayerString = multiPlayerString + " - Total Attacker Units: " + totalUnits + " / BV: " + totalBV + "<br>";
            }
            resultString = resultString + ". " + this.getDefenderString(complete, mod);
            resultString = numDefenders > 1 ? resultString + " are " : resultString + " is ";
            resultString = resultString + "defending ";
            if (numDefenders == 1 && numAttackers < 2) {
                try {
                    SArmy attackArm = CampaignMain.cm.getPlayer(this.attackers.firstKey()).getArmy(this.attackers.get(this.attackers.firstKey()));
                    SArmy defendArm = CampaignMain.cm.getPlayer(this.defenders.firstKey()).getArmy(this.defenders.get(this.defenders.firstKey()));
                    if (mod || complete && !blindDrop) {
                        resultString = resultString + " with " + defendArm.getDescription(true, attackArm);
                        break block16;
                    }
                    resultString = resultString + defendArm.getInaccurateDescription();
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            } else if (numAttackers > 1 || numDefenders > 1) {
                int totalBV = 0;
                int totalUnits = 0;
                for (String currN : this.defenders.keySet()) {
                    try {
                        currArmy = CampaignMain.cm.getPlayer(currN).getArmy(this.defenders.get(currN));
                        totalBV += currArmy.getOperationsBV(null);
                        totalUnits += currArmy.getAmountOfUnits();
                        if (!mod && (!complete || blindDrop)) continue;
                        resultString = resultString + "with " + currArmy.getDescription(true, null);
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog(ex);
                    }
                }
                multiPlayerString = multiPlayerString + " - Total Defender Units: " + totalUnits + " / BV: " + totalBV;
            }
        }
        if (!multiPlayerString.equals("")) {
            resultString = resultString + "<br>" + multiPlayerString;
        }
        return resultString;
    }

    private String getFinishedInfo(boolean complete, boolean mod) {
        Long age = System.currentTimeMillis() - this.completionTime;
        String toReturn = CampaignMain.readableTime(age) + " ago: ";
        if (mod) {
            Long duration = this.completionTime - this.startTime;
            String readableDuration = CampaignMain.readableTime(duration);
            toReturn = toReturn + this.modHeader + " / Duration: " + readableDuration + "]<br>";
            toReturn = toReturn + this.completeFinishedString;
        } else {
            toReturn = complete ? toReturn + this.completeFinishedString : toReturn + this.incompleteFinishedString;
        }
        return toReturn;
    }

    public void setCompleteFinishedInfo(String toSet) {
        this.completeFinishedString = toSet;
    }

    public void setIncompleteFinishedInfo(String toSet) {
        this.incompleteFinishedString = toSet;
    }

    private String getAttackerString(boolean complete, boolean showName) {
        int currAttacker = 0;
        int numAttackers = this.attackers.size();
        boolean blindDrop = CampaignMain.cm.getBooleanConfig("UseBlindDrops");
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        if (o.getBooleanValue("RealBlindDrop")) {
            blindDrop = true;
        }
        String attackString = "";
        if (complete && !blindDrop) {
            Iterator<String> i = this.attackers.keySet().iterator();
            while (i.hasNext()) {
                SPlayer currPlayer = CampaignMain.cm.getPlayer(i.next());
                ++currAttacker;
                attackString = attackString + currPlayer.getColoredName() + currPlayer.getHouseFightingFor().getColoredAbbreviation(true);
                if (numAttackers == 2 && i.hasNext()) {
                    attackString = attackString + " and ";
                    continue;
                }
                if (numAttackers <= 2 || !i.hasNext()) continue;
                if (currAttacker + 1 < numAttackers) {
                    attackString = attackString + ", ";
                    continue;
                }
                if (currAttacker + 1 != numAttackers) continue;
                attackString = attackString + " and ";
            }
        } else {
            String nameString = showName && numAttackers == 1 ? this.initiator.getColoredName() + this.initiator.getHouseFightingFor().getColoredAbbreviation(true) : this.initiator.getHouseFightingFor().getColoredNameAsLink();
            if (numAttackers == 1) {
                attackString = attackString + nameString;
            } else if (numAttackers > 1) {
                attackString = attackString + numAttackers + " " + nameString + " players ";
            }
        }
        return attackString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDefenderString(boolean complete, boolean mod) {
        int currDefender = 0;
        int numDefenders = this.defenders.size();
        boolean blindDrop = CampaignMain.cm.getBooleanConfig("UseBlindDrops");
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        if (!o.getBooleanValue("RealBlindDrop")) {
            blindDrop = true;
        }
        String defendString = "";
        if (mod || complete && !blindDrop) {
            Iterator<String> i = this.defenders.keySet().iterator();
            while (i.hasNext()) {
                SPlayer currPlayer = CampaignMain.cm.getPlayer(i.next());
                ++currDefender;
                defendString = defendString + currPlayer.getColoredName() + currPlayer.getHouseFightingFor().getColoredAbbreviation(true);
                if (numDefenders == 2 && i.hasNext()) {
                    defendString = defendString + " and ";
                    continue;
                }
                if (numDefenders <= 2 || !i.hasNext()) continue;
                if (currDefender + 1 < numDefenders) {
                    defendString = defendString + ", ";
                    continue;
                }
                if (currDefender + 1 != numDefenders) continue;
                defendString = defendString + " and ";
            }
            return defendString;
        }
        try {
            String nameString;
            SPlayer defender = CampaignMain.cm.getPlayer(this.defenders.firstKey());
            if (numDefenders == 1) {
                nameString = defender.getColoredName() + defender.getHouseFightingFor().getColoredAbbreviation(true);
            } else {
                TreeMap<String, Integer> houseSorting = new TreeMap<String, Integer>();
                for (String playerName : this.defenders.keySet()) {
                    defender = CampaignMain.cm.getPlayer(playerName);
                    if (houseSorting.containsKey(defender.getHouseFightingFor().getColoredNameAsLink())) {
                        houseSorting.put(defender.getHouseFightingFor().getColoredNameAsLink(), (Integer)houseSorting.get(defender.getHouseFightingFor().getColoredNameAsLink()) + 1);
                        continue;
                    }
                    houseSorting.put(defender.getHouseFightingFor().getColoredNameAsLink(), 1);
                }
                nameString = "";
                for (String houseName : houseSorting.keySet()) {
                    nameString = nameString + houseSorting.get(houseName) + " " + houseName + ", ";
                }
                nameString = nameString.substring(0, nameString.lastIndexOf(","));
            }
            if (numDefenders == 1) {
                return defendString + nameString;
            }
            if (numDefenders <= 1) return defendString;
            return defendString + nameString + " players ";
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to find defenders for operation: " + this.opName);
            CampaignData.mwlog.errLog(ex);
        }
        return defendString;
    }

    public boolean hasPlayer(SPlayer p) {
        for (String currN : this.getAllPlayerNames()) {
            if (!currN.equalsIgnoreCase(p.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasPlayerFrom(SHouse h) {
        for (String currN : this.getAllPlayerNames()) {
            SPlayer currP = CampaignMain.cm.getPlayer(currN);
            if (!currP.getHouseFightingFor().equals(h)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPlayerWhoseHouseBeginsWith(String s) {
        for (String currN : this.getAllPlayerNames()) {
            SPlayer currP = CampaignMain.cm.getPlayer(currN);
            if (!currP.getHouseFightingFor().getName().toLowerCase().startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getAllPlayerNames() {
        TreeMap<String, Integer> c = new TreeMap<String, Integer>();
        c.putAll(this.attackers);
        c.putAll(this.defenders);
        return c.keySet();
    }

    public TreeMap<String, Integer> getAllPlayersAndArmies() {
        TreeMap<String, Integer> c = new TreeMap<String, Integer>();
        c.putAll(this.attackers);
        c.putAll(this.defenders);
        return c;
    }

    public boolean decrementShowsToClear() {
        --this.showsToClear;
        return this.showsToClear < 0;
    }

    public long getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof ShortOperation) {
            ShortOperation compOp = (ShortOperation)o;
            if (compOp.getShortID() > this.getShortID()) {
                return 1;
            }
            if (compOp.getShortID() == this.getShortID()) {
                return 0;
            }
            return -1;
        }
        return 0;
    }

    public String planetIntel(String intel, SHouse house) {
        String result = intel;
        int factionOwnerShip = this.getTargetWorld().getInfluence().getInfluence(house.getId());
        int basedOwnerShip = CampaignMain.cm.getIntegerConfig("MinChanceForAccurateOperationsReports");
        int chanceVacuum = CampaignMain.cm.getRandomNumber(100);
        int chanceGravity = CampaignMain.cm.getRandomNumber(100);
        int chanceTemp = CampaignMain.cm.getRandomNumber(100);
        int chanceTime = CampaignMain.cm.getRandomNumber(100);
        factionOwnerShip = Math.max(factionOwnerShip, basedOwnerShip);
        result = result + "<br><B>Planet Name:</b> " + this.getTargetWorld().getName() + "<br>";
        result = CampaignMain.cm.getBooleanConfig("UseStaticMaps") ? result + "<b>Continent:</b> " + this.aTerrain.getDisplayName() + "<br>" : result + "<b>Terrain Type:</b> " + this.playEnvironment.getName() + "<br>";
        if (this.intelVacuum && factionOwnerShip >= chanceVacuum) {
            result = result + "<b>Atmosphere:</b> Missing<br>";
        }
        if (this.intelGravity != 1.0 && factionOwnerShip >= chanceGravity) {
            result = result + "<b>Gravity:</b> " + this.intelGravity + "<br>";
        }
        if ((this.intelTemp > 50 || this.intelTemp < -30) && factionOwnerShip >= chanceTemp) {
            result = result + "<b>Current Temp:</b> " + this.intelTemp + "<br>";
        }
        if (this.intelTimeFrame != 0 && factionOwnerShip >= chanceTime) {
            result = result + "<b>Current Time of Day:</b> " + PlanetaryConditions.getLightDisplayableName(this.intelTimeFrame) + "<br>";
        }
        if (this.doubleBlind && factionOwnerShip >= chanceTime) {
            result = result + "<b>Visibility is :</b> " + this.intelVisibility * 30 + " meters<br>";
        }
        if (this.aTerrain != null && this.aTerrain.getWeatherConditions() > 0) {
            result = result + "<b>Weather Condition: </b>";
            result = result + PlanetaryConditions.getWeatherDisplayableName(this.aTerrain.getWeatherConditions());
        }
        return result;
    }

    public void setAutoReport(String report) {
        this.autoReportString = report;
    }

    public String getAutoReport() {
        return this.autoReportString;
    }

    public void setPlayersReported(int players) {
        this.playersReported = players;
    }

    public int getPlayersReported() {
        return this.playersReported;
    }

    public int getStartingBV() {
        return this.startingBV;
    }

    public int getStartingUnits() {
        return this.startingUnits;
    }

    public int getFinishingBV() {
        return this.finishingBV;
    }

    public void setFinishingBV(int i) {
        this.finishingBV = i;
        this.modHeader = this.modHeader + " / Finish BV: " + i;
    }

    public boolean isFromReserve() {
        return this.fromReserve;
    }

    public String checkTeam(int teamNumber) {
        return this.checkTeam(teamNumber, 0, false);
    }

    public String checkTeam(int teamNumber, int bv, boolean attacker) {
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        int maxPlayersPerTeam = o.getIntValue("TeamSize");
        int teamCount = 0;
        int totalBV = 0;
        int maxOpBV = CampaignMain.cm.getIntegerConfig("MaxBVDifference");
        maxOpBV = attacker ? (maxOpBV += o.getIntValue("MaxAttackerBV")) : (maxOpBV += o.getIntValue("MaxDefenderBV"));
        for (String playerName : this.getAllPlayerNames()) {
            SPlayer player = CampaignMain.cm.getPlayer(playerName);
            if (player.getTeamNumber() != teamNumber) continue;
            ++teamCount;
            if (player.getLockedArmy() == null) continue;
            totalBV += player.getLockedArmy().getBV();
        }
        if (teamCount >= maxPlayersPerTeam) {
            return "The Team is already Full";
        }
        if (totalBV + bv >= maxOpBV) {
            return "The BV of your selected army is too large!";
        }
        return "";
    }

    public int getAttackersTeam() {
        if (this.attackers.size() < 1) {
            return -1;
        }
        return CampaignMain.cm.getPlayer(this.attackers.firstKey()).getTeamNumber();
    }

    public int getFactionTeam(String factionName) {
        int team = 1;
        for (String playerName : this.getAllPlayerNames()) {
            SPlayer player = CampaignMain.cm.getPlayer(playerName);
            if (factionName.equalsIgnoreCase(player.getHouseFightingFor().getName())) {
                return player.getTeamNumber();
            }
            if (team != player.getTeamNumber()) continue;
            ++team;
        }
        return team;
    }

    private int getAttackersBV() {
        int bv = 0;
        for (String attacker : this.getAttackers().keySet()) {
            SArmy army;
            SPlayer player = CampaignMain.cm.getPlayer(attacker);
            if (player == null || (army = player.getArmy(this.getAttackers().get(attacker))) == null) continue;
            bv += army.getBV();
        }
        return bv;
    }

    private boolean checkDefendersAndLaunch(int teams, int players) {
        Operation o = CampaignMain.cm.getOpsManager().getOperation(this.opName);
        int maxDefenderBV = o.getIntValue("MaxDefenderBV");
        int teamCount = 0;
        int teamBV = 0;
        for (int teamNumber = 1; teamNumber <= teams; ++teamNumber) {
            for (String defenders : this.getDefenders().keySet()) {
                SArmy army;
                SPlayer defender = CampaignMain.cm.getPlayer(defenders);
                if (defender == null || defender.getTeamNumber() != teamNumber || (army = defender.getArmy(this.getDefenders().get(defenders))) == null) continue;
                ++teamCount;
                teamBV += army.getBV();
            }
            if (teamCount < players && teamBV < maxDefenderBV) {
                return false;
            }
            teamCount = 0;
            teamBV = 0;
        }
        return true;
    }

    public SPlayer getInitiator() {
        return this.initiator;
    }

    public TreeMap<String, SPlayer> getWinners() {
        return this.winners;
    }

    public TreeMap<String, SPlayer> getLosers() {
        return this.losers;
    }

    public TreeSet<String> getCancelledPlayers() {
        return this.cancellingPlayers;
    }

    private int getRandomDeployment(Operation o) {
        int position = 1;
        String[] positionNames = new String[]{"DeployNorthwest", "DeployNorth", "DeployNortheast", "DeployEast", "DeploySoutheast", "DeploySouth", "DeploySouthwest", "DeployWest", "DeployEdge", "DeployCenter", "DeployNorthwestdeep", "DeployNorthdeep", "DeployNortheastdeep", "DeployEastdeep", "DeploySoutheastdeep", "DeploySouthdeep", "DeploySouthwestdeep", "DeployWestdeep"};
        Vector<Integer> deploymentChoices = new Vector<Integer>();
        for (int pos = 0; pos < positionNames.length; ++pos) {
            int chances = o.getIntValue(positionNames[pos]);
            for (int count = 0; count < chances; ++count) {
                deploymentChoices.add(pos);
            }
        }
        deploymentChoices.trimToSize();
        if (deploymentChoices.size() < 1) {
            return position;
        }
        if (deploymentChoices.size() == 1) {
            return (Integer)deploymentChoices.firstElement();
        }
        int rand = CampaignMain.cm.getRandomNumber(deploymentChoices.size());
        position = (Integer)deploymentChoices.elementAt(rand);
        return position;
    }

    private Vector<SUnit> createMulArmy(int number, String list) {
        StringTokenizer st = new StringTokenizer(list, ";");
        Vector<String> mulFileList = new Vector<String>(1, 1);
        Vector<SUnit> returnList = new Vector<SUnit>(1, 1);
        while (st.hasMoreElements()) {
            mulFileList.add(st.nextToken());
        }
        if (mulFileList.size() < 1) {
            return returnList;
        }
        while (number > 0) {
            if (mulFileList.size() == 1) {
                returnList.addAll(SUnit.createMULUnits((String)mulFileList.firstElement()));
            } else {
                returnList.addAll(SUnit.createMULUnits((String)mulFileList.remove(CampaignMain.cm.getRandomNumber(mulFileList.size()))));
            }
            --number;
        }
        returnList.trimToSize();
        return returnList;
    }

    public ArrayList<SUnit> captureUnits(int unitsToCapture, SPlanet target, SHouse losingHouse, boolean forced) {
        int numCaptured = 0;
        ArrayList<UnitFactory> factoriesSearched = new ArrayList<UnitFactory>(target.getUnitFactories());
        ArrayList<SUnit> capturedUnits = new ArrayList<SUnit>();
        while (factoriesSearched.size() > 0 && numCaptured < unitsToCapture) {
            SUnitFactory currFacility = (SUnitFactory)factoriesSearched.remove(CampaignMain.cm.getRandomNumber(factoriesSearched.size()));
            int currWeight = currFacility.getWeightclass();
            for (int type = 0; type < 6; ++type) {
                if (!currFacility.canProduce(type)) continue;
                boolean noUnits = false;
                while (!noUnits && numCaptured < unitsToCapture) {
                    SPilot pilot = new SPilot("Vacant", 99, 99);
                    Vector<SUnit> captured = new Vector<SUnit>(1, 1);
                    if (forced) {
                        captured.addAll(currFacility.getMechProduced(type, pilot));
                    } else {
                        SUnit capturedUnit = losingHouse.getEntity(currWeight, type);
                        if (capturedUnit != null && UnitUtils.canStartUp(capturedUnit.getEntity())) {
                            captured.add(capturedUnit);
                        }
                    }
                    if (captured.size() < 1) {
                        noUnits = true;
                        continue;
                    }
                    capturedUnits.addAll(captured);
                    numCaptured += captured.size();
                }
            }
        }
        return capturedUnits;
    }

    public Vector<SUnit> getPreOperationUnits(Operation o) {
        Vector<SUnit> units = new Vector<SUnit>(1, 1);
        int unitCaptureCap = o.getIntValue("UnitCaptureCap");
        SHouse defendingHouse = CampaignMain.cm.getPlayer(this.defenders.firstKey()).getHouseFightingFor();
        int unitsToCapture = o.getIntValue("AttackerBaseUnitsTaken");
        int unitUnitAdjust = o.getIntValue("AttackerUnitsUnitAdjustment");
        int unitBVAdjust = o.getIntValue("AttackerUnitsBVAdjustment");
        if (unitUnitAdjust > 0) {
            unitsToCapture = (int)((double)unitsToCapture + Math.floor(this.getStartingUnits() / unitUnitAdjust));
        }
        if (unitBVAdjust > 0) {
            unitsToCapture = (int)((double)unitsToCapture + Math.floor(this.getStartingBV() / unitBVAdjust));
        }
        if (unitsToCapture > unitCaptureCap) {
            unitsToCapture = unitCaptureCap;
        }
        units.addAll(this.captureUnits(unitsToCapture, this.targetWorld, defendingHouse, false));
        unitsToCapture = o.getIntValue("AttackerBaseFactoryUnitsTaken");
        unitUnitAdjust = o.getIntValue("AttackerFactoryUnitsUnitAdjustment");
        unitBVAdjust = o.getIntValue("AttackerFactoryUnitsBVAdjustment");
        if (unitUnitAdjust > 0) {
            unitsToCapture = (int)((double)unitsToCapture + Math.floor(this.getStartingUnits() / unitUnitAdjust));
        }
        if (unitBVAdjust > 0) {
            unitsToCapture = (int)((double)unitsToCapture + Math.floor(this.getStartingBV() / unitBVAdjust));
        }
        if (unitsToCapture > unitCaptureCap) {
            unitsToCapture = unitCaptureCap;
        }
        units.addAll(this.captureUnits(unitsToCapture, this.targetWorld, defendingHouse, true));
        StringBuilder results = new StringBuilder("HS|");
        for (SUnit unit : units) {
            if (unit.hasVacantPilot()) {
                SHouse attackingHouse = this.initiator.getHouseFightingFor();
                SPilot pilot = new SPilot(SPilot.getRandomPilotName(CampaignMain.cm.getR()), attackingHouse.getBaseGunner(0), attackingHouse.getBasePilot(0));
                unit.setPilot(pilot);
            }
            results.append(defendingHouse.removeUnit(unit, false));
        }
        CampaignMain.cm.doSendToAllOnlinePlayers(defendingHouse, results.toString(), false);
        return units;
    }

    public boolean validatePlayers(TreeSet<String> players) {
        Collection<String> allPlayersNames = this.getAllPlayerNames();
        for (String name : allPlayersNames) {
            if (players.contains(name)) continue;
            return false;
        }
        return true;
    }

    public void checkMercContracts(SPlayer player, int contractType, int amount) {
        if (!player.getMyHouse().isMercHouse()) {
            return;
        }
        ContractInfo contract = ((MercHouse)player.getMyHouse()).getContractInfo(player);
        if (contract == null) {
            return;
        }
        if (contract.getType() != contractType) {
            return;
        }
        contract.setEarnedAmount(contract.getEarnedAmount() + amount);
    }

    public OperationReporter getReporter() {
        return this.reporter;
    }
}

