/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.CampaignData;
import common.House;
import common.Unit;
import common.UnitFactory;
import common.util.StringUtils;
import common.util.UnitUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Mech;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationEntity;
import server.campaign.operations.OpsScrapThread;
import server.campaign.operations.ShortOperation;
import server.campaign.pilot.SPilot;
import server.campaign.util.ELORanking;

public class ShortResolver {
    TreeMap<String, SPlayer> allPlayers;
    TreeMap<String, SArmy> allArmies;
    TreeMap<String, String> metaStrings;
    TreeMap<String, String> unitStrings;
    TreeMap<String, String> payStrings;
    TreeMap<String, String> longStrings;
    TreeMap<String, Integer> unitCosts;
    TreeMap<String, Integer> lossCompensation;
    TreeMap<Integer, OperationEntity> salvagableUnits;
    TreeMap<Integer, OperationEntity> destroyedUnits;
    TreeMap<Integer, OperationEntity> livingUnits;
    TreeMap<Integer, SPilot> pilots;
    TreeMap<String, OpsScrapThread> scrapThreads;
    boolean attackersWon = false;
    boolean defendersWon = false;
    int currentBV = 0;
    int loserBV = 0;
    int buildingsLeft = -1;
    int buildingsDestroyed = 0;
    String completeFinishedInfoString = "";
    String incompleteFinishedInfoString = "";
    String newsFeedTitle = "";
    String newsFeedBody = "";
    private boolean drawGame = false;
    private boolean saveStats = false;
    private boolean freeForAll = false;
    private ShortOperation shortOp = null;
    boolean nonDestructionMode = false;

    private void resetVariables() {
        this.allPlayers = null;
        this.allArmies = null;
        this.metaStrings = null;
        this.unitStrings = null;
        this.payStrings = null;
        this.longStrings = null;
        this.unitCosts = null;
        this.lossCompensation = null;
        this.salvagableUnits = null;
        this.destroyedUnits = null;
        this.livingUnits = null;
        this.pilots = null;
        this.scrapThreads = null;
        this.attackersWon = false;
        this.defendersWon = false;
        this.currentBV = 0;
        this.loserBV = 0;
        this.buildingsLeft = -1;
        this.buildingsDestroyed = 0;
        this.completeFinishedInfoString = "";
        this.incompleteFinishedInfoString = "";
        this.newsFeedTitle = "";
        this.newsFeedBody = "";
        this.drawGame = false;
        this.saveStats = false;
        this.freeForAll = false;
        this.nonDestructionMode = false;
    }

    public void resolveShortAttack(Operation o, ShortOperation so, String report) {
        this.shortOp = so;
        if (so.getStatus() != ShortOperation.STATUS_INPROGRESS) {
            return;
        }
        if (so.getAutoReport() == null) {
            so.setAutoReport(report);
        }
        this.resetVariables();
        this.nonDestructionMode = o.getBooleanValue("NoDestructionMode");
        this.saveStats = !o.getBooleanValue("NoStatisticsMode");
        this.freeForAll = o.getBooleanValue("FreeForAllOperation");
        StringTokenizer reportTokenizer = new StringTokenizer(report, "#");
        this.allPlayers = new TreeMap();
        this.allArmies = new TreeMap();
        TreeMap<String, Integer> soIdentifiers = so.getAllPlayersAndArmies();
        for (String currName : soIdentifiers.keySet()) {
            SPlayer currP = CampaignMain.cm.getPlayer(currName);
            SArmy currA = currP.getArmy(soIdentifiers.get(currName));
            this.allPlayers.put(currName, currP);
            this.allArmies.put(currName, currA);
        }
        StringTokenizer winnerTokenizer = new StringTokenizer(reportTokenizer.nextToken(), "*");
        while (winnerTokenizer.hasMoreElements()) {
            String nextName = winnerTokenizer.nextToken().toLowerCase();
            if (nextName.equalsIgnoreCase("DRAW")) {
                this.drawGame = true;
            }
            if (so.getWinners().containsKey(nextName)) continue;
            so.getWinners().put(nextName.toLowerCase(), this.allPlayers.get(nextName.toLowerCase()));
        }
        for (String currName : this.allPlayers.keySet()) {
            if (so.getWinners().containsKey(currName) || so.getLosers().containsKey(currName)) continue;
            so.getLosers().put(currName, this.allPlayers.get(currName));
        }
        this.loserBV = 0;
        for (SArmy currArmy : this.allArmies.values()) {
            if (!so.getLosers().containsKey(currArmy.getPlayerName().toLowerCase())) continue;
            this.loserBV += currArmy.getBV();
        }
        if (so.getWinners().size() == 0) {
            for (String pname : this.allPlayers.keySet()) {
                CampaignMain.cm.toUser("Reporting error: Game had no winner.", pname, true);
            }
            so.changeStatus(ShortOperation.STATUS_REPORTING);
            CampaignMain.cm.getOpsManager().terminateOperation(so, 3, null);
            CampaignData.mwlog.errLog("Error while trying to Resolve game: " + so.getShortID() + " Result sent by Game: " + report);
            return;
        }
        so.changeStatus(ShortOperation.STATUS_REPORTING);
        so.getReporter().setWinnersAndLosers(so.getWinners(), so.getLosers());
        if (so.preCapturedUnits.size() > 0) {
            SPlayer winner = CampaignMain.cm.getPlayer(so.getAttackers().firstKey());
            for (SUnit unit : so.preCapturedUnits) {
                winner.addUnit(unit, true);
            }
        }
        this.possibleSalvageFromReport(reportTokenizer, so);
        this.assembleDescriptionStrings(o, so);
        this.assembleSalvageStrings(o, so);
        this.assemblePaymentStrings(o, so, null);
        this.processCapturedUnits(so);
        this.repodUnits(so, o);
        for (SArmy currA : this.allArmies.values()) {
            currA.setLocked(false);
            CampaignMain.cm.toUser("PL|SAL|" + currA.getID() + "#" + false, currA.getPlayerName(), false);
        }
        for (SPlayer currPlayer : this.allPlayers.values()) {
            String currName = currPlayer.getName().toLowerCase();
            String toSend = this.metaStrings.get(currName) + this.unitStrings.get(currName) + this.payStrings.get(currName);
            CampaignMain.cm.toUser(toSend, currName, true);
            CampaignMain.cm.toUser("PL|STN|-1", currName, false);
            CampaignData.mwlog.resultsLog(toSend);
            if (this.scrapThreads.containsKey(currName)) {
                Integer maxScrapPay;
                if (CampaignMain.cm.getOpsManager().getScrapThreads().containsKey(currName)) {
                    CampaignMain.cm.getOpsManager().getScrapThreads().get(currName).stopScrap();
                }
                if ((maxScrapPay = this.unitCosts.get(currName)) == null) {
                    maxScrapPay = new Integer(0);
                }
                this.scrapThreads.get(currName).setMaxPayment(maxScrapPay);
                this.scrapThreads.get(currName).start();
                CampaignMain.cm.getOpsManager().getScrapThreads().put(currName, this.scrapThreads.remove(currName));
            }
            this.contractFinishedInfo(currPlayer);
            for (SArmy currA : currPlayer.getArmies()) {
                currA.setBV(0);
                CampaignMain.cm.toUser("PL|SAD|" + currA.toString(true, "%"), currA.getPlayerName(), false);
                CampaignMain.cm.getOpsManager().checkOperations(currA, true);
            }
            currPlayer.resetWeightedArmyNumber();
            CampaignMain.cm.getIThread().addImmunePlayer(currPlayer);
            if (so.isFromReserve()) {
                currPlayer.setFighting(false, true);
            } else {
                currPlayer.setFighting(false);
            }
            CampaignMain.cm.toUser("PL|AAA|CLEAR", currPlayer.getName(), false);
            CampaignMain.cm.toUser("PL|GEA|CLEAR", currPlayer.getName(), false);
            CampaignMain.cm.toUser("PL|AAM|0|0", currPlayer.getName(), false);
            currPlayer.checkForPromotion();
            currPlayer.checkForDemotion();
            currPlayer.setSave();
            if (!so.isFromReserve() && CampaignMain.cm.getBooleanConfig("ForcedDeactivation")) {
                currPlayer.setActive(false);
                CampaignMain.cm.toUser("You've left the front lines to repair and refit, and are now in reserve.", currPlayer.getName());
            }
            CampaignMain.cm.sendPlayerStatusUpdate(currPlayer, true);
        }
        so.setCompleteFinishedInfo(this.completeFinishedInfoString);
        so.setIncompleteFinishedInfo(this.incompleteFinishedInfoString);
        so.changeStatus(ShortOperation.STATUS_FINISHED);
        CampaignMain.cm.addGamesCompleted(1);
        if (CampaignMain.cm.isUsingCyclops()) {
            CampaignMain.cm.getMWCC().opConclude(so);
        }
        if (o.getBooleanValue("ReportOpToNewsFeed")) {
            CampaignMain.cm.addToNewsFeed(this.newsFeedTitle, this.newsFeedBody);
        }
        so.getReporter().closeOperation(this.drawGame, this.attackersWon);
        so.getReporter().commit();
    }

    public void resolveShortAttack(Operation o, ShortOperation so, String winnerName, String loserName) {
        this.resetVariables();
        SPlayer winner = CampaignMain.cm.getPlayer(winnerName);
        SPlayer loser = CampaignMain.cm.getPlayer(loserName);
        if (so.getStatus() != ShortOperation.STATUS_INPROGRESS) {
            return;
        }
        so.changeStatus(ShortOperation.STATUS_REPORTING);
        if (winner != null) {
            so.getWinners().put(winnerName.toLowerCase(), winner);
        }
        if (loser != null) {
            so.getLosers().put(loserName.toLowerCase(), loser);
        }
        if (so.getWinners().size() == 0) {
            CampaignMain.cm.toUser("Autoreporting error: Game had no winner.", loserName, true);
            CampaignMain.cm.getOpsManager().terminateOperation(so, 3, null);
            return;
        }
        if (so.getLosers().size() == 0) {
            CampaignMain.cm.toUser("Autoreporting error: Game had no loser.", winnerName, true);
            CampaignMain.cm.getOpsManager().terminateOperation(so, 3, null);
            return;
        }
        this.nonDestructionMode = o.getBooleanValue("NoDestructionMode");
        this.allPlayers = new TreeMap();
        this.allArmies = new TreeMap();
        this.allPlayers.put(winnerName.toLowerCase(), winner);
        this.allPlayers.put(loserName.toLowerCase(), loser);
        SArmy winnerA = null;
        SArmy loserA = null;
        if (winner != null) {
            winnerA = winner.getArmy(so.getAllPlayersAndArmies().get(winnerName.toLowerCase()));
        }
        if (loser != null) {
            loserA = loser.getArmy(so.getAllPlayersAndArmies().get(loserName.toLowerCase()));
        }
        if (winnerA == null || winnerA.getPlayerName().trim().length() == 0) {
            CampaignMain.cm.toUser("Autoreporting error: Winner army null or had empty owner name.", winnerName, true);
            CampaignMain.cm.getOpsManager().terminateOperation(so, 3, null);
            return;
        }
        if (loserA == null || loserA.getPlayerName().trim().length() == 0) {
            CampaignMain.cm.toUser("Autoreporting error: Loser army null or had empty owner name.", winnerName, true);
            CampaignMain.cm.getOpsManager().terminateOperation(so, 3, null);
            return;
        }
        this.allArmies.put(winnerName.toLowerCase(), winnerA);
        this.allArmies.put(loserName.toLowerCase(), loserA);
        if (so.preCapturedUnits.size() > 0) {
            winner = CampaignMain.cm.getPlayer(so.getAttackers().firstKey());
            for (SUnit unit : so.preCapturedUnits) {
                winner.addUnit(unit, true);
            }
        }
        this.possibleSalvageFromInProgressInfo(so, loser);
        this.assembleDescriptionStrings(o, so);
        this.assembleSalvageStrings(o, so);
        this.assemblePaymentStrings(o, so, loser);
        this.processCapturedUnits(so);
        this.repodUnits(so, o);
        for (SArmy currA : this.allArmies.values()) {
            currA.setLocked(false);
            CampaignMain.cm.toUser("PL|SAL|" + currA.getID() + "#" + false, currA.getPlayerName(), false);
        }
        String winName = "";
        if (winner != null) {
            winName = winner.getName().toLowerCase();
        }
        String toSend = "Time expired. GAME RESOLVED AUTOMATICALLY.<br>" + this.metaStrings.get(winName) + this.unitStrings.get(winName) + this.payStrings.get(winName);
        CampaignMain.cm.toUser(toSend, winName, true);
        CampaignData.mwlog.resultsLog(toSend);
        if (winner != null) {
            for (SArmy currA : winner.getArmies()) {
                currA.setBV(0);
                CampaignMain.cm.toUser("PL|SAD|" + currA.toString(true, "%"), currA.getPlayerName(), false);
                CampaignMain.cm.getOpsManager().checkOperations(currA, true);
            }
        }
        if (this.scrapThreads.containsKey(winName)) {
            Integer maxScrapPay = this.unitCosts.get(winName);
            if (maxScrapPay == null || maxScrapPay < 0) {
                maxScrapPay = new Integer(0);
            }
            this.scrapThreads.get(winName).setMaxPayment(maxScrapPay);
            this.scrapThreads.get(winName).start();
            if (CampaignMain.cm.getOpsManager().getScrapThreads().containsKey(winName)) {
                CampaignMain.cm.getOpsManager().getScrapThreads().get(winName).stopScrap();
            }
            CampaignMain.cm.getOpsManager().getScrapThreads().put(winName, this.scrapThreads.remove(winName));
        }
        if (winner != null) {
            winner.resetWeightedArmyNumber();
        }
        CampaignMain.cm.getIThread().addImmunePlayer(winner);
        if (so.isFromReserve() && winner != null) {
            winner.setFighting(false, true);
        } else if (winner != null) {
            winner.setFighting(false);
        }
        if (!so.isFromReserve() && CampaignMain.cm.getBooleanConfig("ForcedDeactivation") && winner != null) {
            winner.setActive(false);
            CampaignMain.cm.toUser("You've left the front lines to repair and refit, and are now in reserve.", winner.getName());
        }
        CampaignMain.cm.sendPlayerStatusUpdate(winner, true);
        String loseName = "";
        if (loser != null) {
            loseName = loser.getName().toLowerCase();
        }
        toSend = "You were disconnected too long. GAME RESOLVED AUTOMATICALLY.<br>" + this.metaStrings.get(loseName) + this.unitStrings.get(loseName) + this.payStrings.get(loseName);
        CampaignMain.cm.toUser(toSend, loseName, true);
        if (winner != null) {
            winner.setSave();
        }
        if (loser != null) {
            loser.setSave();
        }
        CampaignData.mwlog.resultsLog(toSend);
        so.setCompleteFinishedInfo(this.completeFinishedInfoString);
        so.setIncompleteFinishedInfo(this.incompleteFinishedInfoString);
        so.changeStatus(ShortOperation.STATUS_FINISHED);
        CampaignMain.cm.addGamesCompleted(1);
        if (CampaignMain.cm.isUsingCyclops()) {
            CampaignMain.cm.getMWCC().opConclude(so);
        }
        if (o.getBooleanValue("ReportOpToNewsFeed")) {
            CampaignMain.cm.addToNewsFeed(this.newsFeedTitle, this.newsFeedBody);
        }
        if (winner != null) {
            winner.checkForPromotion();
            winner.checkForDemotion();
            winner.setSave();
        }
        if (loser != null) {
            loser.checkForPromotion();
            loser.checkForDemotion();
            loser.setSave();
        }
    }

    private void assemblePaymentStrings(Operation o, ShortOperation so, SPlayer disconnector) {
        int defenderTotalBVXPAdjustment;
        int attackerTotalBVXPAdjustment;
        int defenderTotalBVFluAdjustment;
        int attackerTotalBVFluAdjustment;
        int defenderTotalBVMoneyAdjustment;
        this.payStrings = new TreeMap();
        int baseAttackerMoneyPay = o.getIntValue("BaseAttackerPayCBills");
        int baseAttackerFluPay = o.getIntValue("BaseAttackerPayInfluence");
        int baseDefenderMoneyPay = o.getIntValue("BaseDefenderPayCBills");
        int baseDefenderFluPay = o.getIntValue("BaseDefenderPayInfluence");
        int baseAttackerExperiencePay = o.getIntValue("BaseAttackerPayExperience");
        int baseDefenderExperiencePay = o.getIntValue("BaseDefenderPayExperience");
        int baseAttackerRewardPointsPay = o.getIntValue("RPForAttacker");
        int baseDefenderRewardPointsPay = o.getIntValue("RPForDefender");
        int attackerTotalBVMoneyAdjustment = o.getIntValue("AttackerPayBVforCBill");
        if (attackerTotalBVMoneyAdjustment > 0) {
            baseAttackerMoneyPay = (int)((double)baseAttackerMoneyPay + Math.floor(so.getStartingBV() / attackerTotalBVMoneyAdjustment));
        }
        if ((defenderTotalBVMoneyAdjustment = o.getIntValue("DefenderPayBVforCBill")) > 0) {
            baseDefenderMoneyPay = (int)((double)baseDefenderMoneyPay + Math.floor(so.getStartingBV() / defenderTotalBVMoneyAdjustment));
        }
        if ((attackerTotalBVFluAdjustment = o.getIntValue("AttackerPayBVforInfluence")) > 0) {
            baseAttackerFluPay = (int)((double)baseAttackerFluPay + Math.floor(so.getStartingBV() / attackerTotalBVFluAdjustment));
        }
        if ((defenderTotalBVFluAdjustment = o.getIntValue("DefenderPayBVforInfluence")) > 0) {
            baseDefenderFluPay = (int)((double)baseDefenderFluPay + Math.floor(so.getStartingBV() / defenderTotalBVFluAdjustment));
        }
        if ((attackerTotalBVXPAdjustment = o.getIntValue("AttackerPayBVforExperience")) > 0) {
            baseAttackerExperiencePay = (int)((double)baseAttackerExperiencePay + Math.floor(so.getStartingBV() / attackerTotalBVXPAdjustment));
        }
        if ((defenderTotalBVXPAdjustment = o.getIntValue("DefenderPayBVforExperience")) > 0) {
            baseDefenderExperiencePay = (int)((double)baseDefenderExperiencePay + Math.floor(so.getStartingBV() / defenderTotalBVXPAdjustment));
        }
        if (this.buildingsLeft > -1 && this.buildingsLeft <= so.getTotalBuildings()) {
            int defenderBuildingMoneyAdjustment;
            int defenderBuildingRPAdjustment;
            int defenderBuildingFluAdjustment;
            int defenderBuildingXPAdjustment;
            int totalBuildings = so.getTotalBuildings();
            int minBuildings = so.getMinBuildings();
            this.buildingsDestroyed = totalBuildings - this.buildingsLeft;
            if (this.attackerisWinner(so)) {
                this.buildingsDestroyed = Math.max(this.buildingsDestroyed, o.getIntValue("AttackerMinBuildingsIfAttackerWins"));
            }
            if (this.buildingsDestroyed >= minBuildings) {
                int attackerBuildingMoneyAdjustment;
                int attackerBuildingRPAdjustment;
                int attackerBuildingFluAdjustment;
                int attackerBuildingXPAdjustment = o.getIntValue("AttackerExpPerBuilding");
                if (attackerBuildingXPAdjustment != 0) {
                    baseAttackerExperiencePay += attackerBuildingXPAdjustment * this.buildingsDestroyed;
                }
                if ((attackerBuildingFluAdjustment = o.getIntValue("AttackerFluPerBuilding")) != 0) {
                    baseAttackerFluPay += attackerBuildingFluAdjustment * this.buildingsDestroyed;
                }
                if ((attackerBuildingRPAdjustment = o.getIntValue("AttackerRPPerBuilding")) != 0) {
                    baseAttackerRewardPointsPay += attackerBuildingRPAdjustment * this.buildingsDestroyed;
                }
                if ((attackerBuildingMoneyAdjustment = o.getIntValue("AttackerMoneyPerBuilding")) != 0) {
                    baseAttackerMoneyPay += attackerBuildingMoneyAdjustment * this.buildingsDestroyed;
                }
            }
            if ((defenderBuildingXPAdjustment = o.getIntValue("DefenderExpPerBuilding")) != 0) {
                baseDefenderExperiencePay += defenderBuildingXPAdjustment * this.buildingsLeft;
            }
            if ((defenderBuildingFluAdjustment = o.getIntValue("DefenderFluPerBuilding")) != 0) {
                baseDefenderFluPay += defenderBuildingFluAdjustment * this.buildingsLeft;
            }
            if ((defenderBuildingRPAdjustment = o.getIntValue("DefenderRPPerBuilding")) != 0) {
                baseDefenderRewardPointsPay += defenderBuildingRPAdjustment * this.buildingsLeft;
            }
            if ((defenderBuildingMoneyAdjustment = o.getIntValue("DefenderMoneyPerBuilding")) != 0) {
                baseDefenderMoneyPay += defenderBuildingMoneyAdjustment * this.buildingsLeft;
            }
        }
        int discoPayPercent = CampaignMain.cm.getIntegerConfig("DisconnectionPayPercentage");
        for (String currName : this.allPlayers.keySet()) {
            double minBVDifference;
            int minBuildings;
            double fluMod;
            SPlayer currP = CampaignMain.cm.getPlayer(currName);
            CampaignMain.cm.toUser("PL|STN|-1", currName, false);
            if (disconnector != null && disconnector.getName().toLowerCase().equals(currName)) {
                String modString = "";
                if (discoPayPercent <= 0) {
                    modString = "You received no pay for the game because you disconnected.";
                } else if (discoPayPercent > 0) {
                    modString = "You received reduced pay for the game because you disconnected.";
                }
                if (discoPayPercent > 100) {
                    discoPayPercent = 100;
                }
                this.payStrings.put(currName, modString);
            }
            int earnedMoney = 0;
            int earnedFlu = 0;
            int earnedXP = 0;
            int earnedRP = 0;
            boolean payAllAsWinners = o.getBooleanValue("PayAllAsWinners");
            if (payAllAsWinners) {
                so.getWinners().putAll(so.getLosers());
                so.getLosers().clear();
            }
            String buildingReport = "";
            if (so.getAttackers().containsKey(currName)) {
                earnedMoney += baseAttackerMoneyPay;
                earnedFlu += baseAttackerFluPay;
                earnedXP += baseAttackerExperiencePay;
                earnedRP += baseAttackerRewardPointsPay;
                if (so.getWinners().containsKey(currName)) {
                    earnedRP += o.getIntValue("RPForWinner");
                    earnedMoney += o.getIntValue("AttackerWinModifierCBillsFlat");
                    earnedFlu += o.getIntValue("AttackerWinModifierInfluenceFlat");
                    earnedXP += o.getIntValue("AttackerWinModifierExperienceFlat");
                    double moneyMod = 1.0 + o.getDoubleValue("AttackerWinModifierCBillsPercent") / 100.0;
                    fluMod = 1.0 + o.getDoubleValue("AttackerWinModifierInfluencePercent") / 100.0;
                    double expMod = 1.0 + o.getDoubleValue("AttackerWinModifierExperiencePercent") / 100.0;
                    if (moneyMod > 0.0) {
                        earnedMoney = (int)((double)earnedMoney * moneyMod);
                    }
                    if (fluMod > 0.0) {
                        earnedFlu = (int)((double)earnedFlu * fluMod);
                    }
                    if (expMod > 0.0) {
                        earnedXP = (int)((double)earnedXP * expMod);
                    }
                } else if (so.getLosers().containsKey(currName)) {
                    earnedRP += o.getIntValue("RPForLoser");
                    earnedMoney -= o.getIntValue("AttackerLossModifierCBillsFlat");
                    earnedFlu -= o.getIntValue("AttackerLossModifierInfluenceFlat");
                    earnedXP -= o.getIntValue("AttackerLossModifierExperienceFlat");
                    double moneyMod = 1.0 - o.getDoubleValue("AttackerLossModifierCBillsPercent") / 100.0;
                    fluMod = 1.0 - o.getDoubleValue("AttackerLossModifierInfluencePercent") / 100.0;
                    double expMod = 1.0 - o.getDoubleValue("AttackerLossModifierExperiencePercent") / 100.0;
                    if (moneyMod > 0.0) {
                        earnedMoney = (int)((double)earnedMoney * moneyMod);
                    }
                    if (fluMod > 0.0) {
                        earnedFlu = (int)((double)earnedFlu * fluMod);
                    }
                    if (expMod > 0.0) {
                        earnedXP = (int)((double)earnedXP * expMod);
                    }
                    if (o.getBooleanValue("OnlyGiveRPtoWinners")) {
                        earnedRP = 0;
                    }
                }
                if (this.buildingsLeft > -1) {
                    int totalBuildings = so.getTotalBuildings();
                    minBuildings = so.getMinBuildings();
                    buildingReport = this.buildingsDestroyed == 0 ? "<b>Mission Report: Failed</b><br>You did not manage to destroy a single enemy facility!<br>" : (this.buildingsDestroyed == totalBuildings ? "<b>Mission Report: Success</b><br>You managed to destroy all of the enemies facilities!<br>" : (this.buildingsDestroyed >= minBuildings ? "<b>Mission Report: Success</b><br>You managed to destroy " + this.buildingsDestroyed + " out of " + totalBuildings + " facilities!<br>" : "<b>Mission Report: Failed</b><br>You only managed to destroy " + this.buildingsDestroyed + " out of " + totalBuildings + " facilities!<br>"));
                }
            } else if (so.getDefenders().containsKey(currName)) {
                earnedMoney += baseDefenderMoneyPay;
                earnedFlu += baseDefenderFluPay;
                earnedXP += baseDefenderExperiencePay;
                earnedRP += baseDefenderRewardPointsPay;
                if (so.getWinners().containsKey(currName)) {
                    earnedRP += o.getIntValue("RPForWinner");
                    earnedMoney += o.getIntValue("DefenderWinModifierCBillsFlat");
                    earnedFlu += o.getIntValue("DefenderWinModifierInfluenceFlat");
                    earnedXP += o.getIntValue("DefenderWinModifierExperienceFlat");
                    double moneyMod = 1.0 + o.getDoubleValue("DefenderWinModifierCBillsPercent") / 100.0;
                    fluMod = 1.0 + o.getDoubleValue("DefenderWinModifierInfluencePercent") / 100.0;
                    double expMod = 1.0 + o.getDoubleValue("DefenderWinModifierExperiencePercent") / 100.0;
                    if (moneyMod > 0.0) {
                        earnedMoney = (int)((double)earnedMoney * moneyMod);
                    }
                    if (fluMod > 0.0) {
                        earnedFlu = (int)((double)earnedFlu * fluMod);
                    }
                    if (expMod > 0.0) {
                        earnedXP = (int)((double)earnedXP * expMod);
                    }
                } else if (so.getLosers().containsKey(currName)) {
                    earnedRP += o.getIntValue("RPForLoser");
                    earnedMoney -= o.getIntValue("DefenderLossModifierCBillsFlat");
                    earnedFlu -= o.getIntValue("DefenderLossModifierInfluenceFlat");
                    earnedXP -= o.getIntValue("DefenderLossModifierExperienceFlat");
                    double moneyMod = 1.0 - o.getDoubleValue("DefenderLossModifierCBillsPercent") / 100.0;
                    fluMod = 1.0 - o.getDoubleValue("DefenderLossModifierInfluencePercent") / 100.0;
                    double expMod = 1.0 - o.getDoubleValue("DefenderLossModifierExperiencePercent") / 100.0;
                    if (moneyMod > 0.0) {
                        earnedMoney = (int)((double)earnedMoney * moneyMod);
                    }
                    if (fluMod > 0.0) {
                        earnedFlu = (int)((double)earnedFlu * fluMod);
                    }
                    if (expMod > 0.0) {
                        earnedXP = (int)((double)earnedXP * expMod);
                    }
                    if (o.getBooleanValue("OnlyGiveRPtoWinners")) {
                        earnedRP = 0;
                    }
                }
                if (this.buildingsLeft > -1) {
                    int totalBuildings = so.getTotalBuildings();
                    minBuildings = so.getMinBuildings();
                    buildingReport = this.buildingsDestroyed == 0 ? "<b>Mission Report: Success</b><br>You to stop the enemy from destroing any facilites!<br>" : (this.buildingsDestroyed == totalBuildings ? "<b>Mission Report: Failed</b><br>You managed to allow the enemy to destroy all our facilites!<br>" : (this.buildingsDestroyed >= minBuildings ? "<b>Mission Report: Failed</b><br>You managed to allow the enemy to destroy " + this.buildingsDestroyed + " out of " + totalBuildings + " facilities!<br>" : "<b>Mission Report: Success</b><br>The enemy destroyed only " + this.buildingsDestroyed + " out of " + totalBuildings + " facilities!<br>"));
                }
            }
            if (disconnector != null && disconnector.getName().toLowerCase().equals(currName)) {
                earnedMoney = earnedMoney * discoPayPercent / 100;
                earnedFlu = earnedFlu * discoPayPercent / 100;
                earnedXP = earnedXP * discoPayPercent / 100;
                earnedRP = earnedRP * discoPayPercent / 100;
            }
            int salvageAndRepairCosts = 0;
            if (this.unitCosts.containsKey(currName) && !CampaignMain.cm.isUsingAdvanceRepair()) {
                salvageAndRepairCosts = this.unitCosts.get(currName);
            }
            int battleLossCompensation = 0;
            if (this.lossCompensation.containsKey(currName)) {
                battleLossCompensation = this.lossCompensation.get(currName);
            }
            if ((minBVDifference = o.getDoubleValue("MinBVDifferenceForFullPay")) > 0.0 && 1.0 - (double)this.currentBV / (double)this.loserBV < minBVDifference && disconnector == null && so.getLosers().containsKey(currName)) {
                int minBVvPenaltyMod = o.getIntValue("BVFailurePaymentModifier");
                earnedMoney = earnedMoney * minBVvPenaltyMod / 100;
            }
            int techPayment = 0;
            if (o.getBooleanValue("PayTechsForGame")) {
                techPayment = currP.getCurrentTechPayment();
            }
            StringBuilder toSave = new StringBuilder();
            if (buildingReport.length() > 1) {
                toSave.append(buildingReport);
            }
            earnedMoney = Math.max(earnedMoney, 0);
            int actualPay = 0;
            String techFiringWarning = "";
            String unmaintainedUnitWarning = "";
            boolean hasMoneyGain = false;
            boolean hasOtherGain = false;
            if (earnedMoney > 0 || salvageAndRepairCosts > 0 || battleLossCompensation > 0 || techPayment > 0) {
                int numberUnmaintained;
                if (salvageAndRepairCosts > 0 && salvageAndRepairCosts > earnedMoney) {
                    salvageAndRepairCosts = earnedMoney;
                    this.unitCosts.put(currName, salvageAndRepairCosts);
                }
                actualPay = earnedMoney + battleLossCompensation - salvageAndRepairCosts;
                int availMoney = Math.max(currP.getMoney() + actualPay, 0);
                int techsLost = 0;
                if (techPayment > availMoney) {
                    techsLost = currP.doFireUnpaidTechnicians(techPayment - availMoney);
                    techPayment = availMoney;
                }
                if (techsLost > 0) {
                    techFiringWarning = techFiringWarning + "You weren't able to pay all of your technicians. ";
                    techFiringWarning = techFiringWarning + (techsLost == 1 ? "One" : Integer.valueOf(techsLost));
                    techFiringWarning = techFiringWarning + " quit in protest.";
                }
                if (techsLost > 0 && currP.getTechnicians() < 0 && (numberUnmaintained = currP.setRandomUnmaintained()) > 0) {
                    unmaintainedUnitWarning = "<i><u>WARNING:</u></i> ";
                    unmaintainedUnitWarning = unmaintainedUnitWarning + (numberUnmaintained == 1 ? " A unit is now" : " Units are now");
                    unmaintainedUnitWarning = unmaintainedUnitWarning + " unmaintained. You must [<a href=\"MEKWARS/c deactivate\">DEACTIVATE</a>] in order to prevent";
                    unmaintainedUnitWarning = unmaintainedUnitWarning + (numberUnmaintained == 1 ? " an autoscrap." : " autoscraps.");
                }
                toSave.append("Net Pay: " + CampaignMain.cm.moneyOrFluMessage(true, false, actualPay -= techPayment, true) + " (");
                toSave.append("Gross Pay: " + CampaignMain.cm.moneyOrFluMessage(true, false, earnedMoney, true) + ", ");
                if (battleLossCompensation > 0) {
                    toSave.append("Battle Loss Comp: +" + CampaignMain.cm.moneyOrFluMessage(true, false, battleLossCompensation) + ", ");
                }
                if (salvageAndRepairCosts > 0) {
                    toSave.append("Salvage & Repair: -" + CampaignMain.cm.moneyOrFluMessage(true, false, salvageAndRepairCosts) + ", ");
                }
                if (techPayment > 0 && CampaignMain.cm.isUsingAdvanceRepair()) {
                    toSave.append("Bay Rental: -" + CampaignMain.cm.moneyOrFluMessage(true, false, techPayment) + ", ");
                } else if (techPayment > 0) {
                    toSave.append("Techs: -" + CampaignMain.cm.moneyOrFluMessage(true, false, techPayment) + ", ");
                }
                int commaIndex = toSave.lastIndexOf(", ");
                toSave = toSave.replace(commaIndex, commaIndex + 2, ")");
                currP.addMoney(actualPay);
                hasMoneyGain = true;
            }
            StringBuilder tempBuilder = new StringBuilder();
            if (earnedFlu > 0) {
                tempBuilder.append(CampaignMain.cm.moneyOrFluMessage(false, false, earnedFlu));
                currP.addInfluence(earnedFlu);
                hasOtherGain = true;
            }
            if (earnedXP > 0) {
                if (hasOtherGain) {
                    tempBuilder.append(", ");
                }
                tempBuilder.append(earnedXP + "XP");
                currP.addExperience(earnedXP, false);
                so.checkMercContracts(currP, 0, earnedXP);
                hasOtherGain = true;
            }
            if (earnedRP > 0) {
                if (hasOtherGain) {
                    tempBuilder.append(", ");
                }
                tempBuilder.append(earnedRP + "RP");
                currP.addReward(earnedRP);
                hasOtherGain = true;
            }
            if (tempBuilder.length() > 0) {
                tempBuilder.append(".");
                int lastComma = tempBuilder.lastIndexOf(", ");
                if (lastComma >= 0) {
                    tempBuilder.replace(lastComma, lastComma + 1, " and");
                }
                toSave.append("<br>You earned " + tempBuilder.toString());
            }
            if (hasMoneyGain || hasOtherGain) {
                if (earnedRP > 0) {
                    toSave.append(" [<a href=\"MWUSERP\">Use RP</a>]");
                }
                if (techFiringWarning.length() > 0) {
                    toSave.append("<br>" + techFiringWarning);
                }
                if (unmaintainedUnitWarning.length() > 0) {
                    toSave.append("<br>" + unmaintainedUnitWarning);
                }
                this.payStrings.put(currName, toSave.toString());
                continue;
            }
            this.payStrings.put(currName, "You received no pay (money, experience, etc.) for this game.");
        }
        boolean opEffectsElo = o.getBooleanValue("CountGameForRanking");
        if (this.allPlayers.size() == 2 && opEffectsElo && !this.drawGame) {
            SPlayer wp = so.getWinners().get(so.getWinners().firstKey());
            SPlayer lp = so.getLosers().get(so.getLosers().firstKey());
            double oldWinnerRating = wp.getRating();
            double oldLoserRating = lp.getRating();
            wp.setRating(ELORanking.getNewRatingWinner(oldWinnerRating, oldLoserRating, 8));
            lp.setRating(ELORanking.getNewRatingLoser(oldWinnerRating, oldLoserRating, 8));
            if (!CampaignMain.cm.getBooleanConfig("HideELO")) {
                DecimalFormat myFormatter = new DecimalFormat("###.##");
                double winnerRating = wp.getRating() - oldWinnerRating;
                double loserRating = lp.getRating() - oldLoserRating;
                String winRatingStr = myFormatter.format(winnerRating);
                String LoseRatingStr = myFormatter.format(loserRating);
                String winToUser = "Your new Rating is " + wp.getRatingRounded() + " (+" + winRatingStr + ")";
                String loseToUser = "Your new Rating is " + lp.getRatingRounded() + " (" + LoseRatingStr + ")";
                String ls = this.payStrings.get(lp.getName().toLowerCase());
                String ws = this.payStrings.get(wp.getName().toLowerCase());
                this.payStrings.put(lp.getName().toLowerCase(), loseToUser + "<br>" + ls);
                this.payStrings.put(wp.getName().toLowerCase(), winToUser + "<br>" + ws);
            }
        }
        for (String currName : this.allPlayers.keySet()) {
            SPlayer currP = CampaignMain.cm.getPlayer(currName);
            if (!currP.getHouseFightingFor().isNewbieHouse() || currP.getExperience() < CampaignMain.cm.getIntegerConfig("MinEXPforDefecting")) continue;
            String oldString = this.payStrings.get(currP.getName().toLowerCase());
            String toAdd = "You have enough XP to leave the training faction. Click to [<a href=\"MWSOLDEFECT\">defect</a>].";
            this.payStrings.put(currP.getName().toLowerCase(), oldString + "<br>" + toAdd);
        }
    }

    private void assembleSalvageStrings(Operation o, ShortOperation so) {
        Integer oldCost;
        String toOthers;
        String toOwner;
        SUnit currU;
        SPlayer oldOwner;
        String oldOwnerName;
        this.unitStrings = new TreeMap();
        this.unitCosts = new TreeMap();
        this.lossCompensation = new TreeMap();
        this.scrapThreads = new TreeMap();
        if (this.nonDestructionMode) {
            this.livingUnits.putAll(this.salvagableUnits);
            this.livingUnits.putAll(this.destroyedUnits);
            this.salvagableUnits.clear();
            this.destroyedUnits.clear();
            this.pilots.clear();
        }
        for (OperationEntity currEntity : this.livingUnits.values()) {
            String ownerName = currEntity.getOwnerName().toLowerCase();
            SPlayer owner = CampaignMain.cm.getPlayer(ownerName);
            if (owner == null) {
                CampaignData.mwlog.errLog("Null _owner_ while processing post-game salvage for  Attack #" + so.getShortID() + ". Needed to find Player: " + ownerName + " Unit #" + currEntity.getID() + "/Type: " + currEntity.getType());
                continue;
            }
            SUnit currU2 = owner.getUnit(currEntity.getID());
            if (currEntity.getRemovalReason() == 256 || currEntity.getRemovalReason() == 272) {
                this.removePreCaptured(so, currU2.getId());
            }
            try {
                if (!this.nonDestructionMode && currEntity.getUnitDamage().trim().length() > 0) {
                    UnitUtils.applyBattleDamage(currU2.getEntity(), currEntity.getUnitDamage(), false);
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to apply damage to unit " + currU2.getModelName());
                CampaignData.mwlog.errLog(ex);
            }
            if (CampaignMain.cm.getBooleanConfig("AllowPilotDamageToTransfer")) {
                if (this.nonDestructionMode) {
                    currU2.getPilot().setHits(0);
                    currEntity.setPilothits(0);
                } else {
                    int hits = CampaignMain.cm.getIntegerConfig("AmountOfDamagePerPilotHit") * currEntity.getPilothits();
                    currU2.getPilot().setHits(hits);
                }
            }
            String append = this.calculatePilotEXP(o, so, currEntity, owner, true);
            if (this.unitStrings.containsKey(ownerName)) {
                String s = this.unitStrings.get(ownerName);
                this.unitStrings.put(ownerName, s + "The " + currU2.getModelName() + " survived the battle" + append + ".<br>");
            } else {
                this.unitStrings.put(ownerName, "The " + currU2.getModelName() + " survived the battle" + append + ".<br>");
            }
            CampaignMain.cm.toUser("PL|UU|" + currU2.getId() + "|" + currU2.toString(true), ownerName, false);
        }
        boolean winnerAlwaysSalvagesOwn = o.getBooleanValue("WinnerAlwaysSalvagesOwnUnits");
        int winnerSalvagePercent = 0;
        int salvageAdjustment = 0;
        if (this.attackersWon) {
            winnerSalvagePercent = o.getIntValue("BaseAttackerSalvagePercent");
            salvageAdjustment = o.getIntValue("AttackerSalvageAdjustment");
        } else {
            winnerSalvagePercent = o.getIntValue("BaseDefenderSalvagePercent");
            salvageAdjustment = o.getIntValue("DefenderSalvageAdjustment");
        }
        for (OperationEntity currEntity : this.salvagableUnits.values()) {
            boolean pilotLived;
            String workingS;
            String pilotAppend;
            oldOwnerName = currEntity.getOwnerName().toLowerCase();
            oldOwner = CampaignMain.cm.getPlayer(oldOwnerName);
            currU = oldOwner.getUnit(currEntity.getID());
            try {
                if (currEntity.getUnitDamage().trim().length() > 0) {
                    UnitUtils.applyBattleDamage(currU.getEntity(), currEntity.getUnitDamage(), false);
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to apply damage to unit " + currU.getModelName());
                CampaignData.mwlog.errLog(ex);
            }
            Object[] pilotinformation = this.setupPilotStringForUnit(currEntity, currU, so.getTargetWorld());
            if (winnerAlwaysSalvagesOwn && so.getWinners().containsKey(oldOwnerName)) {
                toOwner = " You recovered your " + currU.getModelName() + ". ";
                toOthers = oldOwner.getColoredName() + " recovered his " + currU.getModelName() + ". ";
                boolean pilotLived2 = (Boolean)pilotinformation[0];
                if (!pilotLived2) {
                    pilotAppend = this.handleDeadPilot(oldOwner, currU, currEntity, so);
                    String workingS2 = (String)pilotinformation[1];
                    pilotinformation[1] = workingS2 + pilotAppend;
                } else {
                    pilotAppend = "<br>" + this.calculatePilotEXP(o, so, currEntity, oldOwner, true);
                }
                for (String currName : this.allPlayers.keySet()) {
                    SPlayer captor = (SPlayer)pilotinformation[4];
                    String toSet = toOthers + pilotinformation[3];
                    toSet = currName.equals(oldOwnerName) ? toOwner + pilotinformation[1] + pilotAppend : (captor != null && currName.equals(captor.getName().toLowerCase()) ? toOthers + pilotinformation[2] : toOthers + pilotinformation[3]);
                    if (this.unitStrings.containsKey(currName)) {
                        workingS = this.unitStrings.get(currName);
                        this.unitStrings.put(currName, workingS + toSet + "<br>");
                        continue;
                    }
                    this.unitStrings.put(currName, toSet + "<br>");
                }
                int costToRepair = this.getSalvageCost(oldOwner, currU, currEntity, o, so);
                if (costToRepair < 0 || CampaignMain.cm.isUsingAdvanceRepair()) {
                    costToRepair = 0;
                }
                if (this.unitCosts.containsKey(oldOwnerName)) {
                    oldCost = this.unitCosts.get(oldOwnerName);
                    this.unitCosts.put(oldOwnerName, oldCost + costToRepair);
                } else {
                    this.unitCosts.put(oldOwnerName, costToRepair);
                }
                if (this.scrapThreads.containsKey(oldOwnerName)) {
                    this.scrapThreads.get(oldOwnerName).addScrappableUnit(currU.getId(), costToRepair);
                } else {
                    OpsScrapThread ost = new OpsScrapThread(oldOwnerName);
                    ost.addScrappableUnit(currU.getId(), costToRepair);
                    this.scrapThreads.put(oldOwnerName, ost);
                }
                CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), oldOwnerName, false);
                continue;
            }
            SPlayer newOwner = null;
            if (CampaignMain.cm.getRandomNumber(100) < winnerSalvagePercent) {
                if (!so.getWinners().containsKey(oldOwnerName)) {
                    newOwner = this.selectRandomWinner();
                }
                if (salvageAdjustment != 0) {
                    winnerSalvagePercent -= salvageAdjustment;
                }
                if (winnerSalvagePercent < 0) {
                    winnerSalvagePercent = 0;
                }
            } else {
                if (!so.getLosers().containsKey(oldOwnerName)) {
                    newOwner = this.selectRandomLoser();
                }
                if (salvageAdjustment != 0) {
                    winnerSalvagePercent += salvageAdjustment;
                }
                if (winnerSalvagePercent > 100) {
                    winnerSalvagePercent = 100;
                }
            }
            if (!(pilotLived = ((Boolean)pilotinformation[0]).booleanValue()) && newOwner == null) {
                String deathString = this.handleDeadPilot(oldOwner, currU, currEntity, so);
                String workingS3 = (String)pilotinformation[1];
                workingS3 = workingS3 + deathString;
            }
            pilotAppend = "";
            if (pilotLived) {
                pilotAppend = "<br>" + this.calculatePilotEXP(o, so, currEntity, oldOwner, false);
            }
            if (pilotLived && newOwner != null) {
                this.handleDispossesedPilot(oldOwner, currU);
            }
            String toOriginalOwner = "";
            String toNewOwner = "";
            String toOthers2 = "";
            if (newOwner == null) {
                toOriginalOwner = " You recovered your " + currU.getModelName() + ". ";
                toOthers2 = oldOwner.getColoredName() + " recovered his " + currU.getModelName() + ". ";
            } else {
                toOriginalOwner = " " + newOwner.getColoredName() + " recovered your " + currU.getModelName() + ". ";
                toNewOwner = " You recovered " + oldOwner.getColoredName() + "'s " + currU.getModelName() + ". ";
                toOthers2 = " " + newOwner.getColoredName() + " recovered " + oldOwner.getColoredName() + "'s " + currU.getModelName() + ". ";
            }
            for (String currName : this.allPlayers.keySet()) {
                SPlayer captor = (SPlayer)pilotinformation[4];
                String toSet = toOthers2 + pilotinformation[3];
                toSet = currName.equals(oldOwnerName) ? toOriginalOwner + pilotinformation[1] + pilotAppend : (newOwner != null && currName.equals(newOwner.getName().toLowerCase()) ? (captor != null && currName.equals(captor.getName().toLowerCase()) ? toNewOwner + pilotinformation[2] : toNewOwner + pilotinformation[3]) : (captor != null && currName.equals(captor.getName().toLowerCase()) ? toOthers2 + pilotinformation[2] : toOthers2 + pilotinformation[3]));
                if (this.unitStrings.containsKey(currName)) {
                    String workingS4 = this.unitStrings.get(currName);
                    this.unitStrings.put(currName, workingS4 + toSet + "<br>");
                    continue;
                }
                this.unitStrings.put(currName, toSet + "<br>");
            }
            if (newOwner != null) {
                int compensation = this.determineLossCompensation(oldOwner, currU, true);
                if (compensation > 0) {
                    if (this.lossCompensation.containsKey(oldOwnerName)) {
                        Integer oldCost2 = this.lossCompensation.get(oldOwnerName);
                        this.lossCompensation.put(oldOwnerName, oldCost2 + compensation);
                    } else {
                        this.lossCompensation.put(oldOwnerName, compensation);
                    }
                }
                if (CampaignMain.cm.isUsingCyclops()) {
                    CampaignMain.cm.getMWCC().unitChangeOwnerShip(Integer.toString(currU.getId()), newOwner.getName(), newOwner.getHouseFightingFor().getName(), so.getOpCyclopsID(), "Salvage");
                }
                oldOwner.removeUnit(currU.getId(), false);
                String newPilot = this.handleDeadPilot(newOwner, currU, currEntity, so);
                newOwner.addUnit(currU, true);
                workingS = this.unitStrings.get(newOwner.getName().toLowerCase());
                workingS = workingS.substring(0, workingS.length() - 4);
                this.unitStrings.put(newOwner.getName().toLowerCase(), workingS + newPilot + "<br>");
            } else {
                CampaignMain.cm.toUser("PL|UU|" + currU.getId() + "|" + currU.toString(true), oldOwnerName, false);
            }
            int costToRepair = 0;
            String nameKey = "";
            if (newOwner != null) {
                costToRepair = this.getSalvageCost(newOwner, currU, currEntity, o, so);
                nameKey = newOwner.getName().toLowerCase();
            } else {
                costToRepair = this.getSalvageCost(oldOwner, currU, currEntity, o, so);
                nameKey = oldOwnerName;
            }
            if (costToRepair < 0 || CampaignMain.cm.isUsingAdvanceRepair()) {
                costToRepair = 0;
            }
            if (this.unitCosts.containsKey(nameKey)) {
                Integer cost = this.unitCosts.get(nameKey);
                cost = cost + costToRepair;
            } else {
                this.unitCosts.put(nameKey, costToRepair);
            }
            if (this.scrapThreads.containsKey(nameKey)) {
                this.scrapThreads.get(nameKey).addScrappableUnit(currU.getId(), costToRepair);
                continue;
            }
            OpsScrapThread ost = new OpsScrapThread(nameKey);
            ost.addScrappableUnit(currU.getId(), costToRepair);
            this.scrapThreads.put(nameKey, ost);
        }
        for (OperationEntity currEntity : this.destroyedUnits.values()) {
            int compensation;
            oldOwnerName = currEntity.getOwnerName().toLowerCase();
            oldOwner = CampaignMain.cm.getPlayer(oldOwnerName);
            currU = oldOwner.getUnit(currEntity.getID());
            String append = this.calculatePilotEXP(o, so, currEntity, oldOwner, false);
            toOwner = "Your " + currU.getModelName() + " was utterly destroyed " + append;
            toOthers = oldOwner.getColoredName() + "'s " + currU.getModelName() + " was utterly destroyed. ";
            Object[] pilotinformation = this.setupPilotStringForUnit(currEntity, currU, so.getTargetWorld());
            Boolean pilotLived = (Boolean)pilotinformation[0];
            if (pilotLived.booleanValue()) {
                this.handleDispossesedPilot(oldOwner, currU);
            }
            if (CampaignMain.cm.isUsingCyclops()) {
                CampaignMain.cm.getMWCC().unitDestroy(Integer.toString(currU.getId()), "cored", so.getOpCyclopsID(), "", "");
            }
            if ((compensation = this.determineLossCompensation(oldOwner, currU, false)) > 0) {
                if (this.lossCompensation.containsKey(oldOwnerName)) {
                    oldCost = this.lossCompensation.get(oldOwnerName);
                    this.lossCompensation.put(oldOwnerName, oldCost + compensation);
                } else {
                    this.lossCompensation.put(oldOwnerName, compensation);
                }
            }
            oldOwner.removeUnit(currU.getId(), false);
            if (CampaignMain.cm.isUsingMySQL()) {
                CampaignMain.cm.MySQL.deleteUnit(currU.getDBId());
            }
            for (String currName : this.allPlayers.keySet()) {
                SPlayer captor = (SPlayer)pilotinformation[4];
                String toSet = toOthers + pilotinformation[3];
                toSet = currName.equals(oldOwnerName) ? toOwner + pilotinformation[1] : (captor != null && currName.equals(captor.getName().toLowerCase()) ? toOthers + pilotinformation[2] : toOthers + pilotinformation[3]);
                if (this.unitStrings.containsKey(currName)) {
                    String workingS = this.unitStrings.get(currName);
                    this.unitStrings.put(currName, workingS + toSet + "<br>");
                    continue;
                }
                this.unitStrings.put(currName, toSet + "<br>");
            }
        }
    }

    private void assembleDescriptionStrings(Operation o, ShortOperation so) {
        try {
            this.metaStrings = new TreeMap();
            SPlayer aWinner = so.getWinners().get(so.getWinners().firstKey());
            SPlayer aLoser = so.getLosers().get(so.getLosers().firstKey());
            if (this.drawGame) {
                this.attackersWon = false;
                this.defendersWon = false;
            } else if (this.attackerisWinner(so)) {
                this.attackersWon = true;
                this.defendersWon = false;
            } else {
                this.defendersWon = true;
                this.attackersWon = false;
            }
            boolean attackersPolluted = false;
            boolean defendersPolluted = false;
            if (!this.drawGame) {
                for (SPlayer wp : so.getWinners().values()) {
                    for (SPlayer compareP : so.getWinners().values()) {
                        if (compareP.getHouseFightingFor().equals(wp.getHouseFightingFor())) continue;
                        attackersPolluted = true;
                    }
                    if (!attackersPolluted) continue;
                    break;
                }
            }
            block14: for (SPlayer lp : so.getLosers().values()) {
                for (SPlayer compareP : so.getLosers().values()) {
                    if (!compareP.getHouseFightingFor().equals(lp.getHouseFightingFor())) {
                        defendersPolluted = true;
                        continue block14;
                    }
                    if (!defendersPolluted) continue;
                    continue block14;
                }
            }
            if (attackersPolluted || defendersPolluted) {
                try {
                    String genericWinnerString = "";
                    int marker = 0;
                    int total = so.getWinners().size();
                    if (!this.drawGame) {
                        for (SPlayer wp : so.getWinners().values()) {
                            genericWinnerString = genericWinnerString + wp.getName();
                            if (++marker + 1 == total) {
                                genericWinnerString = genericWinnerString + " and ";
                                continue;
                            }
                            if (marker + 1 >= total) continue;
                            genericWinnerString = genericWinnerString + ", ";
                        }
                    }
                    this.completeFinishedInfoString = this.completeFinishedInfoString + genericWinnerString;
                    this.completeFinishedInfoString = this.completeFinishedInfoString + " defeated ";
                    String genericLoserString = "";
                    marker = 0;
                    total = so.getLosers().size();
                    for (SPlayer lp : so.getLosers().values()) {
                        genericLoserString = genericLoserString + lp.getName();
                        if (++marker + 1 == total) {
                            genericLoserString = genericLoserString + " and ";
                            continue;
                        }
                        if (marker + 1 >= total) continue;
                        genericLoserString = genericLoserString + ", ";
                    }
                    this.completeFinishedInfoString = this.completeFinishedInfoString + genericLoserString + " (" + so.getName() + ").<br>";
                    this.newsFeedBody = this.newsFeedTitle = this.completeFinishedInfoString.substring(0, this.completeFinishedInfoString.indexOf("<br>"));
                    int numberOfWinners = so.getWinners().size();
                    if (!this.drawGame) {
                        for (SPlayer wp : so.getWinners().values()) {
                            if (numberOfWinners == 1) {
                                this.metaStrings.put(wp.getName().toLowerCase(), "You have defeated " + genericLoserString + " (" + so.getName() + ").<br>");
                                continue;
                            }
                            int i = 0;
                            int numToList = numberOfWinners - 1;
                            String toSet = "You worked with ";
                            for (SPlayer loopP : so.getWinners().values()) {
                                if (!wp.equals(loopP)) {
                                    toSet = toSet + loopP.getName();
                                    if (++i + 1 == numToList) {
                                        toSet = toSet + " and ";
                                        continue;
                                    }
                                    if (marker + 1 >= numToList) continue;
                                    toSet = toSet + ", ";
                                    continue;
                                }
                                ++i;
                            }
                            toSet = toSet + " to defeat " + genericLoserString + " (" + so.getName() + ").";
                            this.metaStrings.put(wp.getName().toLowerCase(), toSet);
                        }
                    }
                    for (SPlayer lp : so.getLosers().values()) {
                        if (this.drawGame) {
                            String toSet = "The match on " + so.getTargetWorld().getNameAsColoredLink() + " ended in a draw! (" + so.getName() + ").<br>";
                            this.metaStrings.put(lp.getName().toLowerCase(), toSet);
                            continue;
                        }
                        this.metaStrings.put(lp.getName().toLowerCase(), "You were defeated by " + genericWinnerString + " (" + so.getName() + ").<br>");
                    }
                    this.incompleteFinishedInfoString = this.completeFinishedInfoString;
                    return;
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            }
            try {
                String toSet;
                int numWinners = so.getWinners().size();
                int numLosers = so.getLosers().size();
                if (!this.drawGame) {
                    for (SPlayer wp : so.getWinners().values()) {
                        toSet = "";
                        toSet = numWinners > 1 ? toSet + "Your team " : toSet + "You ";
                        toSet = toSet + " defeated ";
                        toSet = numLosers > 1 ? toSet + aLoser.getHouseFightingFor().getColoredNameAsLink() : toSet + aLoser.getColoredName() + aLoser.getHouseFightingFor().getColoredAbbreviation(true);
                        toSet = toSet + " on " + so.getTargetWorld().getNameAsColoredLink() + " (" + so.getName() + ").";
                        this.metaStrings.put(wp.getName().toLowerCase(), toSet + "<br>");
                    }
                }
                for (SPlayer lp : so.getLosers().values()) {
                    toSet = "";
                    if (this.drawGame) {
                        toSet = toSet + "The game ended in a draw!<br>";
                        toSet = toSet + so.getTargetWorld().getNameAsColoredLink() + " (" + so.getName() + ").";
                    } else {
                        toSet = numLosers > 1 ? toSet + "Your team was defeated by " : toSet + "You were defeated by ";
                        toSet = numWinners > 1 ? toSet + aWinner.getHouseFightingFor().getColoredNameAsLink() : toSet + aWinner.getColoredName() + aWinner.getHouseFightingFor().getColoredAbbreviation(true);
                        toSet = toSet + " on " + so.getTargetWorld().getNameAsColoredLink() + " (" + so.getName() + ").";
                    }
                    this.metaStrings.put(lp.getName().toLowerCase(), toSet + "<br>");
                }
                if (numWinners > 1 || !CampaignMain.cm.getBooleanConfig("ShowCompleteGameInfoInNews")) {
                    this.completeFinishedInfoString = this.completeFinishedInfoString + aWinner.getHouseFightingFor().getColoredNameAsLink();
                    this.incompleteFinishedInfoString = this.incompleteFinishedInfoString + aWinner.getHouseFightingFor().getColoredNameAsLink();
                    this.newsFeedBody = aWinner.getHouseFightingFor().getName();
                    this.newsFeedTitle = aWinner.getHouseFightingFor().getName();
                } else {
                    this.completeFinishedInfoString = this.completeFinishedInfoString + aWinner.getColoredName() + aWinner.getHouseFightingFor().getColoredAbbreviation(true);
                    this.incompleteFinishedInfoString = this.incompleteFinishedInfoString + aWinner.getHouseFightingFor().getColoredNameAsLink();
                    this.newsFeedBody = aWinner.getName() + "[" + aWinner.getHouseFightingFor().getAbbreviation() + "]";
                    this.newsFeedTitle = aWinner.getName() + "[" + aWinner.getHouseFightingFor().getAbbreviation() + "]";
                }
                this.newsFeedTitle = this.newsFeedTitle + " defeats ";
                String completeLoserTemp = "";
                String incompleteLoserTemp = "";
                String newsFeedTemp = "";
                if (numLosers > 1 || !CampaignMain.cm.getBooleanConfig("ShowCompleteGameInfoInNews")) {
                    completeLoserTemp = completeLoserTemp + aLoser.getHouseFightingFor().getColoredNameAsLink();
                    incompleteLoserTemp = incompleteLoserTemp + aLoser.getHouseFightingFor().getColoredNameAsLink();
                    newsFeedTemp = aLoser.getHouseFightingFor().getName();
                    this.newsFeedTitle = this.newsFeedTitle + aLoser.getHouseFightingFor().getName();
                } else {
                    completeLoserTemp = completeLoserTemp + aLoser.getColoredName() + aLoser.getHouseFightingFor().getColoredAbbreviation(true);
                    incompleteLoserTemp = incompleteLoserTemp + aLoser.getHouseFightingFor().getColoredNameAsLink();
                    newsFeedTemp = aLoser.getName() + "[" + aLoser.getHouseFightingFor().getAbbreviation() + "]";
                    this.newsFeedTitle = this.newsFeedTitle + aLoser.getName() + "[" + aLoser.getHouseFightingFor().getAbbreviation() + "]";
                }
                if (numLosers > 1 && this.attackersWon) {
                    this.completeFinishedInfoString = this.completeFinishedInfoString + " defeated" + completeLoserTemp + "defenders";
                    this.incompleteFinishedInfoString = this.incompleteFinishedInfoString + " defeated" + incompleteLoserTemp + "defenders";
                    this.newsFeedBody = this.newsFeedBody + " defeated" + newsFeedTemp + "defenders";
                } else if (numLosers == 1 && this.attackersWon) {
                    this.completeFinishedInfoString = this.completeFinishedInfoString + " attacked and defeated " + completeLoserTemp;
                    this.incompleteFinishedInfoString = this.incompleteFinishedInfoString + " attacked and defeated " + incompleteLoserTemp;
                    this.newsFeedBody = this.newsFeedBody + " attacked and defeated " + newsFeedTemp;
                } else if (numLosers > 1 && this.defendersWon) {
                    this.completeFinishedInfoString = this.completeFinishedInfoString + " defeated " + completeLoserTemp + " attackers";
                    this.incompleteFinishedInfoString = this.incompleteFinishedInfoString + " defeated " + incompleteLoserTemp + " attackers";
                    this.newsFeedBody = this.newsFeedBody + " defeated " + newsFeedTemp + " attackers";
                } else {
                    this.completeFinishedInfoString = this.completeFinishedInfoString + " defeated an attack by " + completeLoserTemp;
                    this.incompleteFinishedInfoString = this.incompleteFinishedInfoString + " defeated an attack by " + incompleteLoserTemp;
                    this.newsFeedBody = this.newsFeedBody + " defeated an attack by " + newsFeedTemp;
                }
                this.completeFinishedInfoString = this.completeFinishedInfoString + " on " + so.getTargetWorld().getNameAsColoredLink() + " (" + so.getName() + ").<br>";
                this.incompleteFinishedInfoString = this.incompleteFinishedInfoString + " on " + so.getTargetWorld().getNameAsColoredLink() + " (" + so.getName() + ").<br>";
                this.newsFeedBody = this.newsFeedBody + " on " + so.getTargetWorld().getName() + " (" + so.getName() + ").";
                this.newsFeedTitle = this.newsFeedTitle + " on " + so.getTargetWorld().getName();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            if (o.getTypeIndicator() == Operation.TYPE_SHORTANDLONG) {
                return;
            }
            try {
                int delayBVAdjust;
                int delayUnitAdjust;
                int conquestBVAdjust;
                int conquestUnitAdjust;
                boolean hasLoss = false;
                int conquestCap = o.getIntValue("ConquestAmountCap");
                int delayCap = o.getIntValue("DelayAmountCap");
                int ppCaptureCap = o.getIntValue("PPCapptureCap");
                int unitCaptureCap = o.getIntValue("UnitCaptureCap");
                String winnerMetaString = "";
                String loserMetaString = "";
                StringBuilder winnerHSUpdates = new StringBuilder();
                StringBuilder loserHSUpdates = new StringBuilder();
                SPlanet target = so.getTargetWorld();
                if (this.attackersWon) {
                    try {
                        String unitString;
                        int numCaptured;
                        int totalConquest = o.getIntValue("AttackerBaseConquestAmount");
                        conquestUnitAdjust = o.getIntValue("AttackerConquestUnitAdjustment");
                        conquestBVAdjust = o.getIntValue("AttackerConquestBVAdjustment");
                        if (conquestUnitAdjust > 0) {
                            totalConquest = (int)((double)totalConquest + Math.floor(so.getStartingUnits() / conquestUnitAdjust));
                        }
                        if (conquestBVAdjust > 0) {
                            totalConquest = (int)((double)totalConquest + Math.floor(so.getStartingBV() / conquestBVAdjust));
                        }
                        if (totalConquest > conquestCap) {
                            totalConquest = conquestCap;
                        }
                        if (!aWinner.getHouseFightingFor().isConquerable() || !aLoser.getHouseFightingFor().isConquerable()) {
                            totalConquest = 0;
                        }
                        if (!so.getTargetWorld().isConquerable()) {
                            totalConquest = 0;
                        }
                        if ((totalConquest = so.getTargetWorld().doGainInfluence(aWinner.getHouseFightingFor(), aLoser.getHouseFightingFor(), totalConquest, false)) > 0) {
                            hasLoss = true;
                            String point = "points";
                            if (totalConquest == 1) {
                                point = "point";
                            }
                            winnerMetaString = winnerMetaString + " gained " + totalConquest + " " + point + " of " + target.getNameAsColoredLink();
                            loserMetaString = loserMetaString + " lost " + totalConquest + " " + point + " of " + target.getNameAsColoredLink();
                            so.checkMercContracts(aWinner, 1, totalConquest);
                        }
                        int totalDelay = o.getIntValue("AttackerBaseDelayAmount");
                        delayUnitAdjust = o.getIntValue("AttackerDelayUnitAdjustment");
                        delayBVAdjust = o.getIntValue("AttackerDelayBVAdjustment");
                        if (delayUnitAdjust > 0) {
                            totalDelay = (int)((double)totalDelay + Math.floor(so.getStartingUnits() / delayUnitAdjust));
                        }
                        if (delayBVAdjust > 0) {
                            totalDelay = (int)((double)totalDelay + Math.floor(so.getStartingBV() / delayBVAdjust));
                        }
                        if (this.buildingsLeft > -1 && this.buildingsLeft <= so.getTotalBuildings()) {
                            int buildingDestructionDelayAmount;
                            if (this.attackerisWinner(so)) {
                                this.buildingsDestroyed = Math.max(this.buildingsDestroyed, o.getIntValue("AttackerMinBuildingsIfAttackerWins"));
                            }
                            if (this.buildingsDestroyed >= so.getMinBuildings() && (buildingDestructionDelayAmount = o.getIntValue("DelayPerBuilding")) != 0) {
                                totalDelay += buildingDestructionDelayAmount * this.buildingsDestroyed;
                            }
                        }
                        if (so.getTargetWorld().getOwner() == null || !so.getTargetWorld().getOwner().getName().equalsIgnoreCase(aLoser.getHouseFightingFor().getName())) {
                            totalDelay = 0;
                        }
                        if (totalDelay > delayCap) {
                            totalDelay = delayCap;
                        }
                        if (target.getFactoryCount() == 0) {
                            totalDelay = 0;
                        }
                        if (totalDelay > 0) {
                            for (UnitFactory UF : target.getUnitFactories()) {
                                SUnitFactory currFacility = (SUnitFactory)UF;
                                loserHSUpdates.append(currFacility.addRefresh(totalDelay, false));
                            }
                            if (hasLoss) {
                                winnerMetaString = winnerMetaString + ",";
                                loserMetaString = loserMetaString + ",";
                            }
                            winnerMetaString = winnerMetaString + " stopped production on " + target.getNameAsColoredLink() + " for " + totalDelay + " miniticks";
                            loserMetaString = loserMetaString + " allowed " + aWinner.getHouseFightingFor().getColoredNameAsLink() + " to stop production on " + target.getNameAsColoredLink() + " for " + totalDelay + " miniticks";
                            hasLoss = true;
                            so.checkMercContracts(aWinner, 4, totalDelay);
                        }
                        int unitsToCapture = o.getIntValue("AttackerBaseUnitsTaken");
                        int unitUnitAdjust = o.getIntValue("AttackerUnitsUnitAdjustment");
                        int unitBVAdjust = o.getIntValue("AttackerUnitsBVAdjustment");
                        if (unitUnitAdjust > 0) {
                            unitsToCapture = (int)((double)unitsToCapture + Math.floor(so.getStartingUnits() / unitUnitAdjust));
                        }
                        if (unitBVAdjust > 0) {
                            unitsToCapture = (int)((double)unitsToCapture + Math.floor(so.getStartingBV() / unitBVAdjust));
                        }
                        if (unitsToCapture > unitCaptureCap) {
                            unitsToCapture = unitCaptureCap;
                        }
                        if (o.getBooleanValue("AttackerUnitsTakenBeforeFightStarts")) {
                            unitsToCapture = 0;
                        }
                        ArrayList<Object> capturedUnits = new ArrayList();
                        if (unitsToCapture > 0) {
                            capturedUnits = so.captureUnits(unitsToCapture, target, aLoser.getHouseFightingFor(), false);
                            numCaptured = capturedUnits.size();
                            if (numCaptured >= 1) {
                                for (SUnit sUnit : capturedUnits) {
                                    loserHSUpdates.append(aLoser.getHouseFightingFor().getHSUnitRemovalString(sUnit));
                                    winnerHSUpdates.append(aWinner.getHouseFightingFor().addUnit(sUnit, false));
                                }
                                if (hasLoss) {
                                    winnerMetaString = winnerMetaString + ",";
                                    loserMetaString = loserMetaString + ",";
                                }
                                hasLoss = true;
                                unitString = "";
                                for (SUnit sUnit : capturedUnits) {
                                    unitString = unitString + sUnit.getModelName() + ", ";
                                }
                                unitString = unitString.substring(0, unitString.length() - 2);
                                if (numCaptured == 1) {
                                    winnerMetaString = winnerMetaString + " captured a unit [" + unitString + "]";
                                    loserMetaString = loserMetaString + " lost a unit [" + unitString + "]";
                                } else {
                                    winnerMetaString = winnerMetaString + " captured " + numCaptured + " units [" + unitString + "]";
                                    loserMetaString = loserMetaString + " lost " + numCaptured + " units [" + unitString + "]";
                                }
                            }
                            so.checkMercContracts(aWinner, 2, numCaptured);
                        }
                        unitsToCapture = o.getIntValue("AttackerBaseFactoryUnitsTaken");
                        unitUnitAdjust = o.getIntValue("AttackerFactoryUnitsUnitAdjustment");
                        unitBVAdjust = o.getIntValue("AttackerFactoryUnitsBVAdjustment");
                        if (unitUnitAdjust > 0) {
                            unitsToCapture = (int)((double)unitsToCapture + Math.floor(so.getStartingUnits() / unitUnitAdjust));
                        }
                        if (unitBVAdjust > 0) {
                            unitsToCapture = (int)((double)unitsToCapture + Math.floor(so.getStartingBV() / unitBVAdjust));
                        }
                        if (unitsToCapture > unitCaptureCap) {
                            unitsToCapture = unitCaptureCap;
                        }
                        if (o.getBooleanValue("AttackerUnitsTakenBeforeFightStarts")) {
                            unitsToCapture = 0;
                        }
                        if (unitsToCapture > 0) {
                            capturedUnits = new ArrayList();
                            capturedUnits = so.captureUnits(unitsToCapture, target, aLoser.getHouseFightingFor(), true);
                            numCaptured = capturedUnits.size();
                            if (numCaptured >= 1) {
                                for (SUnit sUnit : capturedUnits) {
                                    loserHSUpdates.append(aLoser.getHouseFightingFor().getHSUnitRemovalString(sUnit));
                                    winnerHSUpdates.append(aWinner.getHouseFightingFor().addUnit(sUnit, false));
                                }
                                if (hasLoss) {
                                    winnerMetaString = winnerMetaString + ",";
                                    loserMetaString = loserMetaString + ",";
                                }
                                hasLoss = true;
                                unitString = "";
                                for (SUnit sUnit : capturedUnits) {
                                    unitString = unitString + sUnit.getModelName() + ", ";
                                }
                                unitString = unitString.substring(0, unitString.length() - 2);
                                if (numCaptured == 1) {
                                    winnerMetaString = winnerMetaString + " force produced a unit [" + unitString + "]";
                                    loserMetaString = loserMetaString + " had a unit force produced [" + unitString + "]";
                                } else {
                                    winnerMetaString = winnerMetaString + " force produced " + numCaptured + " units [" + unitString + "]";
                                    loserMetaString = loserMetaString + " had " + numCaptured + " units force produced [" + unitString + "]";
                                }
                            }
                            so.checkMercContracts(aWinner, 2, numCaptured);
                        }
                        double ppToCaptureDoub = o.getDoubleValue("AttackerBasePPAmount");
                        double d = o.getDoubleValue("AttackerPPUnitAdjustment");
                        double ppBVAdjust = o.getDoubleValue("AttackerPPBVAdjustment");
                        if (d > 0.0) {
                            ppToCaptureDoub *= (double)so.getStartingUnits() / d;
                        }
                        if (ppBVAdjust > 0.0) {
                            ppToCaptureDoub *= (double)so.getStartingBV() / ppBVAdjust;
                        }
                        int ppToCapture = (int)Math.min(ppToCaptureDoub, (double)ppCaptureCap);
                        if (so.getTargetWorld().getOwner() == null || !so.getTargetWorld().getOwner().getName().equalsIgnoreCase(aLoser.getHouseFightingFor().getName())) {
                            ppToCapture = 0;
                        }
                        int ppCaptured = 0;
                        ArrayList<UnitFactory> factoriesSearched = new ArrayList<UnitFactory>(target.getUnitFactories());
                        while (factoriesSearched.size() > 0 && ppCaptured < ppToCapture) {
                            SUnitFactory currFacility = (SUnitFactory)factoriesSearched.remove(CampaignMain.cm.getRandomNumber(factoriesSearched.size()));
                            int currWeight = currFacility.getWeightclass();
                            for (int type = 0; type < 6; ++type) {
                                if (!currFacility.canProduce(type)) continue;
                                boolean noPP = false;
                                while (!noPP && ppCaptured < ppToCapture) {
                                    int ppAvailable = aLoser.getHouseFightingFor().getPP(currWeight, type);
                                    if (ppAvailable <= 0) {
                                        noPP = true;
                                        continue;
                                    }
                                    int toTake = ppToCapture;
                                    if (ppToCapture > ppAvailable) {
                                        toTake = ppAvailable;
                                    }
                                    loserHSUpdates.append(aLoser.getHouseFightingFor().addPP(currWeight, type, -toTake, false));
                                    winnerHSUpdates.append(aWinner.getHouseFightingFor().addPP(currWeight, type, toTake, false));
                                    ppCaptured += toTake;
                                    if (hasLoss) {
                                        winnerMetaString = winnerMetaString + ",";
                                        loserMetaString = loserMetaString + ",";
                                    }
                                    winnerMetaString = winnerMetaString + " stole " + toTake + " " + Unit.getWeightClassDesc(currWeight) + " " + Unit.getTypeClassDesc(type) + " components";
                                    loserMetaString = loserMetaString + " lost " + toTake + " " + Unit.getWeightClassDesc(currWeight) + " " + Unit.getTypeClassDesc(type) + " components";
                                    hasLoss = true;
                                }
                            }
                        }
                        so.checkMercContracts(aWinner, 3, ppCaptured);
                        int unitDestructionCap = o.getIntValue("UnitDestructionCap");
                        int unitsToDestroy = o.getIntValue("BaseUnitsDestroyed");
                        int unitBVDestroyAdjust = o.getIntValue("DestroyedUnitsBVAdjustment");
                        int unitUnitDestroyAdjust = o.getIntValue("DestroyedUnitsUnitAdjustment");
                        if (unitUnitDestroyAdjust > 0) {
                            unitsToDestroy += so.getStartingUnits() / unitUnitDestroyAdjust;
                        }
                        if (unitBVDestroyAdjust > 0) {
                            unitsToDestroy += so.getStartingBV() / unitBVDestroyAdjust;
                        }
                        unitsToDestroy = Math.min(unitsToDestroy, unitDestructionCap);
                        ArrayList<SUnit> opdestroyedUnits = new ArrayList<SUnit>();
                        if (unitsToDestroy > 0) {
                            int numDestroyed = 0;
                            factoriesSearched.clear();
                            factoriesSearched.addAll(target.getUnitFactories());
                            while (factoriesSearched.size() > 0) {
                                SUnitFactory currFacility = (SUnitFactory)factoriesSearched.remove(CampaignMain.cm.getRandomNumber(factoriesSearched.size()));
                                int currWeight = currFacility.getWeightclass();
                                for (int type = 0; type < 6; ++type) {
                                    if (!currFacility.canProduce(type)) continue;
                                    boolean noUnits = false;
                                    while (!noUnits && numDestroyed < unitsToDestroy) {
                                        SUnit destroyed = aLoser.getHouseFightingFor().getEntity(currWeight, type);
                                        if (destroyed == null) {
                                            noUnits = true;
                                            continue;
                                        }
                                        opdestroyedUnits.add(destroyed);
                                        loserHSUpdates.append(aLoser.getHouseFightingFor().getHSUnitRemovalString(destroyed));
                                        ++numDestroyed;
                                    }
                                }
                            }
                            if (numDestroyed >= 1) {
                                if (hasLoss) {
                                    winnerMetaString = winnerMetaString + ",";
                                    loserMetaString = loserMetaString + ",";
                                }
                                hasLoss = true;
                                String unitString2 = "";
                                for (SUnit currU : opdestroyedUnits) {
                                    unitString2 = unitString2 + currU.getModelName() + ", ";
                                }
                                unitString2 = unitString2.substring(0, unitString2.length() - 2);
                                if (numDestroyed == 1) {
                                    winnerMetaString = winnerMetaString + " destroyed a unit [" + unitString2 + "]";
                                    loserMetaString = loserMetaString + " lost a unit [" + unitString2 + "]";
                                } else {
                                    winnerMetaString = winnerMetaString + " destroyed " + numDestroyed + " units [" + unitString2 + "]";
                                    loserMetaString = loserMetaString + " lost " + numDestroyed + " units [" + unitString2 + "]";
                                }
                            }
                            so.checkMercContracts(aWinner, 2, numDestroyed);
                        }
                        double ppDestructionCap = o.getDoubleValue("PPDestructionCap");
                        double ppToDestroyDoub = o.getDoubleValue("BasePPDestroyed");
                        double ppBVDestroyAdjust = o.getDoubleValue("DestroyedPPBVAdjustment");
                        double ppUnitDestroyAdjust = o.getDoubleValue("DestroyedPPUnitAdjustment");
                        if (ppUnitDestroyAdjust > 0.0) {
                            ppToDestroyDoub *= (double)so.getStartingUnits() / ppUnitDestroyAdjust;
                        }
                        if (ppBVDestroyAdjust > 0.0) {
                            ppToDestroyDoub *= (double)so.getStartingBV() / ppBVDestroyAdjust;
                        }
                        int ppToDestroy = (int)Math.min(ppToDestroyDoub, ppDestructionCap);
                        if (so.getTargetWorld().getOwner() == null || !so.getTargetWorld().getOwner().getName().equalsIgnoreCase(aLoser.getHouseFightingFor().getName())) {
                            ppToDestroy = 0;
                        }
                        int ppDestroyed = 0;
                        factoriesSearched.clear();
                        factoriesSearched.addAll(target.getUnitFactories());
                        while (factoriesSearched.size() > 0 && ppDestroyed < ppToDestroy) {
                            SUnitFactory currFacility = (SUnitFactory)factoriesSearched.remove(CampaignMain.cm.getRandomNumber(factoriesSearched.size()));
                            int currWeight = currFacility.getWeightclass();
                            for (int type = 0; type < 6; ++type) {
                                if (!currFacility.canProduce(type)) continue;
                                boolean noPP = false;
                                while (!noPP && ppDestroyed < ppToDestroy) {
                                    int ppAvailable = aLoser.getHouseFightingFor().getPP(currWeight, type);
                                    if (ppAvailable <= 0) {
                                        noPP = true;
                                        continue;
                                    }
                                    int toDestroy = ppToDestroy;
                                    if (ppToDestroy > ppAvailable) {
                                        toDestroy = ppAvailable;
                                    }
                                    loserHSUpdates.append(aLoser.getHouseFightingFor().addPP(currWeight, type, -toDestroy, false));
                                    ppDestroyed += toDestroy;
                                    if (hasLoss) {
                                        winnerMetaString = winnerMetaString + ",";
                                        loserMetaString = loserMetaString + ",";
                                    }
                                    winnerMetaString = winnerMetaString + " destroyed " + toDestroy + " " + Unit.getWeightClassDesc(currWeight) + " " + Unit.getTypeClassDesc(type) + " components";
                                    loserMetaString = loserMetaString + " lost " + toDestroy + " " + Unit.getWeightClassDesc(currWeight) + " " + Unit.getTypeClassDesc(type) + " components";
                                    hasLoss = true;
                                }
                            }
                        }
                        so.checkMercContracts(aWinner, 3, ppDestroyed);
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog(ex);
                    }
                } else if (this.defendersWon) {
                    try {
                        int totalConquest = o.getIntValue("DefenderBaseConquestAmount");
                        conquestUnitAdjust = o.getIntValue("DefenderConquestUnitAdjustment");
                        conquestBVAdjust = o.getIntValue("DefenderConquestBVAdjustment");
                        if (conquestUnitAdjust > 0) {
                            totalConquest = (int)((double)totalConquest + Math.floor(so.getStartingUnits() / conquestUnitAdjust));
                        }
                        if (conquestBVAdjust > 0) {
                            totalConquest = (int)((double)totalConquest + Math.floor(so.getStartingBV() / conquestBVAdjust));
                        }
                        if (totalConquest > conquestCap) {
                            totalConquest = conquestCap;
                        }
                        if (!aWinner.getHouseFightingFor().isConquerable() || !aLoser.getHouseFightingFor().isConquerable()) {
                            totalConquest = 0;
                        }
                        if (!so.getTargetWorld().isConquerable()) {
                            totalConquest = 0;
                        }
                        if ((totalConquest = so.getTargetWorld().doGainInfluence(aWinner.getHouseFightingFor(), aLoser.getHouseFightingFor(), totalConquest, false)) > 0) {
                            hasLoss = true;
                            String point = "points";
                            if (totalConquest == 1) {
                                point = "point";
                            }
                            winnerMetaString = winnerMetaString + " gained " + totalConquest + " " + point + " of " + target.getNameAsColoredLink();
                            loserMetaString = loserMetaString + " lost " + totalConquest + " " + point + " of " + target.getNameAsColoredLink();
                            so.checkMercContracts(aWinner, 1, totalConquest);
                        }
                        int totalRefreshBoost = o.getIntValue("DefenderBaseDelayAmount");
                        delayUnitAdjust = o.getIntValue("DefenderDelayUnitAdjustment");
                        delayBVAdjust = o.getIntValue("DefenderDelayBVAdjustment");
                        if (delayUnitAdjust > 0) {
                            totalRefreshBoost = (int)((double)totalRefreshBoost + Math.floor(so.getStartingUnits() / delayUnitAdjust));
                        }
                        if (delayBVAdjust > 0) {
                            totalRefreshBoost = (int)((double)totalRefreshBoost + Math.floor(so.getStartingBV() / delayBVAdjust));
                        }
                        if (totalRefreshBoost > delayCap) {
                            totalRefreshBoost = delayCap;
                        }
                        if (target.getFactoryCount() == 0) {
                            totalRefreshBoost = 0;
                        }
                        if (so.getTargetWorld().getOwner() == null || !so.getTargetWorld().getOwner().getName().equalsIgnoreCase(aWinner.getHouseFightingFor().getName())) {
                            totalRefreshBoost = 0;
                        }
                        if (totalRefreshBoost > 0) {
                            for (UnitFactory UF : target.getUnitFactories()) {
                                SUnitFactory currFacility = (SUnitFactory)UF;
                                winnerHSUpdates.append(currFacility.addRefresh(-totalRefreshBoost, true));
                            }
                            if (hasLoss) {
                                winnerMetaString = winnerMetaString + ",";
                                loserMetaString = loserMetaString + ",";
                            }
                            winnerMetaString = winnerMetaString + " sped up production on " + target.getNameAsColoredLink() + " by " + totalRefreshBoost + " miniticks";
                            loserMetaString = loserMetaString + " encouraged the workers on " + target.getNameAsColoredLink() + " to speed up the production lines for " + totalRefreshBoost + "miniticks";
                            hasLoss = true;
                            so.checkMercContracts(aWinner, 4, totalRefreshBoost);
                        }
                        if (target.getFactoryCount() > 0) {
                            int n;
                            double ppToGenerateDoub = o.getDoubleValue("DefenderBasePPAmount");
                            double ppUnitAdjust = o.getDoubleValue("DefenderPPUnitAdjustment");
                            double ppBVAdjust = o.getDoubleValue("DefenderPPBVAdjustment");
                            if (ppUnitAdjust > 0.0) {
                                ppToGenerateDoub *= (double)so.getStartingUnits() / ppUnitAdjust;
                            }
                            if (ppBVAdjust > 0.0) {
                                ppToGenerateDoub *= (double)so.getStartingBV() / ppBVAdjust;
                            }
                            if (ppToGenerateDoub > (double)ppCaptureCap) {
                                ppToGenerateDoub = ppCaptureCap;
                            }
                            int n2 = (int)ppToGenerateDoub;
                            if (so.getTargetWorld().getOwner() == null || !so.getTargetWorld().getOwner().getName().equalsIgnoreCase(aWinner.getHouseFightingFor().getName())) {
                                n = 0;
                            }
                            if (n > 0) {
                                SUnitFactory sUnitFactory = target.getRandomUnitFactory();
                                for (int type = 0; type < 6; ++type) {
                                    if (!sUnitFactory.canProduce(type)) continue;
                                    winnerHSUpdates.append(aWinner.getHouseFightingFor().addPP(sUnitFactory.getWeightclass(), type, n, false));
                                    if (hasLoss) {
                                        winnerMetaString = winnerMetaString + ",";
                                        loserMetaString = loserMetaString + ",";
                                    }
                                    winnerMetaString = winnerMetaString + " generated an extra " + n + " " + Unit.getWeightClassDesc(sUnitFactory.getWeightclass()) + " " + Unit.getTypeClassDesc(type) + " components";
                                    loserMetaString = loserMetaString + " inspired the workers on " + target.getNameAsColoredLink() + " to manufacture " + n + " " + Unit.getWeightClassDesc(sUnitFactory.getWeightclass()) + " " + Unit.getTypeClassDesc(type) + " components";
                                    hasLoss = true;
                                    so.checkMercContracts(aWinner, 3, n);
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog(ex);
                    }
                }
                if (hasLoss) {
                    String meta1 = "";
                    String meta2 = "";
                    int winnerIndex = winnerMetaString.lastIndexOf(", ");
                    int loserIndex = loserMetaString.lastIndexOf(", ");
                    if (winnerIndex >= 0) {
                        meta1 = winnerMetaString.substring(0, winnerIndex);
                        meta2 = winnerMetaString.substring(winnerIndex + 2, winnerMetaString.length());
                        winnerMetaString = meta1 + " and " + meta2 + ".";
                    }
                    this.completeFinishedInfoString = this.completeFinishedInfoString + " " + aWinner.getHouseFightingFor().getColoredNameAsLink() + winnerMetaString;
                    this.incompleteFinishedInfoString = this.incompleteFinishedInfoString + " " + aWinner.getHouseFightingFor().getColoredNameAsLink() + winnerMetaString;
                    this.newsFeedBody = this.newsFeedBody + " " + aWinner.getHouseFightingFor().getName() + winnerMetaString;
                    if (loserIndex >= 0) {
                        meta1 = loserMetaString.substring(0, loserIndex);
                        meta2 = loserMetaString.substring(loserIndex + 2, loserMetaString.length());
                        loserMetaString = meta1 + " and " + meta2 + ".";
                    }
                    if (!this.drawGame) {
                        for (String currName : so.getWinners().keySet()) {
                            String currMeta = this.metaStrings.get(currName);
                            this.metaStrings.put(currName, currMeta + " You've " + winnerMetaString + "<br>");
                        }
                    }
                    for (String currName : so.getLosers().keySet()) {
                        String currentMeta = this.metaStrings.get(currName);
                        this.metaStrings.put(currName, currentMeta + " You've " + loserMetaString + "<br>");
                    }
                }
                if (winnerHSUpdates.length() > 0) {
                    CampaignMain.cm.doSendToAllOnlinePlayers(aWinner.getHouseFightingFor(), "HS|" + winnerHSUpdates, false);
                }
                if (loserHSUpdates.length() > 0) {
                    CampaignMain.cm.doSendToAllOnlinePlayers(aLoser.getHouseFightingFor(), "HS|" + loserHSUpdates, false);
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    private void possibleSalvageFromReport(StringTokenizer reportTokenizer, ShortOperation so) {
        try {
            this.salvagableUnits = new TreeMap();
            this.destroyedUnits = new TreeMap();
            this.livingUnits = new TreeMap();
            this.pilots = new TreeMap();
            int destroyed = 0;
            Operation o = CampaignMain.cm.getOpsManager().getOperation(so.getName());
            int fledSalvageChance = o.getIntValue("FledUnitSalvageChance");
            int fledScrappedChance = o.getIntValue("FledUnitScrappedChance");
            int pushedSalvageChance = o.getIntValue("PushedUnitSalvageChance");
            int pushedScrappedChance = o.getIntValue("PushedUnitScrappedChance");
            int enginedScrappedChance = o.getIntValue("EnginedUnitsScrappedChance");
            int forcedSalvageScrappedChance = o.getIntValue("ForcedSalvageUnitsScrappedChance");
            try {
                while (reportTokenizer.hasMoreTokens()) {
                    String currentUnit = reportTokenizer.nextToken();
                    if (currentUnit.startsWith("MW*")) {
                        StringTokenizer mwTokenizer = new StringTokenizer(currentUnit, "*");
                        mwTokenizer.nextToken();
                        int originalID = Integer.parseInt(mwTokenizer.nextToken());
                        int pickUpID = Integer.parseInt(mwTokenizer.nextToken());
                        boolean isDead = Boolean.parseBoolean(mwTokenizer.nextToken());
                        SPilot mw = SPilot.getMekWarrior(originalID, pickUpID);
                        mw.setDeath(isDead);
                        this.pilots.put(originalID, mw);
                        continue;
                    }
                    if (currentUnit.startsWith("BL*")) {
                        this.buildingsLeft = Integer.parseInt(currentUnit.substring(3));
                        continue;
                    }
                    OperationEntity oEntity = new OperationEntity(currentUnit);
                    SUnit unit = CampaignMain.cm.getPlayer(oEntity.getOwnerName()).getUnit(oEntity.getID());
                    if (unit == null && !o.getBooleanValue("SupportUnitsAreSalvageable")) continue;
                    if (unit == null && o.getBooleanValue("SupportUnitsAreSalvageable")) {
                        unit = new SUnit(oEntity.getID(), "Salvaged Support Unit", oEntity.getUnitFileName());
                        CampaignMain.cm.getPlayer(oEntity.getOwnerName()).addUnit(unit, true);
                    }
                    if ((fledSalvageChance > 0 || fledScrappedChance > 0) && oEntity.getRemovalReason() == 256) {
                        if (CampaignMain.cm.getRandomNumber(100) <= fledSalvageChance) {
                            oEntity.setRemovalReason(512);
                            oEntity.setSalvage(true);
                        } else if (CampaignMain.cm.getRandomNumber(100) <= fledScrappedChance) {
                            oEntity.setRemovalReason(1024);
                        }
                    } else if ((pushedSalvageChance > 0 || pushedScrappedChance > 0) && oEntity.getRemovalReason() == 272) {
                        if (CampaignMain.cm.getRandomNumber(100) <= pushedSalvageChance) {
                            oEntity.setRemovalReason(512);
                            oEntity.setSalvage(true);
                        } else if (CampaignMain.cm.getRandomNumber(100) <= pushedScrappedChance) {
                            oEntity.setRemovalReason(1024);
                        }
                    } else if (UnitUtils.getNumberOfDamagedEngineCrits(unit.getEntity()) >= 3 && CampaignMain.cm.getRandomNumber(100) <= enginedScrappedChance) {
                        oEntity.setRemovalReason(1024);
                    } else if (!oEntity.canStand() && CampaignMain.cm.getRandomNumber(100) < forcedSalvageScrappedChance) {
                        oEntity.setRemovalReason(1024);
                    }
                    if (oEntity.getRemovalReason() == 528 && CampaignMain.cm.isUsingAdvanceRepair() && !this.nonDestructionMode) {
                        UnitUtils.destroyCockPit(unit.getEntity());
                    }
                    so.getReporter().addEndingUnit(unit, oEntity.getRemovalReason());
                    if (oEntity.isLiving()) {
                        this.livingUnits.put(oEntity.getID(), oEntity);
                        destroyed = 0;
                        if (so.getLosers().containsKey(oEntity.getOwnerName().toLowerCase())) {
                            this.currentBV += unit.getBV();
                        }
                    } else if (oEntity.isSalvagable()) {
                        this.salvagableUnits.put(oEntity.getID(), oEntity);
                        destroyed = 1;
                    } else {
                        this.destroyedUnits.put(oEntity.getID(), oEntity);
                        destroyed = 1;
                    }
                    if (!this.saveStats) continue;
                    SUnit currU = CampaignMain.cm.getPlayer(oEntity.getOwnerName()).getUnit(oEntity.getID());
                    if (so.getWinners().containsKey(oEntity.getOwnerName().toLowerCase())) {
                        CampaignMain.cm.addMechStat(currU.getUnitFilename(), currU.getWeightclass(), 1, 1, 0, destroyed);
                        continue;
                    }
                    if (!so.getLosers().containsKey(oEntity.getOwnerName().toLowerCase())) continue;
                    CampaignMain.cm.addMechStat(currU.getUnitFilename(), currU.getWeightclass(), 1, 0, 0, destroyed);
                }
                so.setFinishingBV(this.currentBV);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            int baseChance = CampaignMain.cm.getIntegerConfig("ArtilleryOffBoardOverRun");
            int captureChance = CampaignMain.cm.getIntegerConfig("OffBoardChanceOfCapture");
            try {
                for (OperationEntity currO : this.livingUnits.values()) {
                    if (so.getWinners().containsKey(currO.getOwnerName().toLowerCase()) || currO.getOffBoardRange() <= 0) continue;
                    int currOverrunChance = baseChance - currO.getOffBoardRange();
                    if (CampaignMain.cm.getRandomNumber(100) > currOverrunChance) continue;
                    this.livingUnits.remove(currO);
                    if (CampaignMain.cm.getRandomNumber(100) < captureChance) {
                        currO.setRemovalReason(512);
                        this.salvagableUnits.put(currO.getID(), currO);
                        continue;
                    }
                    if (currO.getType() == 0 || currO.getType() == 6) {
                        currO.setCTint(0);
                    }
                    currO.setSalvage(false);
                    this.destroyedUnits.put(currO.getID(), currO);
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void possibleSalvageFromInProgressInfo(ShortOperation so, SPlayer loser) {
        try {
            this.salvagableUnits = new TreeMap();
            this.destroyedUnits = new TreeMap();
            this.livingUnits = new TreeMap();
            this.pilots = new TreeMap();
            try {
                for (OperationEntity currEntity : so.getUnitsInProgress().values()) {
                    if (CampaignMain.cm.getPlayer(currEntity.getOwnerName()).getUnit(currEntity.getID()) == null) continue;
                    if (currEntity.isLiving()) {
                        this.livingUnits.put(currEntity.getID(), currEntity);
                        continue;
                    }
                    if (currEntity.isSalvagable()) {
                        this.salvagableUnits.put(currEntity.getID(), currEntity);
                        continue;
                    }
                    this.destroyedUnits.put(currEntity.getID(), currEntity);
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            try {
                for (SArmy currArmy : this.allArmies.values()) {
                    for (Unit currUnit : currArmy.getUnits()) {
                        int currID = currUnit.getId();
                        if (this.livingUnits.get(currID) != null || this.salvagableUnits.get(currID) != null || this.destroyedUnits.get(currID) != null) continue;
                        OperationEntity oe = new OperationEntity(currArmy.getPlayerName(), currID, 0, 1, 1, true);
                        this.livingUnits.put(currID, oe);
                    }
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            this.pilots.putAll(so.getPilotsInProgress());
            ArrayList<OperationEntity> dropLivingUnits = new ArrayList<OperationEntity>();
            try {
                for (OperationEntity currE : this.livingUnits.values()) {
                    if (!currE.getOwnerName().toLowerCase().equals(loser.getName().toLowerCase())) continue;
                    dropLivingUnits.add(currE);
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
            try {
                if (dropLivingUnits.size() > 0) {
                    int unitsToDestroy = CampaignMain.cm.getIntegerConfig("DisconnectionAddUnitsDestroyed");
                    int unitsToSalvage = CampaignMain.cm.getIntegerConfig("DisconnectionAddUnitsSalvage");
                    for (int unitsDestroyed = 0; unitsDestroyed < unitsToDestroy && dropLivingUnits.size() > 0; ++unitsDestroyed) {
                        OperationEntity randomEntity = (OperationEntity)dropLivingUnits.remove(CampaignMain.cm.getRandomNumber(dropLivingUnits.size()));
                        randomEntity.setRemovalReason(1024);
                        randomEntity.setSalvage(false);
                        this.livingUnits.remove(randomEntity.getID());
                        this.destroyedUnits.put(randomEntity.getID(), randomEntity);
                    }
                    for (int unitsSalvaged = 0; unitsSalvaged < unitsToSalvage && dropLivingUnits.size() > 0; ++unitsSalvaged) {
                        OperationEntity randomEntity = (OperationEntity)dropLivingUnits.remove(CampaignMain.cm.getRandomNumber(dropLivingUnits.size()));
                        if (randomEntity.getType() == 0 || randomEntity.getType() == 6) {
                            this.pilots.put(randomEntity.getID(), SPilot.getMekWarrior(randomEntity.getID(), -1));
                        }
                        randomEntity.setRemovalReason(512);
                        randomEntity.setSalvage(true);
                        this.livingUnits.remove(randomEntity.getID());
                        this.salvagableUnits.put(randomEntity.getID(), randomEntity);
                    }
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    private String handleDeadPilot(SPlayer owner, SUnit unit, OperationEntity entity, ShortOperation op) {
        String toReturn = "";
        try {
            boolean personalQueues = CampaignMain.cm.getBooleanConfig("AllowPersonalPilotQueues");
            boolean isPilotChangeable = unit.isSinglePilotUnit();
            if (CampaignMain.cm.isUsingCyclops()) {
                CampaignMain.cm.getMWCC().pilotKill((SPilot)unit.getPilot(), op.getOpCyclopsID());
            }
            if (CampaignMain.cm.isUsingMySQL()) {
                CampaignMain.cm.MySQL.deletePilot(((SPilot)unit.getPilot()).getPilotId());
            }
            if (isPilotChangeable && personalQueues) {
                SPilot pilot = new SPilot("Vacant", 99, 99);
                unit.setPilot(pilot);
            } else {
                unit.setPilot(owner.getHouseFightingFor().getNewPilot(unit.getType()));
                if (unit.isSinglePilotUnit()) {
                    toReturn = toReturn + " New Pilot: " + unit.getPilot().getName();
                } else if (entity.getType() == 1) {
                    toReturn = toReturn + " New Crew:";
                } else if (entity.getType() == 4 || entity.getType() == 2) {
                    toReturn = toReturn + " New Squad:";
                }
                toReturn = toReturn + " " + this.newPilotDescription(unit);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return toReturn;
        }
        return toReturn;
    }

    private void handleDispossesedPilot(SPlayer owner, SUnit unit) {
        try {
            boolean personalQueues = CampaignMain.cm.getBooleanConfig("AllowPersonalPilotQueues");
            boolean isPilotChangeable = unit.isSinglePilotUnit();
            if (isPilotChangeable && personalQueues) {
                owner.getPersonalPilotQueue().addPilot(unit.getPilot(), unit.getWeightclass());
                CampaignMain.cm.toUser("PL|AP2PPQ|" + unit.getType() + "|" + unit.getWeightclass() + "|" + ((SPilot)unit.getPilot()).toFileFormat("#", true), owner.getName(), false);
                owner.getPersonalPilotQueue().checkQueueAndWarn(owner.getName(), unit.getType(), unit.getWeightclass());
                unit.setPilot(new SPilot("Vacant", 99, 99));
            } else {
                owner.getHouseFightingFor().addDispossessedPilot(unit, false);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    private Object[] setupPilotStringForUnit(OperationEntity currEntity, SUnit currUnit, SPlanet target) {
        SPilot mw = this.pilots.get(currEntity.getID());
        Object[] toReturn = new Object[]{new Boolean(false), "", "", "", null};
        try {
            int minChance;
            if (mw != null) {
                int minChance2;
                if (mw.isDead()) {
                    toReturn[1] = currUnit.getPilot().getName() + " ejected, but was killed on the ground.";
                    toReturn[3] = " The pilot was killed.";
                    return toReturn;
                }
                SPlayer pickupPlayer = null;
                OperationEntity pickupEntity = this.livingUnits.get(mw.getPickedUpID());
                if (pickupEntity != null) {
                    pickupPlayer = CampaignMain.cm.getPlayer(pickupEntity.getOwnerName());
                }
                if (pickupPlayer != null) {
                    if (currEntity.getOwner().getHouseFightingFor().equals(pickupPlayer.getHouseFightingFor())) {
                        toReturn[0] = new Boolean(true);
                        toReturn[1] = currUnit.getPilot().getName() + " ejected and was picked up by a friendly unit.";
                        toReturn[3] = "The pilot survived.";
                        return toReturn;
                    }
                    toReturn[1] = currUnit.getPilot().getName() + " ejected, but was captured by enemy forces.";
                    toReturn[3] = "The pilot was captured.";
                    toReturn[4] = pickupPlayer;
                    int captureChance = CampaignMain.cm.getIntegerConfig("ChanceToConvertCapturedPilots");
                    if (CampaignMain.cm.getRandomNumber(100) < captureChance) {
                        if (CampaignMain.cm.getBooleanConfig("AllowPersonalPilotQueues")) {
                            pickupPlayer.getPersonalPilotQueue().addPilot(currUnit.getPilot(), currUnit.getWeightclass());
                            CampaignMain.cm.toUser("PL|AP2PPQ|" + currUnit.getType() + "|" + currUnit.getWeightclass() + "|" + ((SPilot)currUnit.getPilot()).toFileFormat("#", true), pickupPlayer.getName(), false);
                            pickupPlayer.getPersonalPilotQueue().checkQueueAndWarn(pickupPlayer.getName(), currUnit.getType(), currUnit.getWeightclass());
                        } else {
                            pickupPlayer.getHouseFightingFor().addDispossessedPilot(currUnit, true);
                        }
                        toReturn[0] = new Boolean(false);
                        toReturn[2] = currUnit.getPilot().getName() + " was captured by your forces and has decided to join " + pickupPlayer.getHouseFightingFor().getColoredNameAsLink() + ".";
                        return toReturn;
                    }
                    toReturn[2] = currUnit.getPilot().getName() + " was captured by your forces and transferred to HQ for interrogation.";
                    return toReturn;
                }
                if (this.shortOp.getWinners().containsKey(currEntity.getOwnerName().toLowerCase())) {
                    toReturn[0] = new Boolean(true);
                    toReturn[1] = currUnit.getPilot().getName() + " was picked up by a recovery team.";
                    toReturn[3] = "The pilot survived.";
                    return toReturn;
                }
                int survivalChance = target.getInfluence().getInfluence(currEntity.getOwner().getHouseFightingFor().getId());
                if (survivalChance < (minChance2 = CampaignMain.cm.getIntegerConfig("BasePilotSurvival"))) {
                    survivalChance = minChance2;
                }
                if (currUnit.getPilot().getSkills().has(14)) {
                    survivalChance += 20;
                }
                if (CampaignMain.cm.getRandomNumber(100) < survivalChance) {
                    toReturn[0] = new Boolean(true);
                    toReturn[1] = ((SPilot)currUnit.getPilot()).getPilotRescueMessage(currUnit);
                    toReturn[3] = "The pilot survived";
                    return toReturn;
                }
                pickupPlayer = this.selectRandomWinner();
                if (pickupPlayer == null) {
                    return toReturn;
                }
                toReturn[1] = ((SPilot)currUnit.getPilot()).getPilotCaptureMessageToOwner(currUnit);
                toReturn[3] = "The pilot was captured.";
                toReturn[4] = pickupPlayer;
                int captureChance = CampaignMain.cm.getIntegerConfig("ChanceToConvertCapturedPilots");
                if (CampaignMain.cm.getRandomNumber(100) < captureChance) {
                    if (CampaignMain.cm.getBooleanConfig("AllowPersonalPilotQueues")) {
                        pickupPlayer.getPersonalPilotQueue().addPilot(currUnit.getPilot(), currUnit.getWeightclass());
                        CampaignMain.cm.toUser("PL|PPQ|" + pickupPlayer.getPersonalPilotQueue().toString(true), pickupPlayer.getName(), false);
                    } else {
                        pickupPlayer.getHouseFightingFor().addDispossessedPilot(currUnit, true);
                    }
                    toReturn[0] = new Boolean(false);
                    toReturn[2] = ((SPilot)currUnit.getPilot()).getPilotCaptureAndDefectedMessage(currUnit, pickupPlayer.getHouseFightingFor());
                    return toReturn;
                }
                toReturn[2] = ((SPilot)currUnit.getPilot()).getPilotCaptureAndRemovedMessage(currUnit);
                return toReturn;
            }
            if (currEntity.getType() == 3) {
                toReturn[1] = currUnit.getPilot().getName() + " died when the unit was destroyed.";
                toReturn[3] = "The pilot was killed.";
                return toReturn;
            }
            if (currEntity.getType() == 1) {
                if (currEntity.isSalvage() && !currEntity.isCrewDead()) {
                    int minChance3;
                    if (this.shortOp.getWinners().containsKey(currEntity.getOwnerName().toLowerCase()) || !CampaignMain.cm.getBooleanConfig("DownPilotsMustRollForSurvival")) {
                        toReturn[0] = new Boolean(true);
                        toReturn[1] = "The crew survived.";
                        toReturn[3] = "The crew survived.";
                        return toReturn;
                    }
                    int survivalChance = target.getInfluence().getInfluence(currEntity.getOwner().getHouseFightingFor().getId());
                    if (survivalChance < (minChance3 = CampaignMain.cm.getIntegerConfig("BasePilotSurvival"))) {
                        survivalChance = minChance3;
                    }
                    if (CampaignMain.cm.getRandomNumber(100) < (survivalChance -= CampaignMain.cm.getIntegerConfig("TrappedInMechSurvivalMod"))) {
                        toReturn[0] = new Boolean(true);
                        toReturn[1] = "The crew survived.";
                        toReturn[3] = "The crew survived.";
                    } else {
                        toReturn[0] = new Boolean(false);
                        toReturn[1] = "The crew didn't make it back to base.";
                        toReturn[3] = "The crew was killed.";
                    }
                } else if (currEntity.isSalvage() && currEntity.isCrewDead()) {
                    toReturn[1] = "The crew of the " + currUnit.getModelName() + " was killed in action.";
                    toReturn[3] = "The crew was killed.";
                } else {
                    toReturn[1] = "The crew of the " + currUnit.getModelName() + " died when the unit was destroyed.";
                    toReturn[3] = "The crew was killed.";
                }
                return toReturn;
            }
            if (currEntity.getType() == 4 || currEntity.getType() == 2) {
                toReturn[1] = "The " + currUnit.getModelName() + " squad was declared MIA.";
                toReturn[3] = "The squad was killed.";
                return toReturn;
            }
            if (currEntity.getPilothits() >= 6) {
                toReturn[1] = currUnit.getPilot().getName() + " was fatally wounded.";
                toReturn[3] = "The pilot was killed.";
                return toReturn;
            }
            if (currEntity.getHDint() <= 0 && currEntity.getCockpitType() != 1 && currEntity.getRemovalReason() != 528) {
                toReturn[1] = currUnit.getPilot().getName() + " died when the " + currUnit.getModelName() + "'s head was destroyed.";
                toReturn[3] = "The pilot was killed.";
                return toReturn;
            }
            if ((currEntity.getCTint() <= 0 || currEntity.getRemovalReason() == 1024) && currEntity.getCockpitType() == 1) {
                toReturn[1] = currUnit.getPilot().getName() + " died when the " + currUnit.getModelName() + "'s center torso was destroyed.";
                toReturn[3] = "The pilot was killed.";
                return toReturn;
            }
            if (CampaignMain.cm.getBooleanConfig("AllowPilotDamageToTransfer")) {
                currUnit.getPilot().setHits(currEntity.getPilothits());
            }
            if (this.shortOp.getWinners().containsKey(currEntity.getOwnerName().toLowerCase()) || !CampaignMain.cm.getBooleanConfig("DownPilotsMustRollForSurvival")) {
                toReturn[0] = new Boolean(true);
                toReturn[1] = ((SPilot)currUnit.getPilot()).getPilotRescueMessage(currUnit);
                toReturn[3] = "The pilot survived.";
                return toReturn;
            }
            int survivalChance = target.getInfluence().getInfluence(currEntity.getOwner().getHouseFightingFor().getId());
            if (survivalChance < (minChance = CampaignMain.cm.getIntegerConfig("BasePilotSurvival"))) {
                survivalChance = minChance;
            }
            if (currUnit.getPilot().getSkills().has(14)) {
                survivalChance += 20;
            }
            if (CampaignMain.cm.getRandomNumber(100) < (survivalChance -= CampaignMain.cm.getIntegerConfig("TrappedInMechSurvivalMod"))) {
                toReturn[0] = new Boolean(true);
                toReturn[1] = ((SPilot)currUnit.getPilot()).getPilotRescueMessage(currUnit);
                toReturn[3] = "The pilot survived.";
                return toReturn;
            }
            SPlayer pickupPlayer = this.selectRandomWinner();
            if (pickupPlayer == null) {
                pickupPlayer = this.selectRandomLoser();
            }
            if (pickupPlayer == null) {
                return toReturn;
            }
            toReturn[1] = ((SPilot)currUnit.getPilot()).getPilotCaptureMessageToOwner(currUnit);
            toReturn[3] = "The pilot was captured.";
            toReturn[4] = pickupPlayer;
            int captureChance = CampaignMain.cm.getIntegerConfig("ChanceToConvertCapturedPilots");
            if (CampaignMain.cm.getRandomNumber(100) < captureChance) {
                if (CampaignMain.cm.getBooleanConfig("AllowPersonalPilotQueues")) {
                    pickupPlayer.getPersonalPilotQueue().addPilot(currUnit.getPilot(), currUnit.getWeightclass());
                    CampaignMain.cm.toUser("PL|PPQ|" + pickupPlayer.getPersonalPilotQueue().toString(true), pickupPlayer.getName(), false);
                } else {
                    pickupPlayer.getHouseFightingFor().addDispossessedPilot(currUnit, true);
                }
                toReturn[0] = new Boolean(false);
                toReturn[2] = ((SPilot)currUnit.getPilot()).getPilotCaptureAndDefectedMessage(currUnit, pickupPlayer.getHouseFightingFor());
                return toReturn;
            }
            toReturn[2] = ((SPilot)currUnit.getPilot()).getPilotCaptureAndRemovedMessage(currUnit);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return toReturn;
        }
        return toReturn;
    }

    private int getSalvageCost(SPlayer owner, SUnit u, OperationEntity oe, Operation o, ShortOperation so) {
        float repairCost = 0.0f;
        int attackerMod = o.getIntValue("BVToBoostAttackerSalvageCost");
        int defenderMod = o.getIntValue("BVToBoostDefenderSalvageCost");
        boolean isAttacker = false;
        try {
            if (so.getAttackers().containsKey(owner.getName().toLowerCase()) && attackerMod > 0) {
                repairCost = u.getBV() / attackerMod;
                isAttacker = true;
            }
            if (so.getDefenders().containsKey(owner.getName().toLowerCase()) && defenderMod > 0) {
                repairCost = u.getBV() / defenderMod;
            }
            if (oe.getHDint() <= 0) {
                repairCost = (float)((double)repairCost * 0.7);
            } else if (oe.getRemovalReason() == 528) {
                repairCost = (float)((double)repairCost * 0.6);
            }
            if (oe.getLLint() <= 0) {
                repairCost = (float)((double)repairCost * 1.05);
            }
            if (oe.getRLint() <= 0) {
                repairCost = (float)((double)repairCost * 1.05);
            }
            repairCost = oe.getOwnerName().toLowerCase().equals(owner.getName().toLowerCase()) ? (float)((double)repairCost * 0.75) : (float)((double)repairCost * 1.15);
            repairCost = isAttacker ? (repairCost *= o.getFloatValue("AttackerSalvageCostModifier")) : (repairCost *= o.getFloatValue("DefenderSalvageCostModifier"));
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return Math.round(repairCost);
        }
        return Math.round(repairCost);
    }

    private int determineLossCompensation(SPlayer p, SUnit u, boolean salvage) {
        int flatMax;
        float compensation = CampaignMain.cm.getFloatConfig("BaseUnitLossPayment");
        int newPrice = p.getHouseFightingFor().getPriceForUnit(u.getWeightclass(), u.getType());
        compensation += (float)newPrice * CampaignMain.cm.getFloatConfig("NewCostMultiUnitLossPayment");
        if (salvage) {
            compensation *= CampaignMain.cm.getFloatConfig("SalvageMultiToUnitLossPayment");
        }
        if (u.getType() == 0 || u.getType() == 6) {
            compensation *= CampaignMain.cm.getFloatConfig("MekMultiToUnitLossPayment");
        } else if (u.getType() == 1) {
            compensation *= CampaignMain.cm.getFloatConfig("VehMultiToUnitLossPayment");
        } else if (u.getType() == 3) {
            compensation *= CampaignMain.cm.getFloatConfig("ProtoMultiToUnitLossPayment");
        } else if (u.getType() == 4) {
            compensation *= CampaignMain.cm.getFloatConfig("BAMultiToUnitLossPayment");
        } else if (u.getType() == 2) {
            compensation *= CampaignMain.cm.getFloatConfig("InfMultiToUnitLossPayment");
        } else if (u.getType() == 5) {
            compensation *= CampaignMain.cm.getFloatConfig("AeroMultiToUnitLossPayment");
        }
        float newMultiMax = (float)newPrice * CampaignMain.cm.getFloatConfig("NewCostMultiMaxUnitLossPayment");
        if (newMultiMax > 0.0f && compensation > newMultiMax) {
            compensation = newMultiMax;
        }
        if (compensation > (float)(flatMax = CampaignMain.cm.getIntegerConfig("FlatMaxUnitLossPayment"))) {
            compensation = flatMax;
        }
        if (compensation < 0.0f) {
            compensation = 0.0f;
        }
        return Math.round(compensation);
    }

    private SPlayer selectRandomWinner() {
        try {
            if (this.shortOp.getWinners().size() <= 0) {
                return null;
            }
            if (this.shortOp.getWinners().size() == 1) {
                String key = this.shortOp.getWinners().firstKey();
                return CampaignMain.cm.getPlayer(key);
            }
            int random = CampaignMain.cm.getRandomNumber(this.shortOp.getWinners().size());
            int current = 0;
            for (String wn : this.shortOp.getWinners().keySet()) {
                if (random == current) {
                    return CampaignMain.cm.getPlayer(wn);
                }
                ++current;
            }
            return null;
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return null;
        }
    }

    private SPlayer selectRandomLoser() {
        try {
            if (this.shortOp.getLosers().size() <= 0) {
                return null;
            }
            if (this.shortOp.getLosers().size() == 1) {
                String key = this.shortOp.getLosers().firstKey();
                return CampaignMain.cm.getPlayer(key);
            }
            int random = CampaignMain.cm.getRandomNumber(this.shortOp.getLosers().size());
            int current = 0;
            for (String ln : this.shortOp.getLosers().keySet()) {
                if (random == current) {
                    return CampaignMain.cm.getPlayer(ln);
                }
                ++current;
            }
            return null;
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return null;
        }
    }

    private String newPilotDescription(SUnit u) {
        String result = " ";
        try {
            result = u.getPilot().getName() + " ";
            result = u.getType() == 0 || u.getType() == 1 || u.getType() == 5 ? "[" + u.getPilot().getGunnery() + "/" + u.getPilot().getPiloting() : (u.getType() == 2 || u.getType() == 4 ? (((Infantry)u.getEntity()).isAntiMek() ? "[" + u.getPilot().getGunnery() + "/" + u.getPilot().getPiloting() : u.getModelName() + " [" + u.getPilot().getGunnery()) : u.getModelName() + " [" + u.getPilot().getGunnery());
            if (!u.getPilot().getSkillString(true).equals(" ")) {
                result = result + u.getPilot().getSkillString(true);
            }
            result = result + "]";
            return result;
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return result;
        }
    }

    private void contractFinishedInfo(SPlayer player) {
        if (!player.getMyHouse().isMercHouse()) {
            return;
        }
        ContractInfo contract = ((MercHouse)player.getMyHouse()).getContractInfo(player);
        if (contract == null) {
            return;
        }
        int duration = contract.getContractDuration();
        if (duration <= contract.getEarnedAmount()) {
            int payoff = contract.getPayment() / 2;
            player.addMoney(payoff);
            CampaignMain.cm.toUser("You completed your contract with " + contract.getEmployingHouse().getName() + " and received the final payment (" + CampaignMain.cm.moneyOrFluMessage(true, true, payoff, false) + ").", player.getName(), true);
            CampaignMain.cm.toUser(player.getName() + " completed his contract and received his final payment.", contract.getOfferingPlayerName(), true);
            ((MercHouse)player.getMyHouse()).endContract(player);
        }
    }

    private boolean attackerisWinner(ShortOperation so) {
        try {
            for (String player : so.getAttackers().keySet()) {
                if (!so.getWinners().containsKey(player)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return false;
        }
    }

    private String calculatePilotEXP(Operation o, ShortOperation so, OperationEntity currEntity, SPlayer owner, boolean allowLevelUp) {
        boolean countKills;
        StringBuffer append = new StringBuffer("");
        String ownerName = owner.getName().toLowerCase();
        SUnit currU = owner.getUnit(currEntity.getID());
        int unitXP = o.getIntValue("BaseUnitXP");
        int totalUnitsAsjusment = o.getIntValue("UnitXPUnitsAdjustment");
        int totalBVAdjustment = o.getIntValue("UnitXPBVAdjustment");
        if (totalUnitsAsjusment > 0) {
            unitXP = (int)((double)unitXP + Math.floor(so.getStartingUnits() / totalUnitsAsjusment));
        }
        if (totalBVAdjustment > 0) {
            unitXP = (int)((double)unitXP + Math.floor(so.getStartingBV() / totalBVAdjustment));
        }
        int winnerXP = o.getIntValue("WinnerBonusUnitXP");
        int defenderXP = o.getIntValue("DefenderBonusUnitXP");
        int flatKillXP = o.getIntValue("KillBonusUnitXP");
        int totalXPforUnit = unitXP;
        if (so.getWinners().containsKey(ownerName)) {
            totalXPforUnit += winnerXP;
        }
        if (so.getDefenders().containsKey(ownerName)) {
            totalXPforUnit += defenderXP;
        }
        int realKills = 0;
        boolean bl = countKills = !o.getBooleanValue("NoStatisticsMode");
        if (currEntity.getKills().size() > 0 && countKills) {
            for (Integer id : currEntity.getKills()) {
                SUnit killedUnit;
                OperationEntity killed = this.salvagableUnits.get(id);
                if (killed == null) {
                    killed = this.destroyedUnits.get(id);
                }
                if (killed == null || (killedUnit = currEntity.getOwner().getUnit(currEntity.getID())) == null || so.getWinners().containsKey(ownerName) && so.getWinners().containsKey(killed.getOwnerName().toLowerCase()) || so.getLosers().containsKey(ownerName) && so.getLosers().containsKey(killed.getOwnerName().toLowerCase()) && !this.drawGame && !this.freeForAll) continue;
                totalXPforUnit += flatKillXP;
                int bvForBonusXP = o.getIntValue("KillBonusXPforBV");
                if (bvForBonusXP > 0) {
                    totalXPforUnit = (int)((double)totalXPforUnit + Math.floor(killedUnit.getBV() / bvForBonusXP));
                }
                if (CampaignMain.cm.isKeepingUnitHistory()) {
                    String model = killedUnit.getModelName();
                    String insertString = "Killed " + model;
                    int unitID = currU.getDBId();
                    int pilotID = ((SPilot)currU.getPilot()).getDBId();
                    CampaignMain.cm.MySQL.addHistoryEntry(1, unitID, 15, insertString);
                    CampaignMain.cm.MySQL.addHistoryEntry(2, pilotID, 23, insertString);
                }
                ++realKills;
            }
            currU.getPilot().addKill(realKills);
        }
        boolean housePilotGetsXP = o.getBooleanValue("HousePilotsGainXP");
        boolean solPilotGetsXP = o.getBooleanValue("SOLPilotsGainXP");
        if (owner.getMyHouse().isNewbieHouse() && !solPilotGetsXP) {
            totalXPforUnit = 0;
        }
        if (!owner.getMyHouse().isNewbieHouse() && !housePilotGetsXP) {
            totalXPforUnit = 0;
        }
        if (totalXPforUnit < 0) {
            totalXPforUnit = 0;
        }
        if (currU.getPilot().getSkills().has(17)) {
            totalXPforUnit = (int)((double)totalXPforUnit * 1.05);
        }
        currU.getPilot().setExperience(currU.getPilot().getExperience() + totalXPforUnit);
        if ((so.getWinners().containsKey(ownerName) || CampaignMain.cm.getBooleanConfig("LosingPilotsCheckToLevel")) && allowLevelUp) {
            boolean solPilotCanLevel = o.getBooleanValue("SOLPilotsCheckLevelUp");
            boolean housePilotCanLevel = o.getBooleanValue("HousePilotsCheckLevelUp");
            if (owner.getMyHouse().isNewbieHouse() && solPilotCanLevel || !owner.getMyHouse().isNewbieHouse() && housePilotCanLevel) {
                append.append(((SPilot)currU.getPilot()).checkForPilotSkillImprovement(currU, owner));
            }
        }
        if (append.toString().trim().equals("")) {
            append.append(". " + currU.getPilot().getName() + " gained " + totalXPforUnit + " XP");
        }
        if (realKills == 1) {
            append.append(". Earned 1 kill");
        } else if (realKills > 1) {
            append.append(". Earned " + realKills + " kills");
        }
        return append.toString();
    }

    private void processCapturedUnits(ShortOperation so) {
        block10: {
            SPlayer attacker;
            block9: {
                if (so.preCapturedUnits.size() < 1) {
                    return;
                }
                attacker = CampaignMain.cm.getPlayer(so.getAttackers().firstKey());
                SPlayer defender = CampaignMain.cm.getPlayer(so.getDefenders().firstKey());
                if (this.attackerisWinner(so)) break block9;
                StringBuilder results = new StringBuilder("You managed to recover the following ");
                StringBuilder unitList = new StringBuilder();
                int savedUnitCount = 0;
                for (SUnit unit : so.preCapturedUnits) {
                    if (attacker.getUnit(unit.getId()) != null) {
                        attacker.removeUnit(unit.getId(), false);
                        unitList.append(unit.getModelName());
                        unitList.append(", ");
                        ++savedUnitCount;
                        defender.getHouseFightingFor().addUnit(unit, true);
                        continue;
                    }
                    if (defender.getUnit(unit.getId()) == null) continue;
                    defender.removeUnit(unit.getId(), false);
                    unitList.append(unit.getModelName());
                    unitList.append(", ");
                    ++savedUnitCount;
                    defender.getHouseFightingFor().addUnit(unit, true);
                }
                so.preCapturedUnits.clear();
                if (savedUnitCount == 0) {
                    for (String player : so.getDefenders().keySet()) {
                        CampaignMain.cm.toUser("You did not manage to recover any of the stolen units!", player);
                    }
                }
                if (savedUnitCount > 1) {
                    results.append("units ");
                } else {
                    results.append("unit ");
                }
                unitList.replace(unitList.length() - 2, unitList.length(), ".");
                results.append(unitList.toString());
                if (savedUnitCount <= 0) break block10;
                for (String player : so.getDefenders().keySet()) {
                    CampaignMain.cm.toUser(results.toString(), player);
                }
                break block10;
            }
            for (SUnit unit : so.preCapturedUnits) {
                if (attacker.getUnit(unit.getId()) == null) continue;
                SPilot pilot = new SPilot("Vacant", 99, 99);
                unit.setPilot(pilot);
            }
        }
    }

    private void removePreCaptured(ShortOperation so, int unitId) {
        for (int pos = 0; pos < so.preCapturedUnits.size(); ++pos) {
            if (so.preCapturedUnits.elementAt(pos).getId() != unitId) continue;
            SPilot pilot = new SPilot("Vacant", 99, 99);
            so.preCapturedUnits.elementAt(pos).setPilot(pilot);
            so.preCapturedUnits.removeElementAt(pos);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repodUnits(ShortOperation so, Operation o) {
        String repodModel = o.getValue("RepodOmniUnitsToBase");
        if (repodModel.trim().length() < 1) {
            return;
        }
        for (String player : so.getAllPlayersAndArmies().keySet()) {
            SPlayer currp = CampaignMain.cm.getPlayer(player);
            if (currp == null) continue;
            SArmy curra = currp.getArmy(so.getAllPlayersAndArmies().get(player));
            try {
                Enumeration<Unit> units = curra.getUnits().elements();
                while (units.hasMoreElements()) {
                    SUnit unit = (SUnit)units.nextElement();
                    Entity en = unit.getEntity();
                    if (!en.isOmni() || unit.getModelName().equalsIgnoreCase(repodModel)) continue;
                    String repodChassie = en.getChassis();
                    Vector<String> tables = new Vector<String>(1, 1);
                    String buildFile = "";
                    String timeZone = currp.getMyHouse().getConfig("RewardsRepodFolder");
                    String repodFileName = "";
                    for (House house : CampaignMain.cm.getData().getAllHouses()) {
                        SHouse faction = (SHouse)house;
                        buildFile = BuildTable.getFileName(faction.getName(), Unit.getWeightClassDesc(unit.getWeightclass()), timeZone, unit.getType());
                        if (!tables.contains(buildFile)) {
                            tables.add(buildFile);
                        }
                        if (!tables.contains(buildFile = BuildTable.getFileName("Common", Unit.getWeightClassDesc(unit.getWeightclass()), timeZone, unit.getType()))) {
                            tables.add(buildFile);
                        }
                        timeZone = currp.getMyHouse().getConfig("NoFactoryRepodFolder");
                        buildFile = BuildTable.getFileName(faction.getName(), Unit.getWeightClassDesc(unit.getWeightclass()), timeZone, unit.getType());
                        if (tables.contains(buildFile)) continue;
                        tables.add(buildFile);
                    }
                    block11: for (String buildTable : tables) {
                        try {
                            FileInputStream fis = new FileInputStream(buildTable);
                            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                            while (dis.ready()) {
                                String model;
                                String l = dis.readLine();
                                StringTokenizer ST = new StringTokenizer(l);
                                if (!ST.hasMoreElements()) continue;
                                ST.nextElement();
                                String unitFile = "";
                                while (ST.hasMoreElements()) {
                                    unitFile = unitFile + (String)ST.nextElement();
                                    if (!ST.hasMoreElements()) continue;
                                    unitFile = unitFile + " ";
                                }
                                if (!unitFile.toLowerCase().startsWith(repodChassie.toLowerCase())) continue;
                                SUnit cm = new SUnit(unit.getId(), unit.getProducer(), unitFile);
                                Entity cme = cm.getEntity();
                                String chassis = cme.getChassis();
                                if (!cm.isOmni() || !chassis.equalsIgnoreCase(repodChassie) || !(model = cm.getModelName()).equalsIgnoreCase(repodModel)) continue;
                                repodFileName = unitFile;
                                break block11;
                            }
                            dis.close();
                            fis.close();
                        }
                        catch (FileNotFoundException ex) {
                            CampaignData.mwlog.mainLog("File " + buildTable + " was not Found");
                        }
                        catch (IOException ex) {
                            CampaignData.mwlog.mainLog("File " + buildTable + " had an I/O error");
                        }
                        catch (Exception ex) {
                            CampaignData.mwlog.errLog(ex);
                            CampaignData.mwlog.mainLog("File " + buildTable + " has a problem");
                        }
                    }
                    if (repodFileName.trim().length() <= 0) continue;
                    SUnit cm = new SUnit(unit.getId(), unit.getProducer(), repodFileName);
                    cm.setPilot((SPilot)unit.getPilot());
                    cm.setExperience(unit.getExperience());
                    if (cm.getType() == 0) {
                        ((Mech)cm.getEntity()).setAutoEject(((Mech)en).isAutoEject());
                    }
                    if (UnitUtils.hasTargettingComputer(cm.getEntity())) {
                        cm.getEntity().setTargSysType(1);
                    } else {
                        cm.getEntity().setTargSysType(en.getTargetType());
                    }
                    cm.getEntity().setSpotlight(en.hasSpotlight());
                    cm.getEntity().setSpotlightState(en.isUsingSpotlight());
                    cm.setWeightclass(unit.getWeightclass());
                    cm.setType(unit.getType());
                    currp.removeUnit(unit.getId(), false);
                    currp.addUnit(cm, true);
                    curra.addUnit(cm);
                    CampaignMain.cm.toUser("Your " + unit.getVerboseModelName() + "#" + unit.getId() + " is now " + StringUtils.aOrAn(cm.getVerboseModelName(), true) + ".", currp.getName(), true);
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
    }
}

