/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.operations;

import common.CampaignData;
import common.House;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import megamek.common.BattleArmor;
import megamek.common.Protomech;
import server.campaign.CampaignMain;
import server.campaign.NewbieHouse;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;
import server.campaign.operations.ShortOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortValidator {
    private OperationManager manager;
    public static final int SFAIL_COMMON_PROTOGROUPS = 1;
    public static final int SFAIL_COMMON_ELODIFFERENCE = 2;
    public static final int SFAIL_COMMON_TEAM_BV_EXCEEDED = 3;
    public static final int SFAIL_COMMON_NOT_ENOUGH_COMMANDERS = 4;
    public static final int SFAIL_COMMON_TOO_MANY_COMMANDERS = 5;
    public static final int SFAIL_COMMON_INSUFFICENT_SUBFACTION_ACCESS_LEVEL = 6;
    public static final int SFAIL_COMMON_MAX_BV_DIFFERENCE = 7;
    public static final int SFAIL_COMMON_INFACTION_ATTACK = 8;
    public static final int SFAIL_ATTACK_MAXBV = 200;
    public static final int SFAIL_ATTACK_MINBV = 201;
    public static final int SFAIL_ATTACK_MAXMEKS = 202;
    public static final int SFAIL_ATTACK_MINMEKS = 203;
    public static final int SFAIL_ATTACK_MINSPEED = 204;
    public static final int SFAIL_ATTACK_MAXUNITTON = 205;
    public static final int SFAIL_ATTACK_MINUNITTON = 206;
    public static final int SFAIL_ATTACK_NOMEKS = 207;
    public static final int SFAIL_ATTACK_NOVEHS = 208;
    public static final int SFAIL_ATTACK_NOINF = 209;
    public static final int SFAIL_ATTACK_NONORMINF = 210;
    public static final int SFAIL_ATTACK_MAXARMYTON = 211;
    public static final int SFAIL_ATTACK_MINARMYTON = 212;
    public static final int SFAIL_ATTACK_MONEY = 213;
    public static final int SFAIL_ATTACK_INFLUENCE = 214;
    public static final int SFAIL_ATTACK_REWARD = 215;
    public static final int SFAIL_ATTACK_MAXRATING = 216;
    public static final int SFAIL_ATTACK_MINRATING = 217;
    public static final int SFAIL_ATTACK_MAXXP = 218;
    public static final int SFAIL_ATTACK_MINXP = 219;
    public static final int SFAIL_ATTACK_MAXGAMES = 220;
    public static final int SFAIL_ATTACK_MINGAMES = 221;
    public static final int SFAIL_ATTACK_OUTOFRANGE = 222;
    public static final int SFAIL_ATTACK_NOOPPONENT = 223;
    public static final int SFAIL_ATTACK_NOPLANDEF = 224;
    public static final int SFAIL_ATTACK_NOTYPEDEF = 225;
    public static final int SFAIL_ATTACK_SOLCANTATT = 226;
    public static final int SFAIL_ATTACK_NON_CONQ_A = 227;
    public static final int SFAIL_ATTACK_NEEDSFAC = 228;
    public static final int SFAIL_ATTACK_HASFAC = 229;
    public static final int SFAIL_ATTACK_MINUNITBV = 230;
    public static final int SFAIL_ATTACK_MAXUNITBV = 231;
    public static final int SFAIL_ATTACK_MAXSPREAD = 232;
    public static final int SFAIL_ATTACK_MINSPREAD = 233;
    public static final int SFAIL_ATTACK_FACTION = 234;
    public static final int SFAIL_ATTACK_MINOWNERSHIP = 235;
    public static final int SFAIL_ATTACK_MAXOWNERSHIP = 236;
    public static final int SFAIL_ATTACK_NEEDSHOME = 237;
    public static final int SFAIL_ATTACK_HASHOME = 238;
    public static final int SFAIL_ATTACK_MAXVEHICLES = 239;
    public static final int SFAIL_ATTACK_MINVEHICLES = 240;
    public static final int SFAIL_ATTACK_MAXINFANTRY = 241;
    public static final int SFAIL_ATTACK_MININFANTRY = 242;
    public static final int SFAIL_ATTACK_OMNIONLY = 243;
    public static final int SFAIL_ATTACK_OPFLAGS = 244;
    public static final int SFAIL_ATTACK_DOPFLAGS = 245;
    public static final int SFAIL_ATTACK_NOPOWERINF = 246;
    public static final int SFAIL_ATTACK_NOCOUNTERS = 247;
    public static final int SFAIL_ATTACK_AFRONLY = 248;
    public static final int SFAIL_ATTACK_ACTIVEONLY = 249;
    public static final int SFAIL_ATTACK_MAXNONINFANTRY = 250;
    public static final int SFAIL_ATTACK_MINNONINFANTRY = 251;
    public static final int SFAIL_ATTACK_ELITE_PILOTS = 252;
    public static final int SFAIL_ATTACK_GREEN_PILOTS = 253;
    public static final int SFAIL_ATTACK_MAX_AERO = 254;
    public static final int SFAIL_ATTACK_MIN_AERO = 255;
    public static final int SFAIL_ATTACK_NOAEROS = 256;
    public static final int SFAIL_DEFEND_MAXBV = 400;
    public static final int SFAIL_DEFEND_MINBV = 401;
    public static final int SFAIL_DEFEND_MAXMEKS = 402;
    public static final int SFAIL_DEFEND_MINMEKS = 403;
    public static final int SFAIL_DEFEND_MINSPEED = 404;
    public static final int SFAIL_DEFEND_MAXUNITTON = 405;
    public static final int SFAIL_DEFEND_MINUNITTON = 406;
    public static final int SFAIL_DEFEND_NOMEKS = 407;
    public static final int SFAIL_DEFEND_NOVEHS = 408;
    public static final int SFAIL_DEFEND_NOINF = 409;
    public static final int SFAIL_DEFEND_NONORMINF = 410;
    public static final int SFAIL_DEFEND_MAXARMYTON = 411;
    public static final int SFAIL_DEFEND_MINARMYTON = 412;
    public static final int SFAIL_DEFEND_MONEY = 413;
    public static final int SFAIL_DEFEND_INFLUENCE = 414;
    public static final int SFAIL_DEFEND_REWARD = 415;
    public static final int SFAIL_DEFEND_MAXRATING = 416;
    public static final int SFAIL_DEFEND_MINRATING = 417;
    public static final int SFAIL_DEFEND_MAXXP = 418;
    public static final int SFAIL_DEFEND_MINXP = 419;
    public static final int SFAIL_DEFEND_MAXGAMES = 420;
    public static final int SFAIL_DEFEND_MINGAMES = 421;
    public static final int SFAIL_DEFEND_NOTPLANDEF = 424;
    public static final int SFAIL_DEFEND_SOLCANTDEF = 426;
    public static final int SFAIL_DEFEND_NON_CONQ_D = 427;
    public static final int SFAIL_DEFEND_MINUNITBV = 430;
    public static final int SFAIL_DEFEND_MAXUNITBV = 431;
    public static final int SFAIL_DEFEND_MAXSPREAD = 432;
    public static final int SFAIL_DEFEND_MINSPREAD = 433;
    public static final int SFAIL_DEFEND_FACTION = 434;
    public static final int SFAIL_DEFEND_MAXVEHICLES = 439;
    public static final int SFAIL_DEFEND_MINVEHICLES = 440;
    public static final int SFAIL_DEFEND_MAXINFANTRY = 441;
    public static final int SFAIL_DEFEND_MININFANTRY = 442;
    public static final int SFAIL_DEFEND_OMNIONLY = 443;
    public static final int SFAIL_DEFEND_NOPOWERINF = 446;
    public static final int SFAIL_DEFEND_MAXNONINFANTRY = 450;
    public static final int SFAIL_DEFEND_MINNONINFANTRY = 451;
    public static final int SFAIL_DEFEND_NON_CONQ_PLANET = 452;
    public static final int SFAIL_DEFEND_ELITE_PILOTS = 453;
    public static final int SFAIL_DEFEND_GREEN_PILOTS = 454;
    public static final int SFAIL_DEFEND_MAX_AERO = 455;
    public static final int SFAIL_DEFEND_MIN_AERO = 456;
    public static final int SFAIL_DEFEND_NOAEROS = 457;

    public ShortValidator(OperationManager m) {
        this.manager = m;
    }

    public ArrayList<Integer> validateShortAttacker(SPlayer ap, SArmy aa, Operation o, SPlanet target, int longID, boolean joiningAttack) {
        ArrayList<Integer> failureReasons = new ArrayList<Integer>();
        if (target == null) {
            this.checkAttackerMilestones(failureReasons, ap, o);
            this.checkAttackerConstruction(failureReasons, aa, o);
        } else {
            this.checkAttackerRange(failureReasons, ap, o, target);
            this.checkAttackerMilestones(failureReasons, ap, o);
            this.checkAttackerCosts(failureReasons, ap, o);
            this.checkAttackerConstruction(failureReasons, aa, o);
            if (failureReasons.size() > 0) {
                return failureReasons;
            }
            if (aa.getOpponents() == null || aa.getOpponents().size() == 0 && !o.getBooleanValue("AttackerAllowAgainstUnclaimedLand")) {
                failureReasons.add(223);
                return failureReasons;
            }
            ArrayList<SArmy> planetMatches = new ArrayList<SArmy>();
            ArrayList<SArmy> fullMatches = new ArrayList<SArmy>();
            for (SArmy currArmy : aa.getOpponents()) {
                SPlayer currPlayer = CampaignMain.cm.getPlayer(currArmy.getPlayerName());
                if (currPlayer == null) continue;
                SHouse currHouse = currPlayer.getHouseFightingFor();
                if (!o.getBooleanValue("FreeForAllOperation") && target.getInfluence().getInfluence(currHouse.getId()) <= 0) continue;
                planetMatches.add(currArmy);
            }
            if (o.getBooleanValue("AttackerAllowAgainstUnclaimedLand") && target.getInfluence().getInfluence(-1) > 0) {
                int freeShortID = this.manager.getFreeShortID();
                ShortOperation newOp = new ShortOperation(o.getName(), target, ap, aa, fullMatches, freeShortID, longID, false);
                this.manager.addShortOperation(newOp, ap, o);
                newOp.changeStatus(ShortOperation.STATUS_INPROGRESS);
                newOp.changeStatus(ShortOperation.STATUS_REPORTING);
                int conquestCap = o.getIntValue("ConquestAmountCap");
                int totalConquest = o.getIntValue("AttackerBaseConquestAmount");
                int conquestUnitAdjust = o.getIntValue("AttackerConquestUnitAdjustment");
                int conquestBVAdjust = o.getIntValue("AttackerConquestBVAdjustment");
                if (conquestUnitAdjust > 0) {
                    totalConquest = (int)((double)totalConquest + Math.floor(newOp.getStartingUnits() / conquestUnitAdjust));
                }
                if (conquestBVAdjust > 0) {
                    totalConquest = (int)((double)totalConquest + Math.floor(newOp.getStartingBV() / conquestBVAdjust));
                }
                if (totalConquest > conquestCap) {
                    totalConquest = conquestCap;
                }
                if ((totalConquest = newOp.getTargetWorld().doGainInfluence(ap.getHouseFightingFor(), CampaignMain.cm.getHouseById(-1), totalConquest, false)) > 0) {
                    String newsFeedBody;
                    String newsFeedTitle;
                    String point = "points";
                    if (totalConquest == 1) {
                        point = "point";
                    }
                    String winnerMetaString = " gained " + totalConquest + " " + point + " of " + newOp.getTargetWorld().getNameAsColoredLink();
                    newOp.checkMercContracts(ap, 1, totalConquest);
                    CampaignMain.cm.toUser("You've" + winnerMetaString, ap.getName());
                    for (House house : newOp.getTargetWorld().getInfluence().getHouses()) {
                        SHouse h = (SHouse)house;
                        if (h.equals(ap.getHouseFightingFor())) continue;
                        CampaignMain.cm.doSendToAllOnlinePlayers(h, ap.getName() + winnerMetaString, true);
                    }
                    if (!CampaignMain.cm.getBooleanConfig("ShowCompleteGameInfoInNews")) {
                        newsFeedTitle = ap.getHouseFightingFor().getColoredNameAsLink() + " gained land on " + newOp.getTargetWorld().getName();
                        newsFeedBody = ap.getHouseFightingFor().getColoredNameAsLink() + " gained " + totalConquest + "cp on " + newOp.getTargetWorld().getName();
                    } else {
                        newsFeedTitle = ap.getName() + " gained land on " + newOp.getTargetWorld().getName();
                        newsFeedBody = ap.getName() + " gained " + totalConquest + "cp on " + newOp.getTargetWorld().getName();
                    }
                    if (o.getBooleanValue("ReportOpToNewsFeed")) {
                        CampaignMain.cm.addToNewsFeed(newsFeedTitle, newsFeedBody);
                    }
                    newOp.setCompleteFinishedInfo(ap.getName() + " gained " + totalConquest + "cp on " + newOp.getTargetWorld().getName());
                    newOp.setIncompleteFinishedInfo(ap.getHouseFightingFor().getColoredNameAsLink() + " gained " + totalConquest + "cp on " + newOp.getTargetWorld().getName());
                }
                newOp.changeStatus(ShortOperation.STATUS_FINISHED);
                ap.lockArmy(-1);
                return failureReasons;
            }
            if (planetMatches.size() == 0) {
                failureReasons.add(224);
                return failureReasons;
            }
            int maxELO = o.getIntValue("MaxELODifference");
            for (SArmy currArmy : planetMatches) {
                SPlayer currPlayer = CampaignMain.cm.getPlayer(currArmy.getPlayerName());
                ArrayList<Integer> defenderFails = this.validateShortDefender(currPlayer, currArmy, o, target);
                if (maxELO > 0 && Math.abs(currPlayer.getRating() - ap.getRating()) > (double)maxELO) {
                    defenderFails.add(2);
                }
                if (!aa.matches(currArmy, o)) {
                    defenderFails.add(7);
                }
                if (currPlayer.getHouseFightingFor().equals(ap.getHouseFightingFor()) && !o.getBooleanValue("AllowInFaction")) {
                    defenderFails.add(8);
                }
                if (defenderFails.size() == 0) {
                    fullMatches.add(currArmy);
                    continue;
                }
                if (!o.getBooleanValue("DebugOp")) continue;
                CampaignData.mwlog.errLog("Failed Defense reasons for Op: " + o.getName() + " Launched by player: " + ap.getName() + " with army: #" + aa.getID());
                CampaignData.mwlog.errLog("Defending Player: " + currPlayer.getName() + " Army id: #" + currArmy.getID());
                Iterator<Integer> df = defenderFails.iterator();
                while (df.hasNext()) {
                    CampaignData.mwlog.errLog("Reason: " + this.decodeFailure(df.next()));
                }
            }
            if (fullMatches.size() == 0) {
                failureReasons.add(225);
                return failureReasons;
            }
            if (!joiningAttack) {
                int freeShortID = this.manager.getFreeShortID();
                ShortOperation newOp = new ShortOperation(o.getName(), target, ap, aa, fullMatches, freeShortID, longID, false);
                this.manager.addShortOperation(newOp, ap, o);
            }
        }
        return failureReasons;
    }

    public void checkAttackerRange(ArrayList<Integer> failureReasons, SPlayer ap, Operation o, SPlanet target) {
        int percToAttackOnWorld;
        StringTokenizer st;
        if (target.getOwner() != null && target.getOwner() instanceof NewbieHouse) {
            return;
        }
        if (o.getBooleanValue("ForbidCounterAttacks") && CampaignMain.cm.getOpsManager().playerHasActiveChickenThread(ap)) {
            failureReasons.add(247);
        }
        if (o.getBooleanValue("OnlyAllowedFromReserve") && ap.getDutyStatus() >= 3) {
            failureReasons.add(248);
        }
        if (o.getBooleanValue("OnlyAllowedFromActive") && ap.getDutyStatus() <= 2) {
            failureReasons.add(249);
        }
        int ahID = ap.getHouseFightingFor().getId();
        double percentOwned = 100.0 * ((double)target.getInfluence().getInfluence(ahID) / (double)target.getConquestPoints());
        if (percentOwned < (double)o.getIntValue("MinPlanetOwnership")) {
            failureReasons.add(235);
        }
        if (percentOwned > (double)o.getIntValue("MaxPlanetOwnership")) {
            failureReasons.add(236);
        }
        boolean mustHaveFac = o.getBooleanValue("OnlyAgainstFactoryWorlds");
        boolean mustNotHaveFac = o.getBooleanValue("OnlyAgainstNonFactoryWorlds");
        if (mustHaveFac && target.getFactoryCount() <= 0) {
            failureReasons.add(228);
        }
        if (mustNotHaveFac && target.getFactoryCount() > 0) {
            failureReasons.add(229);
        }
        boolean mustHaveHome = o.getBooleanValue("OnlyAgainstHomeWorlds");
        boolean mustNotHaveHome = o.getBooleanValue("OnlyAgainstNonHomeWorlds");
        if (mustHaveHome && !target.isHomeWorld()) {
            failureReasons.add(237);
        }
        if (mustNotHaveHome && target.isHomeWorld()) {
            failureReasons.add(238);
        }
        String allowPlanetFlags = o.getValue("AllowPlanetFlags");
        String disallowPlanetFlags = o.getValue("DisallowPlanetFlags");
        if (allowPlanetFlags.length() > 0) {
            st = new StringTokenizer(allowPlanetFlags, "^");
            while (st.hasMoreTokens()) {
                if (target.getPlanetFlags().containsKey(st.nextToken())) continue;
                failureReasons.add(244);
            }
        }
        if (disallowPlanetFlags.length() > 0) {
            st = new StringTokenizer(disallowPlanetFlags, "^");
            while (st.hasMoreTokens()) {
                if (!target.getPlanetFlags().containsKey(st.nextToken())) continue;
                failureReasons.add(244);
            }
        }
        if (percentOwned >= (double)(percToAttackOnWorld = o.getIntValue("PercentageToAttackOnWorld"))) {
            return;
        }
        double opRange = o.getDoubleValue("OperationRange");
        double percToAttackOffWorld = o.getDoubleValue("PercentageToAttackOffWorld");
        for (SPlanet sPlanet : CampaignMain.cm.getData().getAllPlanets()) {
            percentOwned = 100.0 * ((double)sPlanet.getInfluence().getInfluence(ahID) / (double)sPlanet.getConquestPoints());
            if (!(percentOwned >= percToAttackOffWorld) || !(sPlanet.getPosition().distanceSq(target.getPosition()) <= opRange)) continue;
            return;
        }
        failureReasons.add(222);
    }

    public void checkAttackerMilestones(ArrayList<Integer> failureReasons, SPlayer ap, Operation o) {
        boolean solCanAttack = o.getBooleanValue("AllowSOLToUse");
        boolean nonConqCanAttack = o.getBooleanValue("AllowNonConqToUse");
        if (ap.getHouseFightingFor().isNewbieHouse() && !solCanAttack) {
            failureReasons.add(226);
        }
        if (!ap.getHouseFightingFor().isConquerable() && !nonConqCanAttack) {
            failureReasons.add(227);
        }
        String allowed = o.getValue("LegalAttackFactions");
        String notAllowed = o.getValue("IllegalAttackFactions");
        if (allowed.trim().length() != 0 && allowed.indexOf(ap.getHouseFightingFor().getName()) == -1) {
            failureReasons.add(234);
        } else if (notAllowed.trim().length() != 0 && notAllowed.indexOf(ap.getHouseFightingFor().getName()) >= 0) {
            failureReasons.add(234);
        }
        if (ap.getRating() > o.getDoubleValue("MaxAttackerRating")) {
            failureReasons.add(216);
        }
        if (ap.getRating() < o.getDoubleValue("MinAttackerRating")) {
            failureReasons.add(217);
        }
        if (ap.getExperience() > o.getIntValue("MaxAttackerXP")) {
            failureReasons.add(218);
        }
        if (ap.getExperience() < o.getIntValue("MinAttackerXP")) {
            failureReasons.add(219);
        }
        if (ap.getSubFactionAccess() < o.getIntValue("MinSubFactionAccessLevel")) {
            failureReasons.add(6);
        }
    }

    public void checkAttackerCosts(ArrayList<Integer> failureReasons, SPlayer ap, Operation o) {
        if (ap.getMoney() < o.getIntValue("AttackerCostMoney")) {
            failureReasons.add(213);
        }
        if (ap.getInfluence() < o.getIntValue("AttackerCostInfluence")) {
            failureReasons.add(214);
        }
        if (ap.getReward() < o.getIntValue("AttackerCostReward")) {
            failureReasons.add(215);
        }
    }

    public void checkAttackerConstruction(ArrayList<Integer> failureReasons, SArmy aa, Operation o) {
        if (o.getBooleanValue("MULArmiesOnly")) {
            return;
        }
        if (aa.getBV() > o.getIntValue("MaxAttackerBV")) {
            failureReasons.add(new Integer(200));
        } else if (aa.getBV() < o.getIntValue("MinAttackerBV")) {
            failureReasons.add(new Integer(201));
        }
        if (aa.getNumberOfUnitTypes(0) > o.getIntValue("MaxAttackerMeks")) {
            failureReasons.add(new Integer(202));
        } else if (aa.getNumberOfUnitTypes(0) < o.getIntValue("MinAttackerMeks")) {
            failureReasons.add(new Integer(203));
        }
        if (aa.getNumberOfUnitTypes(1) > o.getIntValue("MaxAttackerVehicles")) {
            failureReasons.add(new Integer(239));
        } else if (aa.getNumberOfUnitTypes(1) < o.getIntValue("MinAttackerVehicles")) {
            failureReasons.add(new Integer(240));
        }
        if (aa.getNumberOfUnitTypes(5) > o.getIntValue("MaxAttackerAero")) {
            failureReasons.add(new Integer(254));
        } else if (aa.getNumberOfUnitTypes(5) < o.getIntValue("MinAttackerAero")) {
            failureReasons.add(new Integer(255));
        }
        int infCount = aa.getNumberOfUnitTypes(2);
        int protoCount = aa.getNumberOfUnitTypes(3);
        if (protoCount > 0) {
            infCount += Math.max(1, protoCount / 5);
        }
        if ((infCount += aa.getNumberOfUnitTypes(4)) > o.getIntValue("MaxAttackerInfantry")) {
            failureReasons.add(new Integer(241));
        } else if (infCount < o.getIntValue("MinAttackerInfantry")) {
            failureReasons.add(new Integer(242));
        }
        if (aa.getNumberOfUnitTypes(0) + aa.getNumberOfUnitTypes(1) + aa.getNumberOfUnitTypes(5) > o.getIntValue("MaxAttackerNonInfantry")) {
            failureReasons.add(new Integer(250));
        } else if (aa.getNumberOfUnitTypes(0) + aa.getNumberOfUnitTypes(1) + aa.getNumberOfUnitTypes(5) < o.getIntValue("MinAttackerNonInfantry")) {
            failureReasons.add(new Integer(251));
        }
        int totalWeight = 0;
        int largestWeight = 0;
        int numProtoMeks = aa.getNumberOfUnitTypes(3);
        int lowUnitBV = Integer.MAX_VALUE;
        int highUnitBV = Integer.MIN_VALUE;
        int numberOfCommanders = 0;
        boolean hasMeks = false;
        boolean hasVehs = false;
        boolean hasAeros = false;
        boolean hasInf = false;
        boolean normInf = false;
        boolean powerInf = false;
        boolean speedFail = false;
        boolean maxTonFail = false;
        boolean minTonFail = false;
        boolean maxBVFail = false;
        boolean minBVFail = false;
        boolean omniFail = false;
        boolean checkOmni = o.getBooleanValue("AttackerOmniMeksOnly");
        boolean vetPilots = false;
        boolean greenPilots = false;
        double averageArmySkills = 0.0;
        int numberOfValidUnits = 0;
        for (SUnit sUnit : aa.getUnits()) {
            int type;
            int currBV;
            numberOfCommanders = aa.getCommanders().size();
            int currWeight = (int)sUnit.getEntity().getWeight();
            totalWeight += currWeight;
            if (currWeight > largestWeight) {
                largestWeight = currWeight;
            }
            if (sUnit.getType() == 0) {
                hasMeks = true;
                if (checkOmni && !omniFail && !sUnit.isOmni()) {
                    omniFail = true;
                }
            } else if (sUnit.getType() == 1) {
                hasVehs = true;
            } else if (sUnit.getType() == 5) {
                hasAeros = true;
            } else if (sUnit.getType() == 2 || sUnit.getType() == 4 || sUnit.getType() == 3) {
                hasInf = true;
                if (sUnit.getEntity() instanceof BattleArmor || sUnit.getEntity() instanceof Protomech) {
                    powerInf = true;
                } else {
                    normInf = true;
                }
            }
            if (!speedFail) {
                try {
                    int walkMP = sUnit.getEntity().getWalkMP();
                    int jumpMP = sUnit.getEntity().getJumpMP();
                    if (walkMP < o.getIntValue("MinAttackerWalk") && jumpMP < o.getIntValue("MinAttackerJump")) {
                        speedFail = true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (sUnit.getType() == 0 || sUnit.getType() == 1 || sUnit.getType() == 5) {
                if (currWeight > o.getIntValue("MaxAttackerUnitTonnage")) {
                    maxTonFail = true;
                } else if (currWeight < o.getIntValue("MinAttackerUnitTonnage")) {
                    minTonFail = true;
                }
            }
            if ((currBV = sUnit.getBV()) < o.getIntValue("MinAttackerUnitBV")) {
                minBVFail = true;
            } else if (currBV > o.getIntValue("MaxAttackerUnitBV")) {
                maxBVFail = true;
            }
            if ((type = sUnit.getType()) == 1 && !o.getBooleanValue("CountVehsForSpread") || type == 3 && !o.getBooleanValue("CountProtosForSpread") || (type == 4 || type == 2) && !o.getBooleanValue("CountInfForSpread") || type == 5 && !o.getBooleanValue("CountAerosForSpread")) continue;
            if (!sUnit.hasVacantPilot()) {
                int piloting = sUnit.getPilot().getPiloting();
                int gunnery = sUnit.getPilot().getGunnery();
                int totalSkills = gunnery + piloting;
                averageArmySkills += (double)totalSkills;
                ++numberOfValidUnits;
                if (piloting > o.getIntValue("HighestAttackerPiloting")) {
                    greenPilots = true;
                }
                if (piloting < o.getIntValue("LowestAttackerPiloting")) {
                    vetPilots = true;
                }
                if (gunnery > o.getIntValue("HighestAttackerGunnery")) {
                    greenPilots = true;
                }
                if (gunnery < o.getIntValue("LowestAttackerGunnery")) {
                    vetPilots = true;
                }
                if (totalSkills > o.getIntValue("HighestAttackerPilotSkillTotal")) {
                    greenPilots = true;
                }
                if (totalSkills < o.getIntValue("LowestAttackerPilotSkillTotal")) {
                    vetPilots = true;
                }
            }
            lowUnitBV = Math.min(lowUnitBV, currBV);
            highUnitBV = Math.max(highUnitBV, currBV);
        }
        if (hasMeks && !o.getBooleanValue("AttackerAllowedMeks")) {
            failureReasons.add(new Integer(207));
        }
        if (hasVehs && !o.getBooleanValue("AttackerAllowedVehs")) {
            failureReasons.add(new Integer(208));
        }
        if (hasAeros && !o.getBooleanValue("AttackerAllowedAeros")) {
            failureReasons.add(new Integer(256));
        }
        if (hasInf && !o.getBooleanValue("AttackerAllowedInf")) {
            if (o.getBooleanValue("AttackerPoweredInfAllowed") && normInf) {
                failureReasons.add(new Integer(210));
            } else if (o.getBooleanValue("AttackerStandardInfAllowed") && powerInf) {
                failureReasons.add(new Integer(246));
            } else if (!normInf && !powerInf) {
                failureReasons.add(new Integer(209));
            }
        }
        if (o.getBooleanValue("UseUnitCommander")) {
            if (numberOfCommanders < o.getIntValue("MinimumUnitCommanders")) {
                failureReasons.add(4);
            }
            if (numberOfCommanders > o.getIntValue("MaximumUnitCommanders")) {
                failureReasons.add(5);
            }
        }
        if (checkOmni && omniFail) {
            failureReasons.add(new Integer(243));
        }
        if (o.getBooleanValue("ProtosMustbeGrouped") && numProtoMeks > 0 && numProtoMeks % 5 != 0) {
            failureReasons.add(new Integer(1));
        }
        if (speedFail) {
            failureReasons.add(new Integer(204));
        }
        if (maxTonFail) {
            failureReasons.add(new Integer(205));
        }
        if (minTonFail) {
            failureReasons.add(new Integer(206));
        }
        if (maxBVFail) {
            failureReasons.add(new Integer(231));
        }
        if (minBVFail) {
            failureReasons.add(new Integer(230));
        }
        if (totalWeight > o.getIntValue("MaxTotalAttackerTonnage")) {
            failureReasons.add(new Integer(211));
        } else if (totalWeight < o.getIntValue("MinTotalAttackerTonnage")) {
            failureReasons.add(new Integer(212));
        }
        int n = o.getIntValue("MaxAttackerUnitBVSpread");
        int minAllowedSpread = o.getIntValue("MinAttackerUnitBVSpread");
        if (n > 0 && highUnitBV - lowUnitBV > n) {
            failureReasons.add(232);
        }
        if (minAllowedSpread > 0 && highUnitBV - lowUnitBV < minAllowedSpread) {
            failureReasons.add(233);
        }
        averageArmySkills /= (double)numberOfValidUnits;
        if (vetPilots || averageArmySkills > o.getDoubleValue("AttackerAverageArmySkillMax")) {
            failureReasons.add(252);
        }
        if (greenPilots || averageArmySkills < o.getDoubleValue("AttackerAverageArmySkillMin")) {
            failureReasons.add(253);
        }
    }

    public ArrayList<Integer> validateShortDefender(SPlayer dp, SArmy da, Operation o, SPlanet target) {
        ArrayList<Integer> failureReasons = new ArrayList<Integer>();
        this.checkDefenderMilestones(failureReasons, dp, o, target);
        this.checkDefenderCosts(failureReasons, dp, o);
        this.checkDefenderConstruction(failureReasons, da, o);
        return failureReasons;
    }

    private void checkDefenderMilestones(ArrayList<Integer> failureReasons, SPlayer dp, Operation o, SPlanet target) {
        boolean solCanDefend = o.getBooleanValue("AllowAgainstSOL");
        boolean nonConqCanDefend = o.getBooleanValue("AllowAgainstNonConq");
        double percentOwned = 0.0;
        percentOwned = target != null ? 100.0 * ((double)target.getInfluence().getInfluence(dp.getHouseFightingFor().getId()) / (double)target.getConquestPoints()) : 0.0;
        if (target != null && percentOwned < (double)o.getIntValue("MinPlanetOwnership")) {
            failureReasons.add(424);
        }
        if (dp.getHouseFightingFor().isNewbieHouse() && !solCanDefend) {
            failureReasons.add(426);
        }
        if (!dp.getHouseFightingFor().isConquerable() && !nonConqCanDefend) {
            failureReasons.add(427);
        }
        if (!(o.getIntValue("AttackerBaseConquestAmount") <= 0 && o.getIntValue("AttackerConquestBVAdjustment") <= 0 && o.getIntValue("AttackerConquestUnitAdjustment") <= 0 && o.getIntValue("DefenderBaseConquestAmount") <= 0 && o.getIntValue("DefenderConquestBVAdjustment") <= 0 && o.getIntValue("DefenderConquestUnitAdjustment") <= 0 || target == null || target.isConquerable())) {
            failureReasons.add(452);
        }
        String allowed = o.getValue("LegalDefendFactions");
        String notAllowed = o.getValue("IllegalDefendFactions");
        if (allowed.trim().length() != 0 && allowed.indexOf(dp.getHouseFightingFor().getName()) == -1) {
            failureReasons.add(434);
        } else if (notAllowed.trim().length() != 0 && notAllowed.indexOf(dp.getHouseFightingFor().getName()) >= 0) {
            failureReasons.add(434);
        }
        if (dp.getRating() > o.getDoubleValue("MaxDefenderRating")) {
            failureReasons.add(416);
        }
        if (dp.getRating() < o.getDoubleValue("MinDefenderRating")) {
            failureReasons.add(417);
        }
        if (dp.getExperience() > o.getIntValue("MaxDefenderXP")) {
            failureReasons.add(418);
        }
        if (dp.getExperience() < o.getIntValue("MinDefenderXP")) {
            failureReasons.add(419);
        }
        if (dp.getSubFactionAccess() < o.getIntValue("MinSubFactionAccessLevel")) {
            failureReasons.add(6);
        }
    }

    private void checkDefenderCosts(ArrayList<Integer> failureReasons, SPlayer dp, Operation o) {
        if (dp.getMoney() < o.getIntValue("DefenderCostMoney")) {
            failureReasons.add(413);
        }
        if (dp.getInfluence() < o.getIntValue("DefenderCostInfluence")) {
            failureReasons.add(414);
        }
        if (dp.getReward() < o.getIntValue("DefenderCostReward")) {
            failureReasons.add(415);
        }
    }

    private void checkDefenderConstruction(ArrayList<Integer> failureReasons, SArmy da, Operation o) {
        if (o.getBooleanValue("MULArmiesOnly")) {
            return;
        }
        if (da.getBV() > o.getIntValue("MaxDefenderBV")) {
            failureReasons.add(new Integer(400));
        } else if (da.getBV() < o.getIntValue("MinDefenderBV")) {
            failureReasons.add(new Integer(401));
        }
        if (da.getNumberOfUnitTypes(0) > o.getIntValue("MaxDefenderMeks")) {
            failureReasons.add(new Integer(402));
        } else if (da.getNumberOfUnitTypes(0) < o.getIntValue("MinDefenderMeks")) {
            failureReasons.add(new Integer(403));
        }
        if (da.getNumberOfUnitTypes(1) > o.getIntValue("MaxDefenderVehicles")) {
            failureReasons.add(new Integer(439));
        } else if (da.getNumberOfUnitTypes(1) < o.getIntValue("MinDefenderVehicles")) {
            failureReasons.add(new Integer(440));
        }
        if (da.getNumberOfUnitTypes(5) > o.getIntValue("MaxDefenderAero")) {
            failureReasons.add(new Integer(455));
        } else if (da.getNumberOfUnitTypes(5) < o.getIntValue("MinDefenderAero")) {
            failureReasons.add(new Integer(456));
        }
        int infCount = da.getNumberOfUnitTypes(2);
        infCount += da.getNumberOfUnitTypes(4);
        int protoCount = da.getNumberOfUnitTypes(3);
        if (protoCount > 0) {
            infCount += Math.max(1, protoCount / 5);
        }
        if (infCount > o.getIntValue("MaxDefenderInfantry")) {
            failureReasons.add(new Integer(441));
        } else if (infCount < o.getIntValue("MinDefenderInfantry")) {
            failureReasons.add(new Integer(442));
        }
        if (da.getNumberOfUnitTypes(0) + da.getNumberOfUnitTypes(1) + da.getNumberOfUnitTypes(5) > o.getIntValue("MaxDefenderNonInfantry")) {
            failureReasons.add(new Integer(450));
        } else if (da.getNumberOfUnitTypes(0) + da.getNumberOfUnitTypes(1) + da.getNumberOfUnitTypes(5) < o.getIntValue("MinDefenderNonInfantry")) {
            failureReasons.add(new Integer(451));
        }
        int totalWeight = 0;
        int largestWeight = 0;
        int numProtoMeks = da.getNumberOfUnitTypes(3);
        int lowUnitBV = Integer.MAX_VALUE;
        int highUnitBV = Integer.MIN_VALUE;
        int numberOfCommanders = 0;
        boolean hasMeks = false;
        boolean hasVehs = false;
        boolean hasAeros = false;
        boolean hasInf = false;
        boolean normInf = false;
        boolean powerInf = false;
        boolean speedFail = false;
        boolean maxTonFail = false;
        boolean minTonFail = false;
        boolean maxBVFail = false;
        boolean minBVFail = false;
        boolean omniFail = false;
        boolean checkOmni = o.getBooleanValue("DefenderOmniMeksOnly");
        boolean vetPilots = false;
        boolean greenPilots = false;
        double averageArmySkills = 0.0;
        int numberOfValidUnits = 0;
        for (SUnit sUnit : da.getUnits()) {
            int type;
            int currBV;
            numberOfCommanders = da.getCommanders().size();
            int currWeight = (int)sUnit.getEntity().getWeight();
            totalWeight += currWeight;
            if (currWeight > largestWeight) {
                largestWeight = currWeight;
            }
            if (sUnit.getType() == 0) {
                hasMeks = true;
                if (checkOmni && !omniFail && !sUnit.isOmni()) {
                    omniFail = true;
                }
            } else if (sUnit.getType() == 1) {
                hasVehs = true;
            } else if (sUnit.getType() == 5) {
                hasAeros = true;
            } else if (sUnit.getType() == 2 || sUnit.getType() == 4 || sUnit.getType() == 3) {
                hasInf = true;
                if (sUnit.getEntity() instanceof BattleArmor || sUnit.getEntity() instanceof Protomech) {
                    powerInf = true;
                } else {
                    normInf = true;
                }
            }
            if (!speedFail) {
                try {
                    int walkMP = sUnit.getEntity().getWalkMP();
                    int jumpMP = sUnit.getEntity().getJumpMP();
                    if (walkMP < o.getIntValue("MinDefenderWalk") && jumpMP < o.getIntValue("MinDefenderJump")) {
                        speedFail = true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (sUnit.getType() == 0 || sUnit.getType() == 1) {
                if (currWeight > o.getIntValue("MaxDefenderUnitTonnage")) {
                    maxTonFail = true;
                } else if (currWeight < o.getIntValue("MinDefenderUnitTonnage")) {
                    minTonFail = true;
                }
            }
            if ((currBV = sUnit.getBV()) < o.getIntValue("MinDefenderUnitBV")) {
                minBVFail = true;
            } else if (currBV > o.getIntValue("MaxDefenderUnitBV")) {
                maxBVFail = true;
            }
            if ((type = sUnit.getType()) == 1 && !o.getBooleanValue("CountVehsForSpread") || type == 3 && !o.getBooleanValue("CountProtosForSpread") || (type == 4 || type == 2) && !o.getBooleanValue("CountInfForSpread") || type == 5 && !o.getBooleanValue("CountAerosForSpread")) continue;
            if (!sUnit.hasVacantPilot()) {
                int piloting = sUnit.getPilot().getPiloting();
                int gunnery = sUnit.getPilot().getGunnery();
                int totalSkills = gunnery + piloting;
                ++numberOfValidUnits;
                averageArmySkills += (double)totalSkills;
                if (piloting > o.getIntValue("HighestDefenderPiloting")) {
                    greenPilots = true;
                }
                if (piloting < o.getIntValue("LowestDefenderPiloting")) {
                    vetPilots = true;
                }
                if (gunnery > o.getIntValue("HighestDefenderGunnery")) {
                    greenPilots = true;
                }
                if (gunnery < o.getIntValue("LowestDefenderGunnery")) {
                    vetPilots = true;
                }
                if (totalSkills > o.getIntValue("HighestDefenderPilotSkillTotal")) {
                    greenPilots = true;
                }
                if (totalSkills < o.getIntValue("LowestDefenderPilotSkillTotal")) {
                    vetPilots = true;
                }
            }
            lowUnitBV = Math.min(lowUnitBV, currBV);
            highUnitBV = Math.max(highUnitBV, currBV);
        }
        if (hasMeks && !o.getBooleanValue("DefenderAllowedMeks")) {
            failureReasons.add(new Integer(407));
        }
        if (hasVehs && !o.getBooleanValue("DefenderAllowedVehs")) {
            failureReasons.add(new Integer(408));
        }
        if (hasAeros && !o.getBooleanValue("DefenderAllowedAeros")) {
            failureReasons.add(new Integer(457));
        }
        if (hasInf && !o.getBooleanValue("DefenderAllowedInf")) {
            if (o.getBooleanValue("DefenderPoweredInfAllowed") && normInf) {
                failureReasons.add(new Integer(410));
            }
            if (o.getBooleanValue("DefenderStandardInfAllowed") && powerInf) {
                failureReasons.add(new Integer(446));
            } else if (!normInf && !powerInf) {
                failureReasons.add(new Integer(209));
            }
        }
        if (checkOmni && omniFail) {
            failureReasons.add(new Integer(443));
        }
        if (o.getBooleanValue("UseUnitCommander")) {
            if (numberOfCommanders < o.getIntValue("MinimumUnitCommanders")) {
                failureReasons.add(4);
            }
            if (numberOfCommanders > o.getIntValue("MaximumUnitCommanders")) {
                failureReasons.add(5);
            }
        }
        if (o.getBooleanValue("ProtosMustbeGrouped") && numProtoMeks > 0 && numProtoMeks % 5 != 0) {
            failureReasons.add(new Integer(1));
        }
        if (speedFail) {
            failureReasons.add(new Integer(404));
        }
        if (maxTonFail) {
            failureReasons.add(new Integer(405));
        } else if (minTonFail) {
            failureReasons.add(new Integer(406));
        }
        if (maxBVFail) {
            failureReasons.add(new Integer(431));
        } else if (minBVFail) {
            failureReasons.add(new Integer(430));
        }
        if (totalWeight > o.getIntValue("MaxTotalDefenderTonnage")) {
            failureReasons.add(new Integer(411));
        } else if (totalWeight < o.getIntValue("MinTotalDefenderTonnage")) {
            failureReasons.add(new Integer(412));
        }
        int n = o.getIntValue("MaxDefenderUnitBVSpread");
        int minAllowedSpread = o.getIntValue("MinDefenderUnitBVSpread");
        if (n > 0 && highUnitBV - lowUnitBV > n) {
            failureReasons.add(432);
        }
        if (minAllowedSpread > 0 && highUnitBV - lowUnitBV < minAllowedSpread) {
            failureReasons.add(433);
        }
        averageArmySkills /= (double)numberOfValidUnits;
        if (vetPilots || averageArmySkills > o.getDoubleValue("DefenderAverageArmySkillMax")) {
            failureReasons.add(453);
        }
        if (greenPilots || averageArmySkills < o.getDoubleValue("DefenderAverageArmySkillMin")) {
            failureReasons.add(454);
        }
    }

    public void checkOperations(SArmy a, boolean display, TreeMap<String, Operation> operations) {
        SPlayer p = CampaignMain.cm.getPlayer(a.getPlayerName());
        if (p == null) {
            return;
        }
        if (p.getDutyStatus() < 2) {
            return;
        }
        ArrayList<String> addNames = new ArrayList<String>();
        ArrayList<String> removeNames = new ArrayList<String>();
        for (Operation currType : operations.values()) {
            ArrayList<Integer> failures = this.validateShortAttacker(p, a, currType, null, -1, false);
            if (failures.size() > 0) {
                String removal = a.getLegalOperations().remove(currType.getName());
                if (removal == null) continue;
                removeNames.add(removal);
                continue;
            }
            if (a.getLegalOperations().put(currType.getName(), currType.getName()) != null) continue;
            addNames.add(currType.getName());
        }
        if (addNames.size() > 0 || removeNames.size() > 0) {
            String toSend = "PL|UOE|" + a.getID() + "*";
            for (String currName : addNames) {
                toSend = toSend + "a*" + currName + "*";
            }
            for (String currName : removeNames) {
                toSend = toSend + "r*" + currName + "*";
            }
            CampaignMain.cm.toUser(toSend, p.getName(), false);
            if (display) {
                String back;
                String front;
                int lastComma;
                Iterator i;
                String addSend = "AM:Army #" + a.getID();
                String removeSend = "AM:Army #" + a.getID();
                if (addNames.size() == 1) {
                    addSend = addSend + " gained access to an attack: " + (String)addNames.get(0) + ".";
                    CampaignMain.cm.toUser(addSend, p.getName(), true);
                } else if (addNames.size() > 1) {
                    addSend = addSend + " gained access to the following attacks: ";
                    i = addNames.iterator();
                    while (i.hasNext()) {
                        addSend = addSend + (String)i.next();
                        if (!i.hasNext()) continue;
                        addSend = addSend + ", ";
                    }
                    lastComma = addSend.lastIndexOf(", ");
                    if (lastComma >= 0) {
                        front = addSend.substring(0, lastComma);
                        back = addSend.substring(lastComma + 2, addSend.length());
                        addSend = front + " and " + back + ".";
                    }
                    CampaignMain.cm.toUser(addSend, p.getName(), true);
                }
                if (removeNames.size() == 1) {
                    removeSend = removeSend + " lost access to an attack: " + (String)removeNames.get(0) + ".";
                    CampaignMain.cm.toUser(removeSend, p.getName(), true);
                } else if (removeNames.size() > 1) {
                    removeSend = removeSend + " lost access to the following attacks: ";
                    i = removeNames.iterator();
                    while (i.hasNext()) {
                        removeSend = removeSend + (String)i.next();
                        if (!i.hasNext()) continue;
                        removeSend = removeSend + ", ";
                    }
                    lastComma = removeSend.lastIndexOf(", ");
                    if (lastComma >= 0) {
                        front = removeSend.substring(0, lastComma);
                        back = removeSend.substring(lastComma + 2, removeSend.length());
                        removeSend = front + " and " + back + ".";
                    }
                    CampaignMain.cm.toUser(removeSend, p.getName(), true);
                }
            }
        }
    }

    public String failuresToString(ArrayList<Integer> failList) {
        String s = "";
        if (failList.size() == 1) {
            s = s + " because:<br>- " + this.decodeFailure(failList.get(0)) + ".";
            return s;
        }
        s = s + "because:<br>";
        Iterator<Integer> i = failList.iterator();
        while (i.hasNext()) {
            s = s + "- " + this.decodeFailure(i.next());
            if (!i.hasNext()) continue;
            s = s + "<br>";
        }
        return s;
    }

    private String decodeFailure(Integer code) {
        int decoded = code;
        switch (decoded) {
            case 1: {
                return " the army includes an illegal number of protomechs. Protos must deploy in 5-unit points.";
            }
            case 2: {
                return " Difference in ELO was too high.";
            }
            case 3: {
                return " Team total bv exceeded.";
            }
            case 4: {
                return " not enough commanders in army";
            }
            case 5: {
                return " too many commanders in army";
            }
            case 6: {
                return " Sub-Factions access level is lower then the operations min. required access level.";
            }
            case 7: {
                return " BV difference between attacking and defending army is too large.";
            }
            case 8: {
                return " Intra-Faction attacks not allowed.";
            }
            case 200: {
                return " the army is over the BV limit for this type of attack";
            }
            case 201: {
                return " the army is under the BV limit for this type of attack";
            }
            case 202: {
                return " the army has too many Meks";
            }
            case 203: {
                return " the army does not have enough Meks";
            }
            case 239: {
                return " the army has too many Vehicles";
            }
            case 240: {
                return " the army does not have enough Vehicles";
            }
            case 241: {
                return " the army has too many Infantry";
            }
            case 242: {
                return " the army does not have enough Infantry";
            }
            case 250: {
                return " the army has too many non-Infantry";
            }
            case 251: {
                return " the army does not have enough non-Infantry";
            }
            case 204: {
                return " the army contains a unit which is too slow";
            }
            case 205: {
                return " the army contains a unit which is too heavy";
            }
            case 206: {
                return " the army contains a unit which is too light";
            }
            case 207: {
                return " the army contains meks, which may not participate in this type of attack";
            }
            case 208: {
                return " the army contains vehicles, which may not participate in this type of attack";
            }
            case 209: {
                return " the army contains infantry, which may not participate in this type of attack";
            }
            case 210: {
                return " the army contains conventional infantry, which may not participate in this type of attack";
            }
            case 211: {
                return " the army is over the tonnage maximum for this type of attack";
            }
            case 212: {
                return " the army is under the tonnage minimum for this type of attack";
            }
            case 213: {
                return " you cannot afford the attack";
            }
            case 214: {
                return " you do not have enough " + CampaignMain.cm.getConfig("FluLongName") + " for this type of attack";
            }
            case 215: {
                return " you do not have enough RP for this type of attack";
            }
            case 216: {
                return " your rating is too high for this type of attack";
            }
            case 217: {
                return " your rating is too low for this type of attack";
            }
            case 218: {
                return " you have too much experience for this type of attack";
            }
            case 219: {
                return " you have too little experience for this type of attack";
            }
            case 220: {
                return " you're played too many games to perform this type of attack";
            }
            case 221: {
                return " you've played too few games to perform this type of attack";
            }
            case 222: {
                return " the target world is out of range";
            }
            case 223: {
                return " no active opponents may fight against this Army";
            }
            case 224: {
                return " no active opponents may defend the target world";
            }
            case 225: {
                return " no active opponents may defend this type of attack";
            }
            case 226: {
                return " players in the training faction are not allowed to use this type of attack";
            }
            case 227: {
                return " players in non-conquer factions are not allowed to use this type of attack";
            }
            case 228: {
                return " the target has no factory";
            }
            case 229: {
                return " this type of attack may only be performed on worlds without factories";
            }
            case 237: {
                return " the target is not a homeworld";
            }
            case 238: {
                return " this type of attack may only be performed a homeworld";
            }
            case 230: {
                return " the army contains a unit with a BV too low for this type of attack";
            }
            case 231: {
                return " the army contains a unit with a BV too high for this type of attack";
            }
            case 232: {
                return " the BV difference between the largest and smallest counted units is too large";
            }
            case 233: {
                return " the BV difference between the largest and smallest counted units is too small";
            }
            case 234: {
                return " your faction may not make this type of attack";
            }
            case 235: {
                return " your faction controls too little of the target planet";
            }
            case 236: {
                return " your faction controls too much of the target planet";
            }
            case 243: {
                return " your army can only have meks that are Omnimeks for this op";
            }
            case 244: {
                return " The target planet did not contain the correct Op Flags";
            }
            case 245: {
                return " the target planet contained an op flag that was not allowed for this operation.";
            }
            case 246: {
                return " the army contains armored infantry, which may not participate in this type of attack";
            }
            case 247: {
                return " you are under attack, and may not counterattack using this type of attack.";
            }
            case 248: {
                return " this operation must be initiated by a player on reserve duty (use AFR)";
            }
            case 249: {
                return " this operation may only be initated by a player on active duty";
            }
            case 252: {
                return " this army has eilte pilots.";
            }
            case 253: {
                return " this army has green pilots.";
            }
            case 254: {
                return " the army has too many aeros";
            }
            case 255: {
                return " the army does not have enough aeros";
            }
            case 256: {
                return " the army contains aeros, which may not participate in this type of attack";
            }
            case 400: {
                return " the army is over the BV limit for this type of defense";
            }
            case 401: {
                return " the army is under the BV limit for this type of defense";
            }
            case 402: {
                return " the army has too many meks";
            }
            case 403: {
                return " the army does not have enough meks";
            }
            case 439: {
                return " the army has too many vehicles";
            }
            case 440: {
                return " the army does not have enough vehicles";
            }
            case 441: {
                return " the army has too many infantry";
            }
            case 442: {
                return " the army does not have enough infantry";
            }
            case 450: {
                return " the army has too many non-infantry";
            }
            case 451: {
                return " the army does not have enough non-infantry";
            }
            case 404: {
                return " the army contains a unit which is too slow";
            }
            case 405: {
                return " the army contains a unit which is too heavy";
            }
            case 406: {
                return " the army contains a unit which is too light";
            }
            case 407: {
                return " the army contains meks, which may not participate in this type of defense";
            }
            case 408: {
                return " the army contains vehicles, which may not participate in this type of defense";
            }
            case 409: {
                return " the army contains infantry, which may not participate in this type of defense";
            }
            case 410: {
                return " the army contains conventional infantry, which may not participate in this type of defense";
            }
            case 411: {
                return " the army is over the tonnage maximum for this type of defense";
            }
            case 412: {
                return " the army is under the tonnage minimum for this type of defense";
            }
            case 413: {
                return " you cannot afford the defense";
            }
            case 414: {
                return " you do not have enough influence for this type of defense";
            }
            case 415: {
                return " you do not have enough RP for this type of defense";
            }
            case 416: {
                return " your rating is too high for this type of defense";
            }
            case 417: {
                return " your rating is too low for this type of defense";
            }
            case 418: {
                return " you have too much experience for this type of defense";
            }
            case 419: {
                return " you have too little experience for this type of defense";
            }
            case 420: {
                return " you're played too many games to perform this type of defense";
            }
            case 421: {
                return " you've played too few games to perform this type of defense";
            }
            case 426: {
                return " players in the training faction are not allowed to defend against this type of attack";
            }
            case 427: {
                return " players in non-conquer factions are not allowed to defend against this type of attack";
            }
            case 430: {
                return " the army contains a unit with a BV too low for this type of defense";
            }
            case 431: {
                return " the army contains a unit with a BV too high for this type of defense";
            }
            case 432: {
                return " the BV difference between the largest and smallest counted units is too large";
            }
            case 433: {
                return " the BV difference between the largest and smallest counted units is too small";
            }
            case 434: {
                return " your faction may not defend this type of attack";
            }
            case 443: {
                return " your army can only have meks that are Omnimeks for this op";
            }
            case 424: {
                return " defender does not have any ownship of target world";
            }
            case 446: {
                return " the army contains armored infantry, which may not participate in this type of defense";
            }
            case 452: {
                return " the planet is non-conqerable and this operation allows for conqest";
            }
            case 453: {
                return " this army has eilte pilots.";
            }
            case 454: {
                return " this army has green pilots.";
            }
            case 455: {
                return " the army has too many aeros";
            }
            case 456: {
                return " the army does not have enough aeros";
            }
            case 457: {
                return " the army contains aeros, which may not participate in this type of defense";
            }
        }
        return "";
    }
}

