/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot;

import common.CampaignData;
import common.campaign.pilot.Pilot;
import common.campaign.pilot.skills.PilotSkill;
import common.util.TokenReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.StringTokenizer;
import megamek.common.Infantry;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.pilot.skills.AstechSkill;
import server.campaign.pilot.skills.EdgeSkill;
import server.campaign.pilot.skills.SPilotSkill;
import server.campaign.pilot.skills.TraitSkill;
import server.campaign.pilot.skills.WeaponSpecialistSkill;

public class SPilot
extends Pilot {
    private int originalID;
    private int pickedUpID;
    private boolean death = false;

    public SPilot(String name, int gunnery, int piloting) {
        super(name, gunnery, piloting);
    }

    public SPilot() {
    }

    public String checkForPilotSkillImprovement(SUnit unit, SPlayer owner) {
        if (CampaignMain.cm.getBooleanConfig("PlayersCanBuyPilotUpgrades")) {
            return "";
        }
        int bestGunnery = CampaignMain.cm.getIntegerConfig("BestGunnerySkill");
        int bestPiloting = CampaignMain.cm.getIntegerConfig("BestPilotingSkill");
        int bestTotal = CampaignMain.cm.getIntegerConfig("BestTotalPilot");
        int startingSkillAmount = 10;
        int currentSkillAmount = this.getGunnery() + this.getPiloting();
        SPilotSkill skillToAdd = null;
        int differential = this.getGunnery() - this.getPiloting();
        if (unit.getEntity() instanceof Infantry) {
            differential = 0;
        }
        if (this.getSkills().has(5)) {
            ++differential;
        }
        if (this.getSkills().has(6)) {
            --differential;
        }
        int oldBV = unit.getBV();
        boolean pilotIsElite = false;
        if (this.getGunnery() <= bestGunnery && this.getPiloting() <= bestPiloting) {
            pilotIsElite = true;
        }
        if (this.getGunnery() + this.getPiloting() <= bestTotal) {
            pilotIsElite = true;
        }
        int baseRollToLevel = CampaignMain.cm.getIntegerConfig("BaseRollToLevel");
        int rollMultiplier = CampaignMain.cm.getIntegerConfig("MultiplierPerPreviousLevel");
        int multiplier = startingSkillAmount - currentSkillAmount;
        if (pilotIsElite) {
            --multiplier;
        }
        if (multiplier < 1) {
            multiplier = 1;
        }
        int dieSize = 0;
        dieSize = rollMultiplier <= 0 ? baseRollToLevel : baseRollToLevel * rollMultiplier * multiplier;
        boolean shouldLevelUp = false;
        boolean shouldLevelDown = false;
        boolean useRandomLevels = CampaignMain.cm.getBooleanConfig("UseRandomPilotLevelups");
        if (!pilotIsElite) {
            if (!useRandomLevels && this.getExperience() >= dieSize) {
                shouldLevelUp = true;
            } else if (this.getExperience() >= CampaignMain.cm.getRandomNumber(dieSize)) {
                shouldLevelUp = true;
            }
        } else if (pilotIsElite && CampaignMain.cm.getBooleanConfig("RandomRetirementOfElites")) {
            if (!useRandomLevels && this.getExperience() >= dieSize) {
                shouldLevelDown = true;
            } else if (this.getExperience() >= CampaignMain.cm.getRandomNumber(dieSize)) {
                shouldLevelDown = true;
            }
        }
        boolean pilotsCanGainSkills = CampaignMain.cm.getBooleanConfig("PilotSkills");
        if (!shouldLevelUp && !shouldLevelDown && pilotsCanGainSkills) {
            int dieRoll;
            int chanceToGainSkill = CampaignMain.cm.getIntegerConfig("SkillLevelChance");
            if (unit.getPilot().getSkills().has(18)) {
                chanceToGainSkill += CampaignMain.cm.getIntegerConfig("GiftedPercent");
            }
            if ((dieRoll = CampaignMain.cm.getRandomNumber(100) + 1) < chanceToGainSkill) {
                skillToAdd = CampaignMain.cm.getRandomSkill(this, unit.getType());
            }
        }
        if (shouldLevelUp || shouldLevelDown || skillToAdd != null) {
            this.setExperience(0);
        }
        if (shouldLevelUp) {
            int random = CampaignMain.cm.getRandomNumber(10);
            boolean levelGunnery = false;
            boolean levelPiloting = false;
            if (differential > 0) {
                levelGunnery = true;
            } else if (differential < 0) {
                levelPiloting = true;
            } else if (random < 3 || unit.getEntity() instanceof Infantry && random < 5) {
                levelPiloting = true;
            } else {
                levelGunnery = true;
            }
            if (levelGunnery && this.getGunnery() <= bestGunnery) {
                levelGunnery = false;
                if (this.getPiloting() > bestPiloting) {
                    levelPiloting = true;
                } else {
                    pilotIsElite = true;
                }
            }
            if (levelPiloting && this.getPiloting() <= bestPiloting) {
                levelPiloting = false;
                if (this.getGunnery() > bestGunnery) {
                    levelGunnery = true;
                } else {
                    pilotIsElite = true;
                }
            }
            if (levelGunnery) {
                this.setGunnery(this.getGunnery() - 1);
            } else if (levelPiloting) {
                if (unit.getEntity() instanceof Infantry) {
                    if (((Infantry)unit.getEntity()).isAntiMek()) {
                        this.setPiloting(this.getPiloting() - 1);
                    } else {
                        levelPiloting = false;
                    }
                } else {
                    this.setPiloting(this.getPiloting() - 1);
                }
            }
            if (levelGunnery || levelPiloting) {
                unit.setPilot(this);
                return " and advanced a level. " + this.getName() + " is now " + this.getGunnery() + "/" + this.getPiloting() + " [Old BV: " + oldBV + "/New BV: " + unit.getBV() + "]";
            }
        } else if (shouldLevelDown) {
            this.setGunnery(owner.getMyHouse().getBaseGunner(unit.getType()));
            this.setPiloting(owner.getMyHouse().getBasePilot(unit.getType()));
            String oldName = this.getName();
            if (oldName.endsWith("Jr.")) {
                this.setName(oldName.substring(0, oldName.lastIndexOf("Jr.")) + "III");
            } else if (oldName.endsWith("III")) {
                this.setName(oldName.substring(0, oldName.lastIndexOf("III")) + "IV");
            } else if (oldName.endsWith("IV")) {
                this.setName(oldName.substring(0, oldName.lastIndexOf("IV")) + "V");
            } else if (oldName.endsWith("V")) {
                this.setName(oldName + "I");
            } else if (oldName.endsWith("VI")) {
                this.setName(oldName + "I");
            } else if (oldName.endsWith("VII")) {
                this.setName(oldName + "I");
            } else if (oldName.endsWith("VIII")) {
                this.setName(oldName.substring(0, oldName.lastIndexOf("VIII")) + "IX");
            } else if (oldName.endsWith("IX")) {
                this.setName(oldName.substring(0, oldName.lastIndexOf("IX")) + "X");
            } else {
                this.setName(oldName + " Jr.");
            }
            unit.setPilot(this);
            return ". " + oldName + " grew weary of war and retired from active duty. The unit was passed on to " + this.getName() + " [" + this.getGunnery() + "/" + this.getPiloting() + ", Old BV: " + oldBV + "/New BV: " + unit.getBV() + "]";
        }
        if (skillToAdd != null) {
            if (skillToAdd instanceof WeaponSpecialistSkill) {
                ((WeaponSpecialistSkill)skillToAdd).assignWeapon(unit.getEntity(), this);
            } else if (skillToAdd instanceof TraitSkill) {
                ((TraitSkill)skillToAdd).assignTrait(this);
            } else if (skillToAdd instanceof EdgeSkill) {
                if (this.getSkills().has(20)) {
                    skillToAdd = (SPilotSkill)this.getSkills().getPilotSkill(20);
                    ((EdgeSkill)skillToAdd).setLevel(skillToAdd.getLevel() + 1);
                }
            } else if (skillToAdd instanceof AstechSkill && this.getSkills().has(2)) {
                skillToAdd = (SPilotSkill)this.getSkills().getPilotSkill(2);
                ((AstechSkill)skillToAdd).setLevel(skillToAdd.getLevel() + 1);
            }
            skillToAdd.addToPilot(this);
            skillToAdd.modifyPilot(this);
            unit.setPilot(this);
            int newBV = unit.getBV();
            if (skillToAdd instanceof AstechSkill && !CampaignMain.cm.isUsingAdvanceRepair()) {
                CampaignMain.cm.toUser("PL|SF|" + owner.getFreeBays(), owner.getName(), false);
            }
            String toSend = ". " + this.getName() + " gained the " + skillToAdd.getName() + " skill";
            if (newBV != oldBV) {
                toSend = toSend + " [Old BV: " + oldBV + "/New BV: " + newBV + "]";
            }
            return toSend;
        }
        if (pilotIsElite) {
            return " but could not level up because " + this.getName() + " is elite";
        }
        return "";
    }

    public String toFileFormat(String delimiter, boolean toPlayer) {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        result.append(delimiter);
        result.append(this.getExperience());
        result.append(delimiter);
        result.append(this.getGunnery());
        result.append(delimiter);
        result.append(this.getPiloting());
        result.append(delimiter);
        result.append(this.getSkills().size());
        result.append(delimiter);
        for (PilotSkill skill : this.getSkills().getPilotSkills()) {
            SPilotSkill sk = (SPilotSkill)skill;
            result.append(sk.getId());
            result.append(delimiter);
            if (toPlayer) {
                result.append(sk.getName());
                result.append(delimiter);
            }
            result.append(sk.getLevel());
            result.append(delimiter);
            if (toPlayer) {
                result.append(sk.getAbbreviation());
                result.append(delimiter);
            }
            if (sk instanceof WeaponSpecialistSkill) {
                result.append(this.getWeapon());
                result.append(delimiter);
            }
            if (sk instanceof TraitSkill) {
                result.append(this.getTraitName());
                result.append(delimiter);
            }
            if (!(sk instanceof EdgeSkill)) continue;
            result.append(((EdgeSkill)sk).getTac());
            result.append(delimiter);
            result.append(((EdgeSkill)sk).getKO());
            result.append(delimiter);
            result.append(((EdgeSkill)sk).getHeadHit());
            result.append(delimiter);
            result.append(((EdgeSkill)sk).getExplosion());
            result.append(delimiter);
        }
        result.append(this.getKills());
        result.append(delimiter);
        if (!toPlayer) {
            if (this.getCurrentFaction().trim().length() > 0) {
                result.append(this.getCurrentFaction());
            } else {
                result.append(CampaignMain.cm.getConfig("NewbieHouseName"));
            }
            result.append(delimiter);
            result.append(this.getPilotId());
            result.append(delimiter);
        }
        if (CampaignMain.cm.getBooleanConfig("AllowPilotDamageToTransfer")) {
            if (toPlayer) {
                int hits = 0;
                if (this.getHits() != 0) {
                    hits = Math.max(1, this.getHits() / CampaignMain.cm.getIntegerConfig("AmountOfDamagePerPilotHit"));
                }
                result.append(hits);
            } else {
                result.append(this.getHits());
            }
        } else {
            result.append(0);
        }
        result.append(delimiter);
        if (!toPlayer) {
            if (CampaignMain.cm.isUsingMySQL()) {
                result.append(this.getDBId());
            } else {
                result.append(0);
            }
            result.append(delimiter);
        }
        return result.toString();
    }

    public synchronized void toDB(int unitType, int unitSize) {
        Statement ps = null;
        try {
            if (this.getName().equalsIgnoreCase("Vacant")) {
                return;
            }
            if (this.getPilotId() == -1) {
                this.setPilotId(CampaignMain.cm.getAndUpdateCurrentPilotID());
                CampaignData.mwlog.dbLog("Getting new Pilot ID: " + this.getPilotId());
            }
            StringBuffer sql = new StringBuffer();
            if (this.getDBId() < 1) {
                sql.setLength(0);
                ps = CampaignMain.cm.MySQL.getPreparedStatement("INSERT into pilots set MWID=?, pilotName=?, pilotExp=?, pilotGunnery=?, pilotPiloting=?, pilotKills=?, pilotCurrentFaction=?, pilotHits=?, pilotSize = ?, pilotType = ?", 1);
                ps.setInt(1, this.getPilotId());
                ps.setString(2, this.getName());
                ps.setInt(3, this.getExperience());
                ps.setInt(4, this.getGunnery());
                ps.setInt(5, this.getPiloting());
                ps.setInt(6, this.getKills());
                ps.setString(7, this.getCurrentFaction());
                ps.setInt(8, this.getHits());
                ps.setInt(9, unitSize);
                ps.setInt(10, unitType);
                ps.executeUpdate();
                ResultSet rs = ps.getGeneratedKeys();
                rs.next();
                this.setDBId(rs.getInt(1));
            } else {
                sql.setLength(0);
                ps = CampaignMain.cm.MySQL.getPreparedStatement("UPDATE pilots set pilotName=?, pilotExp=?, pilotGunnery=?, pilotPiloting=?, pilotKills=?, pilotCurrentFaction=?, pilotHits=?, pilotSize = ?, pilotType = ?, MWID=? WHERE pilotID=?");
                ps.setString(1, this.getName());
                ps.setInt(2, this.getExperience());
                ps.setInt(3, this.getGunnery());
                ps.setInt(4, this.getPiloting());
                ps.setInt(5, this.getKills());
                ps.setString(6, this.getCurrentFaction());
                ps.setInt(7, this.getHits());
                ps.setInt(8, unitSize);
                ps.setInt(9, unitType);
                ps.setInt(10, this.getPilotId());
                ps.setInt(11, this.getDBId());
                ps.executeUpdate();
            }
            sql.setLength(0);
            sql.append("DELETE from pilotskills WHERE pilotID = " + this.getDBId());
            ps.executeUpdate(sql.toString());
            if (this.getSkills().size() > 0) {
                for (PilotSkill skill : this.getSkills().getPilotSkills()) {
                    SPilotSkill sk = (SPilotSkill)skill;
                    sql.setLength(0);
                    sql.append("REPLACE into pilotskills set ");
                    sql.append("pilotID = " + this.getDBId() + ", ");
                    sql.append("SkillNum = " + sk.getId() + ", ");
                    sql.append("SkillLevel = " + sk.getLevel());
                    if (sk instanceof WeaponSpecialistSkill) {
                        sql.append(", skillData = '" + this.getWeapon() + "'");
                    }
                    if (sk instanceof TraitSkill) {
                        sql.append(", skillData = '" + this.getTraitName() + "'");
                    }
                    if (sk instanceof EdgeSkill) {
                        sql.append(", skillData = '" + ((EdgeSkill)sk).getTac() + "$");
                        sql.append(((EdgeSkill)sk).getKO() + "$");
                        sql.append(((EdgeSkill)sk).getHeadHit() + "$");
                        sql.append(((EdgeSkill)sk).getExplosion() + "'");
                    }
                    ps.executeUpdate(sql.toString());
                }
            }
            ps.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in PilotHandler.savePilot: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
    }

    public void fromFileFormat(String s, String delimiter) {
        TraitSkill traitSkill = null;
        try {
            StringTokenizer ST = new StringTokenizer(s, delimiter);
            if (ST.countTokens() < 1) {
                this.setName("NULL");
                return;
            }
            this.setName(TokenReader.readString(ST));
            this.setExperience(TokenReader.readInt(ST));
            this.setGunnery(TokenReader.readInt(ST));
            this.setPiloting(TokenReader.readInt(ST));
            int skills = TokenReader.readInt(ST);
            for (int i = 0; i < skills; ++i) {
                SPilotSkill skill = CampaignMain.cm.getPilotSkill(TokenReader.readInt(ST));
                int level = TokenReader.readInt(ST);
                if (skill instanceof AstechSkill) {
                    skill = new AstechSkill(2);
                }
                if (skill instanceof WeaponSpecialistSkill) {
                    this.setWeapon(TokenReader.readString(ST));
                }
                if (skill instanceof TraitSkill) {
                    String traitName = TokenReader.readString(ST);
                    if (traitName.equalsIgnoreCase("none")) {
                        traitSkill = (TraitSkill)skill;
                    } else {
                        this.setTraitName(traitName);
                    }
                }
                if (skill instanceof EdgeSkill) {
                    skill = new EdgeSkill(20);
                    ((EdgeSkill)skill).setTac(TokenReader.readBoolean(ST));
                    ((EdgeSkill)skill).setKO(TokenReader.readBoolean(ST));
                    ((EdgeSkill)skill).setHeadHit(TokenReader.readBoolean(ST));
                    ((EdgeSkill)skill).setExplosion(TokenReader.readBoolean(ST));
                }
                skill.setLevel(level);
                skill.addToPilot(this);
                skill.modifyPilot(this);
            }
            this.setKills(TokenReader.readInt(ST));
            this.setCurrentFaction(TokenReader.readString(ST));
            this.setPilotId(TokenReader.readInt(ST));
            this.setHits(TokenReader.readInt(ST));
            if (CampaignMain.cm.isUsingMySQL()) {
                this.setDBId(TokenReader.readInt(ST));
            } else {
                TokenReader.readString(ST);
            }
            if (traitSkill != null) {
                traitSkill.assignTrait(this);
            }
            if (this.getPilotId() == -1) {
                this.setPilotId(CampaignMain.cm.getAndUpdateCurrentPilotID());
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error loading Pilot " + this.getName());
            CampaignData.mwlog.errLog(ex);
        }
    }

    public int getOriginalID() {
        return this.originalID;
    }

    public void setOriginalID(int originalID) {
        this.originalID = originalID;
    }

    public int getPickedUpID() {
        return this.pickedUpID;
    }

    public void setPickedUpID(int pickedUpID) {
        this.pickedUpID = pickedUpID;
    }

    public void setDeath(boolean death) {
        this.death = death;
    }

    public boolean isDead() {
        return this.death;
    }

    public static SPilot getMekWarrior(int originalID, int pickedUpId) {
        SPilot mw = new SPilot();
        mw.setOriginalID(originalID);
        mw.setPickedUpID(pickedUpId);
        return mw;
    }

    public String getPilotCaptureMessageToOwner(SUnit unit) {
        try {
            File folder = new File("./data/pilotmessages");
            if (!folder.exists()) {
                folder.mkdir();
            }
            String scrapFile = "/pilotcapturemessagestoowner.txt";
            FileInputStream fis = new FileInputStream(folder.getPath() + scrapFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            int messages = Integer.parseInt(dis.readLine());
            Random rand = new Random();
            int id = rand.nextInt(messages);
            String scrapMessage = "";
            while (dis.ready()) {
                scrapMessage = dis.readLine();
                if (id <= 0) break;
                --id;
            }
            String scrapMessageWithPilot = scrapMessage.replaceAll("PILOT", this.getName());
            return scrapMessageWithPilot.replaceAll("UNIT", unit.getModelName());
        }
        catch (FileNotFoundException fnfn) {
            return this.getName() + " was captured by enemy forces after fleeing the " + unit.getModelName() + ".";
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("A problem occured with your pilotcapturemessagestoowner File!");
            return this.getName() + " was captured by enemy forces after fleeing the " + unit.getModelName() + ".";
        }
    }

    public String getPilotCaptureAndDefectedMessage(SUnit unit, SHouse house) {
        try {
            File folder = new File("./data/pilotmessages");
            if (!folder.exists()) {
                folder.mkdir();
            }
            String scrapFile = "/pilotcaptureanddefectedmessages.txt";
            FileInputStream fis = new FileInputStream(folder.getPath() + scrapFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            int messages = Integer.parseInt(dis.readLine());
            Random rand = new Random();
            int id = rand.nextInt(messages);
            String scrapMessage = "";
            while (dis.ready()) {
                scrapMessage = dis.readLine();
                if (id <= 0) break;
                --id;
            }
            String scrapMessageWithPilot = scrapMessage.replaceAll("PILOT", this.getName());
            String scrapMessageWithHouse = scrapMessageWithPilot.replaceAll("HOUSE", house.getNameAsLink());
            return scrapMessageWithHouse.replaceAll("UNIT", unit.getModelName());
        }
        catch (FileNotFoundException fnfn) {
            return this.getName() + " was rescued from his unit by our infantry and has decided to join " + house.getColoredNameAsLink() + ".";
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("A problem occured with your pilotcapturemessagesdefect File!");
            return this.getName() + " was rescued from his unit by our infantry and has decided to join " + house.getColoredNameAsLink() + ".";
        }
    }

    public String getPilotCaptureAndRemovedMessage(SUnit unit) {
        try {
            File folder = new File("./data/pilotmessages");
            if (!folder.exists()) {
                folder.mkdir();
            }
            String scrapFile = "/pilotcaptureandremovedmessages.txt";
            FileInputStream fis = new FileInputStream(folder.getPath() + scrapFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            int messages = Integer.parseInt(dis.readLine());
            Random rand = new Random();
            int id = rand.nextInt(messages);
            String scrapMessage = "";
            while (dis.ready()) {
                scrapMessage = dis.readLine();
                if (id <= 0) break;
                --id;
            }
            String scrapMessageWithPilot = scrapMessage.replaceAll("PILOT", this.getName());
            return scrapMessageWithPilot.replaceAll("UNIT", unit.getModelName());
        }
        catch (FileNotFoundException fnfn) {
            return this.getName() + " captured by our infantry transferred to HQ for interrogation.";
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("A problem occured with your pilotcapturemessagesdefect File!");
            return this.getName() + " captured by our infantry transferred to HQ for interrogation.";
        }
    }

    public String getPilotRescueMessage(SUnit unit) {
        try {
            File folder = new File("./data/pilotmessages");
            if (!folder.exists()) {
                folder.mkdir();
            }
            String scrapFile = "/pilotrescuemessages.txt";
            FileInputStream fis = new FileInputStream(folder.getPath() + scrapFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            int messages = Integer.parseInt(dis.readLine());
            Random rand = new Random();
            int id = rand.nextInt(messages);
            String scrapMessage = "";
            while (dis.ready()) {
                scrapMessage = dis.readLine();
                if (id <= 0) break;
                --id;
            }
            String scrapMessageWithPilot = scrapMessage.replaceAll("PILOT", this.getName());
            return scrapMessageWithPilot.replaceAll("UNIT", unit.getModelName());
        }
        catch (FileNotFoundException fnfn) {
            return this.getName() + " hiked back to base.";
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("A problem occured with your pilotcapturemessages File!");
            return this.getName() + " hiked back to base.";
        }
    }

    public static String getRandomPilotName(Random r) {
        String result = "John Doe";
        try {
            File configFile = new File("./data/pilotnames/Pilotnames.txt");
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            int names = Integer.parseInt(dis.readLine());
            int pilotid = r.nextInt(names);
            while (dis.ready()) {
                String line = dis.readLine();
                if (pilotid <= 0) {
                    return line;
                }
                --pilotid;
            }
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("A problem occured with your Pilotnames File!");
        }
        return result;
    }
}

