/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.Unit;
import common.campaign.pilot.Pilot;
import megamek.common.Entity;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.pilot.skills.SPilotSkill;

public class AstechSkill
extends SPilotSkill {
    public AstechSkill(int id) {
        super(id, "Astech", "AT");
        this.setDescription("Reduces the number of techs needed to repair a unit by 1");
    }

    public AstechSkill() {
    }

    public void modifyPilot(Pilot p) {
        if (!CampaignMain.cm.isUsingAdvanceRepair()) {
            p.setBayModifier(p.getBayModifier() - 1);
        }
    }

    public int getBVMod(Entity unit) {
        return 0;
    }

    public int getChance(int unitType, Pilot p) {
        if (p.getSkills().has(2)) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        SHouse house = CampaignMain.cm.getHouseFromPartialString(p.getCurrentFaction());
        if (house == null) {
            return CampaignMain.cm.getIntegerConfig(chance);
        }
        return Integer.parseInt(house.getConfig(chance));
    }

    public void addToPilot(Pilot pilot) {
        pilot.getSkills().add(this);
    }

    public void setLevel(int level) {
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            if (level == -1) {
                super.setLevel(0);
            } else {
                super.setLevel(level);
            }
        } else {
            super.setLevel(-1);
        }
    }
}

