/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import megamek.common.Entity;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.pilot.skills.SPilotSkill;

public class BufferedVDNI
extends SPilotSkill {
    public BufferedVDNI(int id) {
        super(id, "Buffered VDNI", "BVDNI");
        this.setDescription("MD Buffered VDNI");
    }

    public void modifyPilot(Pilot p) {
        super.addToPilot(p);
        p.addMegamekOption(new MegaMekPilotOption("bvdni", true));
        p.setBvMod(p.getBVMod() + 0.01);
    }

    public int getBVMod(Entity unit) {
        return CampaignMain.cm.getIntegerConfig("BufferedVDNIBaseBVMod");
    }

    public int getChance(int unitType, Pilot p) {
        if (p.getSkills().has(23)) {
            return 0;
        }
        if (unitType != 0 && unitType != 1) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        SHouse house = CampaignMain.cm.getHouseFromPartialString(p.getCurrentFaction());
        if (house == null) {
            return CampaignMain.cm.getIntegerConfig(chance);
        }
        return Integer.parseInt(house.getConfig(chance));
    }
}

