/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import megamek.common.Entity;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.pilot.skills.SPilotSkill;

public class EdgeSkill
extends SPilotSkill {
    boolean edge_when_tac = true;
    boolean edge_when_ko = true;
    boolean edge_when_headhit = true;
    boolean edge_when_explosion = true;

    public EdgeSkill(int id) {
        super(id, "Edge", "ED");
        this.setDescription("Allows Pilot to reroll 1 roll(per level) per game.");
    }

    public EdgeSkill() {
    }

    public void modifyPilot(Pilot p) {
        p.addMegamekOption(new MegaMekPilotOption("edge", true));
    }

    public int getBVMod(Entity unit) {
        return CampaignMain.cm.getIntegerConfig("EdgeBaseBVMod");
    }

    public int getChance(int unitType, Pilot p) {
        if (unitType != 0) {
            return 0;
        }
        if (p.getSkills().has(20) && p.getSkills().getPilotSkill(20).getLevel() > CampaignMain.cm.getIntegerConfig("MaxEdgeChanges")) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        SHouse house = CampaignMain.cm.getHouseFromPartialString(p.getCurrentFaction());
        if (house == null) {
            return CampaignMain.cm.getIntegerConfig(chance);
        }
        return Integer.parseInt(house.getConfig(chance));
    }

    public void addToPilot(Pilot pilot) {
        pilot.getSkills().add(this);
    }

    public void setLevel(int level) {
        if (level < 1) {
            super.setLevel(1);
        } else {
            super.setLevel(level);
        }
    }

    public boolean getTac() {
        return this.edge_when_tac;
    }

    public boolean getKO() {
        return this.edge_when_ko;
    }

    public boolean getHeadHit() {
        return this.edge_when_headhit;
    }

    public boolean getExplosion() {
        return this.edge_when_explosion;
    }

    public void setTac(boolean value) {
        this.edge_when_tac = value;
    }

    public void setKO(boolean value) {
        this.edge_when_ko = value;
    }

    public void setHeadHit(boolean value) {
        this.edge_when_headhit = value;
    }

    public void setExplosion(boolean value) {
        this.edge_when_explosion = value;
    }
}

