/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.pilot.skills.SPilotSkill;

public class GunneryMissileSkill
extends SPilotSkill {
    public GunneryMissileSkill(int id) {
        super(id, "Gunnery/Missile", "GM");
        this.setDescription("NOTE: This is a unofficial rule. Pilot gets a -1 to-hit bonus on all ballistic weapons (MGs, all ACs, Gaussrifles).");
    }

    public GunneryMissileSkill() {
    }

    public int getChance(int unitType, Pilot pilot) {
        if (pilot.getSkills().has(this)) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        SHouse house = CampaignMain.cm.getHouseFromPartialString(pilot.getCurrentFaction());
        if (house == null) {
            return CampaignMain.cm.getIntegerConfig(chance);
        }
        return Integer.parseInt(house.getConfig(chance));
    }

    public void modifyPilot(Pilot pilot) {
        pilot.addMegamekOption(new MegaMekPilotOption("gunnery_missile", true));
    }

    public int getBVMod(Entity unit) {
        double missileBV = 0.0;
        double gunneryMissileBVBaseMod = megamek.common.Pilot.getBVSkillMultiplier(unit.getCrew().getGunnery() - 1, unit.getCrew().getPiloting());
        for (Mounted weapon : unit.getWeaponList()) {
            if (!weapon.getType().hasFlag(262144L)) continue;
            missileBV += weapon.getType().getBV(unit);
        }
        return (int)(missileBV * gunneryMissileBVBaseMod);
    }
}

