/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.SPilotSkill;

public class IronManSkill
extends SPilotSkill {
    public IronManSkill(int id) {
        super(id, "Iron Man", "IM");
        this.setDescription("NOTE: This is a unofficial rule. A pilot with this skill receives only 1 pilot hit from ammunition explosions.");
    }

    public IronManSkill() {
    }

    public int getChance(int unitType, Pilot pilot) {
        if (pilot.getSkills().has(this)) {
            return 0;
        }
        if (unitType != 0) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        SHouse house = CampaignMain.cm.getHouseFromPartialString(pilot.getCurrentFaction());
        if (house == null) {
            return CampaignMain.cm.getIntegerConfig(chance);
        }
        return Integer.parseInt(house.getConfig(chance));
    }

    public void modifyPilot(Pilot pilot) {
        pilot.addMegamekOption(new MegaMekPilotOption("iron_man", true));
    }

    public int getBVMod(Entity unit) {
        return 0;
    }

    public int getBVMod(Entity unit, SPilot pilot) {
        int amountOfAmmo = 0;
        int IronManBVBaseMod = CampaignMain.cm.getIntegerConfig("IronManBaseBVMod");
        if (pilot.getSkills().has(4)) {
            return 0;
        }
        for (Mounted ammoType : unit.getAmmo()) {
            AmmoType ammo;
            if (ammoType.getShotsLeft() <= 0 || (ammo = (AmmoType)ammoType.getType()).getAmmoType() == 6 || ammo.getAmmoType() == 22 || ammo.getAmmoType() == 21) continue;
            ++amountOfAmmo;
        }
        for (Mounted weapon : unit.getWeaponList()) {
            if (weapon.getName().indexOf("Gauss Rifle") == -1) continue;
            ++amountOfAmmo;
        }
        return amountOfAmmo * IronManBVBaseMod;
    }
}

