/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import megamek.common.Entity;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.pilot.skills.SPilotSkill;

public class ManeuveringAceSkill
extends SPilotSkill {
    public ManeuveringAceSkill(int id) {
        super(id, "Maneuvering Ace", "MA");
        this.setDescription("Enables the unit to move laterally like a Quad. Units also receive a -1 BTH to rolls against skidding.");
    }

    public ManeuveringAceSkill() {
    }

    public int getChance(int unitType, Pilot pilot) {
        if (pilot.getSkills().has(this)) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        SHouse house = CampaignMain.cm.getHouseFromPartialString(pilot.getCurrentFaction());
        if (house == null) {
            return CampaignMain.cm.getIntegerConfig(chance);
        }
        return Integer.parseInt(house.getConfig(chance));
    }

    public void modifyPilot(Pilot pilot) {
        pilot.addMegamekOption(new MegaMekPilotOption("maneuvering_ace", true));
    }

    public int getBVMod(Entity unit) {
        try {
            double topSpeed = unit.getRunMP();
            double baseBVMod = CampaignMain.cm.getDoubleConfig("ManeuveringAceBaseBVMod");
            double speedRating = CampaignMain.cm.getDoubleConfig("ManeuveringAceSpeedRating");
            double total = topSpeed / speedRating;
            return (int)(total *= baseBVMod);
        }
        catch (Exception ex) {
            return 0;
        }
    }
}

