/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import megamek.common.Entity;
import megamek.common.Mech;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.pilot.skills.SPilotSkill;

public class MeleeSpecialistSkill
extends SPilotSkill {
    public MeleeSpecialistSkill(int id) {
        super(id, "Melee Specialist", "MS");
        this.setDescription("Enables the unit to do 1 additional point of damage with physical attacks and subtracts one from the attacker movement modifier (to a minimum of zero). Note: This ability is only used for BattleMechs.");
    }

    public MeleeSpecialistSkill() {
    }

    public void modifyPilot(Pilot p) {
        p.addMegamekOption(new MegaMekPilotOption("melee_specialist", true));
    }

    public int getBVMod(Entity unit) {
        double tonnage = unit.getWeight();
        double numberOfHatchets = 0.0;
        double hatchetMod = CampaignMain.cm.getDoubleConfig("HatchetRating");
        double baseBV = CampaignMain.cm.getDoubleConfig("MeleeSpecialistBaseBVMod");
        if (!(unit instanceof Mech)) {
            return 0;
        }
        numberOfHatchets = unit.getClubs().size();
        double total = baseBV * (tonnage / 10.0) + hatchetMod * numberOfHatchets;
        return (int)total;
    }

    public int getChance(int unitType, Pilot p) {
        if (p.getSkills().has(this)) {
            return 0;
        }
        if (unitType != 0) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        SHouse house = CampaignMain.cm.getHouseFromPartialString(p.getCurrentFaction());
        if (house == null) {
            return CampaignMain.cm.getIntegerConfig(chance);
        }
        return Integer.parseInt(house.getConfig(chance));
    }
}

