/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import java.util.Iterator;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.pilot.skills.SPilotSkill;

public class PainResistanceSkill
extends SPilotSkill {
    public PainResistanceSkill() {
    }

    public PainResistanceSkill(int id) {
        super(id, "Pain Resistance", "PR");
        this.setDescription("When making consciousness rolls, 1 is added to all rolls. Also, damage received from ammo explosions is reduced to 1. Note: This ability is only used for BattleMechs.");
    }

    public void modifyPilot(Pilot p) {
        super.addToPilot(p);
        p.addMegamekOption(new MegaMekPilotOption("pain_resistance", true));
        p.setBvMod(p.getBVMod() + 0.01);
    }

    public int getChance(int unitType, Pilot p) {
        if (p.getSkills().has(this)) {
            return 0;
        }
        if (unitType != 0) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        SHouse house = CampaignMain.cm.getHouseFromPartialString(p.getCurrentFaction());
        if (house == null) {
            return CampaignMain.cm.getIntegerConfig(chance);
        }
        return Integer.parseInt(house.getConfig(chance));
    }

    public int getBVMod(Entity unit) {
        int amountOfAmmo = 0;
        int PainResistanceBVBaseMod = CampaignMain.cm.getIntegerConfig("PainResistanceBaseBVMod");
        for (Mounted ammoType : unit.getAmmo()) {
            AmmoType ammo;
            if (ammoType.getShotsLeft() <= 0 || (ammo = (AmmoType)ammoType.getType()).getAmmoType() == 6 || ammo.getAmmoType() == 22 || ammo.getAmmoType() == 21) continue;
            ++amountOfAmmo;
        }
        Iterator<Mounted> weaponsList = unit.getWeapons();
        while (weaponsList.hasNext()) {
            Mounted weapon = weaponsList.next();
            if (weapon.getName().indexOf("Gauss Rifle") == -1) continue;
            ++amountOfAmmo;
        }
        return amountOfAmmo * PainResistanceBVBaseMod;
    }
}

