/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.pilot.skills;

import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.Pilot;
import megamek.common.Entity;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.pilot.skills.SPilotSkill;

public class TacticalGeniusSkill
extends SPilotSkill {
    public TacticalGeniusSkill(int id) {
        super(id, "Tactical Genius", "TG");
        this.setDescription("A pilot who has a Tactical Genius may reroll their initiative once per turn.  The second roll must be accepted.");
    }

    public TacticalGeniusSkill() {
    }

    public int getChance(int unitType, Pilot pilot) {
        if (pilot.getSkills().has(this)) {
            return 0;
        }
        String chance = "chancefor" + this.getAbbreviation() + "for" + Unit.getTypeClassDesc(unitType);
        SHouse house = CampaignMain.cm.getHouseFromPartialString(pilot.getCurrentFaction());
        if (house == null) {
            return CampaignMain.cm.getIntegerConfig(chance);
        }
        return Integer.parseInt(house.getConfig(chance));
    }

    public void modifyPilot(Pilot pilot) {
        pilot.addMegamekOption(new MegaMekPilotOption("tactical_genius", true));
        pilot.setBvMod(pilot.getBVMod() + 0.02);
    }

    public int getBVMod(Entity unit) {
        return CampaignMain.cm.getIntegerConfig("TacticalGeniusBVMod");
    }
}

