/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import common.CampaignData;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusionList {
    public static final int NO_EXCLUSION = 0;
    public static final int PLAYER_EXCLUDED = 1;
    public static final int ADMIN_EXCLUDED = 2;
    private int maxSize = CampaignMain.cm.getIntegerConfig("NoPlayListSize");
    private boolean adminListCountsForCap = CampaignMain.cm.getBooleanConfig("NoPlaysFromAdminsCountForMax");
    private String owner = "";
    private Vector<String> playerExcludes = new Vector(this.maxSize, 1);
    private Vector<String> adminExcludes = new Vector(this.maxSize, 1);

    public void setOwnerName(String ownerName) {
        this.owner = ownerName;
    }

    public void addExclude(boolean fromAdmin, String name) {
        if (fromAdmin) {
            this.adminExcludes.add(name.toLowerCase());
        } else {
            this.playerExcludes.add(name.toLowerCase());
        }
    }

    public int checkExclude(String name) {
        if (this.playerExcludes.contains(name.toLowerCase())) {
            return 1;
        }
        if (this.adminExcludes.contains(name.toLowerCase())) {
            return 2;
        }
        return 0;
    }

    public void removeExclude(boolean fromAdmin, String name) {
        if (fromAdmin) {
            this.playerExcludes.remove(name.toLowerCase());
            this.adminExcludes.remove(name.toLowerCase());
        } else {
            this.playerExcludes.remove(name.toLowerCase());
        }
    }

    private void validateExcludes() {
        boolean playerExists;
        String currName;
        Iterator<String> e = this.adminExcludes.iterator();
        while (e.hasNext()) {
            currName = e.next();
            playerExists = false;
            playerExists = !CampaignMain.cm.isUsingMySQL() ? new File("./campaign/players/" + currName.toLowerCase() + ".dat").exists() : CampaignMain.cm.MySQL.playerExists(currName);
            if (playerExists) continue;
            e.remove();
            CampaignMain.cm.toUser(currName + " has left the campaign. No-Play list updated.", this.owner, true);
        }
        e = this.playerExcludes.iterator();
        while (e.hasNext()) {
            currName = e.next();
            playerExists = false;
            playerExists = !CampaignMain.cm.isUsingMySQL() ? new File("./campaign/players/" + currName.toLowerCase() + ".dat").exists() : CampaignMain.cm.MySQL.playerExists(currName);
            if (playerExists) continue;
            e.remove();
            CampaignMain.cm.toUser(currName + " has left the campaign. No-Play list updated.", this.owner, true);
        }
        if (this.playerExcludes.size() > this.maxSize) {
            int excludeSize = 0;
            for (excludeSize = this.adminListCountsForCap ? this.playerExcludes.size() + this.adminExcludes.size() : this.playerExcludes.size(); excludeSize > this.maxSize && this.playerExcludes.size() > 0; --excludeSize) {
                String currName2 = this.playerExcludes.get(this.playerExcludes.size() - 1);
                this.playerExcludes.remove(currName2);
                CampaignMain.cm.toUser("Your No-Play list was too long. " + currName2 + " was removed.", this.owner, true);
            }
        }
    }

    public Vector<String> getPlayerExcludes() {
        return this.playerExcludes;
    }

    public Vector<String> getAdminExcludes() {
        return this.adminExcludes;
    }

    public void adminExcludeFromString(String buffer, String delimiter) {
        StringTokenizer ST = new StringTokenizer(buffer, delimiter);
        while (ST.hasMoreElements()) {
            String curr = ST.nextToken();
            if (curr.equals("0")) {
                return;
            }
            this.addExclude(true, curr);
        }
    }

    public void playerExcludeFromString(String buffer, String delimiter) {
        StringTokenizer ST = new StringTokenizer(buffer, delimiter);
        while (ST.hasMoreElements()) {
            String curr = ST.nextToken();
            if (curr.equals("0")) {
                return;
            }
            this.addExclude(false, curr);
        }
        this.validateExcludes();
    }

    public String adminExcludeToString(String token) {
        StringBuilder result = new StringBuilder();
        if (this.adminExcludes.size() == 0) {
            result.append("0");
            result.append(token);
        } else {
            for (String currName : this.adminExcludes) {
                result.append(currName);
                result.append(token);
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromDB(int playerID) {
        Statement ps = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT * from noplay_lists WHERE player_id = " + playerID;
            ps = CampaignMain.cm.MySQL.getPreparedStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.addExclude(rs.getString("admin_exclude").equalsIgnoreCase("y"), rs.getString("np_name"));
            }
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in ExclusionList.fromDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                CampaignData.mwlog.dbLog("Exception in ExclusionList.fromDB: " + ex.getMessage());
                CampaignData.mwlog.dbLog(ex);
            }
        }
    }

    public String playerExcludeToString(String token) {
        StringBuilder result = new StringBuilder();
        if (this.playerExcludes.size() == 0) {
            result.append("0");
            result.append(token);
        } else {
            for (String currName : this.playerExcludes) {
                result.append(currName);
                result.append(token);
            }
        }
        return result.toString();
    }

    public void toDB(int playerID) {
        PreparedStatement ps = null;
        String sql = "";
        try {
            sql = "DELETE from noplay_lists where player_id = " + playerID;
            ps = CampaignMain.cm.MySQL.getPreparedStatement(sql);
            ps.executeUpdate(sql);
            ps.close();
            if (this.playerExcludes.size() > 0) {
                for (String currName : this.playerExcludes) {
                    sql = "REPLACE into noplay_lists set player_id = ?, np_name = ?, admin_exclude = 'n'";
                    ps = CampaignMain.cm.MySQL.getPreparedStatement(sql);
                    ps.setInt(1, playerID);
                    ps.setString(2, currName);
                    ps.executeUpdate();
                    ps.close();
                }
            }
            if (this.adminExcludes.size() > 0) {
                for (String currName : this.adminExcludes) {
                    sql = "INSERT into noplay_lists set player_id = ?, np_name = ?, admin_exclude = 'y'";
                    ps = CampaignMain.cm.MySQL.getPreparedStatement(sql);
                    ps.setInt(1, playerID);
                    ps.setString(2, currName);
                    ps.executeUpdate();
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in ExclusionList.toDB: " + e.getMessage());
            CampaignData.mwlog.dbLog("  -> " + sql);
            if (ps != null) {
                CampaignData.mwlog.dbLog("    -> " + ps.toString());
            }
            CampaignData.mwlog.dbLog(e);
        }
    }
}

