/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import common.CampaignData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MechStatistics
implements Cloneable,
Comparable<Object> {
    private Long ID;
    private String mechFileName;
    private int mechSize;
    private int gamesWon = 0;
    private int gamesPlayed = 0;
    private int timesScrapped = 0;
    private long lastTimeUpdated = 0L;
    private int OriginalBV = 0;
    private int currentGamesWon = 0;
    private int currentGamesPlayed = 0;
    private int timesDestroyed = 0;
    private int DBID = 0;

    public String getMechFileName() {
        return this.mechFileName;
    }

    public void setMechFileName(String mechFileName) {
        this.mechFileName = mechFileName;
    }

    public String toString() {
        String result = "";
        result = result + this.mechFileName;
        result = result + "*";
        result = result + this.mechSize;
        result = result + "*";
        result = result + this.gamesWon;
        result = result + "*";
        result = result + this.gamesPlayed;
        result = result + "*";
        result = result + this.timesScrapped;
        result = result + "*";
        result = result + this.lastTimeUpdated;
        result = result + "*";
        result = result + this.currentGamesWon;
        result = result + "*";
        result = result + this.currentGamesPlayed;
        result = result + "*";
        result = result + this.OriginalBV;
        result = result + "*";
        result = result + this.timesDestroyed;
        return result;
    }

    public int getDBId() {
        return this.DBID;
    }

    public void setDBId(int ID) {
        this.DBID = ID;
    }

    public void fromDB(int id) {
        ResultSet rs = null;
        try {
            Statement stmt = CampaignMain.cm.MySQL.getStatement();
            rs = stmt.executeQuery("SELECT * from mechstats WHERE ID = " + id);
            if (rs.next()) {
                this.mechFileName = rs.getString("mechFileName");
                this.mechSize = rs.getInt("mechSize");
                this.gamesWon = rs.getInt("gamesWon");
                this.gamesPlayed = rs.getInt("gamesPlayed");
                this.timesScrapped = rs.getInt("timesScrapped");
                this.lastTimeUpdated = rs.getLong("lastTimeUpdated");
                this.currentGamesWon = rs.getInt("currentGamesWon");
                this.currentGamesPlayed = rs.getInt("currentGamesPlayed");
                this.OriginalBV = rs.getInt("originalBV");
                this.timesDestroyed = rs.getInt("timesDestroyed");
                this.setDBId(id);
                rs.close();
                stmt.close();
            }
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in MechStatistics.fromDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void toDB() {
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        if (this.getDBId() == 0) {
            sql.append("INSERT into mechstats set ");
            sql.append("mechFileName = ?, ");
            sql.append("mechSize = ?, ");
            sql.append("gamesWon = ?, ");
            sql.append("gamesPlayed = ?, ");
            sql.append("timesScrapped = ?, ");
            sql.append("currentGamesWon = ?, ");
            sql.append("currentGamesPlayed = ?, ");
            sql.append("originalBV = ?, ");
            sql.append("timesDestroyed = ?, ");
            sql.append("lastTimeUpdated = ?");
            try {
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString(), 1);
                ps.setString(1, this.mechFileName);
                ps.setInt(2, this.mechSize);
                ps.setInt(3, this.gamesWon);
                ps.setInt(4, this.gamesPlayed);
                ps.setInt(5, this.timesScrapped);
                ps.setInt(6, this.currentGamesWon);
                ps.setInt(7, this.currentGamesPlayed);
                ps.setInt(8, this.OriginalBV);
                ps.setInt(9, this.timesDestroyed);
                ps.setLong(10, this.lastTimeUpdated);
                ps.executeUpdate();
                rs = ps.getGeneratedKeys();
                if (rs.next()) {
                    this.setDBId(rs.getInt(1));
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                CampaignData.mwlog.dbLog("SQLException in MechStatistics.toDB: " + e.getMessage());
                CampaignData.mwlog.dbLog(e);
            }
        } else {
            sql.append("UPDATE mechstats set ");
            sql.append("mechFileName = ?, ");
            sql.append("mechSize = ?, ");
            sql.append("gamesWon = ?, ");
            sql.append("gamesPlayed = ?, ");
            sql.append("timesScrapped = ?, ");
            sql.append("currentGamesWon = ?, ");
            sql.append("currentGamesPlayed = ?, ");
            sql.append("originalBV = ?, ");
            sql.append("timesDestroyed = ?, ");
            sql.append("lastTimeUpdated = ? ");
            sql.append("WHERE ID = ?");
            try {
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString());
                ps.setString(1, this.mechFileName);
                ps.setInt(2, this.mechSize);
                ps.setInt(3, this.gamesWon);
                ps.setInt(4, this.gamesPlayed);
                ps.setInt(5, this.timesScrapped);
                ps.setInt(6, this.currentGamesWon);
                ps.setInt(7, this.currentGamesPlayed);
                ps.setInt(8, this.OriginalBV);
                ps.setInt(9, this.timesDestroyed);
                ps.setLong(10, this.lastTimeUpdated);
                ps.setInt(11, this.getDBId());
                ps.executeUpdate();
                ps.close();
            }
            catch (SQLException e) {
                CampaignData.mwlog.dbLog("SQLException in MechStatistics.toDB: " + e.getMessage());
                CampaignData.mwlog.dbLog(e);
            }
        }
    }

    public MechStatistics() {
    }

    public MechStatistics(String Filename, int mechsize) {
        this.mechFileName = Filename;
        this.mechSize = mechsize;
        this.gamesPlayed = 0;
        this.gamesWon = 0;
        this.timesDestroyed = 0;
    }

    public MechStatistics(String s) {
        StringTokenizer ST = new StringTokenizer(s, "*");
        this.mechFileName = ST.nextToken();
        this.mechSize = Integer.parseInt(ST.nextToken());
        this.gamesWon = Integer.parseInt(ST.nextToken());
        this.gamesPlayed = Integer.parseInt(ST.nextToken());
        this.timesScrapped = Integer.parseInt(ST.nextToken());
        if (ST.hasMoreElements()) {
            this.lastTimeUpdated = Long.parseLong(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.currentGamesWon = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.currentGamesPlayed = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.OriginalBV = Integer.parseInt(ST.nextToken());
        }
        if (ST.hasMoreElements()) {
            this.timesDestroyed = Integer.parseInt(ST.nextToken());
        }
    }

    public MechStatistics(int id) {
        this.fromDB(id);
    }

    public int getBV() {
        int baseBV = 0;
        this.currentGamesPlayed = this.gamesPlayed;
        this.currentGamesWon = this.gamesWon;
        baseBV = this.getOriginalBV();
        return baseBV;
    }

    public String addStats(int gamesPlayed, int gamesWon, int originalBV) {
        String result = "";
        this.setGamesPlayed(this.getGamesPlayed() + gamesPlayed);
        this.setGamesWon(this.getGamesWon() + gamesWon);
        if (this.getOriginalBV() == 0) {
            this.setOriginalBV(originalBV);
        }
        return result;
    }

    @Override
    public int compareTo(Object o) {
        MechStatistics m = (MechStatistics)o;
        return this.getMechFileName().compareTo(m.getMechFileName());
    }

    public int getMechSize() {
        return this.mechSize;
    }

    public int getGamesPlayed() {
        return this.gamesPlayed;
    }

    public int getGamesWon() {
        return this.gamesWon;
    }

    public void setGamesPlayed(int gamesPlayed) {
        if (gamesPlayed != this.gamesPlayed) {
            this.lastTimeUpdated = System.currentTimeMillis();
        }
        this.gamesPlayed = gamesPlayed;
    }

    public void setGamesWon(int gamesWon) {
        this.gamesWon = gamesWon;
    }

    public int getTimesScrapped() {
        return this.timesScrapped;
    }

    public void setTimesScrapped(int timesScrapped) {
        this.timesScrapped = timesScrapped;
    }

    public int getTimesDestroyed() {
        return this.timesDestroyed;
    }

    public void setTimesDestroyed(int timesDestroyed) {
        this.timesDestroyed = timesDestroyed;
    }

    public long getLastTimeUpdated() {
        return this.lastTimeUpdated;
    }

    public void setLastTimeUpdated(long lastTimeUpdated) {
        this.lastTimeUpdated = lastTimeUpdated;
    }

    public Long getID() {
        return this.ID;
    }

    public void setID(Long id) {
        this.ID = id;
    }

    public void setMechSize(int mechSize) {
        this.mechSize = mechSize;
    }

    public int getOriginalBV() {
        if (this.OriginalBV == 0 && this.getMechFileName() != null) {
            this.OriginalBV = SUnit.loadMech(this.getMechFileName()).calculateBattleValue();
        }
        return this.OriginalBV;
    }

    public void setOriginalBV(int OriginalBV) {
        this.OriginalBV = OriginalBV;
    }

    public int getCurrentGamesPlayed() {
        return this.currentGamesPlayed;
    }

    public int getCurrentGamesWon() {
        return this.currentGamesWon;
    }

    public void setCurrentGamesWon(int currentGamesWon) {
        this.currentGamesWon = currentGamesWon;
    }

    public void setCurrentGamesPlayed(int currentGamesPlayed) {
        this.currentGamesPlayed = currentGamesPlayed;
    }
}

