/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import common.CampaignData;
import common.House;
import common.util.StringUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;

public class OpponentListHelper {
    private SPlayer searchPlayer;
    private TreeMap<String, ArrayList<SArmy>> potentialOpponents;
    private int currentMode = -1;
    public static final int MODE_ADD = 0;
    public static final int MODE_REMOVE = 1;

    public OpponentListHelper(SPlayer p, int mode) {
        this.searchPlayer = p;
        this.potentialOpponents = new TreeMap();
        this.currentMode = mode;
        if (mode == 0) {
            this.getOpponentsForAll();
        }
        if (mode == 1) {
            this.removeOpponentsForAll();
        }
    }

    private void getOpponentsForAll() {
        SHouse searchHouse = this.searchPlayer.getHouseFightingFor();
        for (House h : CampaignMain.cm.getData().getAllHouses()) {
            SHouse currHouse = (SHouse)h;
            for (SPlayer currPlayer : currHouse.getActivePlayers().values()) {
                if (this.searchPlayer.equals(currPlayer) || CampaignMain.cm.getIThread().isImmune(currPlayer) || currPlayer.getArmies().size() == 0 || currPlayer.getExclusionList().checkExclude(this.searchPlayer.getName()) != 0 || this.searchPlayer.getExclusionList().checkExclude(currPlayer.getName()) != 0) continue;
                if (CampaignMain.cm.getBooleanConfig("IPCheck")) {
                    try {
                        String p1 = CampaignMain.cm.getServer().getIP(this.searchPlayer.getName()).toString();
                        String p2 = CampaignMain.cm.getServer().getIP(currPlayer.getName()).toString();
                        if (p1.equals(p2)) {
                            continue;
                        }
                    }
                    catch (Exception e) {
                        CampaignData.mwlog.errLog("Exception while checking players' IPs in OLH.");
                        CampaignData.mwlog.errLog(e);
                    }
                }
                ArrayList<SArmy> possDefendArmies = new ArrayList<SArmy>();
                OperationManager manager = CampaignMain.cm.getOpsManager();
                for (SArmy searchArmy : this.searchPlayer.getArmies()) {
                    block5: for (SArmy enemyArmy : currPlayer.getArmies()) {
                        if (searchArmy.isDisabled()) continue;
                        for (String attack : searchArmy.getLegalOperations().keySet()) {
                            Operation o = manager.getOperation(attack);
                            if (currHouse.equals(searchHouse) && !o.getBooleanValue("AllowInFaction") || !searchArmy.matches(enemyArmy, o) || enemyArmy.isDisabled()) continue;
                            searchArmy.addOpponent(enemyArmy);
                            enemyArmy.addOpponent(searchArmy);
                            if (possDefendArmies.contains(enemyArmy)) continue block5;
                            possDefendArmies.add(enemyArmy);
                            continue block5;
                        }
                    }
                }
                if (possDefendArmies.size() == 0) continue;
                ArrayList<SArmy> toStore = new ArrayList<SArmy>();
                block7: for (SArmy currArmy : possDefendArmies) {
                    for (int j = 0; j < toStore.size(); ++j) {
                        if (currArmy.getID() >= ((SArmy)toStore.get(j)).getID()) continue;
                        toStore.add(j, currArmy);
                        continue block7;
                    }
                    toStore.add(currArmy);
                }
                this.potentialOpponents.put(currPlayer.getName(), toStore);
            }
        }
    }

    private void removeOpponentsForAll() {
        for (SArmy currArmy : this.searchPlayer.getArmies()) {
            Enumeration<SArmy> j = currArmy.getOpponents().elements();
            while (j.hasMoreElements()) {
                SArmy oppArmy = j.nextElement();
                oppArmy.removeOpponent(currArmy);
                String currName = oppArmy.getPlayerName().toLowerCase();
                if (this.potentialOpponents.get(currName) != null) continue;
                this.potentialOpponents.put(currName, new ArrayList());
            }
            currArmy.setOpponents(new Vector<SArmy>(1, 1));
        }
    }

    public void sendInfoToOpponents(String s) {
        for (String currOppName : this.potentialOpponents.keySet()) {
            StringBuilder output = new StringBuilder("ED:[!] ");
            SPlayer currOpp = CampaignMain.cm.getPlayer(currOppName);
            if (currOpp == null) continue;
            long minActiveTime = Long.parseLong(CampaignMain.cm.getConfig("MinActiveTime")) * 1000L;
            if (System.currentTimeMillis() - currOpp.getActiveSince() <= minActiveTime) continue;
            SHouse searchHouse = this.searchPlayer.getHouseFightingFor();
            String colHouseName = searchHouse.getColoredNameAsLink();
            output.append(StringUtils.aOrAn(searchHouse.getName(), false, false) + " " + colHouseName + " unit " + s);
            if (this.currentMode == 0) {
                ArrayList<SArmy> currOppArmies = this.potentialOpponents.get(currOppName);
                if (currOppArmies.size() > 1) {
                    output.append("Armies ");
                    Iterator<SArmy> i = currOppArmies.iterator();
                    while (i.hasNext()) {
                        output.append(i.next().getID());
                        if (!i.hasNext()) continue;
                        output.append(", ");
                    }
                    int lastComma = output.lastIndexOf(", ");
                    if (lastComma >= 0) {
                        String front = output.substring(0, lastComma);
                        String back = output.substring(lastComma + 2, output.length());
                        output = new StringBuilder(front + " and " + back);
                    }
                } else {
                    SArmy currArmy = currOppArmies.get(0);
                    output.append("Army " + currArmy.getID());
                }
            }
            output.append(". [<a href=\"MEKWARS/c checkattack\">Report</a>]");
            CampaignMain.cm.toUser(output.toString(), currOppName, true);
        }
    }
}

