/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import common.CampaignData;
import common.House;
import common.Unit;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SmallPlayer;
import server.campaign.util.EXPRankingContainer;
import server.campaign.util.HouseRankingHelpContainer;
import server.campaign.util.MechStatistics;

public class Statistics {
    public static String doGetMechStats(int size) {
        TreeSet<MechStatistics> Sorted = new TreeSet<MechStatistics>();
        Enumeration<MechStatistics> e = CampaignMain.cm.getMechStats().elements();
        while (e.hasMoreElements()) {
            MechStatistics m = e.nextElement();
            if (m.getMechSize() != size) continue;
            Sorted.add(m);
        }
        boolean color = false;
        Iterator i = Sorted.iterator();
        StringBuilder result = new StringBuilder();
        result.append("<h2>" + Unit.getWeightClassDesc(size) + " Units</h2>");
        result.append("<table cellpadding=\"3\" cellspacing=\"0\"><tr bgcolor=\"#0066FF\"><th><font color=\"#FFFFFF\">MekName</th><th><font color=\"#FFFFFF\">Games Played</th><th><font color=\"#FFFFFF\">Games Won</th><th><font color=\"#FFFFFF\">Times Destroyed</th><th><font color=\"#FFFFFF\">Times Scrapped</th><th width=\"50\" align=\"center\"><font color=\"#FFFFFF\">BV</th></font><th><font color=\"#FFFFFF\">Last Used</font></th></tr>");
        while (i.hasNext()) {
            MechStatistics m = (MechStatistics)i.next();
            if (color) {
                result.append("<tr class=\"trcolored\"><td>");
            } else {
                result.append("<tr class=\"truncolored\"><td>");
            }
            color = !color;
            result.append("<center>");
            result.append(m.getMechFileName());
            result.append("</td><td>");
            result.append(m.getGamesPlayed());
            result.append("</td><td>");
            result.append(m.getGamesWon());
            result.append("</td><td>");
            result.append(m.getTimesDestroyed());
            result.append("</td><td>");
            result.append(m.getTimesScrapped());
            result.append("</td><td>");
            result.append(m.getOriginalBV());
            result.append("</td><td align=\"right\">");
            if (m.getLastTimeUpdated() > 0L) {
                result.append(CampaignMain.readableTime(System.currentTimeMillis() - m.getLastTimeUpdated()));
            } else {
                result.append("unknown");
            }
            result.append("</td></tr>\n\r");
        }
        result.append("</table>");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doRanking() {
        if (CampaignMain.cm.isUsingMySQL()) {
            return;
        }
        try {
            Object p;
            Hashtable<String, SmallPlayer> allplayers;
            StringBuilder result = new StringBuilder();
            result.append("<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"format.css\"><style type=\"text/css\"></style></head><body><font face=\"Verdana, Arial, Helvetica, sans-serif\">");
            result.append("<h2>Player Ranking:</h2><p>");
            Iterator<House> e = CampaignMain.cm.getData().getAllHouses().iterator();
            Hashtable<String, SmallPlayer> hashtable = allplayers = new Hashtable<String, SmallPlayer>();
            synchronized (hashtable) {
                while (e.hasNext()) {
                    SHouse h = (SHouse)e.next();
                    if (h.isNewbieHouse()) continue;
                    allplayers.putAll(h.getSmallPlayers());
                }
            }
            TreeSet Sorted = new TreeSet(allplayers.values());
            Iterator i = Sorted.iterator();
            Vector v = new Vector(1, 1);
            boolean color = false;
            while (i.hasNext()) {
                v.add(i.next());
            }
            result.append("<table cellpadding=\"3\" cellspacing=\"0\"><tr bgcolor=\"#0066FF\"><th><font color=\"#FFFFFF\">Rank</font></th><th><font color=\"#FFFFFF\">Name</th><th><font color=\"#FFFFFF\">Rating</th><th><font color=\"#FFFFFF\">House</th><th><font color=\"#FFFFFF\">House Rank</th><th><font color=\"#FFFFFF\">Comment</th></tr>");
            int rank = 1;
            for (int j = v.size() - 1; j >= 0; --j) {
                p = (SmallPlayer)v.elementAt(j);
                try {
                    if (color) {
                        result.append("<tr class=\"trcolored\">");
                    } else {
                        result.append("<tr class=\"truncolored\">");
                    }
                    color = !color;
                    result.append("<td>" + rank + "</td>");
                    result.append("<td>" + ((SmallPlayer)p).getName() + "</td>");
                    if (CampaignMain.cm.getBooleanConfig("HideELO")) {
                        result.append("<td> -- </td>");
                    } else {
                        result.append("<td>" + ((SmallPlayer)p).getRatingRounded() + "</td>");
                    }
                    result.append("<td>" + ((SmallPlayer)p).getMyHouse().getColoredName() + "</td>");
                    if (((SmallPlayer)p).getFluffText().equals("0")) {
                        result.append("<td> </td>");
                    } else {
                        result.append("<td>" + ((SmallPlayer)p).getFluffText() + "</td>");
                    }
                    result.append("</tr>");
                    ++rank;
                    continue;
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("Error while Referencing player: " + ((SmallPlayer)p).getName());
                    CampaignData.mwlog.errLog(ex);
                }
            }
            result.append("</table>");
            result.append("</body></html>");
            FileOutputStream out = new FileOutputStream(CampaignMain.cm.getConfig("RankingPath"));
            p = new PrintStream(out);
            ((PrintStream)p).println(result.toString());
            ((PrintStream)p).close();
            out.close();
            Statistics.doEXPRanking();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public static void doEXPRanking() {
        Object p;
        StringBuilder result = new StringBuilder();
        result.append("<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"format.css\"><style type=\"text/css\"></style></head><body><font face=\"Verdana, Arial, Helvetica, sans-serif\">");
        result.append("<h2>Player Ranking:</h2><p>");
        Iterator<House> e = CampaignMain.cm.getData().getAllHouses().iterator();
        Hashtable<String, EXPRankingContainer> allplayers = new Hashtable<String, EXPRankingContainer>();
        while (e.hasNext()) {
            SHouse h = (SHouse)e.next();
            if (h.isNewbieHouse()) continue;
            Enumeration<SmallPlayer> en = h.getSmallPlayers().elements();
            while (en.hasMoreElements()) {
                EXPRankingContainer EXPRankPlayer = new EXPRankingContainer(en.nextElement());
                allplayers.put(EXPRankPlayer.getName(), EXPRankPlayer);
            }
        }
        TreeSet Sorted = new TreeSet(allplayers.values());
        Iterator i = Sorted.iterator();
        Vector v = new Vector(1, 1);
        while (i.hasNext()) {
            v.add(i.next());
        }
        result.append("<table cellpadding=\"3\" cellspacing=\"0\"><tr bgcolor=\"#0066FF\"><th><font color=\"#FFFFFF\">Rank</font></th><th><font color=\"#FFFFFF\">Name</th><th><font color=\"#FFFFFF\">Experience</th><th><font color=\"#FFFFFF\">House</th><th><font color=\"#FFFFFF\">House Rank</th><th><font color=\"#FFFFFF\">Comment</th></tr>");
        int rank = 1;
        boolean color = false;
        for (int j = v.size() - 1; j > 0 && j >= v.size() - 1000; --j) {
            if (color) {
                result.append("<tr class=\"trcolored\">");
            } else {
                result.append("<tr class=\"truncolored\">");
            }
            color = !color;
            p = (EXPRankingContainer)v.elementAt(j);
            result.append("<td>" + rank + "</td>");
            result.append("<td>" + ((EXPRankingContainer)p).getName() + "</td>");
            result.append("<td>" + ((EXPRankingContainer)p).getExperience() + "</td>");
            result.append("<td>" + ((EXPRankingContainer)p).getMyHouse().getColoredName() + "</td>");
            if (((EXPRankingContainer)p).getFluffText().equals("0")) {
                result.append("<td> </td>");
            } else {
                result.append("<td>" + ((EXPRankingContainer)p).getFluffText() + "</td>");
            }
            result.append("</tr>");
            ++rank;
        }
        result.append("</table>");
        result.append("</body></html>");
        try {
            FileOutputStream out = new FileOutputStream(CampaignMain.cm.getConfig("EXPRankingPath"));
            p = new PrintStream(out);
            ((PrintStream)p).println(result.toString());
            ((PrintStream)p).close();
            out.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static String getReadableHouseRanking(boolean useHTML) {
        String result = "";
        result = useHTML ? result + "<b><i>Faction Ranking: </i><br>" : result + "Faction Ranking: ";
        TreeSet<HouseRankingHelpContainer> s = CampaignMain.cm.getHouseRanking();
        if (s.size() < 1) {
            return "";
        }
        for (HouseRankingHelpContainer h : s) {
            result = useHTML ? result + h.getHouse().getColoredNameAsLink() + " (" : result + h.getHouse().getName() + " (";
            int diff = h.getAmount() - h.getHouse().getInitialHouseRanking();
            result = diff > 0 ? result + "+" + diff : result + diff;
            result = result + "/" + h.getAmount() + "), ";
        }
        int sendLength = result.lastIndexOf(",");
        result = result.substring(0, sendLength) + ".";
        if (useHTML) {
            result = result + "</b>";
        }
        return result;
    }
}

