/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import common.CampaignData;
import gd.xml.ParseException;
import gd.xml.XMLParser;
import gd.xml.XMLResponder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import server.campaign.NewbieHouse;
import server.campaign.SHouse;
import server.campaign.mercenaries.MercHouse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFactionDataParser
implements XMLResponder {
    String lastElement = "";
    String lastInfFaction = "";
    String Name = null;
    String Color = "#00FF00";
    String Abbreviation = null;
    String Logo = null;
    String houseColor = "#000000";
    int Money = 0;
    int BaseGunner = 4;
    int BasePilot = 5;
    int idcounter = 0;
    boolean isMercenary = false;
    boolean canConquer = true;
    boolean inHouseAttacks = false;
    boolean canDefectFrom = true;
    boolean canDefectTo = true;
    boolean isNewbie = false;
    Vector<SHouse> Factions = new Vector(1, 1);
    private String Filename;
    private String prefix;

    public XMLFactionDataParser(String Filename) {
        this.Filename = Filename;
        try {
            XMLParser xp = new XMLParser();
            xp.parseXML((XMLResponder)this);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void endElement(String uri, String localName, String rawName) {
        if (rawName.equalsIgnoreCase("FACTION")) {
            // empty if block
        }
    }

    public Vector<SHouse> getFactions() {
        return this.Factions;
    }

    public void recordNotationDeclaration(String name, String pubID, String sysID) throws ParseException {
        System.out.print(this.prefix + "!NOTATION: " + name);
        if (pubID != null) {
            System.out.print("  pubID = " + pubID);
        }
        if (sysID != null) {
            System.out.print("  sysID = " + sysID);
        }
        CampaignData.mwlog.mainLog("");
    }

    public void recordEntityDeclaration(String name, String value, String pubID, String sysID, String notation) throws ParseException {
        System.out.print(this.prefix + "!ENTITY: " + name);
        if (value != null) {
            System.out.print("  value = " + value);
        }
        if (pubID != null) {
            System.out.print("  pubID = " + pubID);
        }
        if (sysID != null) {
            System.out.print("  sysID = " + sysID);
        }
        if (notation != null) {
            System.out.print("  notation = " + notation);
        }
        CampaignData.mwlog.mainLog("");
    }

    public void recordElementDeclaration(String name, String content) throws ParseException {
        System.out.print(this.prefix + "!ELEMENT: " + name);
        CampaignData.mwlog.mainLog("  content = " + content);
    }

    public void recordAttlistDeclaration(String element, String attr, boolean notation, String type, String defmod, String def) throws ParseException {
        System.out.print(this.prefix + "!ATTLIST: " + element);
        System.out.print("  attr = " + attr);
        System.out.print("  type = " + (notation ? "NOTATIONS " : "") + type);
        System.out.print("  def. modifier = " + defmod);
        CampaignData.mwlog.mainLog(def == null ? "" : "  def = " + notation);
    }

    public void recordDoctypeDeclaration(String name, String pubID, String sysID) throws ParseException {
        System.out.print(this.prefix + "!DOCTYPE: " + name);
        if (pubID != null) {
            System.out.print("  pubID = " + pubID);
        }
        if (sysID != null) {
            System.out.print("  sysID = " + sysID);
        }
        CampaignData.mwlog.mainLog("");
        this.prefix = "";
    }

    public void recordDocStart() {
    }

    public void recordDocEnd() {
        CampaignData.mwlog.mainLog("");
        CampaignData.mwlog.mainLog("Faction Parsing finished without error");
    }

    public void recordElementStart(String name, Hashtable attr) throws ParseException {
        CampaignData.mwlog.mainLog(this.prefix + "Element: " + name);
        this.lastElement = name;
    }

    public void recordElementEnd(String name) throws ParseException {
        if (name.equalsIgnoreCase("FACTION")) {
            CampaignData.mwlog.mainLog("FACTION READ");
            ++this.idcounter;
            SHouse h = this.isMercenary ? new MercHouse(this.idcounter, this.Name, this.Color, this.BaseGunner, this.BasePilot, this.Abbreviation) : (this.isNewbie ? new NewbieHouse(this.idcounter, this.Name, this.Color, this.BaseGunner, this.BasePilot, this.Abbreviation) : new SHouse(this.idcounter, this.Name, this.Color, this.BaseGunner, this.BasePilot, this.Abbreviation));
            if (this.Logo != null) {
                h.setLogo(this.Logo);
            }
            h.setInHouseAttacks(this.inHouseAttacks);
            h.setConquerable(this.canConquer);
            h.setHousePlayerColors(this.houseColor);
            this.Name = null;
            this.Money = 0;
            this.Color = "#00FF00";
            this.isMercenary = false;
            this.isNewbie = false;
            this.Abbreviation = null;
            this.Logo = null;
            this.BaseGunner = 4;
            this.BasePilot = 5;
            this.canConquer = true;
            this.inHouseAttacks = false;
            this.canDefectFrom = true;
            this.canDefectTo = true;
            this.houseColor = "#000000";
            this.Factions.add(h);
        }
    }

    public void recordPI(String name, String pValue) {
        CampaignData.mwlog.mainLog(this.prefix + "*" + name + " PI: " + pValue);
    }

    public void recordCharData(String charData) {
        CampaignData.mwlog.mainLog(this.prefix + charData);
        if (!charData.equalsIgnoreCase("")) {
            CampaignData.mwlog.mainLog(this.lastElement + " --> " + charData);
        } else {
            this.lastElement = "";
        }
        if (this.lastElement.equalsIgnoreCase("NAME")) {
            this.Name = charData;
        } else if (this.lastElement.equalsIgnoreCase("MONEY")) {
            this.Money = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("COLOR")) {
            this.Color = charData;
        } else if (this.lastElement.equalsIgnoreCase("ABBREVIATION")) {
            this.Abbreviation = charData;
        } else if (this.lastElement.equalsIgnoreCase("LOGO")) {
            this.Logo = charData;
        } else if (this.lastElement.equalsIgnoreCase("BASEGUNNER")) {
            this.BaseGunner = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("BASEPILOT")) {
            this.BasePilot = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("ISMERCENARY")) {
            this.isMercenary = new Boolean(charData);
        } else if (this.lastElement.equalsIgnoreCase("CONQUERABLE")) {
            this.canConquer = new Boolean(charData);
        } else if (this.lastElement.equalsIgnoreCase("INHOUSEATTACKS")) {
            this.inHouseAttacks = new Boolean(charData);
        } else if (this.lastElement.equalsIgnoreCase("HOUSEPLAYERCOLOR")) {
            this.houseColor = charData;
        } else if (this.lastElement.equalsIgnoreCase("DEFECTTO")) {
            this.canDefectTo = Boolean.parseBoolean(charData);
        } else if (this.lastElement.equalsIgnoreCase("DEFECTFROM")) {
            this.canDefectFrom = Boolean.parseBoolean(charData);
        } else if (this.lastElement.equalsIgnoreCase("ISNEWBIE")) {
            this.isNewbie = Boolean.parseBoolean(charData);
        }
    }

    public void recordComment(String comment) {
        CampaignData.mwlog.mainLog(this.prefix + "*Comment: " + comment);
    }

    public InputStream getDocumentStream() throws ParseException {
        try {
            return new FileInputStream(this.Filename);
        }
        catch (FileNotFoundException e) {
            throw new ParseException("could not find the specified file");
        }
    }

    public InputStream resolveExternalEntity(String name, String pubID, String sysID) throws ParseException {
        if (sysID != null) {
            File f = new File(new File(this.Filename).getParent(), sysID);
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new ParseException("file not found (" + f + ")");
            }
        }
        return null;
    }

    public InputStream resolveDTDEntity(String name, String pubID, String sysID) throws ParseException {
        return this.resolveExternalEntity(name, pubID, sysID);
    }
}

