/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.util;

import common.AdvancedTerrain;
import common.CampaignData;
import common.Continent;
import common.Influences;
import common.PlanetEnvironments;
import common.UnitFactory;
import gd.xml.ParseException;
import gd.xml.XMLParser;
import gd.xml.XMLResponder;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SUnitFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPlanetDataParser
implements XMLResponder {
    String lastElement = "";
    String lastInfFaction = "";
    String Name = "";
    String MFName = null;
    String MFSize = null;
    String MFFounder = null;
    String XCood = null;
    String YCood = null;
    int Income;
    int MFTicksUntilRefresh = 0;
    int MFRefreshSpeed = 100;
    int Type = 0;
    String buildTableFolder = "0";
    int accessLevel = 0;
    HashMap<Integer, Integer> Influence = new HashMap();
    Vector<SPlanet> planets = new Vector(1, 1);
    Vector<UnitFactory> unitFactories = new Vector(1, 1);
    private String filename;
    private String prefix;
    private String Description = "";
    private PlanetEnvironments PlanEnv = new PlanetEnvironments();
    private AdvancedTerrain AdvTerr = null;
    public TreeMap<Integer, AdvancedTerrain> AdvTerrTreeMap = new TreeMap();
    private TreeMap<String, String> OpFlags = new TreeMap();
    boolean conquerable = true;
    private int counter = 1;
    int xmap = 1;
    int ymap = 1;
    int xboard = 16;
    int yboard = 17;
    int lowtemp = 25;
    int hitemp = 25;
    double gravity = 1.0;
    boolean vacuum = false;
    int nightchance = 0;
    int nightmod = 0;
    int minVisibility = 100;
    int maxVisibility = 100;
    int blizzardChance = 0;
    int blowingSandChance = 0;
    int heavySnowfallChance = 0;
    int lightRainfallChance = 0;
    int heavyRainfallChance = 0;
    int moderateWindsChance = 0;
    int highWindsChance = 0;
    boolean map = false;
    String mapname = "";
    String aterrainName = "";
    int CompProduction = 0;
    int Warehousesize = 0;
    boolean inWarehouse = false;
    boolean inContinent = false;
    boolean hasAdvancedTerrain = false;
    int terrainProb = 0;
    String terrainName = "";
    String OriginalOwner = CampaignMain.cm.getConfig("NewbieHouseName");
    String OpFlag = "";
    String OpName = "";
    boolean isHomeWorld = false;
    boolean singlePlayerFactions = CampaignMain.cm.getBooleanConfig("AllowSinglePlayerFactions");

    public XMLPlanetDataParser(String filename) {
        this.filename = filename;
        try {
            XMLParser xp = new XMLParser();
            xp.parseXML((XMLResponder)this);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public Vector<SPlanet> getPlanets() {
        return this.planets;
    }

    public void recordNotationDeclaration(String name, String pubID, String sysID) throws ParseException {
        System.out.print(this.prefix + "!NOTATION: " + name);
        if (sysID != null) {
            System.out.print("  sysID = " + sysID);
        }
        CampaignData.mwlog.mainLog("");
    }

    public void recordEntityDeclaration(String name, String value, String pubID, String sysID, String notation) throws ParseException {
        System.out.print(this.prefix + "!ENTITY: " + name);
        if (value != null) {
            System.out.print("  value = " + value);
        }
        if (pubID != null) {
            System.out.print("  pubID = " + pubID);
        }
        if (sysID != null) {
            System.out.print("  sysID = " + sysID);
        }
        if (notation != null) {
            System.out.print("  notation = " + notation);
        }
        CampaignData.mwlog.mainLog("");
    }

    public void recordElementDeclaration(String name, String content) throws ParseException {
        System.out.print(this.prefix + "!ELEMENT: " + name);
        CampaignData.mwlog.mainLog("  content = " + content);
    }

    public void recordAttlistDeclaration(String element, String attr, boolean notation, String type, String defmod, String def) throws ParseException {
        System.out.print(this.prefix + "!ATTLIST: " + element);
        System.out.print("  attr = " + attr);
        System.out.print("  type = " + (notation ? "NOTATIONS " : "") + type);
        System.out.print("  def. modifier = " + defmod);
        CampaignData.mwlog.mainLog(def == null ? "" : "  def = " + notation);
    }

    public void recordDoctypeDeclaration(String name, String pubID, String sysID) throws ParseException {
        System.out.print(this.prefix + "!DOCTYPE: " + name);
        if (pubID != null) {
            System.out.print("  pubID = " + pubID);
        }
        if (sysID != null) {
            System.out.print("  sysID = " + sysID);
        }
        CampaignData.mwlog.mainLog("");
        this.prefix = "";
    }

    public void recordDocStart() {
    }

    public void recordDocEnd() {
        CampaignData.mwlog.mainLog("");
        CampaignData.mwlog.mainLog("Planet Parsing finished without error");
    }

    public void recordElementStart(String name, Hashtable attr) throws ParseException {
        this.lastElement = name;
        if (name.equalsIgnoreCase("WAREHOUSE")) {
            this.inWarehouse = true;
        }
        if (name.equalsIgnoreCase("CONTINENT")) {
            this.inContinent = true;
        }
        if (name.equalsIgnoreCase("ADVANCETERRAIN")) {
            this.hasAdvancedTerrain = true;
            this.AdvTerr = new AdvancedTerrain();
            if (!CampaignMain.cm.getBooleanConfig("UseStaticMaps")) {
                CampaignMain.cm.getConfig().setProperty("UseStaticMaps", "true");
                CampaignMain.cm.saveConfigureFile(CampaignMain.cm.getConfig(), CampaignMain.cm.getServer().getConfigParam("CAMPAIGNCONFIG"));
            }
        }
    }

    public void recordElementEnd(String name) throws ParseException {
        if (name.equalsIgnoreCase("TIMEZONE")) {
            CampaignData.mwlog.errLog("planets.xml contains TIMEZONE field. No longer necessary!");
        }
        if (name.equalsIgnoreCase("UNITFACTORY") && this.MFName != null && this.MFFounder != null && this.MFSize != null) {
            SUnitFactory mf = new SUnitFactory(this.MFName, null, this.MFSize, this.MFFounder, this.MFTicksUntilRefresh, this.MFRefreshSpeed, this.Type, this.buildTableFolder, this.accessLevel);
            this.unitFactories.add(mf);
            this.MFName = null;
            this.MFSize = null;
            this.MFFounder = null;
            this.MFTicksUntilRefresh = 0;
            this.MFRefreshSpeed = 100;
            this.Type = 0;
            this.buildTableFolder = "0";
            this.accessLevel = 0;
        }
        if (name.equalsIgnoreCase("CONTINENT")) {
            Continent cont = new Continent(this.terrainProb, CampaignMain.cm.getData().getTerrainByName(this.terrainName));
            this.PlanEnv.add(cont);
            this.terrainProb = 0;
            this.terrainName = "";
            this.inContinent = false;
            if (this.hasAdvancedTerrain) {
                this.AdvTerrTreeMap.put(cont.getEnvironment().getId(), this.AdvTerr);
            }
        }
        if (name.equalsIgnoreCase("ADVANCETERRAIN")) {
            this.AdvTerr.setDisplayName(this.aterrainName);
            this.AdvTerr.setGravity(this.gravity);
            this.AdvTerr.setHighTemp(this.hitemp);
            this.AdvTerr.setLowTemp(this.lowtemp);
            this.AdvTerr.setStaticMap(this.map);
            this.AdvTerr.setStaticMapName(this.mapname);
            this.AdvTerr.setXBoardSize(this.xboard);
            this.AdvTerr.setXSize(this.xmap);
            this.AdvTerr.setNightChance(this.nightchance);
            this.AdvTerr.setNightTempMod(this.nightmod);
            this.AdvTerr.setYBoardSize(this.yboard);
            this.AdvTerr.setYSize(this.ymap);
            this.AdvTerr.setHeavySnowfallChance(this.heavySnowfallChance);
            this.AdvTerr.setLightRainfallChance(this.lightRainfallChance);
            this.AdvTerr.setHeavyRainfallChance(this.heavyRainfallChance);
            this.AdvTerr.setModerateWindsChance(this.moderateWindsChance);
        }
        if (name.equalsIgnoreCase("OPNAME")) {
            this.OpFlags.put(this.OpFlag, this.OpName);
            this.OpFlag = "";
            this.OpName = "";
        }
        if (name.equalsIgnoreCase("PLANET")) {
            CampaignData.mwlog.mainLog("PLANET READ");
            SPlanet p = new SPlanet(this.counter++, this.Name, null, this.Income, this.CompProduction, Double.parseDouble(this.XCood), Double.parseDouble(this.YCood));
            for (int i = 0; i < this.unitFactories.size(); ++i) {
                SUnitFactory MF = (SUnitFactory)this.unitFactories.get(i);
                MF.setPlanet(p);
            }
            p.setUnitFactories(this.unitFactories);
            p.setEnvironments(this.PlanEnv);
            p.setDescription(this.Description);
            p.setBaysProvided(this.Warehousesize);
            CampaignData.mwlog.mainLog("Influence: " + this.Influence);
            p.setInfluence(new Influences(this.Influence));
            p.setConquerable(this.conquerable);
            p.setMapSize(new Dimension(this.xmap, this.ymap));
            p.setBoardSize(new Dimension(this.xboard, this.yboard));
            p.setTemp(new Dimension(this.lowtemp, this.hitemp));
            p.setGravity(this.gravity);
            p.setVacuum(this.vacuum);
            p.setOwner(null, p.checkOwner(), false);
            if (this.hasAdvancedTerrain) {
                p.getAdvancedTerrain().putAll(this.AdvTerrTreeMap);
            }
            if (this.singlePlayerFactions && !this.OriginalOwner.equalsIgnoreCase(CampaignMain.cm.getConfig("NewbieHouseName"))) {
                p.setOriginalOwner("None");
            } else {
                p.setOriginalOwner(this.OriginalOwner);
            }
            p.setPlanetFlags(this.OpFlags);
            p.setHomeWorld(this.isHomeWorld);
            this.planets.add(p);
            this.conquerable = true;
            this.Name = null;
            this.Income = 0;
            this.XCood = null;
            this.YCood = null;
            this.Influence = new HashMap();
            this.OpFlags.clear();
            this.unitFactories = new Vector(1, 1);
            this.Description = "";
            this.PlanEnv = new PlanetEnvironments();
            this.Warehousesize = 0;
            this.CompProduction = 0;
            this.hasAdvancedTerrain = false;
            this.xboard = -1;
            this.yboard = -1;
            this.nightchance = 0;
            this.nightmod = 0;
            this.map = false;
            this.mapname = "";
            this.aterrainName = "";
            this.gravity = 1.0;
            this.vacuum = false;
            this.lowtemp = 25;
            this.hitemp = 25;
            this.ymap = -1;
            this.xmap = -1;
            this.isHomeWorld = false;
            this.minVisibility = 100;
            this.maxVisibility = 100;
            this.blizzardChance = 0;
            this.blowingSandChance = 0;
            this.heavySnowfallChance = 0;
            this.lightRainfallChance = 0;
            this.heavyRainfallChance = 0;
            this.moderateWindsChance = 0;
            this.highWindsChance = 0;
            this.OriginalOwner = CampaignMain.cm.getConfig("NewbieHouseName");
            this.AdvTerr = null;
            this.AdvTerrTreeMap.clear();
        }
        if (name.equalsIgnoreCase("WAREHOUSE")) {
            this.inWarehouse = false;
        }
    }

    public void recordPI(String name, String pValue) {
        CampaignData.mwlog.mainLog(this.prefix + "*" + name + " PI: " + pValue);
    }

    public void recordCharData(String charData) {
        CampaignData.mwlog.mainLog(this.prefix + charData);
        if (!charData.equalsIgnoreCase("")) {
            CampaignData.mwlog.mainLog(this.lastElement + " --> " + charData);
        } else {
            this.lastElement = "";
        }
        if (this.lastElement.equalsIgnoreCase("NAME")) {
            this.Name = charData;
            CampaignData.mwlog.mainLog(this.Name);
        } else if (this.lastElement.equalsIgnoreCase("INCOME")) {
            this.Income = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("XCOOD")) {
            this.XCood = charData;
        } else if (this.lastElement.equalsIgnoreCase("YCOOD")) {
            this.YCood = charData;
        } else if (this.lastElement.equalsIgnoreCase("WAREHOUSE")) {
            this.Warehousesize = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("FACTION")) {
            this.lastInfFaction = charData;
            if (this.singlePlayerFactions && !this.lastInfFaction.equalsIgnoreCase(CampaignMain.cm.getConfig("NewbieHouseName"))) {
                this.lastInfFaction = "None";
            }
        } else if (this.lastElement.equalsIgnoreCase("AMOUNT")) {
            SHouse h = CampaignMain.cm.getHouseFromPartialString(this.lastInfFaction, null);
            if (h != null) {
                this.Influence.put(new Integer(h.getId()), new Integer(charData));
                CampaignData.mwlog.mainLog("Parsed: " + h.toString() + " - " + charData);
            } else {
                CampaignData.mwlog.mainLog("ERROR READING FACTION: " + this.lastInfFaction);
            }
        } else if (this.lastElement.equalsIgnoreCase("FACTORYNAME")) {
            this.MFName = charData;
        } else if (this.lastElement.equalsIgnoreCase("FOUNDER")) {
            this.MFFounder = charData;
        } else if (this.lastElement.equalsIgnoreCase("SIZE")) {
            if (this.inWarehouse) {
                this.Warehousesize = Integer.parseInt(charData);
            } else if (this.inContinent) {
                this.terrainProb = Integer.parseInt(charData);
            } else {
                this.MFSize = charData;
            }
        } else if (this.lastElement.equalsIgnoreCase("TICKSUNTILREFRESH")) {
            this.MFTicksUntilRefresh = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("REFRESHSPEED")) {
            this.MFRefreshSpeed = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("TYPE")) {
            this.Type = charData.equalsIgnoreCase("VEHICLE") ? (this.Type += 2) : (charData.equalsIgnoreCase("INFANTRY") ? (this.Type += 4) : (charData.equalsIgnoreCase("BATTLEARMOR") ? (this.Type += 16) : (charData.equalsIgnoreCase("PROTOMEK") ? (this.Type += 8) : ++this.Type)));
        } else if (this.lastElement.equalsIgnoreCase("COMPPRODUCTION")) {
            this.CompProduction = Integer.parseInt(charData);
        } else if (this.lastElement.equalsIgnoreCase("CONQUERABLE")) {
            this.conquerable = Boolean.parseBoolean(charData);
        } else if (this.lastElement.equalsIgnoreCase("TERRAIN")) {
            this.terrainName = charData;
        } else if (this.lastElement.endsWith("XMAP")) {
            this.xmap = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("YMAP")) {
            this.ymap = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("XBOARD")) {
            this.xboard = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("YBOARD")) {
            this.yboard = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("LOWTEMP")) {
            this.lowtemp = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("HITEMP")) {
            this.hitemp = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("GRAVITY")) {
            this.gravity = Double.parseDouble(charData);
        } else if (this.lastElement.endsWith("VACUUM")) {
            this.vacuum = Boolean.parseBoolean(charData);
        } else if (this.lastElement.endsWith("MAP")) {
            this.map = Boolean.parseBoolean(charData);
        } else if (this.lastElement.endsWith("NIGHTCHANCE")) {
            this.nightchance = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("NIGHTMOD")) {
            this.nightmod = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("MAPNAME")) {
            this.mapname = charData;
        } else if (this.lastElement.endsWith("TERRAINNAME")) {
            this.aterrainName = charData;
        } else if (this.lastElement.endsWith("ORIGINALOWNER")) {
            this.OriginalOwner = charData;
        } else if (this.lastElement.endsWith("OPKEY")) {
            this.OpFlag = charData;
        } else if (this.lastElement.endsWith("OPNAME")) {
            this.OpName = charData;
        } else if (this.lastElement.endsWith("HOMEWORLD")) {
            this.isHomeWorld = Boolean.parseBoolean(charData);
        } else if (this.lastElement.endsWith("BUILDTABLEFOLDER")) {
            this.buildTableFolder = charData;
        } else if (this.lastElement.endsWith("ACCESSSLEVEL")) {
            this.accessLevel = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("MINVISIBILITY")) {
            this.minVisibility = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("MAXVISIBILITY")) {
            this.maxVisibility = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("BLIZZARDCHANCE")) {
            this.blizzardChance = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("BLOWINGSANDCHANCE")) {
            this.blowingSandChance = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("HEAVYSNOWFALLCHANCE")) {
            this.heavySnowfallChance = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("LIGHTRAINFALLCHANCE")) {
            this.lightRainfallChance = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("HEAVYRAINFALLCHANCE")) {
            this.heavyRainfallChance = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("MODERATEWINDSCHANCE")) {
            this.moderateWindsChance = Integer.parseInt(charData);
        } else if (this.lastElement.endsWith("HIGHWINDSCHANCE")) {
            this.highWindsChance = Integer.parseInt(charData);
        }
    }

    public void recordComment(String comment) {
        CampaignData.mwlog.mainLog(this.prefix + "*Comment: " + comment);
    }

    public InputStream getDocumentStream() throws ParseException {
        try {
            return new FileInputStream(this.filename);
        }
        catch (FileNotFoundException e) {
            throw new ParseException("could not find the specified file");
        }
    }

    public InputStream resolveExternalEntity(String name, String pubID, String sysID) throws ParseException {
        if (sysID != null) {
            File f = new File(new File(this.filename).getParent(), sysID);
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new ParseException("file not found (" + f + ")");
            }
        }
        return null;
    }

    public InputStream resolveDTDEntity(String name, String pubID, String sysID) throws ParseException {
        return this.resolveExternalEntity(name, pubID, sysID);
    }

    public static String newLineToBR(String data) {
        StringTokenizer tokened = new StringTokenizer(data, "\n");
        String result = new String();
        while (tokened.hasMoreElements()) {
            result = result + tokened.nextElement();
            if (!tokened.hasMoreElements()) continue;
            result = result + "<BR>";
        }
        return result;
    }
}

