/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.votes;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.votes.Vote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoteManager {
    Vector<Vote> voteVector = new Vector(1, 1);
    CampaignMain cm;

    public VoteManager(CampaignMain campmain) {
        this.cm = campmain;
    }

    public boolean checkForDuplicate(Vote v) {
        Enumeration<Vote> e = this.voteVector.elements();
        Vote nextVote = null;
        boolean dupeFound = false;
        while (e.hasMoreElements() && !dupeFound) {
            nextVote = e.nextElement();
            if (!nextVote.isEqualTo(v, false)) continue;
            dupeFound = true;
        }
        return dupeFound;
    }

    public boolean checkForHouseMatch(Vote v) {
        SHouse recipientHouse;
        boolean toReturn = false;
        SHouse casterHouse = this.cm.getHouseForPlayer(v.getCaster());
        if (casterHouse.equals(recipientHouse = this.cm.getHouseForPlayer(v.getRecipient()))) {
            toReturn = true;
        }
        return toReturn;
    }

    public boolean addVote(Vote v) {
        boolean isDuplicate = this.checkForDuplicate(v);
        boolean playersInSameHouse = this.checkForHouseMatch(v);
        if (isDuplicate || !playersInSameHouse) {
            return false;
        }
        this.voteVector.add(v);
        return true;
    }

    public boolean removeVote(Vote v) {
        Iterator<Vote> i = this.voteVector.iterator();
        boolean voteRemoved = false;
        while (i.hasNext() && !voteRemoved) {
            Vote nextVote = i.next();
            if (!nextVote.isEqualTo(v, true)) continue;
            i.remove();
            voteRemoved = true;
        }
        return voteRemoved;
    }

    public Vector<Vote> getAllVotesFor(SPlayer p) {
        Vector<Vote> toReturn = new Vector<Vote>(1, 1);
        Enumeration<Vote> e = this.voteVector.elements();
        while (e.hasMoreElements()) {
            Vote v = e.nextElement();
            if (!p.getName().equals(v.getRecipient())) continue;
            toReturn.add(v);
        }
        return toReturn;
    }

    public Vector<Vote> getAllVotesFor(SPlayer p, int type) {
        Vector<Vote> votesForPlayer = this.getAllVotesFor(p);
        Vector<Vote> toReturn = new Vector<Vote>(1, 1);
        Enumeration<Vote> e = votesForPlayer.elements();
        while (e.hasMoreElements()) {
            Vote currVote = e.nextElement();
            if (currVote.getType() != type) continue;
            toReturn.add(currVote);
        }
        return toReturn;
    }

    public Vector<Vote> getAllVotesBy(SPlayer p) {
        Vector<Vote> toReturn = new Vector<Vote>(1, 1);
        Enumeration<Vote> e = this.voteVector.elements();
        while (e.hasMoreElements()) {
            Vote v = e.nextElement();
            if (!p.getName().equals(v.getCaster())) continue;
            toReturn.add(v);
        }
        return toReturn;
    }

    public Vector<Vote> getAllVotesBy(SPlayer p, int type) {
        Vector<Vote> votesByPlayer = this.getAllVotesBy(p);
        Vector<Vote> toReturn = new Vector<Vote>(1, 1);
        Enumeration<Vote> e = votesByPlayer.elements();
        while (e.hasMoreElements()) {
            Vote currVote = e.nextElement();
            if (currVote.getType() != type) continue;
            toReturn.add(currVote);
        }
        return toReturn;
    }

    public void removeAllVotesForPlayer(SPlayer p) {
        Vector<Vote> votesForPlayer = this.getAllVotesFor(p);
        Enumeration<Vote> e = votesForPlayer.elements();
        while (e.hasMoreElements()) {
            Vote currVote = e.nextElement();
            this.removeVote(currVote);
        }
    }

    public void removeAllVotesByPlayer(SPlayer p) {
        Vector<Vote> votesByPlayer = this.getAllVotesBy(p);
        Enumeration<Vote> e = votesByPlayer.elements();
        while (e.hasMoreElements()) {
            Vote currVote = e.nextElement();
            this.removeVote(currVote);
        }
    }

    public Vector<Vote> getAllHouseVotes(SHouse h) {
        Vector<Vote> toReturn = new Vector<Vote>(1, 1);
        Enumeration<Vote> e = this.voteVector.elements();
        while (e.hasMoreElements()) {
            Vote v = e.nextElement();
            SHouse casterHouse = this.cm.getHouseForPlayer(v.getCaster());
            if (!h.equals(casterHouse)) continue;
            toReturn.add(v);
        }
        return toReturn;
    }

    public Vector<Vote> getAllHouseVotes(SHouse h, int type) {
        Vector<Vote> factionVotes = this.getAllHouseVotes(h);
        Vector<Vote> toReturn = new Vector<Vote>(1, 1);
        Enumeration<Vote> e = factionVotes.elements();
        while (e.hasMoreElements()) {
            Vote currVote = e.nextElement();
            if (currVote.getType() != type) continue;
            toReturn.add(currVote);
        }
        return toReturn;
    }
}

