/*
 * Decompiled with CFR 0.152.
 */
package server.dataProvider;

import common.CampaignData;
import common.util.BinWriter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import server.dataProvider.ServerCommand;

public class CommandTaskThread
extends Thread {
    private Socket client;
    private CampaignData data;

    public CommandTaskThread(Socket client, CampaignData data) {
        super("Command Task Thread");
        try {
            this.client = client;
            this.data = data;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        CampaignData.mwlog.infoLog("DataProvider call accepted from " + this.client.getInetAddress());
        BinWriter out = null;
        BufferedReader in = null;
        String cmdStr = "";
        String timeStr = "";
        try {
            in = new BufferedReader(new InputStreamReader(this.client.getInputStream(), "UTF8"));
            while ((cmdStr = in.readLine()) != null) {
                ServerCommand cmd;
                try {
                    timeStr = in.readLine();
                }
                catch (Exception e) {
                    in.close();
                    CampaignData.mwlog.errLog("Error getting data provider command or timestamp from client.");
                    CampaignData.mwlog.errLog(e);
                    return;
                }
                if (out == null) {
                    try {
                        out = new BinWriter(new PrintWriter(this.client.getOutputStream()));
                    }
                    catch (Exception e) {
                        in.close();
                        CampaignData.mwlog.errLog("Error in data provider while creating output stream.");
                        CampaignData.mwlog.errLog(e);
                        return;
                    }
                }
                try {
                    Class<?> cmdClass = Class.forName("server.dataProvider.commands." + cmdStr);
                    cmd = (ServerCommand)cmdClass.newInstance();
                }
                catch (Exception e) {
                    in.close();
                    out.close();
                    CampaignData.mwlog.errLog("Error creating dataprovider command: " + cmdStr);
                    CampaignData.mwlog.errLog(e);
                    return;
                }
                out.println(sdf.format(new Date()), "lasttimestamp");
                try {
                    cmd.execute(timeStr.equals("") ? null : sdf.parse(timeStr), out, this.data);
                }
                catch (Exception e) {
                    in.close();
                    out.close();
                    CampaignData.mwlog.errLog("Error executing dataprovider command: " + cmdStr);
                    CampaignData.mwlog.errLog(e);
                    return;
                }
                out.flush();
            }
            try {
                CampaignData.mwlog.infoLog("Closing DataProvider call from " + this.client.getInetAddress());
                in.close();
                if (out != null) {
                    out.close();
                }
                this.client.close();
                this.client = null;
            }
            catch (SocketException se) {
                this.client = null;
                return;
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog(e);
                return;
            }
        }
        catch (SocketException se) {
            return;
        }
        catch (SocketTimeoutException ste) {
            try {
                if (out != null) {
                    out.close();
                }
                this.client.close();
                CampaignData.mwlog.infoLog("TimeOut DataProvider call from " + this.client.getInetAddress());
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.client = null;
            return;
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return;
        }
    }
}

