/*
 * Decompiled with CFR 0.152.
 */
package server.dataProvider;

import common.CampaignData;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import server.dataProvider.CommandTaskThread;

public class Server
extends Thread {
    private CampaignData data;
    private int dataPort;
    private String IpAddress;

    public Server(CampaignData data, int dataPort, String IpAddress) {
        super("Server");
        this.data = data;
        this.dataPort = dataPort;
        this.IpAddress = IpAddress;
    }

    public void run() {
        CampaignData.mwlog.mainLog("DataProvider: startup...");
        ServerSocket server = null;
        try {
            server = this.IpAddress.equals("-1") ? new ServerSocket(this.dataPort, 0, null) : new ServerSocket(this.dataPort, 0, InetAddress.getByName(this.IpAddress));
        }
        catch (IOException e) {
            CampaignData.mwlog.errLog("Shutting down because:");
            CampaignData.mwlog.errLog(e);
            CampaignData.mwlog.mainLog("DataProvider: Could not create server socket. Shutting down.");
            CampaignData.mwlog.infoLog("DataProvider: Could not create server socket. Shutting down.");
            return;
        }
        CampaignData.mwlog.mainLog("DataProvider: server created at port " + this.dataPort + ". Address " + this.IpAddress + ". Waiting for calls...");
        while (true) {
            try {
                while (true) {
                    Socket client = server.accept();
                    new CommandTaskThread(client, this.data).start();
                }
            }
            catch (OutOfMemoryError OOM) {
                CampaignData.mwlog.errLog("Out of Memory while opening dataprovider socket:");
                CampaignData.mwlog.errLog(OOM.toString());
                try {
                    server.close();
                    server = null;
                    System.gc();
                    if (this.IpAddress.equals("-1")) {
                        server = new ServerSocket(this.dataPort, 0, null);
                        continue;
                    }
                    server = new ServerSocket(this.dataPort, 0, InetAddress.getByName(this.IpAddress));
                    continue;
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("Shutting down because:");
                    CampaignData.mwlog.errLog(ex);
                    CampaignData.mwlog.mainLog("DataProvider: Could not create server socket. Shutting down.");
                    CampaignData.mwlog.infoLog("DataProvider: Could not create server socket. Shutting down.");
                    return;
                }
            }
            catch (IOException e) {
                CampaignData.mwlog.errLog("Dataprovider IO Exception:");
                CampaignData.mwlog.errLog(e);
                continue;
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
                continue;
            }
            break;
        }
    }
}

