/*
 * Decompiled with CFR 0.152.
 */
package server.dataProvider.commands;

import common.CampaignData;
import common.House;
import common.Planet;
import common.util.BinWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import server.campaign.CampaignMain;
import server.campaign.data.TimeUpdatePlanet;
import server.dataProvider.ServerCommand;

public class PDiff
implements ServerCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Date timestamp, BinWriter out, CampaignData data) throws Exception {
        boolean fullUpdate = false;
        if (timestamp == null || CampaignMain.cm.getHousePlanetUpdate().compareTo(timestamp) > 0) {
            timestamp = new Date(-1L);
            fullUpdate = true;
        }
        ArrayList<House> houses = new ArrayList<House>();
        for (House e : data.getAllHouses()) {
            houses.add(e);
        }
        data.binHousesOut(houses, out);
        ArrayList<Planet> planets = new ArrayList<Planet>();
        Collection<Planet> collection = data.getAllPlanets();
        synchronized (collection) {
            for (Planet e : data.getAllPlanets()) {
                TimeUpdatePlanet tPlanet = (TimeUpdatePlanet)e;
                if (tPlanet.getLastChanged() == null || tPlanet.getLastChanged().compareTo(timestamp) <= 0) continue;
                planets.add(e);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            out.println(sdf.format(new Date()), "lasttimestamp");
            out.println(fullUpdate, "FullUpdate");
            data.binPlanetsOut(planets, out);
        }
    }
}

