/*
 * Decompiled with CFR 0.152.
 */
package server.mwcyclopscomm;

import common.CampaignData;
import common.House;
import common.Planet;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPersonalPilotQueues;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.operations.ShortOperation;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.SPilotSkill;
import server.mwcyclopscomm.MWCyclopsHouse;
import server.mwcyclopscomm.MWCyclopsOp;
import server.mwcyclopscomm.MWCyclopsPilot;
import server.mwcyclopscomm.MWCyclopsPlanet;
import server.mwcyclopscomm.MWCyclopsPlayer;
import server.mwcyclopscomm.MWCyclopsSkill;
import server.mwcyclopscomm.MWCyclopsUnit;
import server.mwcyclopscomm.MWCyclopsUnitTemplate;
import server.mwcyclopscomm.MWCyclopsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWCyclopsComm
extends Thread {
    Socket socket;
    String ip = "muposerver.dyndns.org";
    String serverName = "Test Server";
    String stringURL = "http://muposerver.dyndns.org/devel/cyclops/XMLRPC/";
    boolean debug = false;
    int port = 80;
    private int queueSize = 100;
    private Vector<String> messageQueue = new Vector(10, 1);

    public MWCyclopsComm(String ip, String servername, String URL2, boolean debug) {
        super("MW Cyclops Comm Thread");
        this.ip = ip;
        this.serverName = servername;
        this.stringURL = URL2;
        this.debug = debug;
    }

    @Override
    public synchronized void run() {
        try {
            while (true) {
                this.wait(125L);
                if (this.messageQueue.isEmpty()) continue;
                this.sendMessage(this.messageQueue.remove(0), this.debug);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error while trying to sleep in MWCyclopsComm.run()");
            CampaignData.mwlog.errLog(ex);
            return;
        }
    }

    public void checkup() {
        int end;
        int start;
        String message = "";
        message = message + MWCyclopsUtils.methodCallStart();
        message = message + MWCyclopsUtils.methodName("cyclops.checkup");
        String version = this.sendMessage(message = message + MWCyclopsUtils.methodCallEnd(), true);
        version = version.substring(start = version.indexOf("<boolean>") + 9, end = version.indexOf("</boolean>")).equals("1") ? "Cyclops is UP" : "Cyclops is DOWN";
        CampaignMain.cm.doSendModMail("Cyclops check: ", version);
    }

    public void version() {
        String message = "";
        message = message + MWCyclopsUtils.methodCallStart();
        message = message + MWCyclopsUtils.methodName("cyclops.version");
        message = message + MWCyclopsUtils.methodCallEnd();
        String version = this.sendMessage(message, true);
        int start = version.indexOf("<string>") + 8;
        int end = version.indexOf("</string>");
        CampaignMain.cm.doSendModMail("Cyclops Version: ", version.substring(start, end));
    }

    public void reset() {
        int end;
        int start;
        String message = "";
        message = message + MWCyclopsUtils.methodCallStart();
        message = message + MWCyclopsUtils.methodName("cyclops.reset");
        String version = this.sendMessage(message = message + MWCyclopsUtils.methodCallEnd(), true);
        version = version.substring(start = version.indexOf("<boolean>") + 9, end = version.indexOf("</boolean>")).equals("1") ? "Cyclops DataBase Reset Complete" : "Cyclops DataBase Reset failed";
        CampaignMain.cm.doSendModMail("Cyclops reset: ", version);
    }

    public void optimize() {
        int end;
        int start;
        String message = "";
        message = message + MWCyclopsUtils.methodCallStart();
        message = message + MWCyclopsUtils.methodName("cyclops.optimize");
        String version = this.sendMessage(message = message + MWCyclopsUtils.methodCallEnd(), true);
        version = version.substring(start = version.indexOf("<boolean>") + 9, end = version.indexOf("</boolean>")).equals("1") ? "Cyclops DataBase Optimize Complete" : "Cyclops DataBase Optimize failed";
        CampaignMain.cm.doSendModMail("Cyclops Optimize: ", version);
    }

    public void postmaxsize() {
        String message = "";
        message = message + MWCyclopsUtils.methodCallStart();
        message = message + MWCyclopsUtils.methodName("cyclops.postmaxsize");
        message = message + MWCyclopsUtils.methodCallEnd();
        String version = this.sendMessage(message, true);
        int start = version.indexOf("<int>") + 5;
        int end = version.indexOf("</int>");
        CampaignMain.cm.doSendModMail("Cyclops Postmaxsize: ", version.substring(start, end));
    }

    public void houseWrite(SHouse house) {
        String message = "";
        message = MWCyclopsHouse.houseWrite(house);
        this.messageQueue.add(message);
    }

    public void houseWriteFromList(Collection<House> houses) {
        String message = "";
        message = MWCyclopsHouse.houseWriteFromList(houses);
        this.messageQueue.add(message);
    }

    public void planetWrite(SPlanet planet) {
        String message = "";
        message = MWCyclopsPlanet.planetWrite(planet);
        this.messageQueue.add(message);
    }

    public void planetWriteFromList(Collection<Planet> planets) {
        String message = "";
        Vector<Planet> planetList = new Vector<Planet>(this.queueSize + 1, 1);
        for (Planet planet : planets) {
            planetList.add(planet);
            if (planetList.size() < this.queueSize) continue;
            message = MWCyclopsPlanet.planetWriteFromList(planetList);
            this.messageQueue.add(message);
            planetList.clear();
        }
        if (!planetList.isEmpty()) {
            message = MWCyclopsPlanet.planetWriteFromList(planetList);
            this.messageQueue.add(message);
        }
    }

    public void playerWrite(SPlayer player) {
        String message = "";
        message = MWCyclopsPlayer.playerWrite(player);
        this.messageQueue.add(message);
    }

    public void unitTemplateWrite(SUnit unit) {
        String message = "";
        message = MWCyclopsUnitTemplate.unitTemplateWrite(unit);
        this.messageQueue.add(message);
    }

    public void unitTemplateWriteFromList(Vector<SUnit> units) {
        String message = "";
        Vector<SUnit> unitList = new Vector<SUnit>(this.queueSize + 1, 1);
        for (SUnit unit : units) {
            unitList.add(unit);
            if (unitList.size() < this.queueSize) continue;
            message = MWCyclopsUnitTemplate.unitTemplateWriteFromList(unitList);
            this.messageQueue.add(message);
            unitList.clear();
        }
        if (!unitList.isEmpty()) {
            message = MWCyclopsUnitTemplate.unitTemplateWriteFromList(unitList);
            this.messageQueue.add(message);
        }
    }

    public void skillWrite(SPilotSkill skill) {
        String message = "";
        message = MWCyclopsSkill.skillWrite(skill);
        this.messageQueue.add(message);
    }

    public void skillWriteFromList(Hashtable<Integer, SPilotSkill> skills) {
        String message = "";
        message = MWCyclopsSkill.skillWriteFromList(skills);
        this.messageQueue.add(message);
    }

    public void unitWrite(SUnit unit, String Player2, String House2) {
        String message = "";
        message = MWCyclopsUnit.unitWrite(unit, Player2, House2);
        this.messageQueue.add(message);
    }

    public void unitWriteFromList(List<SUnit> units, String Player2, String House2) {
        String message = "";
        message = MWCyclopsUnit.unitWriteFromList(units, Player2, House2);
        this.messageQueue.add(message);
    }

    public void unitDestroy(String unitid, String reason, String opid, String destroyingPlayer, String destroyingUnit) {
        String message = "";
        message = MWCyclopsUnit.unitDestroy(unitid, reason, opid, destroyingPlayer, destroyingUnit);
        this.messageQueue.add(message);
    }

    public void unitChangeOwnerShip(String unitID, String Player2, String House2, String opID, String reason) {
        String message = "";
        message = MWCyclopsUnit.unitChangeOwnership(unitID, Player2, House2, opID, reason);
        this.messageQueue.add(message);
    }

    public void pilotWrite(SPilot pilot, String player) {
        String message = "";
        if (pilot.getName().equalsIgnoreCase("vacant") || pilot.getGunnery() == 99 || pilot.getPiloting() == 99) {
            return;
        }
        message = MWCyclopsPilot.pilotWrite(pilot, player);
        this.messageQueue.add(message);
    }

    public void pilotWriteFromList(SPersonalPilotQueues pilots, String player) {
        String message = "";
        message = MWCyclopsPilot.pilotWriteFromList(pilots, player);
        this.messageQueue.add(message);
    }

    public void pilotKill(SPilot pilot, String opid) {
        String message = "";
        message = MWCyclopsPilot.pilotKill(pilot, opid);
        this.messageQueue.add(message);
    }

    public void pilotRetire(SPilot pilot) {
        String message = "";
        message = MWCyclopsPilot.pilotRetire(pilot);
        this.messageQueue.add(message);
    }

    public void opWrite(ShortOperation op) {
        String message = "";
        message = MWCyclopsOp.opWrite(op);
        this.messageQueue.add(message);
    }

    public void opConclude(ShortOperation op) {
        String message = "";
        message = MWCyclopsOp.opConclude(op);
        this.messageQueue.add(message);
    }

    public void opCancel(ShortOperation op) {
        String message = "";
        if (op.getOpCyclopsID() == null) {
            return;
        }
        message = MWCyclopsOp.opCancel(op);
        this.messageQueue.add(message);
    }

    public String sendMessage(String message, boolean log) {
        try {
            URL url = new URL(this.stringURL);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestProperty("User-Agent", this.serverName);
            urlConnection.setRequestProperty("Host", this.ip);
            urlConnection.setRequestProperty("Content-type", "text/xml");
            urlConnection.setRequestProperty("Content-length", Integer.toString(message.length()));
            PrintWriter _out = new PrintWriter(urlConnection.getOutputStream());
            if (log) {
                CampaignData.mwlog.infoLog("Sending Message: " + MWCyclopsUtils.formatMessage(message));
            } else {
                CampaignData.mwlog.infoLog("Sending Message: " + message);
            }
            _out.println(message);
            _out.flush();
            _out.close();
            StringBuilder ret = new StringBuilder();
            if (log) {
                String input;
                BufferedReader _in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                while ((input = _in.readLine()) != null) {
                    ret.append(input + "\n");
                }
                CampaignData.mwlog.infoLog(ret.toString());
                _in.close();
            } else {
                BufferedReader _in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                while (_in.readLine() != null) {
                }
                _in.close();
            }
            _out.close();
            urlConnection.disconnect();
            return ret.toString();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return "";
        }
    }
}

