/*
 * Decompiled with CFR 0.152.
 */
package server.mwcyclopscomm;

import common.CampaignData;
import common.Unit;
import common.util.MD5;
import java.util.Vector;
import megamek.common.TechConstants;
import server.campaign.SUnit;
import server.mwcyclopscomm.MWCyclopsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWCyclopsUnitTemplate {
    public static String unitTemplateWrite(SUnit unit) {
        StringBuilder message = new StringBuilder();
        try {
            message.append(MWCyclopsUtils.methodCallStart());
            message.append(MWCyclopsUtils.methodName("unitTemplate.write"));
            message.append(MWCyclopsUtils.paramsStart());
            message.append(MWCyclopsUtils.paramStart());
            message.append(MWCyclopsUtils.valueStart());
            message.append(MWCyclopsUnitTemplate.createUnitTemplateStruct(unit));
            message.append(MWCyclopsUtils.valueEnd());
            message.append(MWCyclopsUtils.paramEnd());
            message.append(MWCyclopsUtils.paramsEnd());
            message.append(MWCyclopsUtils.methodCallEnd());
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        return message.toString();
    }

    public static String unitTemplateWriteFromList(Vector<SUnit> units) {
        StringBuilder message = new StringBuilder();
        try {
            message.append(MWCyclopsUtils.methodCallStart());
            message.append(MWCyclopsUtils.methodName("unitTemplate.writeFromList"));
            message.append(MWCyclopsUtils.paramsStart());
            message.append(MWCyclopsUtils.paramStart());
            message.append(MWCyclopsUtils.valueStart());
            message.append(MWCyclopsUtils.arrayStart());
            message.append(MWCyclopsUtils.dataStart());
            for (SUnit unit : units) {
                message.append(MWCyclopsUtils.value(MWCyclopsUnitTemplate.createUnitTemplateStruct(unit)));
            }
            message.append(MWCyclopsUtils.dataEnd());
            message.append(MWCyclopsUtils.arrayEnd());
            message.append(MWCyclopsUtils.valueEnd());
            message.append(MWCyclopsUtils.paramEnd());
            message.append(MWCyclopsUtils.paramsEnd());
            message.append(MWCyclopsUtils.methodCallEnd());
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        return message.toString();
    }

    public static String createUnitTemplateStruct(SUnit unit) {
        StringBuilder struct = new StringBuilder();
        struct.append(MWCyclopsUtils.structStart());
        struct.append(MWCyclopsUtils.structMember("id", MD5.getHashString(unit.getUnitFilename())));
        struct.append(MWCyclopsUtils.structMember("filename", unit.getUnitFilename()));
        struct.append(MWCyclopsUtils.structMember("name", unit.getEntity().getShortNameRaw()));
        struct.append(MWCyclopsUtils.structMember("chassis", unit.getEntity().getChassis()));
        struct.append(MWCyclopsUtils.structMember("model", unit.getEntity().getModel()));
        struct.append(MWCyclopsUtils.structMember("tonnage", (int)unit.getEntity().getWeight()));
        struct.append(MWCyclopsUtils.structMember("battlevalue", unit.getEntity().calculateBattleValue()));
        struct.append(MWCyclopsUtils.structMember("class", Unit.getWeightClassDesc(unit.getWeightclass())));
        struct.append(MWCyclopsUtils.structMember("category", Unit.getTypeClassDesc(unit.getType())));
        struct.append(MWCyclopsUtils.structMember("era", unit.getEntity().getYear()));
        struct.append(MWCyclopsUtils.structMember("techlevel", TechConstants.T_NAMES[unit.getEntity().getTechLevel()].replaceAll("_", " ")));
        struct.append(MWCyclopsUtils.structEnd());
        return struct.toString();
    }
}

