/*
 * Decompiled with CFR 0.152.
 */
package server.mwmysql;

import common.CampaignData;
import common.SubFaction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.NewbieHouse;
import server.campaign.SHouse;
import server.campaign.SUnit;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;

public class FactionHandler {
    Connection con;

    public void loadFactions(CampaignData data) {
        try {
            ResultSet rs = null;
            ResultSet rs1 = null;
            Statement stmt = this.con.createStatement();
            Statement stmt2 = this.con.createStatement();
            rs = stmt.executeQuery("SELECT * from factions ORDER BY ID");
            while (rs.next()) {
                int rareSalesTime;
                int i;
                boolean newbieHouse = rs.getBoolean("fIsNewbieHouse");
                boolean mercHouse = rs.getBoolean("fIsMercHouse");
                SHouse h = newbieHouse ? new NewbieHouse(data.getUnusedHouseID()) : (mercHouse ? new MercHouse(data.getUnusedHouseID()) : new SHouse(data.getUnusedHouseID()));
                String fString = rs.getString("fString");
                if (fString != null && fString.trim().length() > 0) {
                    if (fString.startsWith("[N]")) {
                        fString = fString.substring(3);
                    }
                    if (fString.startsWith("[C]")) {
                        fString = fString.substring(3);
                    }
                    if (fString.startsWith("[M]")) {
                        fString = fString.substring(3);
                    }
                    h.fromString(fString, CampaignMain.cm.getR());
                    h.setDBId(rs.getInt("ID"));
                    CampaignMain.cm.addHouse(h);
                    h.loadConfigFileFromDB();
                    h.setUsedMekBayMultiplier(Float.parseFloat(h.getConfig("UsedPurchaseCostMulti")));
                    if (CampaignMain.cm.isUsingIncreasedTechs()) {
                        h.addCommonUnitSupport();
                    }
                    if (CampaignMain.cm.isSynchingBB()) {
                        h.setForumName(h.getConfig("ForumGroupName"));
                        h.setForumID(CampaignMain.cm.MySQL.getHouseForumID(h.getForumName()));
                    }
                    CampaignData.mwlog.dbLog("Faction " + h.getName() + " loaded");
                    continue;
                }
                h.setName(rs.getString("fName"));
                CampaignData.mwlog.createFactionLogger(h.getName());
                CampaignData.mwlog.dbLog("Loading faction " + h.getName());
                h.setDBId(rs.getInt("ID"));
                h.setMoney(rs.getInt("fMoney"));
                h.setHouseColor(rs.getString("fColor"));
                h.setBaseGunner(rs.getInt("fBaseGunner"));
                h.setBasePilot(rs.getInt("fBasePilot"));
                h.setAbbreviation(rs.getString("fAbbreviation"));
                h.getHangar().put(new Integer(0), new Vector(5, 1));
                h.getHangar().put(new Integer(1), new Vector(5, 1));
                h.getHangar().put(new Integer(2), new Vector(5, 1));
                h.getHangar().put(new Integer(3), new Vector(5, 1));
                h.getHangar().put(new Integer(4), new Vector(5, 1));
                h.getHangar().put(new Integer(5), new Vector(5, 1));
                for (i = 0; i < 4; ++i) {
                    h.getHangar(0).add(new Vector(1, 1));
                    h.getHangar(1).add(new Vector(1, 1));
                    h.getHangar(2).add(new Vector(1, 1));
                    h.getHangar(4).add(new Vector(1, 1));
                    h.getHangar(3).add(new Vector(1, 1));
                    h.getHangar(5).add(new Vector(1, 1));
                }
                h.getComponents().put(0, new Vector(4, 1));
                h.getComponents().put(1, new Vector(4, 1));
                h.getComponents().put(2, new Vector(4, 1));
                h.getComponents().put(3, new Vector(4, 1));
                h.getComponents().put(4, new Vector(4, 1));
                h.getComponents().put(5, new Vector(4, 1));
                for (i = 0; i < 4; ++i) {
                    h.getComponents().get(0).add(0);
                    h.getComponents().get(1).add(0);
                    h.getComponents().get(2).add(0);
                    h.getComponents().get(3).add(0);
                    h.getComponents().get(4).add(0);
                    h.getComponents().get(5).add(0);
                }
                h.setInitialHouseRanking(rs.getInt("fInitialHouseRanking"));
                h.setConquerable(rs.getBoolean("fConquerable"));
                h.setInHouseAttacks(rs.getBoolean("fInHouseAttacks"));
                h.setId(-1);
                h.setHousePlayerColors(rs.getString("fPlayerColors"));
                h.setHouseDefectionFrom(rs.getBoolean("fAllowDefectionsFrom"));
                h.setHouseDefectionTo(rs.getBoolean("fAllowDefectionsTo"));
                h.setHouseFluFile(rs.getString("fFluFile"));
                h.setMotd(rs.getString("fMOTD"));
                h.setTechLevel(rs.getInt("fTechLevel"));
                CampaignData.mwlog.dbLog("Loading Meks");
                rs1 = stmt2.executeQuery("SELECT ID from units WHERE uType = 0 AND uFactionID = " + h.getDBId());
                while (rs1.next()) {
                    SUnit u = new SUnit();
                    u.fromDB(rs1.getInt("ID"));
                    if (newbieHouse) {
                        int priceForUnit = h.getPriceForUnit(u.getWeightclass(), u.getType());
                        rareSalesTime = Integer.parseInt(h.getConfig("RareMinSaleTime"));
                        CampaignMain.cm.getMarket().addListing("Faction_" + h.getName(), u, priceForUnit, rareSalesTime);
                        u.setStatus(3);
                    }
                    try {
                        h.addUnit(u, false);
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.dbLog("Exception at addUnit: ");
                        CampaignData.mwlog.dbLog(ex);
                    }
                }
                CampaignData.mwlog.dbLog("Loading Vees");
                rs1 = stmt2.executeQuery("SELECT ID from units WHERE uType = 1 AND uFactionID = " + h.getDBId());
                while (rs1.next()) {
                    SUnit u = new SUnit();
                    u.fromDB(rs1.getInt("ID"));
                    if (newbieHouse) {
                        int priceForUnit = h.getPriceForUnit(u.getWeightclass(), u.getType());
                        rareSalesTime = Integer.parseInt(h.getConfig("RareMinSaleTime"));
                        CampaignMain.cm.getMarket().addListing("Faction_" + h.getName(), u, priceForUnit, rareSalesTime);
                        u.setStatus(3);
                    }
                    h.addUnit(u, false);
                }
                CampaignData.mwlog.dbLog("Loading Infantry");
                if (Boolean.parseBoolean(h.getConfig("UseInfantry"))) {
                    rs1 = stmt2.executeQuery("SELECT ID from units WHERE uType = 2 AND uFactionID = " + h.getDBId());
                    while (rs1.next()) {
                        SUnit u = new SUnit();
                        u.fromDB(rs1.getInt("ID"));
                        if (newbieHouse) {
                            int priceForUnit = h.getPriceForUnit(u.getWeightclass(), u.getType());
                            rareSalesTime = Integer.parseInt(h.getConfig("RareMinSaleTime"));
                            CampaignMain.cm.getMarket().addListing("Faction_" + h.getName(), u, priceForUnit, rareSalesTime);
                            u.setStatus(3);
                        }
                        CampaignData.mwlog.dbLog("Adding Unit");
                        h.addUnit(u, false);
                    }
                }
                CampaignData.mwlog.dbLog("Loading Protos");
                rs1 = stmt2.executeQuery("SELECT ID from units WHERE uType = 3 AND uFactionID = " + h.getDBId());
                while (rs1.next()) {
                    SUnit u = new SUnit();
                    u.fromDB(rs1.getInt("ID"));
                    if (newbieHouse) {
                        int priceForUnit = h.getPriceForUnit(u.getWeightclass(), u.getType());
                        rareSalesTime = Integer.parseInt(h.getConfig("RareMinSaleTime"));
                        CampaignMain.cm.getMarket().addListing("Faction_" + h.getName(), u, priceForUnit, rareSalesTime);
                        u.setStatus(3);
                    }
                    h.addUnit(u, false);
                }
                CampaignData.mwlog.dbLog("Loading BA");
                rs1 = stmt2.executeQuery("SELECT ID from units WHERE uType = 4 AND uFactionID = " + h.getDBId());
                while (rs1.next()) {
                    SUnit u = new SUnit();
                    u.fromDB(rs1.getInt("ID"));
                    if (newbieHouse) {
                        int priceForUnit = h.getPriceForUnit(u.getWeightclass(), u.getType());
                        rareSalesTime = Integer.parseInt(h.getConfig("RareMinSaleTime"));
                        CampaignMain.cm.getMarket().addListing("Faction_" + h.getName(), u, priceForUnit, rareSalesTime);
                        u.setStatus(3);
                    }
                    h.addUnit(u, false);
                }
                CampaignData.mwlog.dbLog("Loading Aeros");
                rs1 = stmt2.executeQuery("SELECT ID from units WHERE uType = 5 AND uFactionID = " + h.getDBId());
                while (rs1.next()) {
                    SUnit u = new SUnit();
                    u.fromDB(rs1.getInt("ID"));
                    if (newbieHouse) {
                        int priceForUnit = h.getPriceForUnit(u.getWeightclass(), u.getType());
                        rareSalesTime = Integer.parseInt(h.getConfig("RareMinSaleTime"));
                        CampaignMain.cm.getMarket().addListing("Faction_" + h.getName(), u, priceForUnit, rareSalesTime);
                        u.setStatus(3);
                    }
                    h.addUnit(u, false);
                }
                CampaignData.mwlog.dbLog("Loading Components");
                rs1 = stmt2.executeQuery("SELECT * from factioncomponents where factionID = " + h.getDBId());
                while (rs1.next()) {
                    h.getComponents().get(rs1.getInt("unitType")).setElementAt(rs1.getInt("components"), rs1.getInt("unitWeight"));
                }
                CampaignData.mwlog.dbLog("Loading Base Gunnery & Piloting");
                rs1 = stmt2.executeQuery("SELECT * from faction_base_gunnery_piloting WHERE factionID = " + h.getDBId());
                while (rs1.next()) {
                    h.setBaseGunner(rs1.getInt("baseGunnery"), rs1.getInt("unitType"));
                    h.setBasePilot(rs1.getInt("basePiloting"), rs1.getInt("unitType"));
                }
                CampaignData.mwlog.dbLog("Loading Default Pilot Skills");
                rs1 = stmt2.executeQuery("SELECT * from faction_pilot_skills WHERE factionID = " + h.getDBId());
                while (rs1.next()) {
                    int skillID = rs1.getInt("skillID");
                    h.setBasePilotSkill(rs1.getString("pilotSkills"), skillID);
                }
                rs1 = stmt2.executeQuery("SELECT * from subfactions WHERE houseID = " + h.getDBId());
                while (rs1.next()) {
                    SubFaction newSubFaction = new SubFaction();
                    newSubFaction.fromString(rs1.getString("sf_string"));
                    h.getSubFactionList().put(rs1.getString("subfactionName"), newSubFaction);
                }
                rs1.close();
                rs1 = stmt2.executeQuery("SELECT * from faction_leaders WHERE faction_id = " + h.getDBId());
                while (rs1.next()) {
                    h.addLeader(rs1.getString("leader_name"));
                }
                if (h.isMercHouse()) {
                    CampaignData.mwlog.dbLog("Merc House");
                    rs1.close();
                    Hashtable<String, ContractInfo> merctable = new Hashtable<String, ContractInfo>();
                    PreparedStatement ps = this.con.prepareStatement("SELECT contractID from merc_contract_info WHERE contractHouse = ?");
                    ps.setString(1, h.getName());
                    rs1 = ps.executeQuery();
                    while (rs1.next()) {
                        ContractInfo ci = new ContractInfo();
                        ci.fromDB(rs1.getInt("contractID"));
                        merctable.put(ci.getPlayerName(), ci);
                    }
                    ps.close();
                    ((MercHouse)h).setOutstandingContracts(merctable);
                }
                CampaignMain.cm.addHouse(h);
                CampaignData.mwlog.dbLog("Loading Faction Pilots");
                CampaignMain.cm.MySQL.loadFactionPilots(h);
                h.loadConfigFileFromDB();
                h.setUsedMekBayMultiplier(Float.parseFloat(h.getConfig("UsedPurchaseCostMulti")));
                if (CampaignMain.cm.isUsingIncreasedTechs()) {
                    h.addCommonUnitSupport();
                }
                if (CampaignMain.cm.isSynchingBB()) {
                    h.setForumName(h.getConfig("ForumGroupName"));
                    h.setForumID(CampaignMain.cm.MySQL.getHouseForumID(h.getForumName()));
                }
                CampaignData.mwlog.dbLog("Faction " + h.getName() + " loaded");
            }
            rs.close();
            if (rs1 != null) {
                rs1.close();
            }
            stmt.close();
            stmt2.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in FactionHandler.loadFaction: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public int countFactions() {
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) as num from factions");
            rs.next();
            int num = rs.getInt("num");
            rs.close();
            stmt.close();
            return num;
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in FactionHandler.countFactions: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return 0;
        }
    }

    public void saveSubFaction(String SubFactionString, int houseID) {
        try {
            String sql = "";
            PreparedStatement ps = null;
            ResultSet rs = null;
            SubFaction sf = new SubFaction();
            sf.fromString(SubFactionString);
            CampaignData.mwlog.dbLog("Saving subfaction: " + sf.getConfig("Name"));
            Boolean inDB = false;
            ps = this.con.prepareStatement("SELECT COUNT(*) as num from subfactions WHERE houseID = " + houseID + " AND subfactionName='" + sf.getConfig("Name") + "'");
            rs = ps.executeQuery();
            rs.next();
            if (rs.getInt("num") > 0) {
                inDB = true;
            }
            rs.close();
            ps.close();
            if (!inDB.booleanValue()) {
                sql = "INSERT into subfactions set subfactionName = ?, houseID = ?, sf_string = ?";
                ps = this.con.prepareStatement(sql);
                ps.setString(1, sf.getConfig("Name"));
                ps.setInt(2, houseID);
                ps.setString(3, sf.toString());
                ps.executeUpdate();
            } else {
                sql = "UPDATE subfactions set sf_string = ? WHERE (houseID = ? AND subfactionName = ?)";
                ps = this.con.prepareStatement(sql);
                ps.setString(1, sf.toString());
                ps.setInt(2, houseID);
                ps.setString(3, sf.getConfig("Name"));
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in FactionHandler.saveSubFaction: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void deleteSubFaction(String subFactionName, int houseID) {
        PreparedStatement ps = null;
        try {
            ps = this.con.prepareStatement("DELETE from subfactions WHERE subfactionName = ? AND houseID = ?");
            ps.setString(1, subFactionName);
            ps.setInt(2, houseID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in FactionHandler.deleteSubFaction: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public FactionHandler(Connection c) {
        this.con = c;
    }
}

