/*
 * Decompiled with CFR 0.152.
 */
package server.mwmysql;

import common.CampaignData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import server.campaign.operations.OperationReportEntry;

public class HistoryHandler {
    Connection con = null;
    public static final int UNIT_CREATED = 0;
    public static final int UNIT_AUTOPRODUCED = 1;
    public static final int UNIT_RAIDED = 2;
    public static final int UNIT_SALVAGED = 3;
    public static final int UNIT_DONATED = 4;
    public static final int UNIT_TRADED_AWAY = 5;
    public static final int UNIT_RECEIVED_IN_TRADE = 6;
    public static final int UNIT_SCRAPPED = 7;
    public static final int UNIT_BOUGHT_FROM_BAY = 8;
    public static final int UNIT_BOUGHT_FROM_FACTORY = 9;
    public static final int UNIT_BOUGHT_WITH_RP = 10;
    public static final int UNIT_DESTROYED = 11;
    public static final int UNIT_DESTROYED_BY_ACCIDENT = 12;
    public static final int UNIT_SOLD_ON_BM = 13;
    public static final int UNIT_PARTICIPATED_IN_TASK = 14;
    public static final int UNIT_KILLED_UNIT = 15;
    public static final int UNIT_PILOT_ASSIGNED = 16;
    public static final int UNIT_PILOT_KILLED = 17;
    public static final int PILOT_ASSIGNED = 18;
    public static final int PILOT_LEVEL_UP = 19;
    public static final int PILOT_SKILL_GAIN = 20;
    public static final int PILOT_ASSIGNED_TO_QUEUE = 21;
    public static final int PILOT_CHANGED_NAME = 22;
    public static final int PILOT_KILLED_UNIT = 23;
    public static final int PILOT_DISPOSSESSED = 24;
    public static final int PILOT_DIED = 25;
    public static final int PILOT_IMPRISONED = 26;
    public static final int PILOT_DEFECTED = 27;
    public static final int UNIT_PRODUCED_BY_WELFARE = 28;
    public static final int HISTORY_TYPE_UNIT = 1;
    public static final int HISTORY_TYPE_PILOT = 2;

    public void addHistoryEntry(int historyType, int unitID, int eventType, String fluff) {
        PreparedStatement ps = null;
        String hTypeName = "";
        String unitIDType = "";
        if (historyType == 1) {
            hTypeName = "unit_history";
            unitIDType = "unit_id";
        } else if (historyType == 2) {
            hTypeName = "pilot_history";
            unitIDType = "pilot_id";
        }
        try {
            ps = this.con.prepareStatement("INSERT INTO " + hTypeName + " set event_fluff = ?, " + unitIDType + " = ?, event_type = ?");
            ps.setString(1, fluff);
            ps.setInt(2, unitID);
            ps.setInt(3, eventType);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in HistoryHandler.addHistoryEntry: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitBattleReport(OperationReportEntry opData) {
        Statement ps = null;
        try {
            CampaignData.mwlog.dbLog("New Operation!!!");
            CampaignData.mwlog.dbLog("Attacker(s): " + opData.getAttackers() + " (" + opData.getAttackerStartBV() + " / " + opData.getAttackerEndBV() + ")");
            CampaignData.mwlog.dbLog("Defender(s): " + opData.getDefenders() + " (" + opData.getDefenderStartBV() + " / " + opData.getDefenderEndBV() + ")");
            CampaignData.mwlog.dbLog("Planet Info: " + opData.getPlanet() + " / " + opData.getTerrain() + " / " + opData.getTheme());
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT into task_history SET ");
            sql.append("type = ?, ");
            sql.append("planet = ?, ");
            sql.append("terrain = ?, ");
            sql.append("theme = ?, ");
            sql.append("attackers = ?, ");
            sql.append("defenders = ?, ");
            sql.append("attackerStartBV = ?, ");
            sql.append("attackerEndBV = ?, ");
            sql.append("attackerNumUnits = ?, ");
            sql.append("defenderStartBV = ?, ");
            sql.append("defenderEndBV = ?, ");
            sql.append("defenderNumUnits = ?, ");
            sql.append("attackerWon = ?, ");
            sql.append("drawGame = ?, ");
            sql.append("winner = ?, ");
            sql.append("loser = ?, ");
            sql.append("gameLength = ?");
            ps = this.con.prepareStatement(sql.toString());
            ps.setString(1, opData.getOpType());
            ps.setString(2, opData.getPlanet());
            ps.setString(3, opData.getTerrain());
            ps.setString(4, opData.getTheme());
            ps.setString(5, opData.getAttackers());
            ps.setString(6, opData.getDefenders());
            ps.setInt(7, opData.getAttackerStartBV());
            ps.setInt(8, opData.getAttackerEndBV());
            ps.setInt(9, opData.getAttackerSize());
            ps.setInt(10, opData.getDefenderStartBV());
            ps.setInt(11, opData.getDefenderEndBV());
            ps.setInt(12, opData.getDefenderSize());
            ps.setBoolean(13, opData.attackerIsWinner());
            ps.setBoolean(14, opData.gameIsDraw());
            ps.setString(15, opData.getWinners());
            ps.setString(16, opData.getLosers());
            ps.setString(17, opData.getHumanReadableGameLength());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in HistoryHandler.commitBattleReport: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public HistoryHandler(Connection c) {
        this.con = c;
    }
}

