/*
 * Decompiled with CFR 0.152.
 */
package server.mwmysql;

import common.CampaignData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.operations.OperationReportEntry;
import server.campaign.pilot.SPilot;
import server.mwmysql.FactionHandler;
import server.mwmysql.HistoryHandler;
import server.mwmysql.MWmysql;
import server.mwmysql.PhpBBConnector;
import server.mwmysql.PilotHandler;
import server.mwmysql.PlayerHandler;
import server.mwmysql.UnitHandler;
import server.mwmysql.factoryHandler;
import server.mwmysql.planetHandler;

public class mysqlHandler {
    private MWmysql MySQLCon = new MWmysql();
    private planetHandler ph = null;
    private factoryHandler fh = null;
    private PilotHandler pih = null;
    private UnitHandler uh = null;
    private FactionHandler fah = null;
    private PlayerHandler plh = null;
    private PhpBBConnector phpBBCon = null;
    private HistoryHandler hh = null;
    private final int currentDBVersion = 30;

    public void closeMySQL() {
        this.MySQLCon.close();
        if (CampaignMain.cm.isSynchingBB()) {
            this.phpBBCon.close();
        }
    }

    public boolean isSynchingBB() {
        boolean isUsing = Boolean.parseBoolean(CampaignMain.cm.getServer().getConfigParam("MYSQL_SYNCHPHPBB"));
        if (isUsing && this.phpBBCon == null) {
            this.phpBBCon = new PhpBBConnector();
            this.phpBBCon.init();
        } else if (!isUsing && this.phpBBCon != null) {
            this.phpBBCon.close();
            this.phpBBCon = null;
        }
        if (isUsing) {
            try {
                if (this.phpBBCon.con.isClosed()) {
                    this.phpBBCon = new PhpBBConnector();
                    this.phpBBCon.init();
                }
            }
            catch (SQLException e) {
                CampaignData.mwlog.dbLog("SQLException in mysqlHandler.isSynchingBB: " + e.getMessage());
                CampaignData.mwlog.dbLog(e);
            }
        }
        return isUsing;
    }

    public int getUnitDBIdFromMWId(int MWId) {
        return this.uh.getUnitDBIdFromMWId(MWId);
    }

    public void clearArmies(int userID) {
        try {
            PreparedStatement ps = this.MySQLCon.con.prepareStatement("DELETE from playerarmies WHERE playerID = ?");
            ps.setInt(1, userID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.clearArmies: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public int getFactoryIdByNameAndPlanet(String fName, String pName) {
        return this.fh.getFactoryIdByNameAndPlanet(fName, pName);
    }

    public void deleteArmy(int userID, int armyID) {
        try {
            PreparedStatement ps = this.MySQLCon.con.prepareStatement("DELETE from playerarmies WHERE playerID = ? AND armyID = ?");
            ps.setInt(1, userID);
            ps.setInt(2, armyID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.deleteArmy: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public boolean addUserToForum(String name, String pass, String email) {
        return this.phpBBCon.addToForum(name, pass, email);
    }

    public void addUserToHouseForum(int userID, int forumID) {
        this.phpBBCon.addToHouseForum(userID, forumID);
    }

    public void removeUserFromHouseForum(int userID, int houseForumID) {
        this.phpBBCon.removeFromHouseForum(userID, houseForumID);
    }

    public void backupDB(long time) {
        this.MySQLCon.backupDB(time);
    }

    public PreparedStatement getPreparedStatement(String sql) {
        try {
            return this.MySQLCon.con.prepareStatement(sql);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.getPreparedStatement: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public PreparedStatement getPreparedStatement(String sql, int autoGeneratedKeys) {
        try {
            return this.MySQLCon.con.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.getPreparedStatement(String, Int): " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public PreparedStatement getPreparedStatement(String sql, int[] columnIndexes) {
        try {
            return this.MySQLCon.con.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.getPreparedStatement(String, int[]): " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public PreparedStatement getPreparedStatement(String sql, String[] columnNames) {
        try {
            return this.MySQLCon.con.prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.getPreparedStatement(String, String[]): " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public PreparedStatement getPreparedStatement(String sql, int resultSetType, int resultSetConcurrency) {
        try {
            return this.MySQLCon.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.getPreparedStatement(String, int, int): " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public PreparedStatement getPreparedStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        try {
            return this.MySQLCon.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.getPreparedStatement(String, int, int, int): " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public Statement getStatement() {
        try {
            return this.MySQLCon.con.createStatement();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.getStatement: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public Statement getStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        try {
            return this.MySQLCon.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.getStatement(int, int, int): " + e.getMessage());
            CampaignData.mwlog.dbLog("resultSetType: " + resultSetType);
            CampaignData.mwlog.dbLog("resultSetConcurrency: " + resultSetConcurrency);
            CampaignData.mwlog.dbLog("resultSetHoldability: " + resultSetHoldability);
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public Statement getStatement(int resultSetType, int resultSetConcurrency) {
        try {
            return this.MySQLCon.con.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.getStatement(int, int): " + e.getMessage());
            CampaignData.mwlog.dbLog("resultSetType: " + resultSetType);
            CampaignData.mwlog.dbLog("resultSetConcurrency: " + resultSetConcurrency);
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public void deleteFactory(int FactoryID) {
        this.fh.deleteFactory(FactoryID);
    }

    public void deletePlanetFactories(String planetName) {
        this.fh.deletePlanetFactories(planetName);
    }

    public void loadFactories(SPlanet planet) {
        this.fh.loadFactories(planet);
    }

    public int countPlanets() {
        return this.ph.countPlanets();
    }

    public void loadPlanets(CampaignData data) {
        this.ph.loadPlanets(data);
    }

    public void saveInfluences(SPlanet planet) {
        this.ph.saveInfluences(planet);
    }

    public void saveEnvironments(SPlanet planet) {
        this.ph.saveEnvironments(planet);
    }

    public void savePlanetFlags(SPlanet planet) {
        this.ph.savePlanetFlags(planet);
    }

    public void deletePlanet(int PlanetID) {
        this.ph.deletePlanet(PlanetID);
    }

    public void loadFactionPilots(SHouse h) {
        try {
            ResultSet rs = null;
            Statement stmt = this.MySQLCon.con.createStatement();
            for (int x = 0; x < 6; ++x) {
                h.getPilotQueues().setFactionID(h.getDBId());
                rs = stmt.executeQuery("SELECT pilotID from pilots WHERE factionID = " + h.getId() + " AND pilotType= " + x);
                while (rs.next()) {
                    SPilot p = this.pih.loadPilot(rs.getInt("pilotID"));
                    h.getPilotQueues().loadPilot(x, p);
                }
            }
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in mysqlHandler.loadFactionPilots: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void deleteFactionPilots(int factionID) {
        this.pih.deleteFactionPilots(factionID);
    }

    public void deleteFactionPilots(int factionID, int type) {
        this.pih.deleteFactionPilots(factionID, type);
    }

    public void deletePlayerPilots(int playerID) {
        this.pih.deletePlayerPilots(playerID);
    }

    public void deletePlayerPilots(int playerID, int unitType, int unitWeight) {
        this.pih.deletePlayerPilots(playerID, unitType, unitWeight);
    }

    public void deletePilot(int pilotID) {
        this.pih.deletePilot(pilotID);
    }

    public SPilot loadUnitPilot(int unitID) {
        return this.pih.loadUnitPilot(unitID);
    }

    public SPilot loadPilot(int pilotID) {
        return this.pih.loadPilot(pilotID);
    }

    public void unlinkUnit(int unitID) {
        this.uh.unlinkUnit(unitID);
    }

    public void linkUnitToPlayer(int unitID, int playerID) {
        this.uh.linkUnitToPlayer(unitID, playerID);
    }

    public void linkUnitToFaction(int unitID, int factionID) {
        this.uh.linkUnitToFaction(unitID, factionID);
    }

    public void deleteUnit(int unitID) {
        this.uh.deleteUnit(unitID);
    }

    public void loadFactions(CampaignData data) {
        this.fah.loadFactions(data);
    }

    public int countFactions() {
        return this.fah.countFactions();
    }

    public int countPlayers() {
        return this.plh.countPlayers();
    }

    public int getPlayerIDByName(String name) {
        return this.plh.getPlayerIDByName(name);
    }

    public void setPlayerPassword(int ID, String password) {
        this.plh.setPassword(ID, password);
    }

    public void setPlayerAccess(int ID, int level) {
        this.plh.setPlayerAccess(ID, level);
    }

    public boolean matchPassword(String playerName, String pass) {
        return this.plh.matchPassword(playerName, pass);
    }

    public boolean playerExists(String name) {
        return this.plh.playerExists(name);
    }

    public void deletePlayer(SPlayer p) {
        this.plh.deletePlayer(p, true);
    }

    public void deletePlayer(SPlayer p, boolean deleteForumAccount) {
        this.plh.deletePlayer(p, deleteForumAccount);
    }

    public void deleteForumAccount(int forumID) {
        this.phpBBCon.deleteForumAccount(forumID);
    }

    public void purgeStalePlayers(long days) {
        this.plh.purgeStalePlayers(days);
    }

    public void saveSubFaction(String SubFactionString, int houseID) {
        this.fah.saveSubFaction(SubFactionString, houseID);
    }

    public void deleteSubFaction(String subFactionName, int houseID) {
        this.fah.deleteSubFaction(subFactionName, houseID);
    }

    public int getDBVersion() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement();
            rs = stmt.executeQuery("SELECT config_value from config WHERE config_key = 'mekwars_database_version'");
            if (rs.next()) {
                return rs.getInt("config_value");
            }
            rs.close();
            stmt.close();
            return 0;
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in mysqlHandler.getDBVersion: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return 0;
        }
    }

    private boolean databaseIsUpToDate() {
        if (this.getDBVersion() == 30) {
            CampaignData.mwlog.dbLog("Database up to date");
            return true;
        }
        CampaignData.mwlog.dbLog("Database is an incorrect version!  Please update.");
        CampaignData.mwlog.dbLog("Current Version: 30   --   Your version: " + this.getDBVersion());
        return false;
    }

    public void checkAndUpdateDB() {
        if (this.databaseIsUpToDate()) {
            return;
        }
        CampaignData.mwlog.mainLog("Database out of date.  Shutting down to avoid data corruption.");
        CampaignData.mwlog.mainLog("Required version: 30, your version: " + this.getDBVersion());
        System.exit(0);
    }

    public PreparedStatement BBgetPreparedStatement(String sql) {
        try {
            return this.phpBBCon.con.prepareStatement(sql);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.BBgetPreparedStatement: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public PreparedStatement BBgetPreparedStatement(String sql, int autoGeneratedKeys) {
        try {
            return this.phpBBCon.con.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.BBgetPreparedStatement(String, Int): " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public PreparedStatement BBgetPreparedStatement(String sql, int[] columnIndexes) {
        try {
            return this.phpBBCon.con.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.BBgetPreparedStatement(String, int[]): " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public PreparedStatement BBgetPreparedStatement(String sql, String[] columnNames) {
        try {
            return this.phpBBCon.con.prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.BBgetPreparedStatement(String, String[]): " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public PreparedStatement BBgetPreparedStatement(String sql, int resultSetType, int resultSetConcurrency) {
        try {
            return this.phpBBCon.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.BBgetPreparedStatement(String, int, int): " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public PreparedStatement BBgetPreparedStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        try {
            return this.phpBBCon.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.BBgetPreparedStatement(String, int, int, int): " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public Statement BBgetStatement() {
        try {
            return this.phpBBCon.con.createStatement();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.BBgetStatement: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public Statement BBgetStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        try {
            return this.phpBBCon.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.BBgetStatement(int, int, int): " + e.getMessage());
            CampaignData.mwlog.dbLog("resultSetType: " + resultSetType);
            CampaignData.mwlog.dbLog("resultSetConcurrency: " + resultSetConcurrency);
            CampaignData.mwlog.dbLog("resultSetHoldability: " + resultSetHoldability);
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public Statement BBgetStatement(int resultSetType, int resultSetConcurrency) {
        try {
            return this.phpBBCon.con.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.BBgetStatement(int, int): " + e.getMessage());
            CampaignData.mwlog.dbLog("resultSetType: " + resultSetType);
            CampaignData.mwlog.dbLog("resultSetConcurrency: " + resultSetConcurrency);
            CampaignData.mwlog.dbLog(e);
            return null;
        }
    }

    public int getHouseForumID(String houseName) {
        return this.phpBBCon.getHouseForumID(houseName);
    }

    public int getUserForumID(String userName, String userEmail) {
        return this.phpBBCon.getUserForumID(userName, userEmail);
    }

    public String getActivationKey(int userID) {
        return this.phpBBCon.getActivationKey(userID);
    }

    public void validateUser(int forumID) {
        this.phpBBCon.validateUser(forumID);
    }

    public void changeForumName(String oldname, String newname) {
        this.phpBBCon.changeForumName(oldname, newname);
    }

    public void addHistoryEntry(int historyType, int unitID, int eventType, String fluff) {
        this.hh.addHistoryEntry(historyType, unitID, eventType, fluff);
    }

    public void commitBattleReport(OperationReportEntry opData) {
        this.hh.commitBattleReport(opData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() {
        Statement ps = null;
        Properties configs = CampaignMain.cm.getConfig();
        Set<Object> keys = configs.keySet();
        String key = "";
        Iterator<Object> keyIterator = keys.iterator();
        try {
            while (keyIterator.hasNext()) {
                ps = this.MySQLCon.con.prepareStatement("REPLACE into campaign_config SET config_name=?, config_value=?");
                key = (String)keyIterator.next();
                ps.setString(1, key);
                ps.setString(2, configs.getProperty(key));
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.saveConfig: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configIsSaved() {
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean isSaved = false;
        try {
            ps = this.MySQLCon.con.prepareStatement("SELECT COUNT(*) as num from campaign_config");
            rs = ps.executeQuery();
            if (rs.next() && rs.getInt("num") > 0) {
                isSaved = true;
            }
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.configIsSaved: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {}
        }
        CampaignData.mwlog.dbLog("Campaign saved in DB: " + Boolean.toString(isSaved));
        return isSaved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig(Properties config) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.MySQLCon.con.prepareStatement("SELECT * from campaign_config");
            rs = ps.executeQuery();
            while (rs.next()) {
                config.put(rs.getString("config_name"), rs.getString("config_value"));
            }
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in mysqlHandler.loadConfig: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {}
        }
    }

    public mysqlHandler() {
        if (Boolean.parseBoolean(CampaignMain.cm.getServer().getConfigParam("MYSQL_SYNCHPHPBB"))) {
            this.phpBBCon = new PhpBBConnector();
            this.phpBBCon.init();
        }
        this.ph = new planetHandler(this.MySQLCon.con);
        this.fh = new factoryHandler(this.MySQLCon.con);
        this.pih = new PilotHandler(this.MySQLCon.con);
        this.uh = new UnitHandler(this.MySQLCon.con);
        this.fah = new FactionHandler(this.MySQLCon.con);
        this.plh = new PlayerHandler(this.MySQLCon.con);
        this.hh = new HistoryHandler(this.MySQLCon.con);
        this.checkAndUpdateDB();
    }
}

