/*
 * Decompiled with CFR 0.152.
 */
package server.mwmysql;

import common.AdvancedTerrain;
import common.CampaignData;
import common.Continent;
import common.House;
import common.Influences;
import common.Terrain;
import common.util.Position;
import java.awt.Dimension;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;

public class planetHandler {
    Connection con = null;

    public int countPlanets() {
        int num = 0;
        try {
            ResultSet rs = null;
            Statement stmt = this.con.createStatement();
            String sql = "SELECT COUNT(*) as numplanets from planets";
            rs = stmt.executeQuery(sql);
            rs.next();
            num = rs.getInt("numplanets");
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in countPlanets: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
        return num;
    }

    public void deletePlanet(int PlanetID) {
        try {
            Statement stmt = this.con.createStatement();
            stmt.executeUpdate("DELETE from planets WHERE PlanetID = " + PlanetID);
            stmt.executeUpdate("DELETE from planetenvironments WHERE PlanetID = " + PlanetID);
            stmt.executeUpdate("DELETE from planetflags WHERE PlanetID = " + PlanetID);
            stmt.executeUpdate("DELETE from planetinfluences WHERE PlanetID = " + PlanetID);
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in deletePlanet: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void loadPlanets(CampaignData data) {
        try {
            ResultSet rs = null;
            Statement stmt = this.con.createStatement();
            String sql = "SELECT * from planets";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                SPlanet p = new SPlanet();
                p.setCompProduction(rs.getInt("pCompProd"));
                p.setPosition(new Position(rs.getFloat("pXpos"), rs.getFloat("pYpos")));
                p.setDescription(rs.getString("pDesc"));
                p.setBaysProvided(rs.getInt("pBays"));
                p.setConquerable(rs.getBoolean("pIsConquerable"));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                try {
                    p.setTimestamp(sdf.parse(rs.getString("pLastChanged")));
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("The following exception is not critical, but will cause useless bandwidth usage: please fix!");
                    CampaignData.mwlog.errLog(ex);
                    p.setTimestamp(new Date(0L));
                }
                p.setId(-1);
                p.setMapSize(new Dimension(rs.getInt("pMapSizeWidth"), rs.getInt("pMapSizeHeight")));
                p.setBoardSize(new Dimension(rs.getInt("pBoardSizeWidth"), rs.getInt("pBoardSizeHeight")));
                p.setTemp(new Dimension(rs.getInt("pTempWidth"), rs.getInt("pTempHeight")));
                p.setGravity(rs.getFloat("pGravity"));
                p.setVacuum(rs.getBoolean("pVacuum"));
                p.setNightChance(rs.getInt("pNightChance"));
                p.setNightTempMod(rs.getInt("pNightTempMod"));
                p.setMinPlanetOwnerShip(rs.getInt("pMinPlanetOwnership"));
                p.setHomeWorld(rs.getBoolean("pIsHomeworld"));
                p.setOriginalOwner(rs.getString("pOriginalOwner"));
                p.setConquestPoints(rs.getInt("pMaxConquestPoints"));
                p.setName(rs.getString("pName"));
                p.setDBID(rs.getInt("PlanetID"));
                this.loadInfluences(p, data);
                this.loadEnvironments(p, data);
                this.loadPlanetFlags(p, data);
                CampaignMain.cm.MySQL.loadFactories(p);
                CampaignMain.cm.addPlanet(p);
                p.setOwner(null, p.checkOwner(), false);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in loadPlanets: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void loadInfluences(SPlanet p, CampaignData data) {
        try {
            ResultSet rs1 = null;
            Statement stmt = this.con.createStatement();
            HashMap<Integer, Integer> influence = new HashMap<Integer, Integer>();
            rs1 = stmt.executeQuery("SELECT * from planetinfluences WHERE planetID = " + p.getDBID());
            while (rs1.next()) {
                Integer HouseInf = new Integer(rs1.getInt("influence"));
                String HouseName = rs1.getString("FactionName");
                SHouse h = (SHouse)data.getHouseByName(HouseName);
                if (h != null) {
                    influence.put(h.getId(), HouseInf);
                    continue;
                }
                if (HouseName.equalsIgnoreCase("None")) {
                    influence.put(-1, HouseInf);
                    continue;
                }
                CampaignData.mwlog.errLog("House not found: " + HouseName);
            }
            p.setInfluence(new Influences(influence));
            rs1.close();
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in loadInfluences: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void loadPlanetFlags(SPlanet p, CampaignData data) {
        try {
            ResultSet rs2 = null;
            Statement stmt = this.con.createStatement();
            TreeMap<String, String> map = new TreeMap<String, String>();
            rs2 = stmt.executeQuery("SELECT * from planetflags WHERE planetID = " + p.getDBID());
            while (rs2.next()) {
                String key = rs2.getString("PlanetFlag");
                if (!CampaignMain.cm.getData().getPlanetOpFlags().containsKey(key)) continue;
                map.put(key, CampaignMain.cm.getData().getPlanetOpFlags().get(key));
            }
            p.setPlanetFlags(map);
            rs2.close();
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in loadPlanetFlags: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void loadEnvironments(SPlanet p, CampaignData data) {
        ResultSet rs3 = null;
        Statement stmt = null;
        try {
            stmt = this.con.createStatement();
            rs3 = stmt.executeQuery("SELECT * from planetenvironments WHERE PlanetID = " + p.getDBID());
            while (rs3.next()) {
                int size = rs3.getInt("ContinentSize");
                Terrain planetEnvironment = null;
                int terrainNumber = 0;
                try {
                    terrainNumber = rs3.getInt("TerrainData");
                    planetEnvironment = data.getTerrain(terrainNumber);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.dbLog(ex);
                    CampaignData.mwlog.dbLog("Unable to load Terrain #" + terrainNumber);
                    planetEnvironment = data.getTerrain(0);
                }
                if (planetEnvironment == null) {
                    planetEnvironment = data.getTerrain(0);
                }
                Continent PE2 = new Continent(size, planetEnvironment);
                if (CampaignMain.cm.getBooleanConfig("UseStaticMaps")) {
                    AdvancedTerrain aTerrain = new AdvancedTerrain();
                    String tempHolder = rs3.getString("AdvancedTerrainData");
                    if (tempHolder.length() > 0) {
                        StringTokenizer ST = new StringTokenizer(tempHolder, "$");
                        aTerrain.setDisplayName(ST.nextToken());
                        aTerrain.setXSize(Integer.parseInt(ST.nextToken()));
                        aTerrain.setYSize(Integer.parseInt(ST.nextToken()));
                        aTerrain.setStaticMap(Boolean.parseBoolean(ST.nextToken()));
                        aTerrain.setXBoardSize(Integer.parseInt(ST.nextToken()));
                        aTerrain.setYBoardSize(Integer.parseInt(ST.nextToken()));
                        aTerrain.setLowTemp(Integer.parseInt(ST.nextToken()));
                        aTerrain.setHighTemp(Integer.parseInt(ST.nextToken()));
                        aTerrain.setGravity(Double.parseDouble(ST.nextToken()));
                        ST.nextToken();
                        aTerrain.setNightChance(Integer.parseInt(ST.nextToken()));
                        aTerrain.setNightTempMod(Integer.parseInt(ST.nextToken()));
                        aTerrain.setStaticMapName(ST.nextToken());
                    } else {
                        aTerrain = new AdvancedTerrain(tempHolder);
                    }
                    p.getAdvancedTerrain().put(new Integer(PE2.getEnvironment().getId()), aTerrain);
                }
                p.getEnvironments().add(PE2);
            }
            rs3.close();
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in loadEnvironments: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            try {
                if (rs3 != null) {
                    rs3.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
    }

    public void saveEnvironments(SPlanet p) {
        Statement stmt = null;
        StringBuffer sql = new StringBuffer();
        try {
            stmt = this.con.createStatement();
            sql.append("DELETE from planetenvironments WHERE PlanetID = " + p.getDBID());
            stmt.executeUpdate(sql.toString());
            Iterator<Continent> it = p.getEnvironments().iterator();
            while (it.hasNext()) {
                Continent t = it.next();
                int size = t.getSize();
                StringBuffer atData = new StringBuffer();
                StringBuffer tName = new StringBuffer();
                tName.append(t.getEnvironment().getName());
                int tId = t.getEnvironment().getId();
                if (CampaignMain.cm.getBooleanConfig("UseStaticMaps")) {
                    AdvancedTerrain aTerrain = p.getAdvancedTerrain().get(new Integer(t.getEnvironment().getId()));
                    if (aTerrain == null) {
                        aTerrain = new AdvancedTerrain();
                    }
                    if (aTerrain.getDisplayName().length() <= 1) {
                        aTerrain.setDisplayName(t.getEnvironment().getName());
                    }
                    atData.append(aTerrain.toString());
                }
                sql.setLength(0);
                sql.append("INSERT into planetenvironments set ");
                sql.append("PlanetID = " + p.getDBID() + ", ");
                sql.append("ContinentSize = " + size + ", ");
                sql.append("TerrainData = '" + tId + "'");
                if (CampaignMain.cm.getBooleanConfig("UseStaticMaps")) {
                    sql.append(", AdvancedTerrainData = '" + atData.toString() + "'");
                }
                stmt.executeUpdate(sql.toString());
            }
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in saveEnvironments: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void savePlanetFlags(SPlanet p) {
        Statement stmt = null;
        StringBuffer sql = new StringBuffer();
        try {
            stmt = this.con.createStatement();
            sql.append("DELETE from planetflags WHERE PlanetID = " + p.getDBID());
            stmt.executeUpdate(sql.toString());
            for (String key : p.getPlanetFlags().keySet()) {
                sql.setLength(0);
                sql.append("INSERT into planetflags set PlanetID = " + p.getDBID() + "PlanetFlag = '" + key + "'");
                stmt.executeUpdate(sql.toString());
            }
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in savePlanetFlags: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInfluences(SPlanet p) {
        Iterator<House> it = p.getInfluence().getHouses().iterator();
        Statement ps = null;
        StringBuffer sql = new StringBuffer();
        int pid = p.getDBID();
        try {
            ps = this.con.prepareStatement("DELETE from planetinfluences WHERE PlanetID = " + pid);
            ps.executeUpdate();
            while (it.hasNext()) {
                ps.close();
                SHouse next = (SHouse)it.next();
                String iName = next.getName().replace("'", "'");
                int iInf = p.getInfluence().getInfluence(next.getId());
                sql.setLength(0);
                sql.append("INSERT into planetinfluences set PlanetID = ?, ");
                sql.append("FactionName = ?, ");
                sql.append("Influence = ?");
                ps = this.con.prepareStatement(sql.toString());
                ps.setInt(1, pid);
                ps.setString(2, iName);
                ps.setInt(3, iInf);
                ps.execute();
            }
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in planetHandler.saveInfluences: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {}
        }
    }

    public planetHandler(Connection c) {
        this.con = c;
    }
}

