/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import common.CampaignData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import server.campaign.CampaignMain;

public class AutomaticBackup
extends Thread {
    String dateTime = "";
    String factionZipFileName = "";
    String planetZipFileName = "";
    String playerZipFileName = "";
    String dataZipFileName = "";
    String dateTimeFormat = "yyyy.MM.dd.HH.mm";
    FileOutputStream out;
    ZipOutputStream zipFile;
    long time;

    public AutomaticBackup(long time) {
        super("Automatic Backup");
        this.time = time;
    }

    public void run() {
        if (this.time < 1L) {
            return;
        }
        long backupHours = Long.parseLong(CampaignMain.cm.getConfig("AutomaticBackupHours")) * 3600000L;
        long lastBackup = Long.parseLong(CampaignMain.cm.getConfig("LastAutomatedBackup"));
        if (lastBackup > this.time - backupHours) {
            return;
        }
        CampaignData.mwlog.mainLog("Archiving Started at " + this.time);
        CampaignMain.cm.setArchiving(true);
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.backupDB(this.time);
        }
        SimpleDateFormat sDF = new SimpleDateFormat(this.dateTimeFormat);
        Date date = new Date(this.time);
        File folder = new File("./campaign/backup");
        if (!folder.exists()) {
            folder.mkdir();
        }
        this.dateTime = sDF.format(date);
        this.factionZipFileName = "./campaign/backup/factions" + this.dateTime + ".zip";
        this.planetZipFileName = "./campaign/backup/planets" + this.dateTime + ".zip";
        this.playerZipFileName = "./campaign/backup/players" + this.dateTime + ".zip";
        this.dataZipFileName = "./campaign/backup/data" + this.dateTime + ".zip";
        if (!CampaignMain.cm.isUsingMySQL()) {
            try {
                this.out = new FileOutputStream(this.factionZipFileName);
                this.zipFile = new ZipOutputStream(this.out);
                this.zipBackupFactions();
                this.zipFile.close();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to create factions zip file");
                CampaignData.mwlog.errLog(ex);
            }
            try {
                this.out = new FileOutputStream(this.planetZipFileName);
                this.zipFile = new ZipOutputStream(this.out);
                this.zipBackupPlanets();
                this.zipFile.close();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to create planets zip file");
                CampaignData.mwlog.errLog(ex);
            }
            try {
                this.out = new FileOutputStream(this.playerZipFileName);
                this.zipFile = new ZipOutputStream(this.out);
                this.zipBackupPlayers();
                this.zipFile.close();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to create player zip file");
                CampaignData.mwlog.errLog(ex);
            }
        }
        try {
            this.out = new FileOutputStream(this.dataZipFileName);
            this.zipFile = new ZipOutputStream(this.out);
            this.zipBackupData();
            this.zipFile.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to create data zip file");
            CampaignData.mwlog.errLog(ex);
        }
        CampaignMain.cm.getConfig().setProperty("LastAutomatedBackup", Long.toString(this.time));
        CampaignMain.dso.createConfig();
        CampaignMain.cm.setArchiving(false);
        CampaignData.mwlog.mainLog("Archiving Ended.");
    }

    public void zipBackupFactions() {
        File folder = new File("./campaign/factions");
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            try {
                int c;
                FileInputStream in = new FileInputStream(files[i]);
                ZipEntry entry = new ZipEntry(files[i].getName());
                this.zipFile.putNextEntry(entry);
                while ((c = in.read()) != -1) {
                    this.zipFile.write(c);
                }
                this.zipFile.closeEntry();
                in.close();
                continue;
            }
            catch (FileNotFoundException fnfe) {
                CampaignData.mwlog.errLog("Unable to backup faction file: " + files[i].getName());
                continue;
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to backup faction files");
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public void zipBackupPlanets() {
        File folder = new File("./campaign/planets");
        File[] files = folder.listFiles();
        try {
            for (int i = 0; i < files.length; ++i) {
                int c;
                FileInputStream in = new FileInputStream(files[i]);
                ZipEntry entry = new ZipEntry(files[i].getName());
                this.zipFile.putNextEntry(entry);
                while ((c = in.read()) != -1) {
                    this.zipFile.write(c);
                }
                this.zipFile.closeEntry();
                in.close();
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to backup planet files");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void zipBackupPlayers() {
        File folder = new File("./campaign/players");
        File[] files = folder.listFiles();
        try {
            for (int i = 0; i < files.length; ++i) {
                int c;
                FileInputStream in = new FileInputStream(files[i]);
                ZipEntry entry = new ZipEntry(files[i].getName());
                this.zipFile.putNextEntry(entry);
                while ((c = in.read()) != -1) {
                    this.zipFile.write(c);
                }
                this.zipFile.closeEntry();
                in.close();
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to backup player files");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void zipBackupData() {
        this.zipBackupData("./data");
    }

    public void zipBackupData(String path) {
        File folder = new File(path);
        File[] files = folder.listFiles();
        try {
            for (int i = 0; i < files.length; ++i) {
                int c;
                ZipEntry entry;
                if (files[i].isDirectory()) {
                    entry = new ZipEntry(files[i].getPath() + "/");
                    this.zipFile.putNextEntry(entry);
                    this.zipBackupData(files[i].getPath());
                    continue;
                }
                FileInputStream in = new FileInputStream(files[i]);
                entry = new ZipEntry(path + "/" + files[i].getName());
                this.zipFile.putNextEntry(entry);
                while ((c = in.read()) != -1) {
                    this.zipFile.write(c);
                }
                this.zipFile.closeEntry();
                in.close();
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to backup server data files: " + path);
            CampaignData.mwlog.errLog(ex);
        }
    }
}

