/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import common.CampaignData;
import java.io.IOException;
import server.MWChatServer.commands.ICommands;
import server.MWChatServer.translator.jcrypt;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.util.MWPasswdRecord;

public class MWPasswd
implements ICommands {
    public static String getUserId(String target) {
        SPlayer player = CampaignMain.cm.getPlayer(target);
        if (player == null) {
            return null;
        }
        return player.getName();
    }

    public static final MWPasswdRecord getRecord(String userId) {
        SPlayer player = CampaignMain.cm.getPlayer(userId);
        if (player == null) {
            return null;
        }
        if (player.getPassword() == null) {
            return null;
        }
        return player.getPassword();
    }

    public static final MWPasswdRecord getRecord(String userId, String password) throws IOException, Exception {
        MWPasswdRecord r = MWPasswd.getRecord(userId.toLowerCase());
        if (r == null) {
            return null;
        }
        if (password == null) {
            password = "";
        }
        if (password.length() < 2) {
            CampaignData.mwlog.infoLog("Access denied: " + userId);
            throw new Exception(userId);
        }
        try {
            String salt = r.passwd.substring(0, 2);
            if (jcrypt.crypt(salt, password).equals(r.passwd)) {
                return r;
            }
        }
        catch (Exception ex) {
            return null;
        }
        CampaignData.mwlog.errLog("Access denied: " + userId);
        throw new Exception("/denied");
    }

    public static final void writeRecord(MWPasswdRecord r, String userId) throws IOException {
        SPlayer player = CampaignMain.cm.getPlayer(userId);
        if (player == null) {
            return;
        }
        player.setPassword(r);
    }

    public static final void removeRecord(String userid) {
        SPlayer player = CampaignMain.cm.getPlayer(userid);
        if (player == null) {
            return;
        }
        if (player.getPassword() != null) {
            player.setPassword(null);
        }
    }

    public static final void writeRecord(String userId, int access, String passwd) throws IOException {
        SPlayer player = CampaignMain.cm.getPlayer(userId);
        if (player == null) {
            CampaignData.mwlog.errLog("writeRecord::Player is null");
            return;
        }
        MWPasswdRecord r = new MWPasswdRecord(userId, access, passwd, System.currentTimeMillis(), "");
        String salt = String.valueOf(System.currentTimeMillis());
        int len = salt.length();
        salt = salt.substring(len - 2, len);
        r.passwd = jcrypt.crypt(salt, passwd);
        player.setPassword(r);
    }

    public static final synchronized void save() throws IOException {
    }

    public static void reloadFile() {
    }

    public static void main(String[] args) {
        try {
            MWPasswd.writeRecord(args[0], Integer.parseInt(args[1]), args[2]);
        }
        catch (IOException e) {
            CampaignData.mwlog.errLog("An I/O error occurred: " + e.getMessage());
        }
        catch (Exception e) {
            MWPasswd.showUsageAndExit();
        }
    }

    private static final void showUsageAndExit() {
        CampaignData.mwlog.errLog("Passwd Program.  Adds new line to the passwd file, encrypting the password.");
        CampaignData.mwlog.errLog("usage: java com.lyrisoft.chat.server.remote.auth.Passwd [user id] [access level] [password] [timeoflastuse]");
        System.exit(1);
    }

    static {
        MWPasswd.reloadFile();
    }
}

