/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import common.CampaignData;
import common.campaign.pilot.Pilot;
import common.util.StringUtils;
import common.util.UnitUtils;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Repair {
    private Entity unit;
    private String Username;
    private int unitID;
    private boolean armor = false;
    private int location = -1;
    private int slot;
    private long repairTime;
    private long startTime;
    private long endTime;
    private int techType;
    private int retries;
    private int techWorkMod;
    private boolean simpleRepair = false;
    private Vector<Integer> techs;
    private boolean salvage = false;

    public Repair(SPlayer player, int unitID, boolean armor, int location, int slot, int techType, int retries, int techWorkMod, boolean salvage) {
        this.unit = player.getUnit(unitID).getEntity();
        this.location = location;
        this.slot = slot;
        this.unitID = unitID;
        this.Username = player.getName();
        this.armor = armor;
        this.techType = techType;
        this.retries = retries;
        this.techWorkMod = techWorkMod;
        this.simpleRepair = false;
        this.salvage = salvage;
        if (techType == 5) {
            this.repairTime = 0L;
        } else {
            player.addAvailableTechs(techType, -1);
            this.setRepairTime();
        }
    }

    public Repair(SPlayer player, int unitID, Vector<Integer> techs, int repairTime, boolean simpleRepair, boolean salvage) {
        this.simpleRepair = simpleRepair;
        this.repairTime = repairTime;
        this.techs = techs;
        this.unitID = unitID;
        this.unit = player.getUnit(unitID).getEntity();
        this.Username = player.getName();
        this.location = 1;
        this.slot = 13;
        this.armor = true;
        this.unit.setArmor(0, 1);
        UnitUtils.setArmorRepair(this.unit, 13, 1);
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + (long)(repairTime * 1000);
        this.salvage = salvage;
    }

    public boolean finishRepair() {
        CriticalSlot cs = null;
        Pilot pilot = null;
        SPlayer player = CampaignMain.cm.getPlayer(this.Username);
        if (player == null) {
            CampaignData.mwlog.errLog("Could not find player " + this.Username + " removing repair job from queue.");
            return true;
        }
        SUnit mek = player.getUnit(this.unitID);
        if (mek == null) {
            CampaignData.mwlog.errLog("Could not find unit # " + this.unitID + " for player " + player.getName() + " removing repair job from queue.");
            return true;
        }
        pilot = mek.getPilot();
        try {
            int armorRepaired;
            int chance;
            int roll = 12;
            int die1 = CampaignMain.cm.getRandomNumber(6) + 1;
            int die2 = CampaignMain.cm.getRandomNumber(6) + 1;
            boolean levelTech = false;
            boolean pilotIsRepairing = false;
            boolean rear = false;
            boolean retireTech = false;
            boolean techDeath = false;
            boolean repairTech = this.techType == 5;
            boolean useCrits = CampaignMain.cm.getBooleanConfig("UsePartsRepair");
            String critName = "";
            int damagedCrits = 0;
            boolean disableTechAdvancement = CampaignMain.cm.getBooleanConfig("DisableTechAdvancement");
            if (useCrits) {
                critName = UnitUtils.getCritName(this.unit, this.slot, this.location, this.armor);
                if (this.armor) {
                    UnitUtils.removeArmorRepair(this.unit, this.slot, this.location);
                }
                damagedCrits = this.salvage ? (this.armor ? UnitUtils.getNumberOfCrits(this.unit, this.slot, this.location) : UnitUtils.getNumberOfCrits(this.unit, this.slot, this.location) - UnitUtils.getNumberOfDamagedCrits(this.unit, this.slot, this.location, this.armor)) : UnitUtils.getNumberOfDamagedCrits(this.unit, this.slot, this.location, this.armor);
                if (this.armor) {
                    UnitUtils.setArmorRepair(this.unit, this.slot, this.location);
                }
            }
            if (player.getAmountOfTimesUnitExistsInArmies(this.unitID) > 0 && player.getDutyStatus() == 3) {
                player.setSave();
                return false;
            }
            if (this.simpleRepair) {
                Entity entity = mek.getEntity();
                for (int x = 0; x < entity.locations(); ++x) {
                    entity.setArmor(entity.getOArmor(x), x);
                    if (entity.hasRearArmor(x)) {
                        entity.setArmor(entity.getOArmor(x, true), x, true);
                    }
                    entity.setInternal(entity.getOInternal(x), x);
                    for (int y = 0; y < entity.getNumberOfCriticals(x); ++y) {
                        cs = entity.getCritical(x, y);
                        if (cs == null) continue;
                        if (cs.getType() == 1) {
                            Mounted mounted = entity.getEquipment(cs.getIndex());
                            UnitUtils.repairEquipment(mounted, entity, x);
                            continue;
                        }
                        if (UnitUtils.isEngineCrit(cs)) {
                            UnitUtils.repairDamagedEngine(entity);
                            continue;
                        }
                        if (entity instanceof Mech) {
                            UnitUtils.fixCriticalSlot(cs, entity, true);
                            UnitUtils.fixCriticalSlot(cs, entity, false);
                        }
                        entity.setCritical(x, y, cs);
                    }
                }
                for (int type = 1; type <= 6; ++type) {
                    this.techType = this.techs.elementAt(type);
                    die1 = CampaignMain.cm.getRandomNumber(6) + 1;
                    die2 = CampaignMain.cm.getRandomNumber(6) + 1;
                    if (!disableTechAdvancement) {
                        if (die1 + die2 >= 10 + this.techType && !pilotIsRepairing && !repairTech) {
                            levelTech = true;
                        } else if (die1 + die2 >= 11 + this.techType && pilotIsRepairing) {
                            levelTech = true;
                        }
                    }
                    die1 = CampaignMain.cm.getRandomNumber(6) + 1;
                    die2 = CampaignMain.cm.getRandomNumber(6) + 1;
                    if (!(this.techType <= 0 || die1 + die2 > (9 + this.techType) / 4 || pilotIsRepairing || levelTech || repairTech || disableTechAdvancement)) {
                        retireTech = true;
                    }
                    if (pilotIsRepairing) {
                        mek.setPilotIsRepairing(false);
                    }
                    if (levelTech) {
                        if (pilotIsRepairing) {
                            pilot.getSkills().getPilotSkill(2).setLevel(pilot.getSkills().getPilotSkill(2).getLevel() + 1);
                            CampaignMain.cm.toUser("FSM|" + pilot.getName() + " has graduated to " + StringUtils.aOrAn(UnitUtils.techDescription(this.techType + 1), true) + " tech.", this.Username, false);
                        } else if (player.getTotalTechs().elementAt(this.techType) > 0) {
                            player.addAvailableTechs(this.techType + 1, 1);
                            player.addTotalTechs(this.techType, -1);
                            player.addTotalTechs(this.techType + 1, 1);
                            CampaignMain.cm.toUser("FSM|One of your " + UnitUtils.techDescription(this.techType) + " techs has graduated to " + StringUtils.aOrAn(UnitUtils.techDescription(this.techType + 1), true) + " tech.", this.Username, false);
                        }
                    }
                    if (retireTech && player.getTotalTechs().elementAt(this.techType) > 0) {
                        CampaignMain.cm.toUser("FSM|<font color=#ff80ff>One of your " + UnitUtils.techDescription(this.techType) + " techs retired.</font>", this.Username, false);
                        player.addAvailableTechs(this.techType, -1);
                        player.addTotalTechs(this.techType, -1);
                    }
                    CampaignMain.cm.toUser("PL|UU|" + this.unitID + "|" + mek.toString(true), this.Username, false);
                    player.checkAndUpdateArmies(mek);
                }
                CampaignMain.cm.toUser("FSM|Your " + this.unit.getShortNameRaw() + " is now fully operational and combat ready again!", this.Username, false);
                player.setSave();
                return true;
            }
            if (this.techType == 4) {
                pilot = mek.getPilot();
                this.techType = pilot.getSkills().getPilotSkill(2).getLevel();
                pilotIsRepairing = true;
            }
            if (this.techWorkMod > 0) {
                roll = UnitUtils.getTechRoll(this.unit, this.location, this.slot, this.techType - this.techWorkMod, this.armor, player.getMyHouse().getTechLevel(), this.salvage);
            } else {
                roll = UnitUtils.getTechRoll(this.unit, this.location, this.slot, this.techType, this.armor, player.getMyHouse().getTechLevel(), this.salvage);
                roll += this.techWorkMod;
            }
            roll = !this.armor && this.unit.getCritical(this.location, this.slot) != null && this.unit.getCritical(this.location, this.slot).isBreached() ? Math.max(roll, 2) : Math.max(roll, 3);
            if (repairTech) {
                roll = 2;
                die2 = 6;
                die1 = 6;
            }
            if (die1 + die2 == 2 && !pilotIsRepairing && (chance = CampaignMain.cm.getIntegerConfig("ChanceTechDiesOnFailedRepair")) > CampaignMain.cm.getRandomNumber(100)) {
                techDeath = true;
                this.retries = 0;
            }
            CampaignMain.cm.toUser("FSM|Tech Roll Base: " + roll + " Roll: " + (die1 + die2), this.Username, false);
            if (die1 + die2 < roll) {
                if (this.armor) {
                    armorRepaired = 0;
                    int armorToRepair = 0;
                    rear = false;
                    if (this.slot != 15) {
                        switch (this.location) {
                            case 8: {
                                this.location = 1;
                                rear = true;
                                break;
                            }
                            case 10: {
                                this.location = 3;
                                rear = true;
                                break;
                            }
                            case 9: {
                                this.location = 2;
                                rear = true;
                                break;
                            }
                            default: {
                                rear = this.slot == 14;
                            }
                        }
                        if (this.salvage) {
                            UnitUtils.removeArmorRepair(this.unit, this.slot, this.location);
                            armorToRepair = this.unit.getArmor(this.location, rear);
                            armorRepaired = armorToRepair <= 3 ? 1 : CampaignMain.cm.getRandomNumber(armorToRepair - 2) + 1;
                            armorRepaired = Math.max(1, armorRepaired - (roll - (die1 + die2)));
                            if (roll > 12) {
                                armorRepaired = 0;
                            }
                            player.updatePartsCache(critName, armorRepaired);
                            this.unit.setArmor(0, this.location, rear);
                            String points = " points ";
                            if (armorRepaired == 1) {
                                points = " point ";
                            }
                            if (rear) {
                                CampaignMain.cm.toUser("FSM|The salvage job was not completely successful only " + armorRepaired + points + "of external armor(" + this.unit.getLocationAbbr(this.location) + "r) were salvaged from your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                            } else {
                                CampaignMain.cm.toUser("FSM|The salvage job was not completely successful only " + armorRepaired + points + "of external armor(" + this.unit.getLocationAbbr(this.location) + ") were salvaged from your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                            }
                        } else {
                            UnitUtils.removeArmorRepair(this.unit, this.slot, this.location);
                            armorToRepair = this.unit.getOArmor(this.location, rear) - this.unit.getArmor(this.location, rear);
                            armorRepaired = armorToRepair <= 3 ? 1 : CampaignMain.cm.getRandomNumber(armorToRepair - 2) + 1;
                            armorRepaired = Math.max(1, armorRepaired - (roll - (die1 + die2)));
                            if (roll > 12) {
                                armorRepaired = 0;
                            }
                            this.unit.setArmor(this.unit.getArmor(this.location, rear) + armorRepaired, this.location, rear);
                            String points = " points ";
                            if (armorRepaired == 1) {
                                points = " point ";
                            }
                            if (rear) {
                                CampaignMain.cm.toUser("FSM|The repair job was not completely successful only " + armorRepaired + points + "of external armor(" + this.unit.getLocationAbbr(this.location) + "r) were repaired on your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                            } else {
                                CampaignMain.cm.toUser("FSM|The repair job was not completely successful only " + armorRepaired + points + "of external armor(" + this.unit.getLocationAbbr(this.location) + ") were repaired on your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                            }
                            if (this.unit.getArmor(this.location, rear) == this.unit.getOArmor(this.location, rear)) {
                                if (rear) {
                                    CampaignMain.cm.toUser("FSM|However the external armor(" + this.unit.getLocationAbbr(this.location) + "r) is now fully repaired.", this.Username, false);
                                } else {
                                    CampaignMain.cm.toUser("FSM|However the external armor(" + this.unit.getLocationAbbr(this.location) + ") is now fully repaired.", this.Username, false);
                                }
                                this.unit.setArmor(this.unit.getOArmor(this.location, rear), this.location, rear);
                                this.retries = 0;
                            }
                        }
                    } else if (this.salvage) {
                        UnitUtils.removeArmorRepair(this.unit, 15, this.location);
                        armorToRepair = this.unit.getInternal(this.location);
                        armorRepaired = armorToRepair <= 3 ? 1 : CampaignMain.cm.getRandomNumber(armorToRepair - 2) + 1;
                        armorRepaired = Math.max(1, armorRepaired - (roll - (die1 + die2)));
                        if (roll > 12) {
                            armorRepaired = 0;
                        }
                        player.updatePartsCache(critName, armorRepaired);
                        this.unit.setInternal(0, this.location);
                        String points = " points ";
                        if (armorRepaired == 1) {
                            points = " point ";
                        }
                        CampaignMain.cm.toUser("FSM|The repair job was not completely successful only " + armorRepaired + points + "of internal structure(" + this.unit.getLocationAbbr(this.location) + ") were salvaged from your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                    } else {
                        UnitUtils.removeArmorRepair(this.unit, 15, this.location);
                        if (this.unit.getInternal(this.location) < 0) {
                            this.unit.setInternal(0, this.location);
                        }
                        armorRepaired = (armorToRepair = this.unit.getOInternal(this.location) - this.unit.getInternal(this.location)) <= 3 ? 1 : CampaignMain.cm.getRandomNumber(armorToRepair - 2) + 1;
                        armorRepaired = Math.max(1, armorRepaired - (roll - (die1 + die2)));
                        if (roll > 12) {
                            armorRepaired = 0;
                        }
                        this.unit.setInternal(this.unit.getInternal(this.location) + armorRepaired, this.location);
                        String points = " points ";
                        if (armorRepaired == 1) {
                            points = " point ";
                        }
                        CampaignMain.cm.toUser("FSM|The repair job was not completely successful only " + armorRepaired + points + "of internal structure(" + this.unit.getLocationAbbr(this.location) + ") were repaired on your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                        if (this.unit.getOInternal(this.location) == this.unit.getInternal(this.location)) {
                            CampaignMain.cm.toUser("FSM|However the internal structure(" + this.unit.getLocationAbbr(this.location) + ") is now fully repaired.", this.Username, false);
                            this.unit.setInternal(this.unit.getOInternal(this.location), this.location);
                            this.retries = 0;
                        }
                    }
                } else {
                    String repairMessage = "";
                    cs = this.unit.getCritical(this.location, this.slot);
                    if (this.salvage) {
                        if (cs.getType() == 1) {
                            Mounted mounted = this.unit.getEquipment(cs.getIndex());
                            repairMessage = "The salvage job for the " + mounted.getName() + "(" + this.unit.getLocationAbbr(this.location) + ") on the " + this.unit.getShortNameRaw() + " was a complete failure and the part was lost.";
                            UnitUtils.salvageEquipment(mounted, this.unit, this.location);
                        } else if (UnitUtils.isEngineCrit(cs)) {
                            repairMessage = "The salvage job on the engines for the " + this.unit.getShortNameRaw() + " was a complete failure and the engines are now completely destroyed.";
                            UnitUtils.destroyAllEngineCrits(this.unit);
                        } else if (this.unit instanceof Mech) {
                            repairMessage = "The salvage job for the " + ((Mech)this.unit).getSystemName(cs.getIndex()) + "(" + this.unit.getLocationAbbr(this.location) + ") of the " + this.unit.getShortName() + " was a complete failure and the part was lost.";
                            UnitUtils.salvageSystemCrit(this.location, cs, this.unit);
                        }
                        CampaignMain.cm.toUser("FSM|" + repairMessage, this.Username, false);
                    } else {
                        if (cs.getType() == 1) {
                            Mounted mounted = this.unit.getEquipment(cs.getIndex());
                            repairMessage = "The repair job for the " + mounted.getName() + "(" + this.unit.getLocationAbbr(this.location) + ") on the " + this.unit.getShortNameRaw() + " was a complete failure.";
                        } else if (UnitUtils.isEngineCrit(cs)) {
                            repairMessage = "The repair job on the engines for the " + this.unit.getShortNameRaw() + " was a complete failure.";
                        } else if (this.unit instanceof Mech) {
                            repairMessage = "The repair job for the " + ((Mech)this.unit).getSystemName(cs.getIndex()) + "(" + this.unit.getLocationAbbr(this.location) + ") of the " + this.unit.getShortName() + " was a complete failure.";
                        }
                        CampaignMain.cm.toUser("FSM|" + repairMessage, this.Username, false);
                    }
                }
                if (this.retries > 0 && roll < 13) {
                    if (pilotIsRepairing) {
                        this.techType = 4;
                    }
                    int cost = CampaignMain.cm.getRepairCost(this.unit, this.location, this.slot, this.techType, this.armor, this.techWorkMod, this.salvage);
                    if (player.getAutoReorder() && player.getPartsAmount(critName) < damagedCrits) {
                        String newCommand = critName + "#" + damagedCrits;
                        CampaignMain.cm.getServerCommands().get("BUYPARTS").process(new StringTokenizer(newCommand, "#"), this.Username);
                    }
                    if (cost < player.getMoney() && player.getPartsAmount(critName) >= damagedCrits) {
                        --this.retries;
                        this.setRepairTime();
                        CampaignMain.cm.toUser("FSM|The tech responsible rededicates himself to the task.", this.Username, false);
                        player.addMoney(-cost);
                        player.getUnit(this.unitID).addRepairCost(cost);
                        if (this.armor) {
                            UnitUtils.setArmorRepair(this.unit, this.slot, this.location);
                        } else if (cs != null) {
                            UnitUtils.setRepairing(this.unit, cs);
                        }
                        if (rear) {
                            this.location += 7;
                        }
                        mek.setEntity(this.unit);
                        CampaignMain.cm.toUser("PL|UU|" + this.unitID + "|" + mek.toString(true), this.Username, false);
                        player.checkAndUpdateArmies(mek);
                        if (useCrits) {
                            if (critName.indexOf("Ammo") > -1) {
                                player.updatePartsCache("Ammo Bin", -1);
                            } else {
                                player.updatePartsCache(critName, -1);
                            }
                        }
                        player.setSave();
                        return false;
                    }
                }
                if (this.armor) {
                    UnitUtils.removeArmorRepair(this.unit, this.slot, this.location);
                } else if (cs != null) {
                    UnitUtils.removeRepairing(this.unit, cs);
                }
                mek.setEntity(this.unit);
                CampaignMain.cm.toUser("PL|UU|" + this.unitID + "|" + mek.toString(true), this.Username, false);
                player.checkAndUpdateArmies(mek);
            } else {
                if (this.armor) {
                    armorRepaired = 0;
                    rear = false;
                    if (this.slot != 15) {
                        switch (this.location) {
                            case 8: {
                                this.location = 1;
                                rear = true;
                                break;
                            }
                            case 10: {
                                this.location = 3;
                                rear = true;
                                break;
                            }
                            case 9: {
                                this.location = 2;
                                rear = true;
                                break;
                            }
                            default: {
                                rear = this.slot == 14;
                            }
                        }
                        UnitUtils.removeArmorRepair(this.unit, this.slot, this.location);
                        if (this.salvage) {
                            armorRepaired = this.unit.getArmor(this.location, rear);
                            this.unit.setArmor(0, this.location, rear);
                            player.updatePartsCache(critName, armorRepaired);
                            String points = " points ";
                            if (armorRepaired == 1) {
                                points = " point ";
                            }
                            if (rear) {
                                CampaignMain.cm.toUser("FSM|" + armorRepaired + points + "of external armor(" + this.unit.getLocationAbbr(this.location) + "r) were salvaged from your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                            } else {
                                CampaignMain.cm.toUser("FSM|" + armorRepaired + points + "of external armor(" + this.unit.getLocationAbbr(this.location) + ") were salvaged from your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                            }
                        } else {
                            armorRepaired = this.unit.getOArmor(this.location, rear) - this.unit.getArmor(this.location, rear);
                            this.unit.setArmor(this.unit.getOArmor(this.location, rear), this.location, rear);
                            String points = " points ";
                            if (armorRepaired == 1) {
                                points = " point ";
                            }
                            if (rear) {
                                CampaignMain.cm.toUser("FSM|" + armorRepaired + points + "of external armor(" + this.unit.getLocationAbbr(this.location) + "r) were repaired on your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                            } else {
                                CampaignMain.cm.toUser("FSM|" + armorRepaired + points + "of external armor(" + this.unit.getLocationAbbr(this.location) + ") were repaired on your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                            }
                        }
                    } else {
                        UnitUtils.removeArmorRepair(this.unit, this.slot, this.location);
                        if (this.salvage) {
                            armorRepaired = this.unit.getInternal(this.location);
                            this.unit.setInternal(0, this.location);
                            String points = " points ";
                            player.updatePartsCache(critName, armorRepaired);
                            if (armorRepaired == 1) {
                                points = " point ";
                            }
                            CampaignMain.cm.toUser("FSM|" + armorRepaired + points + "of internal structure(" + this.unit.getLocationAbbr(this.location) + ") were salvaged from your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                        } else {
                            armorRepaired = this.unit.getOInternal(this.location) - this.unit.getInternal(this.location);
                            this.unit.setInternal(this.unit.getOInternal(this.location), this.location);
                            String points = " points ";
                            if (armorRepaired == 1) {
                                points = " point ";
                            }
                            CampaignMain.cm.toUser("FSM|" + armorRepaired + points + "of internal structure(" + this.unit.getLocationAbbr(this.location) + ") were repaired on your " + this.unit.getShortNameRaw() + ".", this.Username, false);
                        }
                    }
                } else {
                    String repairMessage = "";
                    cs = this.unit.getCritical(this.location, this.slot);
                    if (this.salvage) {
                        if (cs.getType() == 1) {
                            Mounted mounted = this.unit.getEquipment(cs.getIndex());
                            UnitUtils.salvageEquipment(mounted, this.unit, this.location);
                            repairMessage = "The " + mounted.getName() + "(" + this.unit.getLocationAbbr(this.location) + ") on the " + this.unit.getShortNameRaw() + " was succesfully salvaged.";
                            if (mounted.getType() instanceof AmmoType) {
                                player.updatePartsCache("Ammo Bin", 1);
                                damagedCrits = mounted.getShotsLeft();
                                critName = ((AmmoType)mounted.getType()).getInternalName();
                                if (damagedCrits > 0) {
                                    repairMessage = repairMessage + "<br>" + damagedCrits + " rounds of " + ((AmmoType)mounted.getType()).getName() + " where recovered along with the bin.";
                                }
                            }
                        } else if (UnitUtils.isEngineCrit(cs)) {
                            UnitUtils.destroyAllEngineCrits(this.unit);
                            repairMessage = "All viable engines parts on the " + this.unit.getShortNameRaw() + " have been successfully salvaged.";
                        } else {
                            if (this.unit instanceof Mech) {
                                repairMessage = "The " + ((Mech)this.unit).getSystemName(cs.getIndex()) + "(" + this.unit.getLocationAbbr(this.location) + ") of your " + this.unit.getShortName() + " has been salvaged.";
                            }
                            UnitUtils.salvageSystemCrit(this.location, cs, this.unit);
                            this.unit.setCritical(this.location, this.slot, cs);
                        }
                        player.updatePartsCache(critName, damagedCrits);
                        CampaignMain.cm.toUser("FSM|" + repairMessage, this.Username, false);
                    } else {
                        if (cs.getType() == 1) {
                            Mounted mounted = this.unit.getEquipment(cs.getIndex());
                            UnitUtils.repairEquipment(mounted, this.unit, this.location);
                            if (mounted.getType() instanceof AmmoType) {
                                critName = "Ammo Bin";
                            }
                            repairMessage = "The " + mounted.getName() + "(" + this.unit.getLocationAbbr(this.location) + ") on the " + this.unit.getShortNameRaw() + " is now fully functional.";
                        } else if (UnitUtils.isEngineCrit(cs)) {
                            UnitUtils.repairDamagedEngine(this.unit);
                            repairMessage = "All engines on the " + this.unit.getShortNameRaw() + " are now fully functional.";
                        } else {
                            if (this.unit instanceof Mech) {
                                repairMessage = "The " + ((Mech)this.unit).getSystemName(cs.getIndex()) + "(" + this.unit.getLocationAbbr(this.location) + ") of the " + this.unit.getShortName() + " is now fully functional.";
                            }
                            UnitUtils.repairSystemCrit(this.location, cs, this.unit);
                            this.unit.setCritical(this.location, this.slot, cs);
                        }
                        CampaignMain.cm.toUser("FSM|" + repairMessage, this.Username, false);
                    }
                }
                die1 = CampaignMain.cm.getRandomNumber(6) + 1;
                die2 = CampaignMain.cm.getRandomNumber(6) + 1;
                if (!disableTechAdvancement) {
                    if (die1 + die2 >= 10 + this.techType && !pilotIsRepairing && !repairTech) {
                        levelTech = true;
                    } else if (die1 + die2 >= 11 + this.techType && pilotIsRepairing) {
                        levelTech = true;
                    }
                }
                die1 = CampaignMain.cm.getRandomNumber(6) + 1;
                die2 = CampaignMain.cm.getRandomNumber(6) + 1;
                if (!(this.techType <= 0 || die1 + die2 > (9 + this.techType) / 4 || pilotIsRepairing || levelTech || repairTech || disableTechAdvancement)) {
                    retireTech = true;
                }
            }
            if (pilotIsRepairing) {
                mek.setPilotIsRepairing(false);
            }
            if (!(UnitUtils.hasArmorDamage(this.unit) || UnitUtils.hasCriticalDamage(this.unit) || UnitUtils.isRepairing(this.unit))) {
                SUnit su = player.getUnit(this.unitID);
                CampaignMain.cm.toUser("FSM|Your " + this.unit.getShortNameRaw() + " is now fully operational and combat ready again!<br>Total Cost was " + CampaignMain.cm.moneyOrFluMessage(true, true, su.getCurrentRepairCost()), this.Username, false);
                su.addRepairCost(-1);
            }
            if (levelTech) {
                if (pilotIsRepairing) {
                    pilot.getSkills().getPilotSkill(2).setLevel(pilot.getSkills().getPilotSkill(2).getLevel() + 1);
                    CampaignMain.cm.toUser("FSM|<font color=#C11B17>" + pilot.getName() + " advanced in skill and is now " + StringUtils.aOrAn(UnitUtils.techDescription(this.techType + 1), true) + " tech.</font>", this.Username, false);
                } else {
                    player.addAvailableTechs(this.techType + 1, 1);
                    player.addTotalTechs(this.techType, -1);
                    player.addTotalTechs(this.techType + 1, 1);
                    CampaignMain.cm.toUser("FSM|<font color=#C11B17>One of your " + UnitUtils.techDescription(this.techType) + " techs advanced in skill and is now " + StringUtils.aOrAn(UnitUtils.techDescription(this.techType + 1), true) + " tech.</font>", this.Username, false);
                }
            } else if (!pilotIsRepairing && !repairTech) {
                player.addAvailableTechs(this.techType, 1);
            }
            if (retireTech) {
                CampaignMain.cm.toUser("FSM|<font color=#ff80ff>One of your " + UnitUtils.techDescription(this.techType) + " techs retired.</font>", this.Username, false);
                player.addAvailableTechs(this.techType, -1);
                player.addTotalTechs(this.techType, -1);
            }
            if (techDeath) {
                CampaignMain.cm.toUser("FSM|<font color=#302226>One of your " + UnitUtils.techDescription(this.techType) + " techs was killed in an accident while repairing " + this.unit.getShortNameRaw() + ".</font>", this.Username, false);
                player.addAvailableTechs(this.techType, -1);
                player.addTotalTechs(this.techType, -1);
            }
            mek.setEntity(this.unit);
            CampaignMain.cm.toUser("PL|UU|" + this.unitID + "|" + mek.toString(true), this.Username, false);
            player.setSave();
            player.checkAndUpdateArmies(mek);
            return true;
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Failed to trap the following error removing repair job from queue: ");
            CampaignData.mwlog.errLog(ex);
            if (mek != null && player != null) {
                mek.setEntity(this.unit);
                CampaignMain.cm.toUser("PL|UU|" + this.unitID + "|" + mek.toString(true), this.Username, false);
                player.setSave();
                player.checkAndUpdateArmies(mek);
            }
            return true;
        }
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean matches(int unitID, int location, int slot, boolean armor) {
        return this.location == location && this.unitID == unitID && this.slot == slot && this.armor == armor;
    }

    public int getUnitID() {
        return this.unitID;
    }

    public boolean getArmor() {
        return this.armor;
    }

    public int getLocation() {
        return this.location;
    }

    public int getSlot() {
        return this.slot;
    }

    public Entity getUnit() {
        return this.unit;
    }

    public String getUsername() {
        return this.Username;
    }

    public int getTechType() {
        return this.techType;
    }

    public boolean isSimpleRepair() {
        return this.simpleRepair;
    }

    public void setRepairTime() {
        this.repairTime = Long.parseLong(CampaignMain.cm.getConfig("TimeForEachRepairPoint")) * 1000L;
        if (!this.armor) {
            CriticalSlot cs = this.unit.getCritical(this.location, this.slot);
            UnitUtils.setRepairing(this.unit, cs);
            this.repairTime *= (long)UnitUtils.getNumberOfCrits(this.unit, cs);
        } else {
            int templocation = this.location;
            if (this.slot != 15) {
                switch (this.location) {
                    case 8: {
                        templocation = 1;
                        break;
                    }
                    case 10: {
                        templocation = 3;
                        break;
                    }
                    case 9: {
                        templocation = 2;
                        break;
                    }
                }
            }
            UnitUtils.setArmorRepair(this.unit, this.slot, templocation);
        }
        if (this.techWorkMod > 0) {
            this.repairTime /= 2L;
        }
        if (this.techWorkMod < 0) {
            for (int x = 0; x > this.techWorkMod; --x) {
                this.repairTime *= 2L;
            }
        }
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + this.repairTime;
    }

    public void stopRepair() {
        if (this.armor) {
            if (this.slot != 15) {
                switch (this.location) {
                    case 8: {
                        this.location = 1;
                        break;
                    }
                    case 10: {
                        this.location = 3;
                        break;
                    }
                    case 9: {
                        this.location = 2;
                        break;
                    }
                }
                UnitUtils.removeArmorRepair(this.unit, this.slot, this.location);
            } else {
                UnitUtils.removeArmorRepair(this.unit, this.slot, this.location);
            }
        } else {
            CriticalSlot cs = this.unit.getCritical(this.location, this.slot);
            UnitUtils.removeRepairing(this.unit, cs);
        }
    }
}

