/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import common.CampaignData;
import java.util.Calendar;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import megamek.common.CriticalSlot;
import megamek.common.Mech;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.util.Repair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepairTrackingThread
extends Thread {
    private Vector<Repair> repairList = new Vector(1, 1);
    private long repairtime = 0L;

    public RepairTrackingThread(long Time2) {
        super("Repair Tracking Thread");
        this.repairtime = Time2;
    }

    @Override
    public synchronized void run() {
        try {
            while (true) {
                this.wait(this.repairtime);
                this.checkRepairs();
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error while trying to sleep in RepairTrackingThread");
            CampaignData.mwlog.errLog(ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRepairs() {
        try {
            ConcurrentLinkedQueue<Repair> tempVector;
            ConcurrentLinkedQueue<Repair> concurrentLinkedQueue = tempVector = new ConcurrentLinkedQueue<Repair>(this.repairList);
            synchronized (concurrentLinkedQueue) {
                for (Repair repairOrder : tempVector) {
                    if (repairOrder == null) {
                        this.repairList.removeElement(repairOrder);
                        return;
                    }
                    if (repairOrder.getEndTime() > System.currentTimeMillis()) continue;
                    try {
                        if (CampaignMain.cm.getPlayer(repairOrder.getUsername()) != null && !repairOrder.finishRepair()) continue;
                        this.repairList.removeElement(repairOrder);
                        SPlayer player = CampaignMain.cm.getPlayer(repairOrder.getUsername());
                        player.checkAndUpdateArmies(player.getUnit(repairOrder.getUnitID()));
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog("Unable to finish repair for " + repairOrder.getUsername() + " for unit #" + repairOrder.getUnitID() + " " + repairOrder.getUnit().getShortNameRaw());
                        CampaignData.mwlog.errLog(ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error while checking repair. Containing and continuing.");
            CampaignData.mwlog.errLog(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String unitRepairTimes(int unitID) {
        String results = "";
        String unitName = "";
        int SEC = 1000;
        int MIN = SEC * 60;
        int HOUR = MIN * 60;
        int DAY = HOUR * 24;
        Vector<Repair> vector = this.repairList;
        synchronized (vector) {
            for (Repair repairOrder : this.repairList) {
                long mills;
                if (repairOrder.getUnitID() != unitID) continue;
                if (unitName.length() < 1) {
                    unitName = repairOrder.getUnit().getShortNameRaw();
                }
                if ((mills = repairOrder.getEndTime() - System.currentTimeMillis()) < 0L) {
                    mills = (long)((double)mills + CampaignMain.cm.getDoubleConfig("TimeForEachRepairPoint") * 1000.0);
                }
                Calendar time = Calendar.getInstance();
                time.setTimeInMillis(mills);
                String output = "";
                if (mills >= (long)DAY) {
                    output = output + mills / (long)DAY + "d ";
                    mills %= (long)DAY;
                }
                if (mills >= (long)HOUR) {
                    output = output + mills / (long)HOUR + "h ";
                    mills %= (long)HOUR;
                }
                if (mills >= (long)MIN) {
                    output = output + mills / (long)MIN + "m ";
                    mills %= (long)MIN;
                }
                if (mills >= (long)SEC) {
                    output = output + mills / (long)SEC + "s ";
                    mills %= (long)SEC;
                }
                output = output.trim();
                if (repairOrder.isSimpleRepair()) {
                    results = "#" + unitID + " " + unitName + " is undergoing a complete repair cycle. ETA: " + output + ".";
                    return results;
                }
                if (repairOrder.getArmor()) {
                    boolean rear = false;
                    int armorLocation = repairOrder.getLocation();
                    if (repairOrder.getSlot() < 15) {
                        switch (armorLocation) {
                            case 8: {
                                armorLocation = 1;
                                rear = true;
                                break;
                            }
                            case 10: {
                                armorLocation = 3;
                                rear = true;
                                break;
                            }
                            case 9: {
                                armorLocation = 2;
                                rear = true;
                                break;
                            }
                            default: {
                                rear = false;
                            }
                        }
                        results = rear ? results + "Repairing external armor " + repairOrder.getUnit().getLocationAbbr(armorLocation) + "(r) ETA: " + output + "." : results + "Repairing external armor " + repairOrder.getUnit().getLocationAbbr(armorLocation) + " ETA: " + output + ".";
                    } else {
                        results = results + "Repairing internal structure " + repairOrder.getUnit().getLocationAbbr(armorLocation) + " ETA: " + output + ".";
                    }
                } else {
                    CriticalSlot cs = repairOrder.getUnit().getCritical(repairOrder.getLocation(), repairOrder.getSlot());
                    if (cs.getType() == 1) {
                        Mounted mounted = repairOrder.getUnit().getEquipment(cs.getIndex());
                        results = results + "Repairing " + mounted.getName() + "(" + repairOrder.getUnit().getLocationAbbr(repairOrder.getLocation()) + ") ETA: " + output + ".";
                    } else if (repairOrder.getUnit() instanceof Mech) {
                        results = results + "Repairing " + ((Mech)repairOrder.getUnit()).getSystemName(cs.getIndex()) + "(" + repairOrder.getUnit().getLocationAbbr(repairOrder.getLocation()) + ") ETA: " + output + ".";
                    }
                }
                results = results + " <a href=\"MEKWARS/c stoprepairjob#" + unitID + "#" + repairOrder.getLocation() + "#" + repairOrder.getSlot() + "#" + repairOrder.getArmor() + "\">Click here to stop</a><br>";
            }
        }
        if (results.length() > 1) {
            results = "#" + unitID + " " + unitName + " has the following repair jobs pending:<br>" + results;
            return results;
        }
        return null;
    }

    public Vector<Repair> getRepairList() {
        return this.repairList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeingRepaired(int unitID, int location, int slot, boolean armor) {
        Vector<Repair> tempRepairList;
        Vector<Repair> vector = tempRepairList = new Vector<Repair>(this.getRepairList());
        synchronized (vector) {
            for (Repair repairOrder : tempRepairList) {
                if (!repairOrder.matches(unitID, location, slot, armor)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRepair(int unitID, int location, int slot, boolean armor) {
        ConcurrentLinkedQueue<Repair> tempRepairList;
        ConcurrentLinkedQueue<Repair> concurrentLinkedQueue = tempRepairList = new ConcurrentLinkedQueue<Repair>(this.getRepairList());
        synchronized (concurrentLinkedQueue) {
            for (Repair repairOrder : tempRepairList) {
                if (!repairOrder.matches(unitID, location, slot, armor)) continue;
                SPlayer player = CampaignMain.cm.getPlayer(repairOrder.getUsername());
                SUnit unit = player.getUnit(unitID);
                CampaignMain.cm.toUser("FSM|Repair order cancelled.", repairOrder.getUsername(), false);
                if (repairOrder.getTechType() == 4) {
                    unit.setPilotIsRepairing(false);
                } else {
                    player.addAvailableTechs(repairOrder.getTechType(), 1);
                }
                repairOrder.stopRepair();
                this.getRepairList().removeElement(repairOrder);
                unit.setEntity(repairOrder.getUnit());
                CampaignMain.cm.toUser("PL|UU|" + unitID + "|" + unit.toString(true), player.getName(), false);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllRepairJobs(int unitID, SPlayer player) {
        ConcurrentLinkedQueue<Repair> tempRepairList;
        ConcurrentLinkedQueue<Repair> concurrentLinkedQueue = tempRepairList = new ConcurrentLinkedQueue<Repair>(this.getRepairList());
        synchronized (concurrentLinkedQueue) {
            for (Repair repairOrder : tempRepairList) {
                if (repairOrder.getUnitID() != unitID) continue;
                try {
                    int techType = repairOrder.getTechType();
                    if (techType != 4) {
                        player.addAvailableTechs(techType, 1);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                repairOrder.stopRepair();
                this.getRepairList().removeElement(repairOrder);
            }
        }
        try {
            SUnit unit = player.getUnit(unitID);
            CampaignMain.cm.toUser("PL|UU|" + unitID + "|" + unit.toString(true), player.getName(), false);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static Repair Repair(SPlayer player, int unitID, boolean armor, int location, int slot, int techType, int retries, int techWorkMod, boolean salvage) {
        return new Repair(player, unitID, armor, location, slot, techType, retries, techWorkMod, salvage);
    }

    public static Repair Repair(SPlayer player, int unitID, Vector<Integer> techs, int repairTime, boolean salvage) {
        return new Repair(player, unitID, techs, repairTime, true, salvage);
    }
}

