/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import common.CampaignData;
import java.io.PrintWriter;
import java.net.Socket;
import server.MWServ;
import server.campaign.CampaignMain;

public class TrackerThread
extends Thread {
    MWServ serv;

    public TrackerThread(MWServ s) {
        super("Tracker Thread");
        this.serv = s;
        CampaignData.mwlog.infoLog("Created TrackerThread");
    }

    public void extendedWait(int time) {
        try {
            this.wait(time);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public synchronized void run() {
        Socket sock;
        CampaignData.mwlog.infoLog("TrackerThread running.");
        String name = this.serv.getConfigParam("SERVERNAME");
        String link = this.serv.getConfigParam("TRACKERLINK");
        String desc = this.serv.getConfigParam("TRACKERDESC");
        String trackerAddress = this.serv.getConfigParam("TRACKERADDRESS");
        try {
            CampaignData.mwlog.infoLog("TrackerThread attempting to send ServerStart information.");
            sock = new Socket(trackerAddress, 13731);
            PrintWriter pw = new PrintWriter(sock.getOutputStream());
            pw.println("SS%" + name + "%" + link + "%" + "0.2.40.0" + "%" + desc);
            pw.flush();
            pw.close();
            CampaignData.mwlog.infoLog("TrackerThread sent server start information.");
        }
        catch (Exception e) {
            CampaignData.mwlog.infoLog("TrackerThread could not contact tracker. Shutting down.");
            CampaignData.mwlog.errLog("Could not contact tracker. Shutting down trackerthread.");
            CampaignData.mwlog.errLog(e);
            return;
        }
        block6: while (true) {
            try {
                while (true) {
                    this.extendedWait(600000);
                    int playersOnline = this.serv.userCount(false);
                    int gamesInProgress = 0;
                    int gamesCompleted = 0;
                    CampaignMain campaign = this.serv.getCampaign();
                    if (campaign != null) {
                        gamesInProgress = campaign.getOpsManager().getRunningOps().size();
                        gamesCompleted = campaign.getGamesCompleted();
                        campaign.setGamesCompleted(0);
                    }
                    String toSend = "PH%" + name + "%" + playersOnline + "%" + gamesInProgress + "%" + gamesCompleted;
                    try {
                        CampaignData.mwlog.infoLog("TrackerThread attempting to send PhoneHome information.");
                        sock = new Socket(trackerAddress, 13731);
                        PrintWriter pw = new PrintWriter(sock.getOutputStream());
                        pw.println(toSend);
                        pw.flush();
                        pw.close();
                        CampaignData.mwlog.infoLog("TrackerThread sent PH% information.");
                        continue block6;
                    }
                    catch (Exception e) {
                        CampaignData.mwlog.infoLog("TrackerThread could not reach tracker for PH%.");
                        CampaignData.mwlog.errLog("Could not contact tracker.");
                        CampaignData.mwlog.errLog(e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
                return;
            }
        }
    }
}

