/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import common.CampaignData;
import common.util.SpringLayoutHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SpringLayout;
import megamek.common.MiscType;

public final class BanTargetingDialog
implements ActionListener {
    private MWClient mwclient = null;
    private static final String okayCommand = "Add";
    private static final String cancelCommand = "Close";
    private String windowName = "Ban Targeting Editor";
    private ArrayList<JCheckBox> cBoxArrayList = new ArrayList();
    private final JButton okayButton = new JButton("Save");
    private final JButton cancelButton = new JButton("Close");
    private JDialog dialog;
    private JOptionPane pane;
    JTabbedPane ConfigPane = new JTabbedPane();

    public BanTargetingDialog(MWClient c) {
        this.mwclient = c;
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save");
        this.cancelButton.setToolTipText("Exit without saving changes");
        JPanel banPanel = new JPanel();
        banPanel.setLayout(new BoxLayout(banPanel, 1));
        JPanel targetingPanel = new JPanel(new SpringLayout());
        this.loadBanTargeting();
        for (int targetType = 0; targetType < MiscType.targSysNames.length; ++targetType) {
            if (targetType == 1) continue;
            JCheckBox cBox = new JCheckBox();
            cBox.setText(MiscType.getTargetSysName(targetType));
            cBox.setSelected(this.checkBan(targetType));
            targetingPanel.add(cBox);
            this.cBoxArrayList.add(cBox);
        }
        SpringLayoutHelper.setupSpringGrid(targetingPanel, 2);
        banPanel.add(targetingPanel);
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(banPanel, -1, -1, null, options, null);
        this.windowName = " Ban Targeting Systems Dialog";
        this.dialog = this.pane.createDialog(targetingPanel, this.windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        HashMap<Integer, String> targetingTypes = this.mwclient.getData().getBannedTargetingSystems();
        if (command.equals(okayCommand)) {
            for (JCheckBox tempBox : this.cBoxArrayList) {
                int targetingSystem = MiscType.getTargetSysType(tempBox.getText());
                if (tempBox.isSelected() && !targetingTypes.containsKey(targetingSystem)) {
                    this.mwclient.sendChat("/c AdminSetBanTargeting#" + targetingSystem);
                    continue;
                }
                if (tempBox.isSelected() || !targetingTypes.containsKey(targetingSystem)) continue;
                this.mwclient.sendChat("/c AdminSetBanTargeting#" + targetingSystem);
            }
            this.dialog.dispose();
            return;
        }
        if (command.equals(cancelCommand)) {
            this.dialog.dispose();
        }
    }

    public void loadBanTargeting() {
        this.mwclient.loadBanTargeting();
    }

    public boolean checkBan(int targetingType) {
        try {
            return this.mwclient.getData().getBannedTargetingSystems().containsKey(targetingType);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to find ammo " + MiscType.getTargetSysName(targetingType));
            return false;
        }
    }
}

