/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import common.CampaignData;
import common.House;
import common.util.SpringLayoutHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SpringLayout;

public final class BannedAmmoDialog
implements ActionListener {
    private MWClient mwclient = null;
    private House house = null;
    private static final String okayCommand = "Add";
    private static final String cancelCommand = "Close";
    private String windowName = "Server Banned Ammo Editor";
    private ArrayList<JCheckBox> cBoxArrayList = new ArrayList();
    private final JButton okayButton = new JButton("Save");
    private final JButton cancelButton = new JButton("Close");
    private JDialog dialog;
    private JOptionPane pane;
    JTabbedPane ConfigPane = new JTabbedPane();

    public BannedAmmoDialog(MWClient c, House house) {
        this.mwclient = c;
        this.house = house;
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save");
        this.cancelButton.setToolTipText("Exit without saving changes");
        JPanel banPanel = new JPanel();
        banPanel.setLayout(new BoxLayout(banPanel, 1));
        JPanel ammoPanel = new JPanel(new SpringLayout());
        this.loadBannedAmmo();
        TreeSet<String> munitions = new TreeSet<String>(this.mwclient.getData().getMunitionsByName().keySet());
        for (String munitionName : munitions) {
            JCheckBox cBox = new JCheckBox();
            cBox.setText(munitionName);
            cBox.setSelected(this.checkAmmoBan(munitionName));
            ammoPanel.add(cBox);
            this.cBoxArrayList.add(cBox);
        }
        SpringLayoutHelper.setupSpringGrid(ammoPanel, 2);
        banPanel.add(ammoPanel);
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(banPanel, -1, -1, null, options, null);
        if (house != null) {
            this.windowName = this.house.getName() + " Banned Ammo Dialog";
        }
        this.dialog = this.pane.createDialog(ammoPanel, this.windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Hashtable<String, Long> munitionTypes = this.mwclient.getData().getMunitionsByName();
        if (command.equals(okayCommand)) {
            if (this.house == null) {
                Hashtable<String, String> bannedAmmo = this.mwclient.getData().getServerBannedAmmo();
                for (JCheckBox tempBox : this.cBoxArrayList) {
                    String ammo = Long.toString(munitionTypes.get(tempBox.getText()));
                    if (tempBox.isSelected() && !bannedAmmo.containsKey(ammo)) {
                        this.mwclient.sendChat("/c adminsetserverammoban#" + munitionTypes.get(tempBox.getText()));
                        continue;
                    }
                    if (tempBox.isSelected() || !bannedAmmo.containsKey(ammo)) continue;
                    this.mwclient.sendChat("/c adminsetserverammoban#" + munitionTypes.get(tempBox.getText()));
                }
            } else {
                Hashtable<String, String> bannedAmmo = this.house.getBannedAmmo();
                for (JCheckBox tempBox : this.cBoxArrayList) {
                    String ammo = Long.toString(munitionTypes.get(tempBox.getText()));
                    if (tempBox.isSelected() && !bannedAmmo.containsKey(ammo)) {
                        this.mwclient.sendChat("/c adminsethouseammoban#" + this.house.getName() + "#" + munitionTypes.get(tempBox.getText()));
                        continue;
                    }
                    if (tempBox.isSelected() || !bannedAmmo.containsKey(ammo)) continue;
                    this.mwclient.sendChat("/c adminsethouseammoban#" + this.house.getName() + "#" + munitionTypes.get(tempBox.getText()));
                }
            }
            this.dialog.dispose();
            return;
        }
        if (command.equals(cancelCommand)) {
            this.dialog.dispose();
        }
    }

    public void loadBannedAmmo() {
        this.mwclient.loadBannedAmmo();
    }

    public boolean checkAmmoBan(String ammo) {
        if (this.house == null) {
            try {
                String munition = Long.toString(this.mwclient.getData().getMunitionsByName().get(ammo));
                return this.mwclient.getData().getServerBannedAmmo().containsKey(munition);
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to find ammo " + ammo);
                return false;
            }
        }
        try {
            String munition = Long.toString(this.mwclient.getData().getMunitionsByName().get(ammo));
            return this.house.getBannedAmmo().containsKey(munition);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to find ammo " + ammo);
            return false;
        }
    }
}

