/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import common.util.SpringLayoutHelper;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class CommandNameDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1024120117465498506L;
    private final Collection<String> commands;
    private final TreeSet<String> CommandNames;
    private JList matchingCommandList;
    private JScrollPane scrollPane;
    private JTextField nameField;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";
    private String commandName = null;
    private int accessLevel = 0;

    public CommandNameDialog(MWClient mwclient, String boxText) {
        super((Frame)mwclient.getMainFrame(), boxText, true);
        this.loadCommands(mwclient);
        this.accessLevel = mwclient.getUser(mwclient.getPlayer().getName()).getUserlevel();
        this.commands = mwclient.getData().getCommandTable().keySet();
        this.CommandNames = new TreeSet();
        for (String command : this.commands) {
            if (command.equalsIgnoreCase("SendClientDataCommand") || this.accessLevel < mwclient.getData().getCommandTable().get(command)) continue;
            this.CommandNames.add(command.substring(0, 1) + command.substring(1).toLowerCase());
        }
        final Object[] allCommandNames = this.CommandNames.toArray();
        this.matchingCommandList = new JList<Object>(allCommandNames);
        this.matchingCommandList.setVisibleRowCount(10);
        this.matchingCommandList.setSelectionMode(0);
        this.nameField = new JTextField();
        this.nameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                new Thread(){

                    public void run() {
                        String text = CommandNameDialog.this.nameField.getText();
                        if (text == null || text.equals("")) {
                            CommandNameDialog.this.matchingCommandList.setListData(allCommandNames);
                            return;
                        }
                        ArrayList<String> possibleCommands = new ArrayList<String>();
                        text = text.toLowerCase();
                        for (String curCommand : CommandNameDialog.this.commands) {
                            if (curCommand.toLowerCase().indexOf(text) == -1) continue;
                            possibleCommands.add(curCommand.substring(0, 1) + curCommand.substring(1).toLowerCase());
                        }
                        CommandNameDialog.this.matchingCommandList.setListData(possibleCommands.toArray());
                        boolean shouldContinue = true;
                        int element = 0;
                        for (String name : possibleCommands) {
                            if (name.toLowerCase().startsWith(text)) {
                                CommandNameDialog.this.matchingCommandList.setSelectedIndex(element);
                                shouldContinue = false;
                                break;
                            }
                            ++element;
                        }
                        if (shouldContinue) {
                            CommandNameDialog.this.matchingCommandList.setSelectedIndex(0);
                        }
                    }
                }.start();
            }
        });
        this.scrollPane = new JScrollPane(this.matchingCommandList);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel springPanel = new JPanel(new SpringLayout());
        springPanel.add(this.nameField);
        springPanel.add(this.scrollPane);
        SpringLayoutHelper.setupSpringGrid(springPanel, 2, 1);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(springPanel);
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.checkMinimumSize();
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okayButton);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            String selectedCommand = (String)this.matchingCommandList.getSelectedValue();
            if (selectedCommand == null) {
                selectedCommand = this.nameField.getText();
            }
            if (selectedCommand == null || selectedCommand.equals("")) {
                return;
            }
            if (this.matchingCommandList.getModel().getSize() == 1) {
                selectedCommand = (String)this.matchingCommandList.getModel().getElementAt(0);
            }
            for (String commandName : this.commands) {
                if (!selectedCommand.equalsIgnoreCase(commandName)) continue;
                this.setCommandName(commandName);
                this.setVisible(false);
                return;
            }
            JOptionPane.showMessageDialog(null, "Unknown Command");
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 300.0) {
            width = 300;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 150.0) {
            height = 150;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }

    private void setCommandName(String name) {
        this.commandName = name.substring(0, 1) + name.toLowerCase().substring(1);
    }

    public String getCommandName() {
        return this.commandName;
    }

    private void loadCommands(MWClient mwclient) {
        mwclient.loadServerCommmands();
    }
}

