/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import common.Equipment;
import common.util.SpringLayoutHelper;
import common.util.UnitUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import megamek.common.AmmoType;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.TechConstants;
import megamek.common.WeaponType;

public final class ComponentDisplayDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 8839724432360797850L;
    private MWClient mwclient = null;
    public static final int WEAPON_TYPE = 0;
    public static final int MISC_TYPE = 1;
    public static final int AMMO_TYPE = 2;
    public static final int AMMO_COSTS_TYPE = 3;
    public static final int SYSTEM = 8;
    private static final String okayCommand = "Add";
    private static final String cancelCommand = "Close";
    private String windowName = "Component Display Dialog";
    private final JButton okayButton = new JButton("Ok");
    private final JButton cancelButton = new JButton("Close");
    private JDialog dialog;
    private JOptionPane pane;
    private JScrollPane MasterPanel = new JScrollPane();
    private int displayType = 0;
    JTabbedPane ConfigPane = new JTabbedPane();

    public ComponentDisplayDialog(MWClient c, int type) {
        super((Frame)c.getMainFrame(), "Component Display Dialog", true);
        this.mwclient = c;
        this.displayType = type;
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save");
        this.cancelButton.setToolTipText("Exit without saving changes");
        this.ConfigPane = new JTabbedPane();
        this.mwclient.getBlackMarketSettings();
        if (this.displayType == 0) {
            this.loadWeaponPanel();
            this.windowName = this.windowName + " (Weapons)";
        } else if (this.displayType == 2) {
            this.loadAmmoPanel();
            this.windowName = this.windowName + " (Ammo)";
        } else if (this.displayType == 3) {
            this.loadAmmoCostPanel();
            this.windowName = this.windowName + " (Ammo Costs)";
        } else {
            this.loadMiscPanel();
            this.windowName = this.windowName + " (Misc)";
        }
        for (int pos = this.ConfigPane.getComponentCount() - 1; pos >= 0; --pos) {
            JPanel panel = (JPanel)this.ConfigPane.getComponent(pos);
            this.findAndPopulateTextAndCheckBoxes(panel);
        }
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        Dimension dim = new Dimension(100, 200);
        this.ConfigPane.setMaximumSize(dim);
        this.pane = new JOptionPane(this.ConfigPane, -1, -1, null, options, null);
        this.pane.setMaximumSize(dim);
        this.MasterPanel.setHorizontalScrollBarPolicy(30);
        this.MasterPanel.setVerticalScrollBarPolicy(20);
        this.MasterPanel.setMaximumSize(dim);
        this.dialog = this.pane.createDialog(this.MasterPanel, this.windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        this.dialog.setMaximumSize(dim);
        this.dialog.setLocationRelativeTo((Component)this.mwclient.getMainFrame());
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            for (int pos = this.ConfigPane.getComponentCount() - 1; pos >= 0; --pos) {
                JPanel panel = (JPanel)this.ConfigPane.getComponent(pos);
                this.findAndSaveConfigs(panel);
            }
            this.transmitSettings();
            this.mwclient.sendChat("/c AdminSaveBlackMarketConfigs");
            this.dialog.dispose();
            return;
        }
        if (command.equals(cancelCommand)) {
            this.dialog.dispose();
        }
    }

    private void loadWeaponPanel() {
        this.loadWeaponPanelType(0);
        this.loadWeaponPanelType(1);
        this.loadWeaponPanelType(5);
        this.loadWeaponPanelType(7);
        this.loadWeaponPanelType(2);
        this.loadWeaponPanelType(6);
        this.loadWeaponPanelType(8);
    }

    private void loadAmmoPanel() {
        this.loadAmmoPanelType(0);
        this.loadAmmoPanelType(1);
        this.loadAmmoPanelType(5);
        this.loadAmmoPanelType(7);
        this.loadAmmoPanelType(2);
        this.loadAmmoPanelType(6);
        this.loadAmmoPanelType(8);
    }

    private void loadAmmoCostPanel() {
        this.loadAmmoCostPanelType(0);
        this.loadAmmoCostPanelType(1);
        this.loadAmmoCostPanelType(5);
        this.loadAmmoCostPanelType(7);
        this.loadAmmoCostPanelType(2);
        this.loadAmmoCostPanelType(6);
        this.loadAmmoCostPanelType(8);
    }

    private void loadAmmoPanelType(int tech) {
        Enumeration<EquipmentType> list = EquipmentType.getAllTypes();
        TreeMap<String, AmmoType> equipmentSort = new TreeMap<String, AmmoType>();
        int count = 0;
        int tabNumber = 0;
        JPanel panel = new JPanel(new SpringLayout());
        JTextField textField = null;
        Dimension dim = new Dimension(50, 10);
        JPanel masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 0));
        panel.add(new JLabel("Component"));
        panel.add(new JLabel("Min. Cost"));
        panel.add(new JLabel("Max. Cost"));
        panel.add(new JLabel("Min. Parts"));
        panel.add(new JLabel("Max. Parts"));
        panel.add(new JLabel("Component"));
        panel.add(new JLabel("Min. Cost"));
        panel.add(new JLabel("Max. Cost"));
        panel.add(new JLabel("Min. Parts"));
        panel.add(new JLabel("Max. Parts"));
        String tabPrefix = TechConstants.T_NAMES[tech] + "-";
        while (list.hasMoreElements()) {
            EquipmentType eq = list.nextElement();
            if (!(eq instanceof AmmoType) || ((AmmoType)eq).getTechLevel() != tech && (tech == 1 && ((AmmoType)eq).getTechLevel() > tech || tech != 1)) continue;
            equipmentSort.put(eq.getName(), (AmmoType)eq);
        }
        for (AmmoType eq : equipmentSort.values()) {
            String name = eq.getName();
            String intName = eq.getInternalName();
            panel.add(new JLabel(name));
            textField = new JTextField("0");
            textField.setName(intName + "|mincost");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The min. cost for this item on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|maxcost");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The max. cost for this item on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|minparts");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The min. number of items that will be on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|maxparts");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The max. number of items that will be on the BM");
            panel.add(textField);
            if (++count % 40 != 0) continue;
            panel.setAutoscrolls(true);
            SpringLayoutHelper.setupSpringGrid(panel, 10);
            masterBox.add(panel);
            this.ConfigPane.addTab(tabPrefix + ++tabNumber, null, panel, tabPrefix + tabNumber);
            panel = new JPanel(new SpringLayout());
            panel.add(new JLabel("Component"));
            panel.add(new JLabel("Min. Cost"));
            panel.add(new JLabel("Max. Cost"));
            panel.add(new JLabel("Min. Parts"));
            panel.add(new JLabel("Max. Parts"));
            panel.add(new JLabel("Component"));
            panel.add(new JLabel("Min. Cost"));
            panel.add(new JLabel("Max. Cost"));
            panel.add(new JLabel("Min. Parts"));
            panel.add(new JLabel("Max. Parts"));
        }
        if (panel.getComponentCount() > 0) {
            SpringLayoutHelper.setupSpringGrid(panel, 10);
            this.ConfigPane.addTab(tabPrefix + ++tabNumber, null, panel, tabPrefix + tabNumber);
        }
        this.MasterPanel.add(this.ConfigPane);
    }

    private void loadAmmoCostPanelType(int tech) {
        Enumeration<EquipmentType> list = EquipmentType.getAllTypes();
        TreeMap<String, AmmoType> equipmentSort = new TreeMap<String, AmmoType>();
        int count = 0;
        int tabNumber = 0;
        JPanel panel = new JPanel(new SpringLayout());
        JTextField textField = null;
        Dimension dim = new Dimension(50, 10);
        JPanel masterBox = new JPanel();
        masterBox.setLayout(new BoxLayout(masterBox, 0));
        panel.add(new JLabel("Component"));
        panel.add(new JLabel("Cost"));
        panel.add(new JLabel("Component"));
        panel.add(new JLabel("Cost"));
        panel.add(new JLabel("Component"));
        panel.add(new JLabel("Cost"));
        panel.add(new JLabel("Component"));
        panel.add(new JLabel("Cost"));
        String tabPrefix = TechConstants.T_NAMES[tech] + "-";
        while (list.hasMoreElements()) {
            EquipmentType eq = list.nextElement();
            if (!(eq instanceof AmmoType) || ((AmmoType)eq).getTechLevel() != tech && (tech == 1 && ((AmmoType)eq).getTechLevel() > tech || tech != 1)) continue;
            equipmentSort.put(eq.getName(), (AmmoType)eq);
        }
        for (AmmoType eq : equipmentSort.values()) {
            String name = eq.getName();
            String intName = eq.getInternalName();
            panel.add(new JLabel(name));
            textField = new JTextField("0");
            textField.setName(intName + "|mincost");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The cost for a shot of " + name + " ammo.");
            panel.add(textField);
            if (++count % 40 != 0) continue;
            panel.setAutoscrolls(true);
            SpringLayoutHelper.setupSpringGrid(panel, 8);
            masterBox.add(panel);
            this.ConfigPane.addTab(tabPrefix + ++tabNumber, null, panel, tabPrefix + tabNumber);
            panel = new JPanel(new SpringLayout());
            panel.add(new JLabel("Component"));
            panel.add(new JLabel("Cost"));
            panel.add(new JLabel("Component"));
            panel.add(new JLabel("Cost"));
            panel.add(new JLabel("Component"));
            panel.add(new JLabel("Cost"));
            panel.add(new JLabel("Component"));
            panel.add(new JLabel("Cost"));
        }
        if (panel.getComponentCount() > 0) {
            SpringLayoutHelper.setupSpringGrid(panel, 8);
            this.ConfigPane.addTab(tabPrefix + ++tabNumber, null, panel, tabPrefix + tabNumber);
        }
        this.MasterPanel.add(this.ConfigPane);
    }

    private void loadWeaponPanelType(int tech) {
        Enumeration<EquipmentType> list = EquipmentType.getAllTypes();
        TreeMap<String, WeaponType> equipmentSort = new TreeMap<String, WeaponType>();
        int count = 0;
        int tabNumber = 0;
        JPanel panel = new JPanel(new SpringLayout());
        JTextField textField = null;
        Dimension dim = new Dimension(50, 10);
        panel.add(new JLabel("Component"));
        panel.add(new JLabel("Min. Cost"));
        panel.add(new JLabel("Max. Cost"));
        panel.add(new JLabel("Min. Parts"));
        panel.add(new JLabel("Max. Parts"));
        panel.add(new JLabel("Component"));
        panel.add(new JLabel("Min. Cost"));
        panel.add(new JLabel("Max. Cost"));
        panel.add(new JLabel("Min. Parts"));
        panel.add(new JLabel("Max. Parts"));
        String tabPrefix = TechConstants.T_NAMES[tech] + "-";
        while (list.hasMoreElements()) {
            EquipmentType eq = list.nextElement();
            if (!(eq instanceof WeaponType) || ((WeaponType)eq).getTechLevel() != tech && (tech == 1 && ((WeaponType)eq).getTechLevel() > tech || tech != 1)) continue;
            equipmentSort.put(eq.getName(), (WeaponType)eq);
        }
        for (WeaponType eq : equipmentSort.values()) {
            String name = eq.getName();
            String intName = eq.getInternalName();
            panel.add(new JLabel(name));
            textField = new JTextField("0");
            textField.setName(intName + "|mincost");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The min. cost for this item on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|maxcost");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The max. cost for this item on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|minparts");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The min. number of items that will be on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|maxparts");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The max. number of items that will be on the BM");
            panel.add(textField);
            if (++count % 40 != 0) continue;
            SpringLayoutHelper.setupSpringGrid(panel, 10);
            this.ConfigPane.addTab(tabPrefix + ++tabNumber, null, panel, tabPrefix + tabNumber);
            panel = new JPanel(new SpringLayout());
            panel.add(new JLabel("Component"));
            panel.add(new JLabel("Min. Cost"));
            panel.add(new JLabel("Max. Cost"));
            panel.add(new JLabel("Min. Parts"));
            panel.add(new JLabel("Max. Parts"));
            panel.add(new JLabel("Component"));
            panel.add(new JLabel("Min. Cost"));
            panel.add(new JLabel("Max. Cost"));
            panel.add(new JLabel("Min. Parts"));
            panel.add(new JLabel("Max. Parts"));
        }
        if (panel.getComponentCount() > 0) {
            SpringLayoutHelper.setupSpringGrid(panel, 10);
            this.ConfigPane.addTab(tabPrefix + ++tabNumber, null, panel, tabPrefix + tabNumber);
        }
        this.MasterPanel.add(this.ConfigPane);
    }

    private void loadMiscPanelType(int tech) {
        Enumeration<EquipmentType> list = EquipmentType.getAllTypes();
        TreeMap<String, MiscType> equipmentSort = new TreeMap<String, MiscType>();
        int count = 0;
        int tabNumber = 0;
        JPanel panel = new JPanel(new SpringLayout());
        JTextField textField = null;
        Dimension dim = new Dimension(50, 10);
        panel.add(new JLabel("Component"));
        panel.add(new JLabel("Min. Cost"));
        panel.add(new JLabel("Max. Cost"));
        panel.add(new JLabel("Min. Parts"));
        panel.add(new JLabel("Max. Parts"));
        panel.add(new JLabel("Component"));
        panel.add(new JLabel("Min. Cost"));
        panel.add(new JLabel("Max. Cost"));
        panel.add(new JLabel("Min. Parts"));
        panel.add(new JLabel("Max. Parts"));
        String tabPrefix = TechConstants.T_NAMES[tech] + "-";
        if (tech == 8) {
            int pos;
            String name = Mech.systemNames[0];
            String intName = Mech.systemNames[0];
            panel.add(new JLabel(name));
            textField = new JTextField("0");
            textField.setName(intName + "|mincost");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The min. cost for this item on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|maxcost");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The max. cost for this item on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|minparts");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The min. number of items that will be on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|maxparts");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The max. number of items that will be on the BM");
            panel.add(textField);
            name = Mech.systemNames[1];
            intName = Mech.systemNames[1];
            panel.add(new JLabel(name));
            textField = new JTextField("0");
            textField.setName(intName + "|mincost");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The min. cost for this item on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|maxcost");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The max. cost for this item on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|minparts");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The min. number of items that will be on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|maxparts");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The max. number of items that will be on the BM");
            panel.add(textField);
            name = "Actuator";
            intName = "Actuator";
            panel.add(new JLabel(name));
            textField = new JTextField("0");
            textField.setName(intName + "|mincost");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The min. cost for this item on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|maxcost");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The max. cost for this item on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|minparts");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The min. number of items that will be on the BM");
            panel.add(textField);
            textField = new JTextField("0");
            textField.setName(intName + "|maxparts");
            textField.setMaximumSize(dim);
            textField.setToolTipText("The max. number of items that will be on the BM");
            panel.add(textField);
            for (pos = 0; pos <= 3; ++pos) {
                name = Mech.getGyroTypeString(pos);
                intName = Mech.getGyroTypeString(pos);
                panel.add(new JLabel(name));
                textField = new JTextField("0");
                textField.setName(intName + "|mincost");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The min. cost for this item on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|maxcost");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The max. cost for this item on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|minparts");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The min. number of items that will be on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|maxparts");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The max. number of items that will be on the BM");
                panel.add(textField);
            }
            for (pos = 0; pos <= 4; ++pos) {
                name = Mech.getCockpitTypeString(pos);
                intName = Mech.getCockpitTypeString(pos);
                panel.add(new JLabel(name));
                textField = new JTextField("0");
                textField.setName(intName + "|mincost");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The min. cost for this item on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|maxcost");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The max. cost for this item on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|minparts");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The min. number of items that will be on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|maxparts");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The max. number of items that will be on the BM");
                panel.add(textField);
            }
            for (pos = 0; pos <= 5; ++pos) {
                name = UnitUtils.ENGINE_TECH_STRING[pos];
                intName = UnitUtils.ENGINE_TECH_STRING[pos];
                panel.add(new JLabel(name));
                textField = new JTextField("0");
                textField.setName(intName + "|mincost");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The min. cost for this item on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|maxcost");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The max. cost for this item on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|minparts");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The min. number of items that will be on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|maxparts");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The max. number of items that will be on the BM");
                panel.add(textField);
            }
            SpringLayoutHelper.setupSpringGrid(panel, 10);
            this.ConfigPane.addTab(tabPrefix, null, panel, tabPrefix);
        } else {
            while (list.hasMoreElements()) {
                EquipmentType eq = list.nextElement();
                if (!(eq instanceof MiscType) || ((MiscType)eq).getTechLevel() != tech && (tech == 1 && ((MiscType)eq).getTechLevel() > tech || tech != 1)) continue;
                equipmentSort.put(eq.getName(), (MiscType)eq);
            }
            for (MiscType eq : equipmentSort.values()) {
                String name = eq.getName();
                String intName = eq.getInternalName();
                if (name.equalsIgnoreCase("standard")) {
                    name = "Armor (STD)";
                    intName = "Armor (STD)";
                }
                panel.add(new JLabel(name));
                textField = new JTextField("0");
                textField.setName(intName + "|mincost");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The min. cost for this item on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|maxcost");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The max. cost for this item on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|minparts");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The min. number of items that will be on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|maxparts");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The max. number of items that will be on the BM");
                panel.add(textField);
                if (name.equalsIgnoreCase("Armor (STD)")) {
                    ++count;
                    name = "IS (STD)";
                    intName = "IS (STD)";
                    panel.add(new JLabel(name));
                    textField = new JTextField("0");
                    textField.setName(intName + "|mincost");
                    textField.setMaximumSize(dim);
                    textField.setToolTipText("The min. cost for this item on the BM");
                    panel.add(textField);
                    textField = new JTextField("0");
                    textField.setName(intName + "|maxcost");
                    textField.setMaximumSize(dim);
                    textField.setToolTipText("The max. cost for this item on the BM");
                    panel.add(textField);
                    textField = new JTextField("0");
                    textField.setName(intName + "|minparts");
                    textField.setMaximumSize(dim);
                    textField.setToolTipText("The min. number of items that will be on the BM");
                    panel.add(textField);
                    textField = new JTextField("0");
                    textField.setName(intName + "|maxparts");
                    textField.setMaximumSize(dim);
                    textField.setToolTipText("The max. number of items that will be on the BM");
                    panel.add(textField);
                }
                if (++count % 40 != 0) continue;
                SpringLayoutHelper.setupSpringGrid(panel, 10);
                this.ConfigPane.addTab(tabPrefix + ++tabNumber, null, panel, tabPrefix + tabNumber);
                panel = new JPanel(new SpringLayout());
                panel.add(new JLabel("Component"));
                panel.add(new JLabel("Min. Cost"));
                panel.add(new JLabel("Max. Cost"));
                panel.add(new JLabel("Min. Parts"));
                panel.add(new JLabel("Max. Parts"));
                panel.add(new JLabel("Component"));
                panel.add(new JLabel("Min. Cost"));
                panel.add(new JLabel("Max. Cost"));
                panel.add(new JLabel("Min. Parts"));
                panel.add(new JLabel("Max. Parts"));
            }
            if (tech == 1) {
                String name = "Ammo Bin";
                String intName = "Ammo Bin";
                panel.add(new JLabel(name));
                textField = new JTextField("0");
                textField.setName(intName + "|mincost");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The min. cost for this item on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|maxcost");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The max. cost for this item on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|minparts");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The min. number of items that will be on the BM");
                panel.add(textField);
                textField = new JTextField("0");
                textField.setName(intName + "|maxparts");
                textField.setMaximumSize(dim);
                textField.setToolTipText("The max. number of items that will be on the BM");
                panel.add(textField);
            }
            if (panel.getComponentCount() > 0) {
                SpringLayoutHelper.setupSpringGrid(panel, 10);
                this.ConfigPane.addTab(tabPrefix + ++tabNumber, null, panel, tabPrefix + tabNumber);
            }
        }
        this.MasterPanel.add(this.ConfigPane);
    }

    private void loadMiscPanel() {
        this.loadMiscPanelType(0);
        this.loadMiscPanelType(1);
        this.loadMiscPanelType(5);
        this.loadMiscPanelType(7);
        this.loadMiscPanelType(2);
        this.loadMiscPanelType(6);
        this.loadMiscPanelType(8);
        this.loadMiscPanelType(8);
    }

    public void findAndPopulateTextAndCheckBoxes(JPanel panel) {
        String key = null;
        DecimalFormat format = new DecimalFormat("#.##");
        for (int fieldPos = panel.getComponentCount() - 1; fieldPos >= 0; --fieldPos) {
            JTextField textBox;
            Component field = panel.getComponent(fieldPos);
            if (field instanceof JPanel) {
                this.findAndPopulateTextAndCheckBoxes((JPanel)field);
                continue;
            }
            if (!(field instanceof JTextField) || (key = (textBox = (JTextField)field).getName()) == null) continue;
            textBox.setMaximumSize(new Dimension(100, 10));
            try {
                StringTokenizer keys = new StringTokenizer(key, "|");
                Equipment equipment = (Equipment)this.mwclient.getBlackMarketEquipmentList().get(keys.nextToken());
                if (equipment == null) {
                    textBox.setText("0");
                    continue;
                }
                String type = keys.nextToken();
                if (type.equalsIgnoreCase("mincost")) {
                    textBox.setText(format.format(equipment.getMinCost()));
                    continue;
                }
                if (type.equalsIgnoreCase("maxcost")) {
                    textBox.setText(format.format(equipment.getMaxCost()));
                    continue;
                }
                if (type.equalsIgnoreCase("minparts")) {
                    textBox.setText(Integer.toString(equipment.getMinProduction()));
                    continue;
                }
                textBox.setText(Integer.toString(equipment.getMaxProduction()));
                continue;
            }
            catch (Exception ex) {
                textBox.setText("N/A");
            }
        }
    }

    public void transmitSettings() {
        for (String key : this.mwclient.getBlackMarketEquipmentList().keySet()) {
            Equipment bme = (Equipment)this.mwclient.getBlackMarketEquipmentList().get(key);
            if (!bme.isUpdated()) continue;
            this.mwclient.sendChat("/c AdminSetBlackMarketSetting#" + key + "#" + bme.getMinCost() + "#" + bme.getMaxCost() + "#" + bme.getMinProduction() + "#" + bme.getMaxProduction());
        }
    }

    public void findAndSaveConfigs(JPanel panel) {
        String key = null;
        String value = null;
        for (int fieldPos = panel.getComponentCount() - 1; fieldPos >= 0; --fieldPos) {
            Component field = panel.getComponent(fieldPos);
            if (field instanceof JPanel) {
                this.findAndSaveConfigs((JPanel)field);
                continue;
            }
            if (!(field instanceof JTextField)) continue;
            JTextField textBox = (JTextField)field;
            value = textBox.getText();
            key = textBox.getName();
            if (key == null || value == null) continue;
            StringTokenizer keys = new StringTokenizer(key, "|");
            String internalName = keys.nextToken();
            Equipment equipment = (Equipment)this.mwclient.getBlackMarketEquipmentList().get(internalName);
            if (equipment == null) {
                equipment = new Equipment();
                equipment.setEquipmentInternalName(key);
            }
            String fieldKey = keys.nextToken();
            if (this.displayType == 3) {
                if (fieldKey.equalsIgnoreCase("mincost")) {
                    double amount = Double.parseDouble(value);
                    if (amount <= 0.0) {
                        equipment.setMinCost(-1.0);
                        equipment.setMaxCost(-1.0);
                        equipment.setMaxProduction(0);
                        equipment.setMinProduction(0);
                    } else {
                        equipment.setMinCost(amount);
                        equipment.setMaxCost(amount);
                        equipment.setMaxProduction(1);
                        equipment.setMinProduction(1);
                    }
                }
            } else if (fieldKey.equalsIgnoreCase("mincost")) {
                equipment.setMinCost(Double.parseDouble(value));
            } else if (fieldKey.equalsIgnoreCase("maxcost")) {
                equipment.setMaxCost(Double.parseDouble(value));
            } else if (fieldKey.equalsIgnoreCase("minparts")) {
                equipment.setMinProduction(Integer.parseInt(value));
            } else {
                equipment.setMaxProduction(Integer.parseInt(value));
            }
            this.mwclient.getBlackMarketEquipmentList().put(internalName, equipment);
        }
    }
}

