/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import common.House;
import common.util.SpringLayoutHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public final class FactionToFactionRewardPointMultiplierDialog
implements ActionListener,
KeyListener {
    private static final String okayCommand = "okay";
    private static final String cancelCommand = "cancel";
    private String windowName = "";
    private JTextField multiplierText = new JTextField(5);
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private JDialog dialog;
    private JOptionPane pane;
    private JComboBox faction1 = null;
    private JComboBox faction2 = null;
    private Hashtable<String, String> configChanges = new Hashtable();
    MWClient mwclient = null;

    public FactionToFactionRewardPointMultiplierDialog(MWClient mwclient) {
        this.mwclient = mwclient;
        this.windowName = "MekWars Faction to Faction Reward Point Multiplier";
        JPanel mainPanel = new JPanel();
        JPanel mainBoxPanel = new JPanel(new SpringLayout());
        TreeSet<String> factionNames = new TreeSet<String>();
        for (House faction : mwclient.getData().getAllHouses()) {
            factionNames.add(faction.getName());
        }
        this.faction1 = new JComboBox<Object>(factionNames.toArray());
        this.faction1.setSelectedIndex(0);
        this.faction1.addActionListener(this);
        this.faction2 = new JComboBox<Object>(factionNames.toArray());
        this.faction2.addActionListener(this);
        this.faction2.setSelectedIndex(0);
        this.multiplierText.addKeyListener(this);
        mainBoxPanel.add(this.faction1);
        mainBoxPanel.add(new JLabel(" to "));
        mainBoxPanel.add(this.faction2);
        mainBoxPanel.add(new JLabel(" multipler "));
        mainBoxPanel.add(this.multiplierText);
        SpringLayoutHelper.setupSpringGrid(mainBoxPanel, 5);
        mainPanel.add(mainBoxPanel);
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save Options");
        this.cancelButton.setToolTipText("Exit without saving options");
        JPanel mainConfigPanel = new JPanel();
        mainConfigPanel.add(mainPanel);
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(mainConfigPanel, -1, -1, null, options, null);
        this.dialog = this.pane.createDialog(mainConfigPanel, this.windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        this.dialog.setLocationRelativeTo((Component)mwclient.getMainFrame());
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.pane.getValue() == this.okayButton) {
            if (this.configChanges.size() > 0) {
                StringBuffer changes = new StringBuffer();
                for (String key : this.configChanges.keySet()) {
                    changes.append(key);
                    changes.append("#");
                    changes.append(this.configChanges.get(key));
                    mwclient.sendChat("/c SetFactionToFactionRewardPointMultiplier#" + changes.toString());
                    changes.setLength(0);
                }
            }
            mwclient.sendChat("/c adminsaveserverconfigs");
            mwclient.getServerConfigData();
        } else {
            this.dialog.dispose();
            if (this.configChanges.size() > 0) {
                mwclient.getServerConfigData();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            this.saveChanges();
            this.pane.setValue(this.okayButton);
            this.dialog.dispose();
        } else if (command.equals(cancelCommand)) {
            this.pane.setValue(this.cancelButton);
            this.dialog.dispose();
        } else {
            String config = this.faction1.getSelectedItem().toString() + "To" + this.faction2.getSelectedItem().toString() + "RewardPointMultiplier";
            this.multiplierText.setText(this.mwclient.getserverConfigs(config));
        }
    }

    public void saveChanges() {
        String config = this.faction1.getSelectedItem().toString() + "To" + this.faction2.getSelectedItem().toString() + "RewardPointMultiplier";
        this.mwclient.getserverConfigs().put(config, this.multiplierText.getText());
        this.configChanges.put(this.faction1.getSelectedItem().toString() + "#" + this.faction2.getSelectedItem().toString(), this.multiplierText.getText());
    }

    public void keyPressed(KeyEvent e) {
        this.saveChanges();
    }

    public void keyReleased(KeyEvent e) {
        this.saveChanges();
    }

    public void keyTyped(KeyEvent e) {
        this.saveChanges();
    }
}

