/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import client.campaign.CUnit;
import common.CampaignData;
import common.House;
import common.SubFaction;
import common.util.SpringLayoutHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public final class SubFactionConfigurationDialog
implements ActionListener {
    private static final String okayCommand = "okay";
    private static final String cancelCommand = "cancel";
    private String windowName = "";
    private JTextField baseTextField = new JTextField(5);
    private JCheckBox BaseCheckBox = new JCheckBox();
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private JDialog dialog;
    private JOptionPane pane;
    private String houseName = "";
    private SubFaction subFactionConfig = null;
    private House faction = null;
    private Hashtable<String, String> configChanges = new Hashtable();
    JTabbedPane ConfigPane = new JTabbedPane(1);
    MWClient mwclient = null;

    public SubFactionConfigurationDialog(MWClient mwclient, String houseName, String subFactionName) {
        JPanel panel;
        int pos;
        int weight;
        int type;
        this.mwclient = mwclient;
        this.houseName = houseName;
        this.windowName = "MekWars SubFaction Configuration";
        this.faction = mwclient.getData().getHouseByName(houseName);
        if (this.faction == null) {
            return;
        }
        if (this.faction.getSubFactionList().containsKey(subFactionName)) {
            this.subFactionConfig = this.faction.getSubFactionList().get(subFactionName);
        } else {
            this.subFactionConfig = new SubFaction(subFactionName, "0");
            this.subFactionConfig.setConfig("MinELO", "0");
            this.subFactionConfig.setConfig("MinExp", "0");
            mwclient.sendChat("/c CreateSubFaction#" + this.subFactionConfig.getConfig("Name") + "#0#" + this.houseName);
        }
        JPanel mainPanel = new JPanel();
        JPanel mainBoxPanel = new JPanel();
        JPanel mainCBoxGridPanel = new JPanel(new SpringLayout());
        JPanel mainTextBoxSpring = new JPanel(new SpringLayout());
        mainBoxPanel.setLayout(new BoxLayout(mainBoxPanel, 1));
        mainBoxPanel.add(mainCBoxGridPanel);
        mainBoxPanel.add(mainTextBoxSpring);
        this.baseTextField = new JTextField(5);
        mainTextBoxSpring.add(new JLabel("Name:", 11));
        this.baseTextField.setToolTipText("Sub faction name.");
        this.baseTextField.setName("Name");
        mainTextBoxSpring.add(this.baseTextField);
        this.baseTextField = new JTextField(5);
        mainTextBoxSpring.add(new JLabel("Access Level:", 11));
        this.baseTextField.setToolTipText("<html>Sub faciton access level<br>This is used to determine what ops can be accessed</html>");
        this.baseTextField.setName("AccessLevel");
        mainTextBoxSpring.add(this.baseTextField);
        this.baseTextField = new JTextField(5);
        mainTextBoxSpring.add(new JLabel("Min Elo:", 11));
        this.baseTextField.setToolTipText("Min ELO needed to join this subfaction");
        this.baseTextField.setName("MinELO");
        mainTextBoxSpring.add(this.baseTextField);
        this.baseTextField = new JTextField(5);
        mainTextBoxSpring.add(new JLabel("Min Exp:", 11));
        this.baseTextField.setToolTipText("Min Exp required to join this subfaciton");
        this.baseTextField.setName("MinExp");
        mainTextBoxSpring.add(this.baseTextField);
        for (type = 0; type < 6; ++type) {
            for (weight = 0; weight <= 3; ++weight) {
                this.BaseCheckBox = new JCheckBox("Can buy new " + CUnit.getWeightClassDesc((int)weight) + " " + CUnit.getTypeClassDesc((int)type));
                this.BaseCheckBox.setToolTipText("<html>Check to allow subfaction memebers to buy new<br>" + CUnit.getWeightClassDesc((int)weight) + " " + CUnit.getTypeClassDesc((int)type) + "</html>");
                this.BaseCheckBox.setName("CanBuyNew" + CUnit.getWeightClassDesc((int)weight) + CUnit.getTypeClassDesc((int)type));
                mainCBoxGridPanel.add(this.BaseCheckBox);
            }
        }
        for (type = 0; type < 6; ++type) {
            for (weight = 0; weight <= 3; ++weight) {
                this.BaseCheckBox = new JCheckBox("Can buy used " + CUnit.getWeightClassDesc((int)weight) + " " + CUnit.getTypeClassDesc((int)type));
                this.BaseCheckBox.setToolTipText("<html>Check to allow subfaction memebers to buy used<br>" + CUnit.getWeightClassDesc((int)weight) + " " + CUnit.getTypeClassDesc((int)type) + "</html>");
                this.BaseCheckBox.setName("CanBuyUsed" + CUnit.getWeightClassDesc((int)weight) + CUnit.getTypeClassDesc((int)type));
                mainCBoxGridPanel.add(this.BaseCheckBox);
            }
        }
        SpringLayoutHelper.setupSpringGrid(mainTextBoxSpring, 4);
        SpringLayoutHelper.setupSpringGrid(mainCBoxGridPanel, 4);
        mainBoxPanel.add(mainTextBoxSpring);
        mainBoxPanel.add(mainCBoxGridPanel);
        mainPanel.add(mainBoxPanel);
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save Options");
        this.cancelButton.setToolTipText("Exit without saving options");
        this.ConfigPane.addTab("Configs", null, mainBoxPanel, "Configs");
        JPanel mainConfigPanel = new JPanel();
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(this.ConfigPane, -1, -1, null, options, null);
        this.dialog = this.pane.createDialog(mainConfigPanel, this.windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        for (pos = this.ConfigPane.getComponentCount() - 1; pos >= 0; --pos) {
            panel = (JPanel)this.ConfigPane.getComponent(pos);
            this.findAndPopulateTextAndCheckBoxes(panel);
        }
        this.dialog.setLocationRelativeTo((Component)mwclient.getMainFrame());
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.pane.getValue() == this.okayButton) {
            for (pos = this.ConfigPane.getComponentCount() - 1; pos >= 0; --pos) {
                panel = (JPanel)this.ConfigPane.getComponent(pos);
                this.findAndSaveConfigs(panel);
            }
            if (this.configChanges.size() > 0) {
                StringBuffer configPairs = new StringBuffer();
                for (String key : this.configChanges.keySet()) {
                    configPairs.append(key);
                    configPairs.append("#");
                    configPairs.append(this.configChanges.get(key));
                    configPairs.append("#");
                }
                mwclient.sendChat("/c SetSubFactionConfig#" + this.subFactionConfig.getConfig("Name") + "#" + houseName + "#" + configPairs.toString());
            }
            mwclient.sendChat("/c adminsave");
            mwclient.refreshData();
        } else {
            this.dialog.dispose();
        }
    }

    public void findAndPopulateTextAndCheckBoxes(JPanel panel) {
        String key = null;
        for (int fieldPos = panel.getComponentCount() - 1; fieldPos >= 0; --fieldPos) {
            Component field = panel.getComponent(fieldPos);
            if (field instanceof JPanel) {
                this.findAndPopulateTextAndCheckBoxes((JPanel)field);
                continue;
            }
            if (field instanceof JTextField) {
                JTextField textBox = (JTextField)field;
                key = textBox.getName();
                if (key == null) continue;
                textBox.setMaximumSize(new Dimension(100, 10));
                textBox.setText(this.subFactionConfig.getConfig(key));
                continue;
            }
            if (field instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)field;
                key = checkBox.getName();
                if (key == null) {
                    CampaignData.mwlog.errLog("Null Checkbox: " + checkBox.getToolTipText());
                    continue;
                }
                checkBox.setSelected(Boolean.parseBoolean(this.subFactionConfig.getConfig(key)));
                continue;
            }
            if (!(field instanceof JRadioButton)) continue;
            JRadioButton radioButton = (JRadioButton)field;
            key = radioButton.getName();
            if (key == null) {
                CampaignData.mwlog.errLog("Null RadioButton: " + radioButton.getToolTipText());
                continue;
            }
            radioButton.setSelected(Boolean.parseBoolean(this.subFactionConfig.getConfig(key)));
        }
    }

    public void findAndSaveConfigs(JPanel panel) {
        String key = null;
        String value = null;
        for (int fieldPos = panel.getComponentCount() - 1; fieldPos >= 0; --fieldPos) {
            Component field = panel.getComponent(fieldPos);
            if (field instanceof JPanel) {
                this.findAndSaveConfigs((JPanel)field);
                continue;
            }
            if (field instanceof JTextField) {
                JTextField textBox = (JTextField)field;
                value = textBox.getText();
                key = textBox.getName();
                if (key == null || value == null || key.equals("LastAutomatedBackup") || this.subFactionConfig.getConfig(key).equalsIgnoreCase(value)) continue;
                this.configChanges.put(key, value);
                continue;
            }
            if (field instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)field;
                value = Boolean.toString(checkBox.isSelected());
                key = checkBox.getName();
                if (key == null || value == null || this.subFactionConfig.getConfig(key).equalsIgnoreCase(value)) continue;
                this.configChanges.put(key, value);
                continue;
            }
            if (!(field instanceof JRadioButton)) continue;
            JRadioButton radioButton = (JRadioButton)field;
            value = Boolean.toString(radioButton.isSelected());
            key = radioButton.getName();
            if (key == null || value == null || this.subFactionConfig.getConfig(key).equalsIgnoreCase(value)) continue;
            this.configChanges.put(key, value);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            this.pane.setValue(this.okayButton);
            this.dialog.dispose();
        } else if (command.equals(cancelCommand)) {
            this.pane.setValue(this.cancelButton);
            this.dialog.dispose();
        }
    }
}

