/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import common.Terrain;
import common.util.SpringLayoutHelper;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class TerrainSelectionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1024120117465498506L;
    private final TreeSet<String> names;
    private JList matchingCommandList;
    private JScrollPane scrollPane;
    private JTextField nameField;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";
    private Object[] commandName = null;

    public TerrainSelectionDialog(MWClient mwclient, String boxText) {
        super(new JFrame(), boxText, true);
        this.names = new TreeSet();
        for (Terrain it : mwclient.getData().getAllTerrains()) {
            this.names.add(it.getName());
        }
        final Object[] allCommandNames = this.names.toArray();
        this.matchingCommandList = new JList<Object>(allCommandNames);
        this.matchingCommandList.setVisibleRowCount(10);
        this.matchingCommandList.setSelectionMode(2);
        this.nameField = new JTextField();
        this.nameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                new Thread(){

                    public void run() {
                        String text = TerrainSelectionDialog.this.nameField.getText();
                        if (text == null || text.equals("")) {
                            TerrainSelectionDialog.this.matchingCommandList.setListData(allCommandNames);
                            return;
                        }
                        ArrayList<String> possibleCommands = new ArrayList<String>();
                        text = text.toLowerCase();
                        for (String curCommand : TerrainSelectionDialog.this.names) {
                            if (curCommand.toLowerCase().indexOf(text) == -1) continue;
                            possibleCommands.add(curCommand.substring(0, 1) + curCommand.substring(1).toLowerCase());
                        }
                        TerrainSelectionDialog.this.matchingCommandList.setListData(possibleCommands.toArray());
                        boolean shouldContinue = true;
                        int element = 0;
                        for (String name : possibleCommands) {
                            if (name.toLowerCase().startsWith(text)) {
                                TerrainSelectionDialog.this.matchingCommandList.setSelectedIndex(element);
                                shouldContinue = false;
                                break;
                            }
                            ++element;
                        }
                        if (shouldContinue) {
                            TerrainSelectionDialog.this.matchingCommandList.setSelectedIndex(0);
                        }
                    }
                }.start();
            }
        });
        this.scrollPane = new JScrollPane(this.matchingCommandList);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel springPanel = new JPanel(new SpringLayout());
        springPanel.add(this.nameField);
        springPanel.add(this.scrollPane);
        SpringLayoutHelper.setupSpringGrid(springPanel, 2, 1);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(springPanel);
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.checkMinimumSize();
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okayButton);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            String selectedCommand = (String)this.matchingCommandList.getSelectedValue();
            if (selectedCommand == null) {
                selectedCommand = this.nameField.getText();
            }
            if (selectedCommand == null || selectedCommand.equals("")) {
                return;
            }
            if (this.matchingCommandList.getModel().getSize() >= 1) {
                this.setCommandName(this.matchingCommandList.getSelectedValues());
            } else {
                JOptionPane.showMessageDialog(null, "Unknown Terrain");
            }
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 300.0) {
            width = 300;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 150.0) {
            height = 150;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }

    private void setCommandName(Object[] terrains) {
        this.commandName = terrains;
    }

    public Object[] getCommandName() {
        return this.commandName;
    }
}

