/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CampaignData;
import common.House;
import common.MutableSerializable;
import common.util.BinReader;
import common.util.BinWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Influences
implements MutableSerializable {
    private HashMap<Integer, Integer> influences = new HashMap();

    public Influences(HashMap<Integer, Integer> influences) {
        this.setInfluence(influences);
    }

    public Influences() {
    }

    public Influences(Influences influences) {
        this.setInfluence(new HashMap<Integer, Integer>(influences.influences));
    }

    public int getInfluence(int factionID) {
        if (!this.influences.containsKey(factionID)) {
            return 0;
        }
        int i = this.influences.get(factionID);
        return i;
    }

    public Integer getOwner() {
        try {
            TreeSet<Object> sset = new TreeSet<Object>(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    try {
                        int i1 = -1;
                        int i2 = -1;
                        if (o1 != null) {
                            i1 = ((House)o1).getId();
                        }
                        if (o2 != null) {
                            i2 = ((House)o2).getId();
                        }
                        return i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
                    }
                    catch (Exception ex) {
                        return 0;
                    }
                }
            });
            sset.addAll(this.getHouses());
            House[] factions = new House[sset.size()];
            int i = 0;
            Iterator<Object> it = sset.iterator();
            while (it.hasNext()) {
                factions[i++] = (House)it.next();
            }
            Arrays.sort(factions, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    int i2;
                    int i1;
                    int h1Id = -1;
                    int h2Id = -2;
                    if (o1 != null) {
                        h1Id = ((House)o1).getId();
                    }
                    if (o2 != null) {
                        h2Id = ((House)o2).getId();
                    }
                    return (i1 = Influences.this.getInfluence(h1Id)) > (i2 = Influences.this.getInfluence(h2Id)) ? -1 : (i1 == i2 ? 0 : 1);
                }
            });
            if (factions.length < 1) {
                return null;
            }
            House faction = factions[0];
            if (faction == null) {
                return null;
            }
            if (factions.length <= 1) {
                return faction.getId();
            }
            House faction2 = factions[1];
            if (faction2 != null && this.getInfluence(faction2.getId()) == this.getInfluence(faction.getId())) {
                return null;
            }
            return faction.getId();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Error in Influenes.getOwner()");
            return null;
        }
    }

    public void setNeutral(List<House> factions, House gainer, int maxInfluence) {
        this.influences = new HashMap();
        for (int i = 0; i < factions.size(); ++i) {
            House h = factions.get(i);
            this.influences.put(h.getId(), maxInfluence / factions.size());
        }
        if (maxInfluence % factions.size() != 0) {
            int bonus = maxInfluence % factions.size();
            if (this.influences.containsKey(gainer.getId())) {
                this.influences.put(gainer.getId(), this.influences.get(gainer) + bonus);
            } else {
                this.influences.put(gainer.getId(), bonus);
            }
        }
    }

    public Set<House> getHouses() {
        HashSet<House> result = new HashSet<House>();
        Iterator<Integer> it = this.influences.keySet().iterator();
        while (it.hasNext()) {
            House faction = CampaignData.cd.getHouse(it.next());
            result.add(faction);
        }
        return result;
    }

    public int houseCount() {
        return this.influences.size();
    }

    public int moveInfluence(House winner, House loser, int amount, int maxInfluence) {
        if (amount == 0) {
            return 0;
        }
        int winnerId = winner.getId();
        int loserId = -1;
        int oldwinnerinfluence = 0;
        int oldloserinfluence = 0;
        oldwinnerinfluence = this.getInfluence(winnerId);
        oldloserinfluence = this.getInfluence(loserId);
        if (oldwinnerinfluence + amount >= maxInfluence) {
            amount = maxInfluence - oldwinnerinfluence;
        }
        if (amount > oldloserinfluence) {
            this.influences.remove(loserId);
            loserId = loser.getId();
            this.influences.put(loserId, this.getInfluence(loserId) + oldloserinfluence);
            oldloserinfluence = this.getInfluence(loserId);
        }
        if (oldloserinfluence < amount) {
            amount = oldloserinfluence;
        }
        int winnerInfluence = oldwinnerinfluence + amount;
        int loserInfluence = oldloserinfluence - amount;
        if (winnerInfluence == 0) {
            this.influences.remove(winnerId);
        } else {
            this.influences.put(winnerId, winnerInfluence);
        }
        if (loserInfluence == 0) {
            this.influences.remove(loserId);
        } else {
            this.influences.put(loserId, loserInfluence);
        }
        return amount;
    }

    public void setInfluence(HashMap<Integer, Integer> influences) {
        this.influences = influences;
    }

    public boolean isHotZone() {
        int maxflu = 0;
        int secondmaxflu = 0;
        for (int flu : this.influences.values()) {
            if (maxflu < flu) {
                secondmaxflu = maxflu;
                maxflu = flu;
                continue;
            }
            if (secondmaxflu >= flu) continue;
            secondmaxflu = flu;
        }
        return maxflu - secondmaxflu < 20;
    }

    @Override
    public void encodeMutableFields(BinWriter out, CampaignData dataProvider) throws IOException {
        out.println(this.influences.size(), "influences.size");
        for (Integer i : this.influences.keySet()) {
            out.println(i, "id");
            out.println(this.influences.get(i), "amount");
        }
    }

    @Override
    public void decodeMutableFields(BinReader in, CampaignData dataProvider) throws IOException {
        int s = in.readInt("influences.size");
        this.influences.clear();
        for (int i = 0; i < s; ++i) {
            int factionID = in.readInt("id");
            int flu = in.readInt("amount");
            this.influences.put(factionID, flu);
        }
    }

    public void xmlOut(PrintWriter out) {
        Iterator<House> inf = this.getHouses().iterator();
        out.println("\t<influence>");
        while (inf.hasNext()) {
            House h = inf.next();
            out.println("\t\t<inf>");
            out.println("\t\t<faction>" + h.getName() + "</faction>");
            out.println("\t\t<amount>" + this.getInfluence(h.getId()) + "</amount>");
            out.println("\t\t</inf>");
        }
        out.println("\t</influence>");
    }

    public Influences difference(Influences infNew) {
        HashMap<Integer, Integer> diff = new HashMap<Integer, Integer>();
        Set<House> other = infNew.getHouses();
        Set<House> thisone = this.getHouses();
        for (House h : thisone) {
            int d = this.getInfluence(h.getId()) - infNew.getInfluence(h.getId());
            if (d == 0) continue;
            diff.put(h.getId(), d);
        }
        for (House h : other) {
            if (thisone.contains(h.getId())) continue;
            diff.put(h.getId(), -infNew.getInfluence(h.getId()));
        }
        return new Influences(diff);
    }

    public void add(Influences infNew) {
        for (House h : this.getHouses()) {
            this.influences.put(h.getId(), infNew.getInfluence(h.getId()));
        }
        for (House h : infNew.getHouses()) {
            if (this.getHouses().contains(h)) continue;
            this.influences.put(h.getId(), infNew.getInfluence(h.getId()));
        }
        for (House h : this.getHouses()) {
            if (this.getInfluence(h.getId()) != 0) continue;
            this.influences.remove(h.getId());
        }
    }

    public void binOut(BinWriter out) throws IOException {
        Object[] h = this.influences.keySet().toArray();
        Arrays.sort(h, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int i2;
                int i1 = (Integer)o1;
                return i1 == (i2 = ((Integer)o2).intValue()) ? 0 : (i1 < i2 ? -1 : 1);
            }
        });
        out.println(h.length, "influence.size");
        for (int i = 0; i < h.length; ++i) {
            out.println((Integer)h[i], "faction");
            out.println(this.getInfluence((Integer)h[i]), "amount");
        }
    }

    public void binIn(BinReader in, Map<Integer, House> factions) throws IOException {
        this.influences = new HashMap();
        int size = in.readInt("influence.size");
        for (int i = 0; i < size; ++i) {
            int hid = in.readInt("faction");
            int flu = in.readInt("amount");
            this.influences.put(hid, flu);
        }
    }

    public void binIn(BinReader in) throws IOException {
        this.influences = new HashMap();
        int size = in.readInt("influence.size");
        for (int i = 0; i < size; ++i) {
            int hid = in.readInt("faction");
            int flu = in.readInt("amount");
            this.influences.put(hid, flu);
        }
    }

    public void removeHouse(House house) {
        this.influences.remove(house.getId());
    }

    public void updateHouse(int id, int amount) {
        this.influences.put(id, amount);
    }
}

